# OpenVerse InitGlobal Variables
# 
# this file initalizes the program and does any
# platform specific things/setup. It will then source 
# supporting modules.
#
# Module Name		- Init Global Variables
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- Main Module
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.


#
# THIS IS THE DEFAULT SERVER AND PORT
#
set MV(roomhost) "datapex4.datapex.com"
set MV(roomport) "7000"


#
# TODO:
# All of these things need to be documented.
#

set MV(debug) 0
set MV(tooltips) 1
set MV(killhigh) 0
set MV(killnotes) 0
set MV(x) 320
set MV(y) 200
set MV(anim.x_off) 0
set MV(anim.y_off) 20
set MV(anim.baloon_x) 24
set MV(anim.baloon_y) 6
set MV(moving) 0
# old style!
set MV(dlnum) 0
# New Style!
set MV(dcc_num) 0
set MV(names) 1
set MV(anim.current) -1
set MV(anim.stop) 1
set MV(anim.running) 0
set MV(plugindir) "$MV(homedir)/plugins"
set MV(images) "$MV(homedir)/images"
set MV(download_dir) "$MV(homedir)/download"
set MV(icondir) "$MV(homedir)/icons"
set MV(rem_images) "$MV(homedir)/rimages"
set MV(bookmarks) "$MV(homedir)/passageways.txt"
set MV(anims) "$MV(homedir)/anims"
set MV(objects) "$MV(homedir)/objects"
set MV(roomdir) "$MV(homedir)/rooms"
set MV(paneldir) "$MV(homedir)/panels"
set MV(roomname) "Welcome To The OpenVerse"
set MV(configfile) "$MV(homedir)/MetaV.cfg"
set MV(nick) "Guest"
set MV(avatar) "default.gif"
set MV(anim) "default.av"
set MV(name_x_offset) 0
set MV(name_y_offset) 40
set MV(MyIpAddress) "0.0.0.0"
set MV(sendbuffer) 4096
set MV(getbuffer) 1024
set MV(sock) -1
set MV(bell) 1
set MV(movespeed) 10
set MV(staytime) 10
set MV(urltimeout) 30
set MV(dcctimeout) 180
set MV(movespeed) 1
set MV(chatsave) 200
set MV(prevsave) 100
set MV(curprev) -1
set MV(ignore.all) {}
set MV(ignore.avatar) {}
set MV(ignore.effect) {}
set MV(ignore.move) {}
set MV(ignore.speech) {}
set MV(ignore.sub) {}
set MV(ignore.url) {}
set MV(chats) {}
set MV(prev) {}
set MV(people) {}
set MV(moves) {}
set MV(downloads) {}
set MV(downloadingroom) 0
set MV(roomloads) {}
set MV(dcc_list) {}
set MV(server_queries) {}
set MV(textwindow) 0
set MV(textwindow.lock) 0
set MV(pwq.queries) 0
set MV(dlwindows) 0
set MV(use_windowmanager_colors) 0
set MV(download_avatars) 1
set MV(honor_effects) 1
set MV(default_avatar_number) 0
set MV(browser_cmd) "netscape"
#
# Panel Related
#
set MV(panel) "Fun"


# ------------------------------------------------------------------------
#                          Plugin Specific Variables.
# ------------------------------------------------------------------------

# ------------------------------------
# ChangeAvatar {filename}
# ------------------------------------
set MV(plugin.traps.ChangeAvatar) {}

# ------------------------------------
# ChangeNick {newnick}
# ------------------------------------
set MV(plugin.traps.ChangeNick) {}

# ------------------------------------
# ChangeUserAvatar {who filename name_x name_y filesize baloon_x baloon_y}
# ------------------------------------
set MV(plugin.traps.ChangeUserAvatar) {}

# ------------------------------------
# Disconnect {}
# ------------------------------------
set MV(plugin.traps.Disconnect) {}

# ------------------------------------
# DoNames {widget who idx} (will call for each name in list.)
# ------------------------------------
set MV(plugin.traps.DoNames) {}

# ------------------------------------
# ShowNames {who} (will process for each user.)
# ------------------------------------
set MV(plugin.traps.ShowNames) {}

# ------------------------------------
# KillNames {who} (will process for each user.)
# ------------------------------------
set MV(plugin.traps.KillNames) {}

# ------------------------------------
# ProcURL {who url type}
# ------------------------------------
set MV(plugin.traps.ProcURL) {}

# ------------------------------------
# MoveTo {x y}
# ------------------------------------
set MV(plugin.traps.MoveTo.Pre) {}
set MV(plugin.traps.MoveTo.Post) {}

# ------------------------------------
# MoveUser {who x y speed}
# ------------------------------------
set MV(plugin.traps.MoveUser.Pre) {}
set MV(plugin.traps.MoveUser.Post) {}

# ------------------------------------
# NewPerson {who x y filename name_x name_y filesize baloon_x baloon_y}
# ------------------------------------
set MV(plugin.traps.NewPerson) {}

# ------------------------------------------------------------------------
#                       Our URL Type Handlers.
# ------------------------------------------------------------------------
set MV(URLS.x) {20 60 100 140 180 220 260 300 340 380 420 460 500 540 580 620}
set MV(URLS.y) {20 60 100 140 180 220 260 300 340 380 420}
for {set c 0} {$c < 16} {incr c} {
	for {set d 0} {$d < 12} {incr d} {
		set MV(URLS.$c.$d) 0
	}
}
set MV(url.icon.unknown) "unknown.gif"
set MV(url.txtlen.unknown) 24

# ------------------------------------------------------------------------
#                       Our default color scheme.
# ------------------------------------------------------------------------

# ------------------------------------
# PersonLeft {who}
# ------------------------------------
set MV(plugin.traps.PersonLeft) {}

# ------------------------------------
# ProcessInput {original_text cmd parms rest}
# ------------------------------------
set MV(plugin.traps.ProcessInput.pre) {}
set MV(plugin.traps.ProcessInput.post) {}

# ------------------------------------
# SendText {text_to_send}
# ------------------------------------
set MV(plugin.traps.SendText) {}

# ------------------------------------------------------------------------
#                       Our default color scheme.
# ------------------------------------------------------------------------

# Baloons.
set MV(colors.chat.baloon) "white"
set MV(colors.chat.text) "black"
set MV(colors.privmsg.baloon) "light blue"
set MV(colors.privmsg.text) "black"
set MV(colors.system.baloon) "white"
set MV(colors.system.text) "red"
set MV(colors.whois.baloon) "light green"
set MV(colors.whois.text) "black"

# ------------------------------------
# Main Window Buttons, entry points. (Button Mode)
# ------------------------------------
set MV(colors.buttons.quit.bg) "light blue"
set MV(colors.buttons.quit.fg) "black"
set MV(colors.buttons.quit.abg) "light blue"
set MV(colors.buttons.quit.afg) "red"
# ------------------------------------
set MV(colors.buttons.textchat.bg) "light blue"
set MV(colors.buttons.textchat.fg) "black"
set MV(colors.buttons.textchat.abg) "light blue"
set MV(colors.buttons.textchat.afg) "red"
# ------------------------------------
set MV(colors.buttons.help.bg) "light blue"
set MV(colors.buttons.help.fg) "black"
set MV(colors.buttons.help.abg) "light blue"
set MV(colors.buttons.help.afg) "red"
# ------------------------------------
set MV(colors.buttons.setup.bg) "light blue"
set MV(colors.buttons.setup.fg) "black"
set MV(colors.buttons.setup.abg) "light blue"
set MV(colors.buttons.setup.afg) "red"
# ------------------------------------
set MV(colors.buttons.passageways.bg) "light blue"
set MV(colors.buttons.passageways.fg) "black"
set MV(colors.buttons.passageways.abg) "light blue"
set MV(colors.buttons.passageways.afg) "red"
# ------------------------------------
set MV(colors.buttons.aved.bg) "light blue"
set MV(colors.buttons.aved.fg) "black"
set MV(colors.buttons.aved.abg) "light blue"
set MV(colors.buttons.aved.afg) "red"
# ------------------------------------
set MV(colors.buttons.animate.bg) "light blue"
set MV(colors.buttons.animate.fg) "black"
set MV(colors.buttons.animate.abg) "light blue"
set MV(colors.buttons.animate.afg) "red"
# ------------------------------------
set MV(colors.buttons.avatars.bg) "light blue"
set MV(colors.buttons.avatars.fg) "black"
set MV(colors.buttons.avatars.abg) "light blue"
set MV(colors.buttons.avatars.afg) "red"
# ------------------------------------
set MV(colors.buttons.sound.bg) "light blue"
set MV(colors.buttons.sound.fg) "black"
set MV(colors.buttons.sound.abg) "light blue"
set MV(colors.buttons.sound.afg) "red"
# ------------------------------------
set MV(colors.buttons.names.bg) "light blue"
set MV(colors.buttons.names.fg) "black"
set MV(colors.buttons.names.abg) "light blue"
set MV(colors.buttons.names.afg) "red"
# ------------------------------------
set MV(colors.buttons.names.chk.bg) "light blue"
set MV(colors.buttons.names.chk.fg) "black"
set MV(colors.buttons.names.chk.abg) "light blue"
set MV(colors.buttons.names.chk.afg) "red"
# ------------------------------------
set MV(colors.buttons.send.bg) "light blue"
set MV(colors.buttons.send.fg) "black"
set MV(colors.buttons.send.abg) "light blue"
set MV(colors.buttons.send.afg) "red"
# ------------------------------------
set MV(colors.buttons.connect.bg) "light blue"
set MV(colors.buttons.connect.fg) "black"
set MV(colors.buttons.connect.abg) "light blue"
set MV(colors.buttons.connect.afg) "red"
# ------------------------------------
# Main Window Entry Boxes
# ------------------------------------
set MV(colors.buttons.entry.bg) "light blue"
set MV(colors.buttons.entry.fg) "black"
# ------------------------------------
# Main Window Frames
# ------------------------------------
set MV(colors.frames.chat.bg) "light blue"
set MV(colors.frames.topbar.bg) "light blue"
set MV(colors.frames.canvas.bg) "light blue"
set MV(colors.frames.menu.bg) "light blue"
set MV(colors.frames.menu.bord.bg) "light blue"
set MV(colors.frames.menu.top.bg) "light blue"
set MV(colors.frames.menu.bot.bg) "light blue"
set MV(colors.frames.names.bg) "light blue"
# ------------------------------------
# Passageways Entries.
# ------------------------------------
set MV(colors.pw.bg) "light blue"
set MV(colors.pw.fg) "black"
set MV(colors.pw.abg) "light blue"
set MV(colors.pw.afg) "red"
# ------------------------------------
# Avatars Entries.
# ------------------------------------
set MV(colors.av.bg) "light blue"
set MV(colors.av.fg) "black"
set MV(colors.av.abg) "light blue"
set MV(colors.av.afg) "red"
# ------------------------------------
# Names Entries.
# ------------------------------------
set MV(colors.name.bg) "light blue"
set MV(colors.name.fg) "black"
set MV(colors.name.abg) "light blue"
set MV(colors.name.afg) "red"
# ------------------------------------
# URL Offer information Window.
# ------------------------------------
set MV(colors.url.frames.bg) "light blue"
set MV(colors.url.labels.fg) "black"
set MV(colors.url.labels.bg) "light blue"
set MV(colors.url.entries.fg) "light green"
set MV(colors.url.entries.bg) "black"
set MV(colors.url.buttons.bg) "light blue"
set MV(colors.url.buttons.abg) "light blue"
set MV(colors.url.buttons.fg) "black"
set MV(colors.url.buttons.afg) "red"
# ------------------------------------
# Download information Window.
# ------------------------------------
set MV(colors.dl.frames.bg) "light blue"
set MV(colors.dl.labels.bg) "light blue"
set MV(colors.dl.labels.fg) "black"
set MV(colors.dl.entries.bg) "black"
set MV(colors.dl.entries.fg) "light green"
set MV(colors.dl.buttons.bg) "light blue"
set MV(colors.dl.buttons.fg) "black"
set MV(colors.dl.buttons.abg) "light blue"
set MV(colors.dl.buttons.afg) "red"



#
# Build our download window array and set all items to 0ff
#
for {set c 0} {$c < 26} {incr c} {
	for {set s 1} {$s < 4} {incr s} {
		set MV(dls.$c.$s) 0
		set MV(dlcps.$c.$s) 0
		set MV(dlactive.$c.$s) 0
	}
}
global tl
set tl(-1) 0

