# OpenVerse Setup Module 
# 
# This module contains all the functions needed for the setup 
# Window to work.
#
# Module Name		- Setup Module
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- InitMainWindow
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

#
# This sets up the setup window.
#
proc Setup {} {
	global MV SET

	set SET(refresh_menu) 0
	
	if [winfo exists .setup] {destroy .setup}
	toplevel .setup
	wm title .setup "OpenVerse Setup"
	wm resizable .setup 0 0
	frame .setup.na
	frame .setup.na.l
	frame .setup.na.l.t
	frame .setup.na.l.b
	frame .setup.na.l.t.nick
	frame .setup.na.l.b.avatars
	frame .setup.na.r
	frame .setup.opta
	frame .setup.optb
	frame .setup.optc
	frame .setup.cmds


	checkbutton .setup.opta.colors -text "Color Buttons" -variable \
		MV(use_windowmanager_colors) -onval 0 -offval 1 \
		-relief raised -borderwidth 2
	checkbutton .setup.opta.av -text "Download Avatars" -variable \
		MV(download_avatars) -onval 1 -offval 0 \
		-relief raised -borderwidth 2
	checkbutton .setup.opta.he -text "Honor Effects" -variable \
		MV(honor_effects) -onval 1 -offval 0 \
		-relief raised -borderwidth 2

	label .setup.optb.http_l -text "Browser Cmd"
	entry .setup.optb.http_e

	frame .setup.optc.list
	label .setup.optc.list.txt -relief raised -text "Panel Style" \
		-borderwidth 2
	listbox .setup.optc.list.l -height 4 -width 20 \
		-relief raised -yscrollcommand ".setup.optc.list.scrly set" \
		-xscrollcommand ".setup.optc.list.scrlx set"
	scrollbar .setup.optc.list.scrly -command ".setup.optc.list.l yview"
	scrollbar .setup.optc.list.scrlx -command ".setup.optc.list.l xview" \
		-orient horizontal
	

	scale .setup.na.r.bspeed -from 1 -to 20 -variable MV(staytime) \
		-orient horizontal -label "Balloon Speed" -relief raised \
		-borderwidth 2
	scale .setup.na.r.mspeed -from 1 -to 20 -variable MV(movespeed) \
		-orient horizontal -label "Move Speed" -relief raised \
		-borderwidth 2
	scale .setup.na.r.url -from 1 -to 300 -variable MV(urltimeout) \
		-orient horizontal -label "URL Timeout" -relief raised \
		-borderwidth 2


	label .setup.na.l.t.nick.txt -text " Nick Name "
	entry .setup.na.l.t.nick.entry
	menubutton .setup.na.l.b.avatars.menu -text "Avatar" -menu \
		.setup.na.l.b.avatars.menu.m -relief raised -borderwidth 2
	menu .setup.na.l.b.avatars.menu.m


	set anims 0
	set depth 0
	set count 0
	foreach file [List_Avatars] {
		if !$depth {
			incr depth
			.setup.na.l.b.avatars.menu.m add cascade -menu \
				.setup.na.l.b.avatars.menu.m.m$depth -label "Avatars $depth"
			menu .setup.na.l.b.avatars.menu.m.m$depth
		}
		set MV(avatar_setup.$count) "[file tail $file]"
		.setup.na.l.b.avatars.menu.m.m$depth add command -label [file tail $file] \
			-command "AnimateMe $count 2"
		incr anims
		incr count
		if {$anims > 19} {
			incr depth
			.setup.na.l.b.avatars.menu.m add cascade -menu \
				.setup.na.l.b.avatars.menu.m.m$depth -label "Avatars $depth"
			menu .setup.na.l.b.avatars.menu.m.m$depth
			set anims 0
		}
	}
	entry .setup.na.l.b.avatars.entry

	button .setup.cmds.cancel -text "Cancel" -command "destroy .setup"
	button .setup.cmds.save -text "Save & Apply" -command "SaveSetup 1"
	button .setup.cmds.apply -text "Apply Only" -command "SaveSetup 2"
	button .setup.cmds.saveo -text "Save Only" -command "SaveSetup 3"

	pack .setup.na -side top -fill both -expand y
	pack .setup.na.l .setup.na.r .setup.na.r.url -side left -fill both \
		-expand y
	pack .setup.na.l.t -side top -fill both -expand y
	pack .setup.na.l.b -side bottom -fill both -expand y
	pack .setup.na.l.t.nick -fill both -expand y
	pack .setup.na.l.b.avatars -fill both -expand y
	pack .setup.na.l.t.nick.txt -side left
	pack .setup.na.l.t.nick.entry -side left -fill both -expand y
	pack .setup.na.l.b.avatars.menu -side left
	pack .setup.na.l.b.avatars.entry -side left -fill both -expand y
	pack .setup.opta -fill both -expand y
	pack .setup.opta.colors .setup.opta.av .setup.opta.he \
		-side left -fill both -expand y
	pack .setup.optb -fill both -expand y
	pack .setup.optb.http_l -side left
	pack .setup.optb.http_e -side left -fill both -expand y
	pack .setup.optc -fill both -expand y
	pack .setup.optc.list -side right
	pack .setup.optc.list.txt -side top -fill x -expand y
	pack .setup.optc.list.scrlx -side top -fill x -expand y
	pack .setup.optc.list.l -side left -fill both -expan y
	pack .setup.optc.list.scrly -side right -fill y -expand y
	pack .setup.cmds -fill both -expand y
	pack .setup.cmds.cancel .setup.cmds.save .setup.cmds.apply .setup.cmds.saveo -side left -fill both \
		-expand y
	pack .setup.na.r.bspeed .setup.na.r.mspeed -side left -fill both \
		-expand y

	.setup.na.l.t.nick.entry insert end $MV(nick)
	.setup.na.l.b.avatars.entry insert end $MV(anim)
	.setup.optb.http_e insert end $MV(browser_cmd)
	
	bind .setup.na.l.t.nick.entry <KeyRelease> {CheckNick}
	bind .setup.na.l.t.nick.entry <ButtonPress> {CheckNick}
	bind .setup.optc.list.l <ButtonRelease> {
		set MV(panel) [selection get]
		set SET(refresh_menu) 1
	}
	FillPanels

}

proc FillPanels {} {
	global MV

	foreach panel [List_Panels] {
		.setup.optc.list.l insert end "[file tail $panel]"
		if {[file tail $panel] == $MV(panel)} {
			.setup.optc.list.l selection set end
			.setup.optc.list.l see end
		}
	}
}


proc SaveSetup {how} {
	global MV SET

	set outfile [open "$MV(configfile)" w]
	puts $outfile "set MV(nick) \"[.setup.na.l.t.nick.entry get]\""
	puts $outfile "set MV(anim) \"[.setup.na.l.b.avatars.entry get]\""
	puts $outfile "set MV(staytime) $MV(staytime)"
	puts $outfile "set MV(movespeed) $MV(movespeed)"
	puts $outfile "set MV(use_windowmanager_colors) $MV(use_windowmanager_colors)"
	puts $outfile "set MV(download_avatars) $MV(download_avatars)"
	puts $outfile "set MV(browser_cmd) \"[.setup.optb.http_e get]\""
	puts $outfile "set MV(urltimeout) $MV(urltimeout)"
	puts $outfile "set MV(honor_effects) $MV(honor_effects)"
	puts $outfile "set MV(panel) \"$MV(panel)\""
	close $outfile
	set MV($MV(nick).haschat) 0
	set MV($MV(nick).chatque) {}
	set MV(download_avatars) $MV(download_avatars)
	set MV(use_windowmanager_colors) $MV(use_windowmanager_colors)
	set MV(browser_cmd) [split [.setup.optb.http_e get] " "]
	if $MV(names) {
		KillName $MV(nick)
	}
	set newnick [.setup.na.l.t.nick.entry get]
	if {$MV(nick) != $newnick} {
		set MV($newnick.haschat) 0
		set MV($newnick.chatque) {}
		ChangeNick "$newnick"
	}
	set MV(anim) [.setup.na.l.b.avatars.entry get]
	AnimateMe "[.setup.na.l.b.avatars.entry get]" 3
	SendToServer "NICK $MV(nick)"
	destroy .setup
	if $SET(refresh_menu) {source "$MV(paneldir)/$MV(panel)"}
}
