# ----------------------------------------------------------------------
#  EXAMPLE: locking up windows when the application is busy
# ----------------------------------------------------------------------
#  Effective Tcl/Tk Programming
#    Mark Harrison, DSC Communications Corp.
#    Michael McLennan, Bell Labs Innovations for Lucent Technologies
#    Addison-Wesley Professional Computing Series
# ======================================================================
#  Copyright (c) 1996-1997  Lucent Technologies Inc. and Mark Harrison
# ======================================================================

# ----------------------------------------------------------------------
# USAGE: busy_eval <script>
#
# Locks up all windows in the application, and executes some <script>.
# When the <script> is finished, the windows are unlocked.
# ----------------------------------------------------------------------
frame .busylock
bind .busylock <KeyPress> break
place .busylock -x -2 -y -2

proc busy_eval {script} {
    set fwin [focus]
    focus .busylock
    grab set .busylock

    set cursor [. cget -cursor]
    . configure -cursor watch
    update

    set status [catch {uplevel $script} result]

    . configure -cursor $cursor
    grab release .busylock
    focus $fwin

    return -code $status $result
}
