# ----------------------------------------------------------------------
#  EXAMPLE: procedures to support electronic mail
# ----------------------------------------------------------------------
#  Effective Tcl/Tk Programming
#    Mark Harrison, DSC Communications Corp.
#    Michael McLennan, Bell Labs Innovations for Lucent Technologies
#    Addison-Wesley Professional Computing Series
# ======================================================================
#  Copyright (c) 1996-1997  Lucent Technologies Inc. and Mark Harrison
# ======================================================================

# ----------------------------------------------------------------------
#  USAGE:  email_send <to> <from> <cc> <subject> <message>
#
#  Sends an electronic mail message to address <to>, from address
#  <from>, with carbon copies to <cc>.  The message is composed of
#  a <subject> line and the <message> body.  This procedure invokes
#  the "sendmail" program to actually send the message.
# ----------------------------------------------------------------------
proc email_send {to from cc subject text} {

    set fid [open "| /usr/lib/sendmail -oi -t" "w"]

    puts $fid "To: $to"
    if {[string length $from] > 0} {
        puts $fid "From: $from"
    }
    if {[string length $cc] > 0} {
        puts $fid "Cc: $cc"
    }
    puts $fid "Subject: $subject"
    puts $fid "Date: [clock format [clock seconds]]"
    puts $fid ""  ;# sendmail terminates header with blank line
    puts $fid $text

    close $fid
}

# ----------------------------------------------------------------------
#  USAGE:  email_bug_reports <address>
#
#  Sets things up so that when an error occurs, the user is given
#  the option of e-mailing a bug report back to the developer.
# ----------------------------------------------------------------------
proc email_bug_reports {addr} {
    proc bgerror {error} "
        email_bug_report_send [list $addr] \$error
    "
}

# ----------------------------------------------------------------------
#  USAGE:  email_bug_report_send <bugAddress> <error>
#
#  Sets things up so that when an error occurs, the user is given
#  the option of e-mailing a bug report back to the developer.
# ----------------------------------------------------------------------
proc email_bug_report_send {bugAddress error} {
    global errorInfo env argv argv0
    set bugReport $errorInfo

    set question "Unexpected error:\n$error\n\n"
    append question "Select \"E-mail Bug Report\" to send "
    append question "a report of this incident to the developer "
    append question "so the problem can be fixed."

    if {[confirm_ask $question "E-mail Bug Report" "Ignore"]} {
        if {[info exists env(REPLYTO)]} {
            set from $env(REPLYTO)
        } else {
            set from ""
        }
        set body [format {
While the following program was executing...
-----------------------------------------------------------------
  %s %s
-----------------------------------------------------------------
...the following error was detected:

%s} $argv0 $argv $bugReport]

        catch {
            email_send $bugAddress $from "" \
                "BUG REPORT ($argv0)" $body
        }
    }
}
