# ----------------------------------------------------------------------
#  EXAMPLE: box of mutually-exclusive choices
# ----------------------------------------------------------------------
#  Effective Tcl/Tk Programming
#    Mark Harrison, DSC Communications Corp.
#    Michael McLennan, Bell Labs Innovations for Lucent Technologies
#    Addison-Wesley Professional Computing Series
# ======================================================================
#  Copyright (c) 1996-1997  Lucent Technologies Inc. and Mark Harrison
# ======================================================================

# ----------------------------------------------------------------------
#  USAGE:  radiobox_create <win> ?<title>?
#
#  Creates an empty radiobox assembly.  Radiobutton choices can be
#  added later using "radiobox_add".  If the <title> is specified,
#  then it appears as a label above the radiobuttons.
# ----------------------------------------------------------------------
proc radiobox_create {win {title ""}} {
    global rbInfo

    set rbInfo($win-current) ""
    set rbInfo($win-count) 0

    frame $win -class Radiobox

    if {$title != ""} {
        label $win.title -text $title
        pack $win.title -side top -anchor w
    }
    frame $win.border -borderwidth 2 -relief groove
    pack $win.border -expand yes -fill both

    bind $win <Destroy> "radiobox_destroy $win"
    return $win
}

# ----------------------------------------------------------------------
#  USAGE:  radiobox_destroy <win>
#
#  Called when a radiobox is destroyed to free up the memory
#  associated with it.
# ----------------------------------------------------------------------
proc radiobox_destroy {win} {
    global rbInfo
    unset rbInfo($win-count)
    unset rbInfo($win-current)
}

# ----------------------------------------------------------------------
#  USAGE:  radiobox_add <win> <choice> ?<command>?
#
#  Adds another choice to a radiobox assembly created by
#  "radiobox_create".  If this is the first entry, it becomes
#  the current choice.
# ----------------------------------------------------------------------
proc radiobox_add {win choice {command ""}} {
    global rbInfo

    set name "$win.border.rb[incr rbInfo($win-count)]"
    radiobutton $name -text $choice -command $command \
        -variable rbInfo($win-current) -value $choice
    pack $name -side top -anchor w

    if {$rbInfo($win-count) == 1} {
        $name invoke
    }
}

# ----------------------------------------------------------------------
#  USAGE:  radiobox_select <win> <choice>
#
#  Sets the current selection in the radiobox assembly for <win>.
# ----------------------------------------------------------------------
proc radiobox_select {win choice} {
    global rbInfo
    set rbInfo($win-current) $choice
}

# ----------------------------------------------------------------------
#  USAGE:  radiobox_get <win>
#
#  Returns the current selection in the radiobox assembly for <win>.
# ----------------------------------------------------------------------
proc radiobox_get {win} {
    global rbInfo
    return $rbInfo($win-current)
}
