#------------------------------------------------------------------------
#
#  mkShowInfoServer.tcl ---
#  
#  Part of the Whiteboard application. It shows server information.
#  Uses one of the 'allIPnumsTo' to get a channel which is used to
#  obtain information.
#  If not connected, then give only the hostname if available.
#  
#  The whiteboard application has been developed by:
#  
#	Mats Bengtsson, 
#	Hamngatan 21,
#	SE-58226, Linkoping Sweden,
#	matben@lin.foa.se,
#	phone: +46 13 136114
# 
#  It is distributed under the standard GPL.
#  See the README file for further details.
#  
#------------------------------------------------------------------------

proc mkShowInfoServer  { thisIPnum }  {
    global  thisServPort sysFont thisUserName ipNum2Socket allIPnumsTo
    
    set w .infoserv
    
    catch {toplevel $w}
    wm title $w "Server Info"
    pack [frame $w.frall -borderwidth 1 -relief raised]
    pack [frame $w.frtop -borderwidth 0] -in $w.frall    
    set wcont [LabeledFrame $w.frtop "Server Info"]
    # Frame for everything inside the labeled container.
    set fr [frame $wcont.fr]

    label $fr.a1 -text "This IP number:" -font $sysFont(sb)
    label $fr.b1 -text "Host name:" -font $sysFont(sb)
    label $fr.c1 -text "User name:" -font $sysFont(sb)
    label $fr.d1 -text "Port number:" -font $sysFont(sb)
    label $fr.e1 -text "Buffering:" -font $sysFont(sb)
    label $fr.f1 -text "Blocking:" -font $sysFont(sb)

    if {[llength $allIPnumsTo] > 0}  {
	
	# Take any ip and get channel.
	set channel $ipNum2Socket([lindex $allIPnumsTo 0])
    
	set peername [fconfigure $channel -peername]
	set sockname [fconfigure $channel -sockname]
	set buff [fconfigure $channel -buffering]
	set block [fconfigure $channel -blocking]
	label $fr.a2 -text "$thisIPnum" -font $sysFont(s)
	label $fr.b2 -text "[info hostname]" -font $sysFont(s)
	label $fr.c2 -text $thisUserName -font $sysFont(s)
	label $fr.d2 -text "$thisServPort" -font $sysFont(s)
	label $fr.e2 -text "$buff" -font $sysFont(s)
	label $fr.f2 -text "$block" -font $sysFont(s)
    } else  {
	
	# Not yet connected
	set theHostname [info hostname]
	if {[string length $theHostname] == 0}  {
	    set theHostname "not available"
	}
	label $fr.a2 -text "$thisIPnum" -font $sysFont(s)
	label $fr.b2 -text $theHostname -font $sysFont(s)
	label $fr.c2 -text $thisUserName -font $sysFont(s)
	label $fr.d2 -text "not available" -font $sysFont(s)
	label $fr.e2 -text "not available" -font $sysFont(s)
	label $fr.f2 -text "not available" -font $sysFont(s)
    }
    
    grid $fr.a1 -column 0 -row 0 -sticky e
    grid $fr.a2 -column 1 -row 0 -sticky w
    grid $fr.b1 -column 0 -row 1 -sticky e
    grid $fr.b2 -column 1 -row 1 -sticky w
    grid $fr.c1 -column 0 -row 2 -sticky e
    grid $fr.c2 -column 1 -row 2 -sticky w
    grid $fr.d1 -column 0 -row 3 -sticky e
    grid $fr.d2 -column 1 -row 3 -sticky w
    grid $fr.e1 -column 0 -row 4 -sticky e
    grid $fr.e2 -column 1 -row 4 -sticky w
    grid $fr.f1 -column 0 -row 5 -sticky e
    grid $fr.f2 -column 1 -row 5 -sticky w
    pack $fr -side left -padx 20    
    pack $wcont -fill x    
        
    # button part
    pack [frame $w.frbot -borderwidth 0] -in $w.frall -fill both  \
      -padx 8 -pady 6
    pack [button $w.ok -text "  OK  " -default active -command "destroy $w"]  \
      -in $w.frbot -side right -padx 5 -pady 5
    wm resizable $w 0 0
    bind $w <Return> "$w.ok invoke"
    
    tkwait window $w
    grab release $w
}
#---------------------------------------------------------------------
