#!/bin/sh
# the next line restarts using wish \
        exec wish "$0" -visual truecolor "$@"

#
# MimeCodeGifs.tcl ---
#
#    Creates tk photos with MIME coded data from all gifs in present directory.

set fileNames [glob *.gif]
set fileNames [glob bt_*.gif]

array set btNo2Name  \
	{00 point 01 move 10 line 11 arrow 20 rect 21 oval 30 pen 31 brush  \
	40 text 41 del 50 paint 51 poly 60 arc 61 rot}
array set btName2No  \
	{point 00 move 01 line 10 arrow 11 rect 20 oval 21 pen 30 brush 31  \
	text 40 del 41 paint 50 poly 51 arc 60 rot 61}

set pat_ {[^_]+}

foreach gifFile $fileNames {
    #regexp "(.+)\.gif" $gifFile match name
    regexp "bt_($pat_)_($pat_)\.gif" $gifFile match type onoff
    puts " "
    set mimecode [exec mimencode $gifFile]
    puts "image create photo im_${onoff}$btName2No($type) -data \{"
    puts $mimecode
    puts "\}"
}