#
# SequenceGrabber.tcl ---
#
#    Contains the tcl code to handle the sequence grabber.
#
#    Copyright (c) 2000   Mats Bengtsson

#---------------------------------------------------------------------
#   DisplaySequenceGrabber ---
#
#   Start the sequence grabber in a window in the canvas.
#   The sequence grabber is given the status of a movie item.

proc DisplaySequenceGrabber  { w }  {
    global  myItpref itno allIPnumsToSend prefs seqGrabPath debugLevel
    
    if {$debugLevel >= 2}  {
	puts "DisplaySequenceGrabber:: w=$w"
    }
    set fr ${w}.fr_sg${itno}
    
    # Make a frame for the grabber; need special class to catch mouse events.
    frame $fr -height 1 -width 1 -bg gray40 -class SGFrame
    
    # Start the sequence grabber.
    if {[catch {seqgrabber ${fr}.sg} msg]}  {
	tk_messageBox -message "Error: couldn,t start the camera."  \
	  -icon error -type ok
	catch {destroy $fr}
	return
    }
    set seqGrabPath $msg	
    set anc [NewImportAnchor]
    
    # We keep the item tag 'movie', and add a new tag 'grabber'.
    $w create window [lindex $anc 0] [lindex $anc 1] -anchor nw  \
      -window $fr -tags "movie grabber $myItpref/$itno"
    place $seqGrabPath -in $fr -anchor nw -x 3 -y 3
    #pack $mpath -in $fr -padx 3 -pady 3
    update idletasks
    set height [winfo height $seqGrabPath]
    set width [winfo width $seqGrabPath]
    if {$debugLevel >= 2}  {
	puts "sgPath=$sgPath, height=$height, width=$width"
    }
    $fr configure -width [expr $width + 6] -height [expr $height + 6]
}

proc SetVideoConfig  { w what {opt {}} }  {
    global  allIPnumsToSend prefs seqGrabPath debugLevel

    if {![winfo exists $seqGrabPath]} {
	return
    }

    switch $what {
	audiosettings {
	    if {[catch {$seqGrabPath audiosettings} res]} {
		tk_messageBox -message "Error:  $res" -icon error -type ok
		return
	    }
	}
	pause {
	    $seqGrabPath pause $opt
	}
	picture {
	    
	    # Open a file?
	    if {[catch {$seqGrabPath picture $opt } res]} {
		tk_messageBox -message "Error:  $res" -icon error -type ok
		return
	    }
	}
	size {
	    $seqGrabPath configure -size $prefs(videoSize)
	}
	videosettings {
	    if {[catch {$seqGrabPath videosettings} res]} {
		tk_messageBox -message "Error:  $res" -icon error -type ok
		return
	    }
	}
	zoom {
	    $seqGrabPath configure -zoom $prefs(videoZoom)
	}
	
    }
	
}