#!/bin/sh
#-*-tcl-*-
# the next line restarts using wish \
exec wish "$0" ${1+"$@"}

# <p><b><h2>cft - <u>C</u>onfigurable <u>F</u>ile <u>T</u>ool</h2></p></b> 
# <b>Version: </b><p><i>0.82</i></p>
# <b>Requirements:</b><p>tcl/Tk 8.0 or above</p>
# <b>Description:</b>
# <p>This tool will allow one to mkdir, browse, view, copy, move, delete, duplicate,
# rename, and convert-ascii files on Unix or Windows systems. It uses the tcl
# <i>file</i> command to perform the 'file' actions.  The graphic extensions
# recognized are those supported by the core TK image types (.gif, .xbm, .ppm and .pgm).  
# Book-marked directories can be saved by using the <b>book-mark</b> icon on the menu bar. 
# An <b>[X]</b> icon on the toolbar deletes the current directory entry from the 
# book-mark list<i>(see Help Bookmark)</i>. The <i>find</i> boxes next to the 
# <b>Directories</b> and <b>Files</b> labels allow one to quickly find directories or 
# files by typing in some matching letters.  The <i>down</i> arrow on the keybord 
# allows one to continue the search if the first item found was not the item requested, 
# and more items in the list box contained matching letters.
# <b>cft</b> can be customized to incorporate commands simply by adding them
# using the <b>Configure Options</b> menu (<i>see Help under the Configure Options menu</i>).
# <b>cft</b> can also be extended to open a file with a particular extension with an
# application of choice using the <b>ADD</b> - <b>Associated File Types</b>
# (<i>see Help under the Associated File Types menu</i>).
# </p>
# <b>Navigating: </b>
# <p>The tool is driven by double-clicking on directories to <i>cd to</i> that
# directory. A single left-mouse button-click selects a file or directory. A
# single right-mouse button-click selects a pop-up menu with options.
# Selecting an option from the pop-up menu completes the operation. 
# Double-clicking on a file opens the file in a browser, or if one of the
# core image types, a button is created with file's image in it.
# </p>
# <b>History: </b>
# <p><b>cft</b> was originally just a collection tcl proc's to help in
# day-to-day activities.  It occurred to me that at the rate I was adding
# stuff to the utility, the tool would become unmanageable. I decided, for
# better or worse, to dump all global references into one large array (PREFS)
# and concentrate on a simple way of saving user-defined commands. This
# enabled the tool to become a little more manageable. Since I spend most of
# my time on Unix systems, I left in chmod, tarit, gzip, and unpackit. I also
# left in some handy RCS source code control commands that I use every-day.
# </p>
# <b>Platforms Tested:</b>
# <b>cft</b> has been tested on Solaris, IRIX, Linux, NT, and Windows. With
# some slight modifications to areas that test for <i>tcl_platform</i>, it
# could be used on Mac's and other untested platforms.
# </p>
# <b>Known Bugs: </b>
# <li>File Selection, when dragging and scrolling, does not continue to select
# Date and Size fields below or above the visible list area.</li>
# <li>On Windows, the <i>Browse</i> window will not show correct line/column
# count when scrolling; On Unix the line count could be off by 1
# (rounding error).
# Workaround: Place the cursor on a line and select Mouse-Button-1. </li>
# <p>
# <b>Future Work: </b>
# <li>Add Option to display additional file and directory information.
# <li>Modify the user-interface to become a little more friendly.</li>
# <li>Add more functionality.</li>
# <li>Re-do command line parsing.</li>
# <li>Work on consolidating functions (especially the RCS ones)
# <li>Possibly re-code existing procs using itcl.</li> 
# </p>
# 
# @author Henry L. Megan
#
# <b>hmeg@alpha1.net</b>
#
# <b>Copyright Notice: </b>
# This program is free software; you can redistribute it and/or modify
# it.  This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
proc sampleWindowsConfig {} {
# Example configuration file for windows.  
#  
  global PREFS
  set PREFS(DATA) {DEVELOPMENT_DIR^C:/tk/cft
MY_DIR^A:/
MY_DIR^C:/tk/cft
MY_DIR^c:/IRONMAN/DAT
MY_DIR^C:/jdk1.2.2/demo/applets/Animator
MY_DIR^C:/jdk1.2.2/demo/java3d/Text2D
MY_DIR^C:/Program Files/Tcl/doc
GENRL_BG^#cbcbcb
ACTIV_FG^#ff0000
ACTIV_BG^#ffff00
TEXTW_FG^#000000
TEXTW_BG^#ffffff
RCSBU_FG^#000000
RCSBU_BG^#ffcece
SPCBU_FG^#fe0000
SPCBU_BG^#00cee3
ENTRY_FG^#000000
ENTRY_BG^#ffffff
LSTBX_FG^#000000
LSTBX_BG^#fffffd
SELCT_FG^#ff0000
SELCT_BG^#ffff00
ENV^CLASSPATH=./
OPTIONS^Edit;1;0;0;C:\WINDOWS\WRITE.EXE+#_FILE_#+&
OPTIONS^Java;1;0;1;C:/jdk1.2.2/bin/java.exe+#_FROOT_#
OPTIONS^JavaDoc;1;0;1;C:/jdk1.2.2/bin/javadoc.exe+#_FILE_#
OPTIONS^Javac;1;0;1;C:/jdk1.2.2/bin/javac.exe+#_FILE_#
OPTIONS^Netscape;1;0;0;C:/Program Files/Netscape/Communicator/Program/netscape.exe+file://#_PWD_#/#_FILE_#+&
OPTIONS^Run;1;0;1;#_FILE_#+#_UIP_#
OPTIONS^TextPad;1;0;0;C:\TextPad\Txtpad32.exe+#_FILE_#+&
OPTIONS^XEmacs;1;0;0;C:\Program Files\XEmacs\XEmacs-21.1.6\i386-pc-win32\runemacs.exe+#_FILE_#+&
OPTIONS^diff;1;0;0;C:\csdiff12\CSDIFF.EXE
OPTIONS^find;1;1;1;C:/cygnus/cygwin-b20/H-i586-cygwin32/bin/find.exe+.+-name+#_UIP_#+-print
OPTIONS^word;1;0;0;C:/Program Files/Microsoft Office/Office/Winword.exe+#_FILE_#+&
FILE_TYPES^.doc;0;C:/Program Files/Microsoft Office/Office/Winword.exe+#_FILE_#+&
FILE_TYPES^.jar;1;C:/jdk1.2.2/bin/jar.exe+tvf+#_FILE_#
FILE_TYPES^.jpg;0;C:\Program Files\ACDSee32\ACDSee32.exe+#_FILE_#+&
FILE_TYPES^.tcl;0;C:\Program Files\Tcl\bin\wish80.exe+#_FILE_#+&
FILE_TYPES^.tk;0;C:\Program Files\Tcl\bin\wish80.exe+#_FILE_#+&
FILE_TYPES^.txt;0;C:\WINDOWS\WRITE.EXE+#_FILE_#+&
FILE_TYPES^.zip;0;C:\Program Files\WinZip\WINZIP32.EXE+#_FILE_#+&
}
browseFile "Sample of Unix Configuration File"
}
proc sampleUnixConfig {} {
# Sample configuration file cft running on Unix (Solaris).  
#  
  global PREFS
  set PREFS(DATA) {RCS_BASE_VER^v2_0
DEVELOPMENT_DIR^/usr/hmeg/devl
MY_DIR^/home/local/orbs/VBroker3.3.1
MY_DIR^/home/vendor/OpenWorks/projDir
MY_DIR^/home/usr/hmeg/devl/classesVBroker3.4/com/util
MY_DIR^/home/usr/hmeg/devl/examples/java
MY_DIR^/home/usr/hmeg/devl/java_src/corp/prj
MY_DIR^/home/usr/hmeg/tk/cft
MY_DIR^/home/usr/hmeg/utility
GENRL_FG^#000000
GENRL_BG^#cbcbcb
ACTIV_FG^#ff0000
ACTIV_BG^#ffff00
TEXTW_FG^#000000
TEXTW_BG^#ffffff
RCSBU_FG^#000000
RCSBU_BG^#ffcece
SPCBU_FG^#fe0000
SPCBU_BG^#00cee3
ENTRY_FG^#000000
ENTRY_BG^#ffffff
LSTBX_FG^#000000
LSTBX_BG^#fffffd
SELCT_FG^#ff0000
SELCT_BG^#ffff00
ENV^RCSROOT=/home/local2/corp/rcsroot
OPTIONS^RCS_BASE_VER;0;0;0;v2_0
OPTIONS^av;1;0;0;av+#_FILE_#
OPTIONS^cppdoc;1;0;0;/home/usr/hmeg/bin/cppdoc+#_FILE_#
OPTIONS^diff;1;1;0;tkdiff
OPTIONS^exec;1;0;1;#_FILE_#+#_UIP_#
OPTIONS^execl;1;0;0;#_FILE_#+&
OPTIONS^fgrep;1;1;1;/home/usr/hmeg/pl/fgrep+#_UIP_#
OPTIONS^find;1;1;1;find+.+-name+#_UIP_#+-print
OPTIONS^gdump;1;0;0;xterm+-e+gdump+#_FILE_#+&
OPTIONS^gmake;1;0;1;/usr/local/corp/bin/gmake+#_UIP_#
OPTIONS^java;1;0;1;/home/corp/bld/build/992_VBroker3.4/javl/Jre1.2/bin/java+#_FROOT_#+#_UIP_#
OPTIONS^javac;1;0;1;javac+#_FILE_#
OPTIONS^javadoc;1;0;1;/home/usr/hmeg/bin/java_doc+#_FILE_#
OPTIONS^man;1;1;1;man+#_UIP_#
OPTIONS^mgrep;1;1;1;mgrep+#_UIP_#
OPTIONS^Netscape;1;0;0;/usr/local/corp/bin/netscape/communicator-v451.sparc-sun-solaris2.5.1/netscape+file://#_PWD_#/#_FILE_#+&
OPTIONS^nmlibs;1;0;1;nmlibs+#_UIP_#
OPTIONS^print;1;0;0;nenscript+-fCourier8+-g+#_FILE_#+&
OPTIONS^soft-link;1;0;0;ln+-s+#_FILE_#+#_UIP_#+&
OPTIONS^strings;1;0;1;strings+#_FILE_#
OPTIONS^tcldoc;1;0;0;/home/usr/hmeg/bin/tcldoc+#_FILE_#
OPTIONS^tgrep;1;0;0;tgrep+#_UIP_#+&
OPTIONS^uudecode;1;0;0;uudecode+#_FILE_#+&
OPTIONS^uuencode;1;0;0;uuencode+#_FILE_#+>+#_FILE_#.uue+<+#_FILE_#
OPTIONS^uuenview;1;0;0;uuenview+-b+#_FILE_#+>+#_FROOT_#.uud
OPTIONS^vi-new;1;0;0;xterm+-e+vi+&
OPTIONS^vi;1;0;0;xterm+-title+#_FILE_#+-e+vi+#_FILE_#+&
OPTIONS^xemacs;1;0;0;xemacs+#_FILE_#+&
OPTIONS^xv;1;0;0;xv+#_FILE_#+&
FILE_TYPES^.gz;1;/usr/local/corp/bin/gzcat+#_FILE_#
FILE_TYPES^.tar;1;tar+tvf+#_FILE_#
FILE_TYPES^.tcl;0;#_FILE_#+&
}
browseFile "Sample of Unix Configuration File"
}

proc envOk {} {
# Set environment variable <i>Name:</i> with the contents of <i>Value:</i>
# and exits from the Environment set-up menu.
#  
  global env 
  global PREFS
  if { $PREFS(ENV_NAME) != "" } {
    set env($PREFS(ENV_NAME)) $PREFS(ENV_VALUE)
  }
  set PREFS(ENV_NAME)  ""
  set PREFS(ENV_VALUE) ""

  if {[winfo exists .env_conf] } {
    destroy .env_conf
  }
}

proc envCancel {} {
# Exits from the Environment set-up menu. 
#  
  set PREFS(ENV_NAME)  ""
  set PREFS(ENV_VALUE) ""
  if {[winfo exists .env_conf] } {
    destroy .env_conf
  }
}

proc helpEnv {} {
# Help info for setting environment variables.  
#  
  global PREFS
  set PREFS(DATA) {Environment Variable Editing menu:

  The Environment Variables menu, allows one to customize environment 
  variables, while running cft.  Common types of environment variables 
  changes are CLASSPATH, RCSROOT, MANPATH and others. 

  OK         To temporarily set the environment variable for the session. 
             There is no "UN-DO" once an environment variable has been set. 
             To change it, re-select the environment variable from the 
             listbox, edit in changes and use "OK" to confirm. 

  CLEAR      To create a new environment variable use the "Clear" button to 
             blank-out the "Name" and "Value" entries and type in a new one.

  OVERRIDE   To "OVERRIDE" or to remember an environment variable, from one 
             session to the next, select "Override". This saves the environment 
             variable permanently in the configuration file. 

  RE-SET     Removes the "OVERRIDE" setting and allows cft to get the "DEFAULT" 
             environment variable settings for the session next time cft is 
             launched. 

  CANCEL     The "Cancel" button only cancels out the current "Name" and 
             "Value" entries and will not create a new environment variable. 
}
browseFile "Help Environment Variables"
}
     
proc envConfig {} {
# The Environment Variable Editing menu allows one to customize
# environment variables, while running <b>cft</b>.  Common types of 
# environment variables changes might be <b>CLASSPATH, RCSROOT,</b>
# and others. To create a new environment variable use the "NEW" 
# button to blank-out the <b>Name</b> and <b>Value</b> entries.  To temporarily 
# set the environment variable, use the "OK" button. The "Override" button
# permanently saves an environment variable entry. The "Re-Set" button removes an 
# "overriden" entry.    
#<p><b>@see helpEnv</b></p>
#      
 
  if {[winfo exists .env_conf] } {
    destroy .env_conf
  }
  toplevel .env_conf 

  # Window manager configurations
  wm positionfrom . user
  wm sizefrom .env_conf ""
  wm maxsize .env_conf 1009 738
  wm minsize .env_conf 1 1
  wm title .env_conf {Environment Variables}

  global env PREFS tcl_platform

  # build widget .env_conf.label6
  label .env_conf.label6 \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -text {Environment Variables}

  # build widget .env_conf.frame
  frame .env_conf.frame \
    -background $PREFS(GENRL_BG)

  # build widget .env_conf.frame.scrollbar3
  scrollbar .env_conf.frame.scrollbar3 \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -troughcolor $PREFS(GENRL_BG) \
    -command {.env_conf.frame.listbox1 xview} \
    -orient {horizontal} \
    -relief {raised}

  # build widget .env_conf.frame.scrollbar2
  scrollbar .env_conf.frame.scrollbar2 \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -troughcolor $PREFS(GENRL_BG) \
    -command {.env_conf.frame.listbox1 yview} \
    -relief {raised}

  # build widget .env_conf.frame.listbox1
  listbox .env_conf.frame.listbox1 \
    -background $PREFS(LSTBX_BG) \
    -foreground $PREFS(LSTBX_FG) \
    -highlightcolor {#ffffffffffff} \
    -selectforeground $PREFS(SELCT_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -height {6} \
    -width {60} \
    -xscrollcommand {.env_conf.frame.scrollbar3 set} \
    -yscrollcommand {.env_conf.frame.scrollbar2 set}
  bind .env_conf.frame.listbox1 <ButtonRelease-1>  {
     set i [ .env_conf.frame.listbox1 curselection]
     if { $i != "" } {
        set item [.env_conf.frame.listbox1 get $i]
        set words [split $item =]
        set PREFS(ENV_NAME)  [lindex $words 0] 
        set PREFS(ENV_VALUE) [lindex $words 1]
     }
  }

  # build widget .env_conf.frame4
  frame .env_conf.frame4 \
    -background $PREFS(GENRL_BG) \
    -borderwidth {2} \
    -height {30} \
    -relief {raised} \
    -width {30}

  # build widget .env_conf.frame4.frame0
  frame .env_conf.frame4.frame0 \
    -background $PREFS(GENRL_BG) \
    -relief {raised}

  # build widget .env_conf.frame4.frame0.label4
  label .env_conf.frame4.frame0.label4 \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -padx {2} \
    -text {Name:}

  # build widget .env_conf.frame4.frame0.entry5
  entry .env_conf.frame4.frame0.entry5 \
    -background $PREFS(ENTRY_BG) \
    -foreground $PREFS(ENTRY_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -textvariable PREFS(ENV_NAME) \
    -width {18}
#
# Find Env Item Name
#
  bind .env_conf.frame4.frame0.entry5 <KeyRelease> {
     update idletasks
     set items [.env_conf.frame.listbox1 get 0 end]
     set ind [lsearch $items $PREFS(ENV_NAME)*]
     if { $ind >= 0 } {
       .env_conf.frame.listbox1 selection clear 0 end
       .env_conf.frame.listbox1 selection set $ind $ind
       .env_conf.frame.listbox1 activate $ind
       .env_conf.frame.listbox1 yview [expr $ind -3]
     }
   }

  # build widget .env_conf.frame4.frame5
  frame .env_conf.frame4.frame5 \
    -background $PREFS(GENRL_BG) \
    -relief {raised}

  # build widget .env_conf.frame4.frame5.label4
  label .env_conf.frame4.frame5.label4 \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -padx {2} \
    -text {Value:}

  # build widget .env_conf.frame4.frame5.entry5
  entry .env_conf.frame4.frame5.entry5 \
    -background $PREFS(ENTRY_BG) \
    -foreground $PREFS(ENTRY_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -background {white} \
    -textvariable PREFS(ENV_VALUE) \
    -width {44}
#
# Find Env Item Value
#
  bind .env_conf.frame4.frame5.entry5 <KeyRelease> {
     if { $PREFS(ENV_NAME) != "" } {
       return
     }
     update idletasks
     set items [.env_conf.frame.listbox1 get 0 end]
     set ind [lsearch $items *$PREFS(ENV_VALUE)*]
     if { $ind >= 0 } {
       .env_conf.frame.listbox1 selection clear 0 end
       .env_conf.frame.listbox1 selection set $ind $ind
       .env_conf.frame.listbox1 activate $ind
       .env_conf.frame.listbox1 yview [expr $ind -3]
     }
   }

  # build widget .env_conf.frame1
  frame .env_conf.frame1 \
    -background $PREFS(GENRL_BG) \
    -borderwidth {2} \
    -height {30} \
    -relief {raised} \
    -width {30}

  # build widget .env_conf.frame1.ok
  button .env_conf.frame1.ok \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -command envOk \
    -padx {9} \
    -pady {3} \
    -text {OK}

  # build widget .env_conf.frame1.cancel
  button .env_conf.frame1.cancel \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -command envCancel \
    -padx {9} \
    -pady {3} \
    -text {Cancel}

  # build widget .env_conf.frame1.new
  button .env_conf.frame1.new \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -command "set PREFS(ENV_NAME) {}; set PREFS(ENV_VALUE) {}" \
    -padx {9} \
    -pady {3} \
    -text {Clear}

  # build widget .env_conf.frame1.override
  button .env_conf.frame1.override \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -command {
       global PREFS
       set count 0
       set found 0
       foreach item $PREFS(ENV) {
         set words [split $item "="] 
         if { [lindex $words 0] == $PREFS(ENV_NAME) } { 
            set tmp [lreplace $PREFS(ENV) $count $count "$PREFS(ENV_NAME)=$PREFS(ENV_VALUE)" ]
            set PREFS(ENV) $tmp
            set found 1
            break;
         }
         incr count
       }
       if { $found == 0 } {
          lappend PREFS(ENV) "$PREFS(ENV_NAME)=$PREFS(ENV_VALUE)"
       }
       writeInfo
    } \
    -padx {9} \
    -pady {3} \
    -text {Override}

  # build widget .env_conf.frame1.reset
  button .env_conf.frame1.reset \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -command {
       global PREFS
       set count 0
       foreach item $PREFS(ENV) {
         set words [split $item "="]
         if { [lindex $words 0] == $PREFS(ENV_NAME) } { 
            set tmp [lreplace $PREFS(ENV) $count $count ]
            set PREFS(ENV) $tmp
         }
         incr count
       }
       writeInfo
    } \
    -padx {9} \
    -pady {3} \
    -text {Re-Set}

  # build widget .env_conf.frame1.help
  button .env_conf.frame1.help \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -command "helpEnv" \
    -padx {9} \
    -pady {3} \
    -text {Help}

  # pack master .env_conf.frame
  pack configure .env_conf.frame.scrollbar2 \
    -fill y \
    -side right
  pack configure .env_conf.frame.listbox1 \
    -expand 1 \
    -fill both
  pack configure .env_conf.frame.scrollbar3 \
    -fill x \
    -side bottom

  # pack master .env_conf.frame4
  pack configure .env_conf.frame4.frame0 \
    -fill x \
    -side left
  pack configure .env_conf.frame4.frame5 \
    -expand 1 \
    -fill both \
    -side left

  # pack master .env_conf.frame4.frame0
  pack configure .env_conf.frame4.frame0.label4 \
    -side left
  pack configure .env_conf.frame4.frame0.entry5 \
    -expand 1 \
    -fill both

  # pack master .env_conf.frame4.frame5
  pack configure .env_conf.frame4.frame5.label4 \
    -side left
  pack configure .env_conf.frame4.frame5.entry5 \
    -expand 1 \
    -fill both

  # pack master .env_conf.frame1
  pack configure .env_conf.frame1.ok \
    -side left
  pack configure .env_conf.frame1.new \
    -side left
  pack configure .env_conf.frame1.override \
    -side left
  pack configure .env_conf.frame1.reset \
    -side left
  pack configure .env_conf.frame1.cancel \
    -side left
  pack configure .env_conf.frame1.help \
    -side left

  # pack master .env_conf
  pack configure .env_conf.label6
  pack configure .env_conf.frame \
    -expand 1 \
    -fill both
  pack configure .env_conf.frame4 \
    -fill x
  pack configure .env_conf.frame1

  .env_conf.frame4.frame0.entry5 insert end {}
  .env_conf.frame4.frame5.entry5 insert end {}

  set searchid [array startsearch env]
  while {[array anymore env $searchid]} {
    set element [array nextelement env $searchid]
    lappend menu_list "$element=$env($element)"
  }
  array donesearch env $searchid
  set menu_list [lsort $menu_list]
  foreach item $menu_list {
    .env_conf.frame.listbox1 insert end $item 
  }
  setWindowPos . .env_conf 30 30
}

proc convertTextFile { } {
# Convert Text File to native. (i.e. UNIX <-> Dos...If on a Unix system, remove 
# Crtl-M from Dos files, if on Windows, add Crtl-M.  
# @global PREFS : Global array containing file selections.
#
  global PREFS
  setFileSelections 
  foreach file $PREFS(SEL_FILES) {
    set f [open $file "r"]
    set data [read $f]
    close $f
    set f [open $file "w"]
    puts -nonewline $f $data 
    close $f 
  }
}

proc colorConf { } {
# A color configuration menu that provides color control of certain 
# widgets, or their components. 
# @global PREFS : Global array containing color configurations.
#
  global PREFS

  if {[winfo exists .color_conf] } {
    destroy .color_conf
  }
  toplevel .color_conf

  # Window manager configurations
  wm positionfrom .color_conf ""
  wm sizefrom     .color_conf ""
  wm resizable    .color_conf 0 0
  wm title .color_conf {Color Configuration}

  set indx 0
  # build widget .color_conf.frame

  foreach line $PREFS(CINF) {
    set words [split $line ":"]
    frame .color_conf.frame_${indx} \
      -borderwidth {2} \
      -height {30} \
      -relief {raised} \
      -width {30}
    label .color_conf.frame_${indx}.label_${indx} \
      -text [lindex $words 0] \
      -width {25}
    button .color_conf.frame_${indx}.button_${indx} \
      -background $PREFS([lindex $words 1]) \
      -command "getColor $indx" \
      -padx {9} \
      -pady {3} \
      -width {2}
    pack configure .color_conf.frame_${indx}.label_${indx} \
      -anchor w \
      -side left
    pack configure .color_conf.frame_${indx}.button_${indx} \
      -side right
    pack configure .color_conf.frame_${indx} \
      -fill x
    incr indx
  }
  button .color_conf.b -text "OK" \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command { if {[winfo exists .get_color] == 1} \
             { destroy .get_color };destroy .color_conf }
  pack .color_conf.b
  setWindowPos . .color_conf 30 30
}

proc acceptColorSelection {indx} {
# Updates, and saves color selection from color configuration menu. 
# @param  indx : Index value of the color-array item to be updated. 
# @global PREFS : Global array containing color configurations to be updated.
#
   global PREFS

   set colr [format #%02x%02x%02x \
            [.get_color.red get] \
            [.get_color.green get] \
            [.get_color.blue get]]
   .color_conf.frame_${indx}.button_${indx} configure -background $colr

   set line [lindex $PREFS(CINF) $indx]
   set words [split $line ":"]
   set name  [lindex $words 1]
   set PREFS(${name}) $colr
   writeInfo
#
# Update Colors dynamically
#
   switch $name {
     GENRL_FG {
     }
     GENRL_BG {
     }
     TEXTW_FG {
     }
     TEXTW_BG {
     }
     RCSBU_FG {
     }
     RCSBU_BG {
     }
     SPCBU_FG {
     }
     SPCBU_BG {
     }
     ENTRY_FG {
       .menubar.ent configure -foreground $PREFS($name) 
       .menubar.ent2 configure -foreground $PREFS($name)
     }
     ENTRY_BG {
       .menubar.ent           configure -background $PREFS($name) 
       .menubar.ent2          configure -background $PREFS($name)
       .main.files.top.fentry configure -background $PREFS($name) 
       .main.dir.le.fentry    configure -background $PREFS($name)
     }
     LSTBX_FG {
       .main.dir.f.list configure -foreground $PREFS($name) 
       .main.dir0.f.list configure -foreground $PREFS($name) 
       .main.date.date_list configure -foreground $PREFS($name)
       .main.files.file_list configure -foreground $PREFS($name) 
       .main.sizes.f.size_list configure -foreground $PREFS($name) 
     }
     LSTBX_BG {
       .main.dir.f.list configure -background $PREFS($name)
       .main.dir0.f.list configure -background $PREFS($name) 
       .main.date.date_list configure -background $PREFS($name)
       .main.files.file_list configure -background $PREFS($name)
       .main.sizes.f.size_list configure -background $PREFS($name) 
     }
     SELCT_FG {
       .main.files.file_list configure -selectforeground $PREFS($name) 
       .menubar.ent configure -selectforeground $PREFS($name) 
       .menubar.ent2 configure -selectforeground $PREFS($name)
     }
     SELCT_BG {
       .main.files.file_list configure -selectbackground $PREFS($name) 
       .menubar.ent configure -selectbackground $PREFS($name) 
       .menubar.ent2 configure -selectbackground $PREFS($name)
     }
   }
   destroy .get_color
}

proc getColor {indx} {
# Selects an RGB (8-bit) color using three slider bars for the selection 
# red, blue, and green.
# @param indx : Index value of the color-array item to be updated. 
# @global PREFS : Global array containing color configurations to be
#

  # build widget .get_color
  if {[winfo exists .get_color] } {
    destroy .get_color
  }
  if {[winfo exists .color_conf] == 0 } { 
    return
  }
  toplevel .get_color

  # Window manager configurations
  wm positionfrom .get_color ""
  wm sizefrom     .get_color ""
  wm resizable .get_color 0 0
  wm title .get_color {Color Select}
  set w .get_color

  set colr [.color_conf.frame_${indx}.button_${indx} cget -background]
  scan $colr "#%02x%02x%02x" red green blue

  scale $w.red -label Red -from 0 -to 255 -length 10c \
                -orient horizontal -command newColor
  scale $w.green -label Green -from 0 -to 255 -length 10c \
                -orient horizontal -command newColor
  scale $w.blue -label Blue -from 0 -to 255 -length 10c \
                -orient horizontal -command newColor
  frame $w.sample -height 1.5c -width 6c
  pack $w.red $w.green $w.blue -side top
  pack $w.sample -side bottom -pady 2m

  proc newColor value {
# Updates a rectangles color from the slider bar selections 
#
 
  set color [format #%02x%02x%02x \
            [.get_color.red get] \
            [.get_color.green get] \
            [.get_color.blue get]]
  .get_color.sample config -background $color
  }
  button $w.ok -text "OK" -command "acceptColorSelection $indx"
  button $w.cancel -text "Cancel" -command "destroy .get_color"
  pack $w.ok $w.cancel -side left -padx 2m -pady 2m
  update idletasks
  .get_color.red    set $red
  .get_color.green  set $green
  .get_color.blue   set $blue
  setWindowPos .color_conf .get_color 30 30 
}

proc runCmd { args mode num} {
# Runs any custom command up-to 15 arguments.  
# @param args : A Text string; arguments separated by a "+" 
# @param mode : = 1, Run a command from the options pop-up menu.
# <p>           = 0, Run a file-associated command.</p> 
# @param  num : Index value from the global PREFS list indicating the selected item.   
# @global PREFS : Global array used to determine if the ouput from the command 
#                 should be "_B" browsed or "_V" viewed.   
#
#<p><B>NOTE:</b> This could be improved to access args directly.</p>

  global PREFS

  if {[winfo exists .dOpt.g] } {
    .dOpt.g configure -cursor watch
  }
  update idletasks 

  set PREFS(DATA) ""

  set count 0
  set title ""

  set words [split $args "+"]
  foreach word $words {
    if { $word != "" } {
      regsub {\{} $word {} word
      regsub {\}} $word {} word 
      set PREFS(ARG,$count) $word
      incr count
    }
  }
  set view 0

  if { $num == -1 } {
      set view 1
  } else {
    if { $mode } {
      if { $PREFS(_B${num}) } {
        set title $PREFS(_N${num}) 
        set view 1 
      } 
    } else {
      if { $PREFS(_V${num}) } {
        set title $PREFS(_E${num}) 
        set view 1
      }
    }
  }

  if { $count == 0 } {
     return
  }

  switch $count {
    1 { catch { exec $PREFS(ARG,0) } PREFS(DATA) }
    2 { catch { exec $PREFS(ARG,0) \
                     $PREFS(ARG,1) } PREFS(DATA) }
    3 { catch { exec $PREFS(ARG,0) \
                     $PREFS(ARG,1) \
                     $PREFS(ARG,2) } PREFS(DATA) }
    4 { catch { exec $PREFS(ARG,0) \
                     $PREFS(ARG,1) \
                     $PREFS(ARG,2) \
                     $PREFS(ARG,3) } PREFS(DATA) }
    5 { catch { exec $PREFS(ARG,0) \
                     $PREFS(ARG,1) \
                     $PREFS(ARG,2) \
                     $PREFS(ARG,3) \
                     $PREFS(ARG,4) } PREFS(DATA) }
    6 { catch { exec $PREFS(ARG,0) \
                     $PREFS(ARG,1) \
                     $PREFS(ARG,2) \
                     $PREFS(ARG,3) \
                     $PREFS(ARG,4) \
                     $PREFS(ARG,5) } PREFS(DATA) }
    7 { catch { exec $PREFS(ARG,0) \
                     $PREFS(ARG,1) \
                     $PREFS(ARG,2) \
                     $PREFS(ARG,3) \
                     $PREFS(ARG,4) \
                     $PREFS(ARG,5) \
                     $PREFS(ARG,6) } PREFS(DATA) }
    8 { catch { exec $PREFS(ARG,0) \
                     $PREFS(ARG,1) \
                     $PREFS(ARG,2) \
                     $PREFS(ARG,3) \
                     $PREFS(ARG,4) \
                     $PREFS(ARG,5) \
                     $PREFS(ARG,6) \
                     $PREFS(ARG,7) } PREFS(DATA) }
    9 { catch { exec $PREFS(ARG,0) \
                     $PREFS(ARG,1) \
                     $PREFS(ARG,2) \
                     $PREFS(ARG,3) \
                     $PREFS(ARG,4) \
                     $PREFS(ARG,5) \
                     $PREFS(ARG,6) \
                     $PREFS(ARG,7) \
                     $PREFS(ARG,8)} PREFS(DATA) }
   10 { catch { exec $PREFS(ARG,0) \
                     $PREFS(ARG,1) \
                     $PREFS(ARG,2) \
                     $PREFS(ARG,3) \
                     $PREFS(ARG,4) \
                     $PREFS(ARG,5) \
                     $PREFS(ARG,6) \
                     $PREFS(ARG,7) \
                     $PREFS(ARG,8) \
                     $PREFS(ARG,9)} PREFS(DATA) }
   11 { catch { exec $PREFS(ARG,0) \
                     $PREFS(ARG,1) \
                     $PREFS(ARG,2) \
                     $PREFS(ARG,3) \
                     $PREFS(ARG,4) \
                     $PREFS(ARG,5) \
                     $PREFS(ARG,6) \
                     $PREFS(ARG,7) \
                     $PREFS(ARG,8) \
                     $PREFS(ARG,9) \
                     $PREFS(ARG,10)} PREFS(DATA) }
   12 { catch { exec $PREFS(ARG,0) \
                     $PREFS(ARG,1) \
                     $PREFS(ARG,2) \
                     $PREFS(ARG,3) \
                     $PREFS(ARG,4) \
                     $PREFS(ARG,5) \
                     $PREFS(ARG,6) \
                     $PREFS(ARG,7) \
                     $PREFS(ARG,8) \
                     $PREFS(ARG,9) \
                     $PREFS(ARG,10) \
                     $PREFS(ARG,11)} PREFS(DATA) }
   13 { catch { exec $PREFS(ARG,0) \
                     $PREFS(ARG,1) \
                     $PREFS(ARG,2) \
                     $PREFS(ARG,3) \
                     $PREFS(ARG,4) \
                     $PREFS(ARG,5) \
                     $PREFS(ARG,6) \
                     $PREFS(ARG,7) \
                     $PREFS(ARG,8) \
                     $PREFS(ARG,9) \
                     $PREFS(ARG,10) \
                     $PREFS(ARG,11) \
                     $PREFS(ARG,12)} PREFS(DATA) }
   14 { catch { exec $PREFS(ARG,0) \
                     $PREFS(ARG,1) \
                     $PREFS(ARG,2) \
                     $PREFS(ARG,3) \
                     $PREFS(ARG,4) \
                     $PREFS(ARG,5) \
                     $PREFS(ARG,6) \
                     $PREFS(ARG,7) \
                     $PREFS(ARG,8) \
                     $PREFS(ARG,9) \
                     $PREFS(ARG,10) \
                     $PREFS(ARG,11) \
                     $PREFS(ARG,12) \
                     $PREFS(ARG,13)} PREFS(DATA) }
   15 { catch { exec $PREFS(ARG,0) \
                     $PREFS(ARG,1) \
                     $PREFS(ARG,2) \
                     $PREFS(ARG,3) \
                     $PREFS(ARG,4) \
                     $PREFS(ARG,5) \
                     $PREFS(ARG,6) \
                     $PREFS(ARG,7) \
                     $PREFS(ARG,8) \
                     $PREFS(ARG,9) \
                     $PREFS(ARG,10) \
                     $PREFS(ARG,11) \
                     $PREFS(ARG,12) \
                     $PREFS(ARG,13) \
                     $PREFS(ARG,14)} PREFS(DATA) }
    default { setErrMsg "too may arguments ... 15 max..." 7000 }
  }
  if {[winfo exists .doit_opt] } {
    .doit_opt configure -cursor        left_ptr
    .doit_opt.top.e configure -cursor  left_ptr
    .doit_opt.bot.ok configure -cursor left_ptr 
    update idletasks
  }
  if {[winfo exists .dOpt.g] } {
    .dOpt.g configure -cursor          left_ptr
  }
  if {$view} {
    browseFile $title
  }
}

proc setFileSelections {} {
# Save file selections from listboxes, into global SEL_FILES  
# @global PREFS : Global array used to capture file selections 
#                <b>"PREFS(SEL_FILES)"</b>   
#
  global PREFS

  set PREFS(SEL_FILES) ""
  set count 0
  set item ""
  set i [.main.files.file_list curselection]
  foreach k $i {
    set item [.main.files.file_list get $k]
    if {$item != ""} {
      lappend PREFS(SEL_FILES) $item
    }
    incr count
  }
  if {$count == 0} {
    set count 0
    set item ""
    set i [.main.dir.f.list curselection]
    foreach k $i {
      set item [.main.dir.f.list get $k]
      if {$item != ""} {
        lappend PREFS(SEL_FILES) $item
      }
      incr count
    }
  }
}

proc doCmd {num mode} {
# Parse and run command from either options, or file  
# associations menu; Replace <b>#_FILE_#</B> with the currently selected
# file and <b>$_UIP_#</b> with the user input dialog entry.
# @param  num :  Index value from the global PREFS list indicating the selected item.   
# @param mode :  = 1, Run a command from the options pop-up menu.
# <p>            = 0, Run a file-associated command.</p> 
# @global PREFS : Global array used to capture the <b>static</b> part of 
#                 of the command <b>"PREFS(_X$num)"</b>   
#
  global PREFS

  setFileSelections

  if { $mode } {
    set cmd $PREFS(_X${num})
    if {([string first "#_FILE_#"  $cmd] >= 0) ||\
        ([string first "#_PWD_#"   $cmd] >= 0) ||\
        ([string first "#_FROOT_#" $cmd] >= 0) } { 
      foreach item $PREFS(SEL_FILES) {
        set froot [file rootname $item]
        if {[regsub -all {#_FILE_#}  $cmd $item  cmd]} {
          regsub    -all {#_FROOT_#} $cmd $froot cmd
          regsub    -all {#_PWD_#}   $cmd [pwd]  cmd
          runCmd ${cmd} 1 $num
        } elseif {[regsub -all {#_FROOT_#} $cmd $froot cmd]} {
	        regsub    -all {#_PWD_#}   $cmd [pwd]  cmd
          runCmd ${cmd} 1 $num
	      } elseif {[regsub -all {#_PWD_#}   $cmd [pwd]  cmd]} {
          runCmd ${cmd} 1 $num
	      }
      } 
      if {[llength $PREFS(SEL_FILES)] == 0 } {
        set cmd $PREFS(_X${num})
        regsub -all {#_FILE_#}  $cmd {} cmd
        regsub -all {#_FROOT_#} $cmd {} cmd
        regsub -all {#_PWD_#}   $cmd {} cmd
        runCmd ${cmd} 1 $num
      }
    } else {
      runCmd $PREFS(_X${num}) 1 $num 
    }
  } else {
    if {[llength $PREFS(SEL_FILES)] == 0 } {
      return
    } else {
      set cmd $PREFS(_O${num}) 
      set item [lindex $PREFS(SEL_FILES) 0]
      set froot [file rootname $item]
      if {$item != ""} {
        if {[regsub -all {#_FILE_#}  $cmd ${item}  cmd]} {
          regsub    -all {#_FROOT_#} $cmd ${froot} cmd
	        regsub    -all {#_PWD_#}   $cmd [pwd]    cmd
          runCmd ${cmd} 0 $num
        } elseif {[regsub -all {#_FROOT_#}  $cmd ${item} cmd]} {
	        regsub    -all {#_PWD_#}   $cmd [pwd]    cmd
          runCmd ${cmd} 0 $num
	      } elseif {[regsub -all {#_PWD_#}    $cmd [pwd] cmd]} {
          runCmd ${cmd} 0 $num
        }
      } 
    }
  }
  set PREFS(SEL_FILES) ""
} 

proc getFilePath {i w} {
#<p>
# A pop-up file selection menu that is activated when trying to locate 
# a new command 
#</p>
# @param i : index value of the command to be inserted
# @param w : parent widget. 
#
  global PREFS

  set types {
            {{All Files}    *}
            {{tcl files}    .tcl}
            {{Born Shells}  .sh}
            {{Dos command}  .com}
            {{C Shells}     .csh}
            {{Korn Shells}  .ksh}
            {{Executables}  .exe}
            {{Dos Command}  .bat}
            }

  set file [tk_getOpenFile -filetypes $types -title "Browse..."]
  if {$w == ".options"} {
    if {[file exists $file]} {
      set PREFS(_X${i}) $file
    }
  } else {
    if {[file exists $file]} {
      set PREFS(_O${i}) $file
    }
  }
  focus $w
}  

proc showOptions {} {
#<p>
# A pop-up menu that is activated using the <b>right-mouse-button</b>.  
# <b>New</b> "customized" buttons can be added by using the 
# <b>Configure Options </b> menu and using the "ADD" button.  
#</p>
# @see "Configure Options Help"
# @global PREFS : Global array used to hold all information about each  
#                 command <b>"PREFS(_N), PREFS(_X), PREFS(_F), etc."</b>   
#

  if {[winfo exists .options] } {
    destroy .options
  }
  toplevel .options  
  global PREFS env 
  global tcl_platform

  # Window manager configurations
  wm positionfrom   .options ""
  wm sizefrom       .options program
  wm maxsize        . 1265 994
  wm minsize        . 1 1
#  wm resizable     .options 0 0
  wm title .options {options}

  set PREFS(YC) 15

  # build widget .options.f
  frame .options.f \
    -background $PREFS(GENRL_BG) \
    -borderwidth {2} \
    -height {30} \
   -relie {raised} \
    -width {30}

  # build widget .options.frameb
  frame .options.frameb \
    -background $PREFS(GENRL_BG) \
    -borderwidth {2} \
    -height {30} \
    -relief {raised} \
    -width {30}

  button .options.frameb.b0 \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -text "OK" \
    -command "updateOptions"
  button .options.frameb.b1 \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -text "ADD" \
    -command "addOptions"
  button .options.frameb.b2 \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -text "Help" \
    -command "helpOptions"

  set w_file test_tile
  set w_size 10

  if { $PREFS(OPT_COUNT) == 0 } {
    if {![string compare "windows" $tcl_platform(platform)]} {
      lappend PREFS(OPTIONS) "Edit;1;0;0;c:\\windows\\notepad.exe+#_FILE_#+&"
    } else {
      lappend PREFS(OPTIONS) "Edit;1;0;0;xterm+-e+vi+#_FILE_#+&"  
    }
    set PREFS(OPT_COUNT) 1
  }

  set hh 0
  if {$PREFS(OPT_COUNT) <= 10} { 
    set hh [expr $PREFS(OPT_COUNT) * $PREFS(OPT_H)]
  } else {
    set hh [expr $PREFS(OPT_H) * 10]
  }

  set PREFS(OPTIONS) [lsort $PREFS(OPTIONS)]
   canvas .options.f.can  \
    -background $PREFS(GENRL_BG) \
    -width $PREFS(OPT_W) \
    -height $hh \
    -yscrollcommand ".options.f.vscr set"  \
    -xscrollcommand ".options.f.hscr set"  \
    -confine false

   scrollbar .options.f.vscr  \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -troughcolor $PREFS(GENRL_BG) \
    -command ".options.f.can yview"

   scrollbar .options.f.hscr  \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -troughcolor $PREFS(GENRL_BG) \
    -orient horizontal \
    -command ".options.f.can xview"

   pack .options.f.vscr \
        -side right \
        -fill y
   pack .options.f.hscr \
        -side bottom \
        -fill x
  
   pack .options.f.can \
        -side left  \
        -expand yes \
        -fill both

  set i 0
  foreach item $PREFS(OPTIONS) {
    set words [split $item ";"]
    set PREFS(_N${i}) [lindex $words 0]
    set PREFS(_F${i}) [lindex $words 1]
    set PREFS(_D${i}) [lindex $words 2]
    set PREFS(_B${i}) [lindex $words 3]
    set PREFS(_X${i}) [lindex $words 4]

   # build widget .options.f.can.frame_${i}
    frame .options.f.can.frame_${i} \
     -background $PREFS(GENRL_BG) \
     -borderwidth {2} \
     -height {30} \
     -relief {raised} \
     -width {30}

    # build widget .options.f.can.frame_${i}.frame_1
    frame .options.f.can.frame_${i}.frame_1 \
      -background $PREFS(GENRL_BG) \
      -relief {raised}

    # build widget .options.f.can.frame_${i}.frame_1.label4
    label .options.f.can.frame_${i}.frame_1.label4 \
      -background $PREFS(GENRL_BG) \
      -foreground $PREFS(GENRL_FG) \
      -padx {2} \
      -relief {flat} \
      -text {Name:}

    # build widget .options.f.can.frame_${i}.frame_1.entry5
    entry .options.f.can.frame_${i}.frame_1.entry5 \
      -background $PREFS(ENTRY_BG) \
      -foreground $PREFS(ENTRY_FG) \
      -selectbackground $PREFS(SELCT_BG) \
      -selectforeground $PREFS(SELCT_FG) \
      -textvariable PREFS(_N${i}) \
      -width {10} \
      -relief {sunken}

    # build widget .options.f.can.frame_${i}.frame_2
    frame .options.f.can.frame_${i}.frame_2 \
      -background $PREFS(GENRL_BG) \
      -relief {raised}

    # build widget .options.f.can.frame_${i}.frame_2.label4
    label .options.f.can.frame_${i}.frame_2.label4 \
      -background $PREFS(GENRL_BG) \
      -foreground $PREFS(GENRL_FG) \
      -padx {2} \
      -relief {flat} \
      -text {Setting:}

  # build widget .options.f.can.frame_${i}.frame_2.entry5
    entry .options.f.can.frame_${i}.frame_2.entry5 \
      -background $PREFS(ENTRY_BG) \
      -foreground $PREFS(ENTRY_FG) \
      -selectbackground $PREFS(SELCT_BG) \
      -selectforeground $PREFS(SELCT_FG) \
      -width {40} \
      -textvariable PREFS(_X${i}) \
      -relief {sunken}

  # build widget .options.f.can.frame_${i}.frame_2.button
    button .options.f.can.frame_${i}.frame_2.button \
      -activeforeground $PREFS(ACTIV_FG) \
      -activebackground $PREFS(ACTIV_BG) \
      -background $PREFS(GENRL_BG) \
      -foreground $PREFS(GENRL_FG) \
      -command "getFilePath $i .options" \
      -relief {raised} \
      -text {Browse...}

  # build widget .options.f.can.frame_${i}.frame_2.button
    button .options.f.can.frame_${i}.frame_2.button2 \
      -activeforeground $PREFS(ACTIV_FG) \
      -activebackground $PREFS(ACTIV_BG) \
      -background $PREFS(GENRL_BG) \
      -foreground $PREFS(GENRL_FG) \
      -command "deleteOption ${i}" \
      -relief {raised} \
      -text {Delete}

  # build widget .options.f.can.frame_${i}.frame_3
    frame .options.f.can.frame_${i}.frame_3 \
      -background $PREFS(GENRL_BG) \
      -relief {raised}

  # build widget .options.f.can.frame_${i}.frame_4
    frame .options.f.can.frame_${i}.frame_4 \
      -background $PREFS(GENRL_BG) \
      -relief {raised}

  # build widget .options.f.can.frame_${i}.frame_4.check1
    checkbutton .options.f.can.frame_${i}.frame_4.check1 \
      -width {4} \
      -activeforeground $PREFS(ACTIV_FG) \
      -activebackground $PREFS(ACTIV_BG) \
      -background $PREFS(GENRL_BG) \
      -foreground $PREFS(GENRL_FG) \
      -highlightcolor {#ffffff} \
      -relief {raised} \
      -selectcolor {red} \
      -text {file} \
      -variable PREFS(_F${i})

  # build widget .options.f.can.frame_${i}.frame_4.check2
    checkbutton .options.f.can.frame_${i}.frame_4.check2 \
      -width {4} \
      -activeforeground $PREFS(ACTIV_FG) \
      -activebackground $PREFS(ACTIV_BG) \
      -background $PREFS(GENRL_BG) \
      -foreground $PREFS(GENRL_FG) \
      -highlightcolor {#ffffff} \
      -relief {raised} \
      -selectcolor {red} \
      -text {dir} \
      -variable PREFS(_D${i})

  # build widget .options.f.can.frame_${i}.frame_4.check3
    checkbutton .options.f.can.frame_${i}.frame_4.check3 \
      -width {4} \
      -activeforeground $PREFS(ACTIV_FG) \
      -activebackground $PREFS(ACTIV_BG) \
      -background $PREFS(GENRL_BG) \
      -foreground $PREFS(GENRL_FG) \
      -highlightcolor {#ffffff} \
      -relief {raised} \
      -selectcolor {red} \
      -text {view} \
      -variable PREFS(_B${i})

  # pack master .options.f.can.frame_${i}
    pack configure .options.f.can.frame_${i}.frame_1 \
      -expand 1 \
      -fill both \
      -side left
    pack configure .options.f.can.frame_${i}.frame_2 \
      -expand 1 \
      -fill both \
      -side left
    pack configure .options.f.can.frame_${i}.frame_3 \
       -expand 1 \
       -fill both \
       -side left
    pack configure .options.f.can.frame_${i}.frame_4 \
       -expand 1 \
       -fill both \
       -side left

  # pack master .options.f.can.frame_${i}.frame_1

    pack configure .options.f.can.frame_${i}.frame_1.label4 \
      -side left
    pack configure .options.f.can.frame_${i}.frame_1.entry5 \
      -expand 1 \
      -fill both

  # pack master .options.f.can.frame_${i}.frame_2
    pack configure .options.f.can.frame_${i}.frame_2.label4 \
      -side left
    pack configure .options.f.can.frame_${i}.frame_2.entry5 \
      -expand 1 \
      -side left \
      -fill both
    pack configure .options.f.can.frame_${i}.frame_2.button \
         -side left \
         -fill x
    pack configure .options.f.can.frame_${i}.frame_2.button2 \
         -side left \
         -fill x

    pack configure .options.f.can.frame_${i}.frame_4.check1 \
         -side left  
    pack configure .options.f.can.frame_${i}.frame_4.check2 \
         -side left
    pack configure .options.f.can.frame_${i}.frame_4.check3 \
         -side left
  
  # pack master .options
    pack configure .options.f.can.frame_${i} \
      -fill x \
      -expand 1
#
# determine the size of .options.f.can.frame_${i}
#
    .options.f.can create window 0 $PREFS(YC) \
       -anchor "w" -width $PREFS(OPT_W) -height $PREFS(OPT_H) \
       -window .options.f.can.frame_${i}   

    .options.f.can configure  -scrollregion "0 0 $PREFS(OPT_W) [expr $PREFS(YC) +2]"

    set PREFS(YC) [expr $PREFS(YC) + $PREFS(OPT_H)]
    incr i
  }

  set PREFS(OPT_COUNT) $i

  pack .options.frameb.b0 \
       -side left \
       -fill x
  pack .options.frameb.b1\
       -side left \
       -fill x
  pack .options.frameb.b2\
       -side left \
       -fill x

  pack .options.f \
       -side top \
       -fill both \
       -expand 1
  pack .options.frameb -side bottom

  tkwait visibility .options
  setWindowPos . .options 30 30
}

proc testOptions {} {
#<p>
# Due to differing screen resolutions, available fonts, etc., a test "options"   
# pop-up menu is activated at start-up to determine the width of the options menu.  
# The Height of a row is stored in global <b>PREFS(OPT_H)</b> and the width is 
# stored in <b>PREFS(OPT_W)</b>
#

  if {[winfo exists .t_options] } {
    destroy .t_options
  }
  toplevel .t_options  
  global PREFS  

  # Window manager configurations
  wm positionfrom   .t_options ""
  wm sizefrom       .t_options program
  wm maxsize        . 1265 994
  wm minsize        . 1 1

  frame .t_options.f  -borderwidth {2}           -relief {raised}
  label .t_options.f.label1    -padx {2}         -relief {flat}  -text {Name:}
  entry .t_options.f.entry1    -width {10}       -relief {sunken}
  label .t_options.f.label2    -padx {2}         -relief {flat}  -text {Setting:}
  entry .t_options.f.entry2    -width {40}       -relief {sunken}
  button .t_options.f.button   -relief {raised}  -text {Browse...}
  button .t_options.f.button2  -relief {raised}  -text {Delete}
  checkbutton .t_options.f.check1 -width {4} -relief {raised}  -text {file}
  checkbutton .t_options.f.check2 -width {4} -relief {raised}  -text {dir} 
  checkbutton .t_options.f.check3 -width {4} -relief {raised}  -text {view} 

  pack configure .t_options.f.label1  -side left
  pack configure .t_options.f.entry1  -side left -expand 1 -fill both
  pack configure .t_options.f.label2  -side left
  pack configure .t_options.f.entry2  -expand 1  -side left  -fill both
  pack configure .t_options.f.button  -side left  -fill x
  pack configure .t_options.f.button2 -side left  -fill x
  pack configure .t_options.f.check1  -side left  
  pack configure .t_options.f.check2  -side left
  pack configure .t_options.f.check3  -side left
  pack .t_options.f  -side top  -fill both  -expand 1 
  tkwait visibility  .t_options 

  set ww [split [winfo geometry .t_options] x]
  set PREFS(OPT_W) [lindex $ww 0]
  set hh [split [lindex $ww 1] +]
  set PREFS(OPT_H) [lindex $hh 0]

  destroy .t_options
}

proc addOptions {} {
# Adds a new blank entry to the options menu.  The <b>Name</b> and
# <b>Settings</b> field must be completed to save the entry.
#    
  if {[winfo exists .options] == 0} {
    return
  }
  global PREFS env
  set i $PREFS(OPT_COUNT)
  lappend PREFS(OPTIONS) ";1;0;0;"
  incr PREFS(OPT_COUNT)
  destroy .options
  update idletasks
  showOptions  
}

proc deleteOption { index } {
# Removes an entry from the options menu.
#
# @param index : <b>PREFS(_N$index),PREFS(_X$index)</b> are set to "" so 
# the value is removed from the menu. 
#
  global PREFS
  if {[winfo exists .options] == 0} {
    return
  }
  destroy .options
  set PREFS(_N${index}) ""
  set PREFS(_X${index}) ""
  updateOptions
  showOptions
}       

proc updateOptions {} {
#  Saves options after an add, delete or "OK" button was pressed. 
#
  global PREFS
  set PREFS(OPTIONS) ""
  set ck $PREFS(OPT_COUNT)
  set PREFS(OPT_COUNT) 0

  for {set i 0} {$i < $ck} {incr i} {
    set item  "$PREFS(_N${i});$PREFS(_F${i});$PREFS(_D${i});$PREFS(_B${i});$PREFS(_X${i})"
    if { ($PREFS(_N${i}) != "") && \
         ($PREFS(_X${i}) != "") && \
           ([lsearch -exact $PREFS(OPTIONS) $item] < 0)} { 
	     lappend PREFS(OPTIONS) $item
        incr PREFS(OPT_COUNT)
    }
  }
  set PREFS(OPTIONS) [lsort $PREFS(OPTIONS)]

  writeInfo
  if {[winfo exists .options] > 0} { 
    destroy .options
  }
}

proc helpOptions {} {
#  Help information for the options menu. 
#

global PREFS
set PREFS(DATA) {
Add Options:

  The Options menu allows one to 'customize' the pop-up menu that 
  appears when the right mouse button is pressed.  The pop-up menu
  has Options that are sensitive to whether you have selected a directory,
  or file. 
  Buttons:
         Name:     = Name or title of the command.
         Setting:  = Command to be executed.
         Browse    = Pop-up file dialog box that can be used to find the program 
                     when creating a 'Settings' command.  
         []cmd     = Must be toggled in order to run. Un-toggled will 
                     preserve the command, but will not show-up on the pop-up
                     menu. 
         []usr     = It causes a pop-up dialog menu to appear, so the user can 
                     complete the argument sequence at run-time.
                     It causes a pop-up entry dialog to appear.
         []file    = The command can be run against a file.
         []dir     = The command can be run against a dir.
         []view    = View output after the command is complete   

  Rules:
          #_FILE_# = Is replaced with current selected file.
          #_FROOT_#= Is replaced with current selected file... 
                     (root part of the name only)
          #_UIP_#  = Is replaced with user defined arguments.
          #_PWD_#  = Is replaced with "Print Working Directory"
          
  Special Name:
          if Name = diff, then  diff1, diff2 buttons are generated to 
          accomodate selecting the two files...(file-comparisons)    
                  
  Common options (defaults):
    Directories:
      Mkdir  = Make a new directory in current path.
    Directories and Files:
      Rename = Rename selected file/dir to new name.
      Delete = Delete selected file or recursively descend a directory and
               delete all files in a directory including the directory itself.
      Copy   = Save the name of the file to be completed with Paste.
      Cut    = Save the name of the file to moved with Paste.
      Paste  = Completes Copy or Cut sequence.
      Convert= Convert an ascii file from its original format to current system's format (e.g DOS->Unix)
      Chmod  = (unix-only) sets file attribute to user specifications. 
      Tarit  = (unix-only) Creates a tar-compressed file of the selected file.
      Gzip   = (unix_only) Created a tar-gzip file of the selected file.
  
  Examples:
  1.  Run a vi session:
          Start an xterm that executes vi that include the selected file and
          run the process in the background.
        
      Set-up:
                    Name: Vi  
                 Setting: xterm+-e+vi+#_FILE_#+& 
          Toggle buttons: [x]file [ ]dir [ ]view 

          Where - #_FILE_# will be replaced with user's selection.
                - arguments are separated with '+'
 
	        - [x]file states that you want to be able to edit (using vi) 
                  the selected file. 
 
   2. Run a Java program:
          Run the java virtial machine against a foo.class file and  
          supply 'user-defined' arguments at run-time. 
   
     Set-up:      
                    Name: java 
                Settings: java+#_FROOT_#+#_UIP_# 
          Toggle buttons: [x]file [ ]dir [x]view 
        
          Where - #_UIP_# will be replaced with a user defined argument.
                - arguments are separated with '+' 

	        - [x]file states that you want to be able to access the find 
                  command when you are over the file list portion and right 
                  mouse button 1 is pressed.
          - [x]view causes the results from the find command to be 
                  displayed.
 
   3. Find a file:
          Run the find command (unix) with all arguments to the find command 
          defined except for the 'user-defined' one.
   
     Set-up:      
                    Name: find 
                Settings: find+.+-name+#_UIP_#+-print 
          Toggle buttons: [x]file [x]dir [x]view 
        
          Where - #_UIP_# will be replaced with a user defined argument.
                - arguments are separated with '+' 

	        - [x]file states that you want to be able to access the find 
                  command when you are over the file list portion and right 
                  mouse button 1 is pressed.
          - [x]dir same as above except it applies when you are over the
                  directory list portion and the right button 1 is pressed.
          - [x]view causes the results from the find command to be 
                  displayed.


    4. uuencode/uudecode a file:
          Run the unix uuencode utility to encode a binary or text file for 
          mailing...  decode a file for reading.
   
     Set-up:
                    Name: uuencode
                Settings: uuencode+#_FILE_#+>+#_FILE_#.uue+<+#_FILE_#

                    Name: uudecode
                settings: uudecode+#_FILE_#+&
         
          Toggle buttons: [x]file [ ]dir [ ]view
                  

          Where - #_FILE_# is used to specify the input file, and to create 
                  the output file (by appending .uue to the input file name). 
                  If in the case of uudecode; It is the imput file.

	        - [x]file states that you want to be able to run the uuencode 
                  command on the selected file name. 


    5. Exec a file:
           Run a program from the file menu, prompt the user for addition 
           command-line arguments and run the job in the background. 
               
      Set-up:
                    Name: Exec
                Settings: #_FILE_#+#_UIP_#+&
          Toggle buttons: [x]file [ ]dir [ ]view

          Where - #_FILE_# is the program or shell script to be executed.

                - [x]file states that you want to be able to run the selected 
                  file name.
                 

	 ** Note #_UIP_# in the argument list causes a pop-up dialog to appear, 
            getting user's arguments, and are used at run-time.
}
browseFile "Help Options"
} 

proc showFileTypes { } {
#<p>
# Menu that allows one to associate a file with some action.
#</p>
# @see "Configure Options Help"
#

  toplevel .file_types  
  global PREFS env 
  global tcl_platform

  # Window manager configurations
  wm positionfrom .file_types ""
  wm sizefrom   .file_types program
  wm maxsize . 1265 994
  wm minsize . 1 1
  wm title .file_types {File Types}

  set PREFS(YC) 15

  # build widget .file_types.f
  frame .file_types.f \
    -background $PREFS(GENRL_BG) \
    -borderwidth {2} \
    -height {30} \
   -relie {raised} \
    -width {30}

  # build widget .file_types.frameb
  frame .file_types.frameb \
    -background $PREFS(GENRL_BG) \
    -borderwidth {2} \
    -height {30} \
    -relief {raised} \
    -width {30}

  button .file_types.frameb.b0 \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -text "OK" \
    -command "updateFileTypes"
  button .file_types.frameb.b1 \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -text "ADD" \
    -command "addFileTypes"
  button .file_types.frameb.b2 \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -text "Help"  \
    -command "helpFileTypes"

  set w_file test_tile
  set w_size 10
#
# Insert a default action if none exist 
#
  if { $PREFS(FTYPE_COUNT) == 0 } {
    if {![string compare "windows" $tcl_platform(platform)]} {
      lappend PREFS(FILE_TYPES) ".txt;0;c:\\winnt\\notepad.exe+#_FILE_#+&"
    } else {
      lappend PREFS(FILE_TYPES) ".txt;0;xterm+-e+vi+#_FILE_#+&"  
    }
    set PREFS(FTYPE_COUNT) 1
  }

  set hh 0
  if {$PREFS(FTYPE_COUNT) <= 10} { 
    set hh [expr $PREFS(FTYPE_COUNT) * $PREFS(FT_H)]
  } else {
    set hh [expr  $PREFS(FT_H) * 10]
  }

  set PREFS(FILE_TYPES) [lsort $PREFS(FILE_TYPES)]
   canvas .file_types.f.can  \
    -background $PREFS(GENRL_BG) \
    -height $hh \
    -width $PREFS(FT_W) \
    -yscrollcommand ".file_types.f.vscr set"  \
    -xscrollcommand ".file_types.f.hscr set"  \
    -confine false

   scrollbar .file_types.f.vscr  \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -troughcolor $PREFS(GENRL_BG) \
    -command ".file_types.f.can yview"

   scrollbar .file_types.f.hscr  \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -troughcolor $PREFS(GENRL_BG) \
    -orient horizontal \
    -command ".file_types.f.can xview"

   pack .file_types.f.vscr \
        -side right \
        -fill y
   pack .file_types.f.hscr \
        -side bottom \
        -fill x
  
   pack .file_types.f.can \
        -side left  \
        -expand yes \
        -fill both

  set i 0
  foreach item $PREFS(FILE_TYPES) {
    set words [split $item ";"]
    set PREFS(_E${i}) [lindex $words 0]
    set PREFS(_V${i}) [lindex $words 1]
    set PREFS(_O${i}) [lindex $words 2]

   # build widget .file_types.f.can.frame_${i}
    frame .file_types.f.can.frame_${i} \
     -background $PREFS(GENRL_BG) \
     -borderwidth {2} \
     -height {30} \
     -relief {raised} \
     -width {30}

    # build widget .file_types.f.can.frame_${i}.frame_1
    frame .file_types.f.can.frame_${i}.frame_1 \
      -background $PREFS(GENRL_BG) \
      -relief {raised}

    # build widget .file_types.f.can.frame_${i}.frame_1.label4
    label .file_types.f.can.frame_${i}.frame_1.label4 \
      -background $PREFS(GENRL_BG) \
      -foreground $PREFS(GENRL_FG) \
      -padx {2} \
      -relief {flat} \
      -text {Extension:}

    # build widget .file_types.f.can.frame_${i}.frame_1.entry5
    entry .file_types.f.can.frame_${i}.frame_1.entry5 \
      -background $PREFS(ENTRY_BG) \
      -foreground $PREFS(ENTRY_FG) \
      -selectbackground $PREFS(SELCT_BG) \
      -selectforeground $PREFS(SELCT_FG) \
      -textvariable PREFS(_E${i}) \
      -width {10} \
      -relief {sunken}

    # build widget .file_types.f.can.frame_${i}.frame_2
    frame .file_types.f.can.frame_${i}.frame_2 \
      -background $PREFS(GENRL_BG) \
      -relief {raised}

    # build widget .file_types.f.can.frame_${i}.frame_2.label4
    label .file_types.f.can.frame_${i}.frame_2.label4 \
      -background $PREFS(GENRL_BG) \
      -foreground $PREFS(GENRL_FG) \
      -padx {2} \
      -relief {flat} \
      -text {Open With:}

  # build widget .file_types.f.can.frame_${i}.frame_2.entry5
    entry .file_types.f.can.frame_${i}.frame_2.entry5 \
      -background $PREFS(ENTRY_BG) \
      -foreground $PREFS(ENTRY_FG) \
      -selectbackground $PREFS(SELCT_BG) \
      -selectforeground $PREFS(SELCT_FG) \
      -width {40} \
      -textvariable PREFS(_O${i}) \
      -relief {sunken}

  # build widget .file_types.f.can.frame_${i}.frame_2.browse
    button .file_types.f.can.frame_${i}.frame_2.browse \
      -activeforeground $PREFS(ACTIV_FG) \
      -activebackground $PREFS(ACTIV_BG) \
      -background $PREFS(GENRL_BG) \
      -foreground $PREFS(GENRL_FG) \
      -command "getFilePath $i .file_types" \
      -relief {raised} \
      -text {Browse...}

  # build widget .file_types.f.can.frame_${i}.frame_2.button2
    button .file_types.f.can.frame_${i}.frame_2.button2 \
      -activeforeground $PREFS(ACTIV_FG) \
      -activebackground $PREFS(ACTIV_BG) \
      -background $PREFS(GENRL_BG) \
      -foreground $PREFS(GENRL_FG) \
      -command "deleteFileTypes ${i}" \
      -relief {raised} \
      -text {Delete}

  # build widget .file_types.f.can.frame_${i}.frame_3
    frame .file_types.f.can.frame_${i}.frame_3 \
      -background $PREFS(GENRL_BG) \
      -relief {raised}

  # build widget .file_types.f.can.frame_${i}.frame_3.check1
    checkbutton .file_types.f.can.frame_${i}.frame_3.check1 \
      -width {4} \
      -activeforeground $PREFS(ACTIV_FG) \
      -activebackground $PREFS(ACTIV_BG) \
      -background $PREFS(GENRL_BG) \
      -foreground $PREFS(GENRL_FG) \
      -highlightcolor {#ffffff} \
      -relief {raised} \
      -selectcolor {red} \
      -text {View} \
      -variable PREFS(_V${i})

  # pack master .file_types.f.can.frame_${i}
    pack configure .file_types.f.can.frame_${i}.frame_1 \
      -expand 1 \
      -fill both \
      -side left
    pack configure .file_types.f.can.frame_${i}.frame_2 \
      -expand 1 \
      -fill both \
      -side left
    pack configure .file_types.f.can.frame_${i}.frame_3 \
       -expand 1 \
       -fill both \
       -side left

  # pack master .file_types.f.can.frame_${i}.frame_1

    pack configure .file_types.f.can.frame_${i}.frame_1.label4 \
      -side left
    pack configure .file_types.f.can.frame_${i}.frame_1.entry5 \
      -expand 1 \
      -fill both

  # pack master .file_types.f.can.frame_${i}.frame_2
    pack configure .file_types.f.can.frame_${i}.frame_2.label4 \
      -side left
    pack configure .file_types.f.can.frame_${i}.frame_2.entry5 \
      -expand 1 \
      -side left \
      -fill both
    pack configure .file_types.f.can.frame_${i}.frame_2.browse \
         -side left \
         -fill x
    pack configure .file_types.f.can.frame_${i}.frame_2.button2 \
         -side left \
         -fill x

    pack configure .file_types.f.can.frame_${i}.frame_3.check1 \
         -side left  

  # pack master .file_types
    pack configure .file_types.f.can.frame_${i} \
      -fill x \
      -expand 1

    .file_types.f.can create window 0 $PREFS(YC) \
       -anchor "w" -width $PREFS(FT_W) -height $PREFS(FT_H) \
       -window .file_types.f.can.frame_${i}   

    .file_types.f.can configure  -scrollregion "0 0 $PREFS(FT_W) [expr $PREFS(YC) +2]"

    set PREFS(YC) [expr $PREFS(YC) + $PREFS(FT_H)]
    incr i
  }

  set PREFS(FTYPE_COUNT) $i

  pack .file_types.frameb.b0 \
       -side left \
       -fill x
  pack .file_types.frameb.b1\
       -side left \
       -fill x
  pack .file_types.frameb.b2\
       -side left \
       -fill x

  pack .file_types.f \
       -side top \
       -fill both \
       -expand 1
  pack .file_types.frameb -side bottom

  update idletasks
  set hw  [split [winfo geometry .file_types] x]
  set hh  [split [lindex $hw 1 ] +]
  set cw [lindex $hw 0]
  set ch [lindex $hh 0]

  setWindowPos . .file_types 30 30
}

proc deleteFileTypes { index } {
#  Deletes entries from the "File Types" association menu. 
#
  global PREFS
  if {[winfo exists .file_types] == 0} {
    return
  }
  destroy .file_types
  set PREFS(_E${index}) ""
  updateFileTypes
  showFileTypes
}       

proc updateFileTypes {} {
#  Saves file type associations after an add, delete or "OK button
#
  global PREFS
  set PREFS(FILE_TYPES) ""
  set ck $PREFS(FTYPE_COUNT)
  set PREFS(FTYPE_COUNT) 0

  for {set i 0} {$i < $ck} {incr i} {
    set item  "$PREFS(_E${i});$PREFS(_V${i});$PREFS(_O${i})"
    if { ($PREFS(_E${i}) != "") && \
         ($PREFS(_O${i}) != "") && \
           ([lsearch -exact $PREFS(FILE_TYPES) $item] < 0)} { 
	     lappend PREFS(FILE_TYPES) $item
        incr PREFS(FTYPE_COUNT)
    }
  }
  writeInfo
  if {[winfo exists .file_types] > 0} { 
    destroy .file_types
  }
}

proc addFileTypes { } {
# Adds a new blank entry to the file types menu.  The <b>Extension</b> and
# <b>Open With</b> field must be completed to save the entry.

  if {[winfo exists .file_types] == 0} {
    return
  }
  global PREFS

  set i $PREFS(FTYPE_COUNT)

  lappend PREFS(FILE_TYPES) ";0;"

  incr PREFS(FTYPE_COUNT)
  destroy .file_types
  update idletasks
  showFileTypes  
}

proc helpFileTypes { } {
#  Help info for the file type association menu.
#

global PREFS
set PREFS(DATA) {
Add File Types:

  The File Types Association menu allows one to customize the association 
  of file-types with an application...Double-mouse button 1 down opens the file.

  File Extension:  = File extension to be used with open.
       Open With:  = Command + args to be used to open file. 
	      Delete:  = Deletes current 'File Types' entry.
          []view   = View verbose listing from the open command.   

  Rules:
		  #_FILE_# = Is replaced with current selected file.
		  #_FROOT_#= Is replaced with current root-part of the selected file... 
		             (name only, no extension)
          #_UIP_#  = Is replaced with user defined arguments.
          #_PWD_#  = Is replaced with "Print Working Directory"

  Default: 
            File Extension   Action
            none/undefined   open with default browser 
            .a               open with ar -tv and output default browser.  
            .gif             open with default image viewer.
            .ppm             open with default image viewer.
            .pgm             open with default image viewer.
            .xwd             open with xwud -in and display(Unix-only).
          
  Examples:
  1. Open an HTML file: 
          Start Netscape and display the file. 
        
      Set-up:
          File Extension: .html  
               Open With: netscape+#_FILE_#+& 

          Where - #_FILE_# will be replaced with user's selection.
                - arguments are separated with '+' 
 
   2.  List the contents of a .gz file:
          Run gzip with -l option... 
   
      Set-up:      
          File Extension: .gz 
               Open With: gzip+-l+#_FILE_# 
          Toggle buttons: [x]view 
        
          Where - #_FILE_# will be replaced with user's selection.
                - arguments are separated with '+' 
                - [x]view causes the results from the gzip command to be displayed.

}
browseFile "File Types"
} 

proc testFileTypes { } {
#
  toplevel .t_file_types  
  global PREFS  

  wm positionfrom .t_file_types ""
  wm sizefrom     .t_file_types program
  wm maxsize . 1265 994
  wm minsize . 1 1

  frame .t_file_types.f  -borderwidth {2} -height {30}    -relief {raised} -width {30}
  label .t_file_types.f.label1 -padx {2}  -relief {flat}  -text {Extension:}
  entry .t_file_types.f.entry1 -width {10}  -relief {sunken}
  label .t_file_types.f.label2 -padx {2}  -relief {flat}  -text {Open With:}
  entry .t_file_types.f.entry2 -width {40} -relief {sunken}
  button .t_file_types.f.browse -relief {raised}  -text {Browse...}
  button .t_file_types.f.button2 -relief {raised}  -text {Delete}
  checkbutton .t_file_types.f.check1 -width {4}  -relief {raised}  -text {View} 

  pack configure .t_file_types.f.label1  -side left
  pack configure .t_file_types.f.entry1 -side left -expand 1  -fill both
  pack configure .t_file_types.f.label2  -side left
  pack configure .t_file_types.f.entry2 -expand 1  -side left -fill both
  pack configure .t_file_types.f.browse -side left  -fill x
  pack configure .t_file_types.f.button2 -side left  -fill x
  pack configure .t_file_types.f.check1 -side left  
  pack configure .t_file_types.f -fill x  -expand 1
  tkwait visibility  .t_file_types 

  set ww [split [winfo geometry .t_file_types] x]
  set PREFS(FT_W) [lindex $ww 0]
  set hh [split [lindex $ww 1] +]
  set PREFS(FT_H) [lindex $hh 0]

  destroy .t_file_types
}

proc addDir { } {
#  Adds your current working directory as a bookmark entry. 
#
  global PREFS
  set dir $PREFS(CUR_DIR)
  if {[lsearch -exact $PREFS(DIRS) $dir] < 0 } {
    lappend PREFS(DIRS) $dir
    .menubar.bookmarks.menu add command \
        -activeforeground $PREFS(ACTIV_FG) \
        -activebackground $PREFS(ACTIV_BG) \
	-background $PREFS(GENRL_BG) \
	-foreground $PREFS(GENRL_FG) \
	-label $dir -underline 0 \
	-command "setCd \"$dir\""
    writeInfo
  }
}

proc rmFavoriteDirectory { } {
#  Removes bookmarked directory entries.
#
  global PREFS
  set indx [lsearch -exact $PREFS(DIRS) $PREFS(CUR_DIR)]
  if { $indx >= 0 } { 
    set PREFS(DIRS) [lreplace $PREFS(DIRS) $indx $indx]
    .menubar.bookmarks.menu delete $PREFS(CUR_DIR) 
    writeInfo
  }
}

proc setCd { dir } {
#<p>
# Go-to a directory from a "bookmark".
# If directory does not exist, remove it from "bookmark"  
#</p>
# @param dir : Directory name from the "bookmark" list.
#
  global PREFS
  if {[file exists $dir]} {
    set PREFS(CUR_DIR) $dir 
    cd $PREFS(CUR_DIR)
    refresh
  } else {
    set indx [lsearch -exact $PREFS(DIRS) $dir]
    if { $indx >= 0 } { 
      set PREFS(DIRS) [lreplace $PREFS(DIRS) $indx $indx]
      .menubar.bookmarks.menu delete $dir
      setErrMsg "No Such Directory:$dir ... Removing directory from favorites list" 7000 
      writeInfo
    }
  }
}

proc getUid { } {
# Get the user login id (unix-only) 
#
# @reutrn users login id.
#
  global tcl_platform 
  if {![string compare "unix" $tcl_platform(platform)]} {
    catch {exec /bin/id} id
    regsub {\(} $id { } id
    regsub {\)} $id { } id
    set wid [split $id ]
    return [lindex $wid 1]
  } 
  return ""
}

proc writeInfo {} {
#  Write state information to .cft.cfg
#
#  @global PREFS : Global array containint all state information. 
#  @global env : environment variables (used to get HOME). 
#
  global PREFS env
  if {[checkEnv HOME] != 0} {
    set file $env(HOME)/.cft.cfg
  } else {
    return
  }
  set ff [open $file w]
  puts $ff "RCS_BASE_VER^$PREFS(RCS_BASE_VER)"
#
  if { $PREFS(DEVELOPMENT_DIR) != "" } {
    puts $ff "DEVELOPMENT_DIR^$PREFS(DEVELOPMENT_DIR)"
  }
  if { $PREFS(BUILD_DIR) != "" } {
    puts $ff "BUILD_DIR^$PREFS(BUILD_DIR)"
  }
#
  set line "MY_DIR^"
  set PREFS(DIR) [lsort -decreasing $PREFS(DIRS)]
  foreach dir $PREFS(DIRS) {
    puts $ff "${line}${dir}"
  }
#
  foreach name $PREFS(CINF) {
    set words [split $name ":"]
    puts $ff "[lindex $words 1]^$PREFS([lindex $words 1])"

  }
  
  set PREFS(ENV) [lsort $PREFS(ENV)] 
  foreach environ $PREFS(ENV) {
    if { $PREFS(ENV) != "" } {
      puts $ff "ENV^$environ"
    }
  } 

  set PREFS(OPTIONS) [lsort $PREFS(OPTIONS)] 
  foreach opt $PREFS(OPTIONS) {
    puts $ff "OPTIONS^$opt"
  } 

  set PREFS(FILE_TYPES) [lsort $PREFS(FILE_TYPES)]
  foreach ftp $PREFS(FILE_TYPES) {
    puts $ff "FILE_TYPES^$ftp"
  } 
  close $ff
}

proc readInfo {} {
# Read-in global parameters from the configuration file. 
# @global PREFS : Global array containing all state information. 
#
  global PREFS env
  set count 0
  if {[checkEnv HOME] != 0} {
    set file $env(HOME)/.cft.cfg
  } else {
    return 0
  }
  set PREFS(OPT_COUNT)    0
  set PREFS(FTYPE_COUNT)  0
  set PREFS(OPTIONS)     ""
  set PREFS(FILE_TYPES)  ""
  set PREFS(DIRS)        ""
  set PREFS(RCS_BASE_VER ""
  set PREFS(RCS_BIN)     ""
  set PREFS(ENV)         ""

  if {[file exists $file] } {
    set ff [open $file r]
    while { [gets $ff line] >= 0 } {
      set words [split $line "^"]
      switch [lindex $words 0] {
        RCS_BASE_VER {
          set PREFS(RCS_BASE_VER) [lindex $words 1 ]
        }
        RCS_BIN {
          set PREFS(RCS_BIN) [lindex $words 1 ]
        }
        MY_DIR {
          lappend PREFS(DIRS) [lindex $words 1 ]
        }
        ENTRY_FG {
          set PREFS(ENTRY_FG) [lindex $words 1]
        }
        ENTRY_BG {
          set PREFS(ENTRY_BG) [lindex $words 1]
        }
        LSTBX_FG {
          set PREFS(LSTBX_FG) [lindex $words 1]
        }
        LSTBX_BG {
        set PREFS(LSTBX_BG) [lindex $words 1]
        }
        SELCT_FG {
          set PREFS(SELCT_FG) [lindex $words 1]
        }
        SELCT_BG {
          set PREFS(SELCT_BG) [lindex $words 1]
        }
        TEXTW_FG {
          set PREFS(TEXTW_FG) [lindex $words 1]
        }
        TEXTW_BG {
          set PREFS(TEXTW_BG) [lindex $words 1]
        }
        GENRL_FG {
          set PREFS(GENRL_FG) [lindex $words 1]
        }
        GENRL_BG {
          set PREFS(GENRL_BG) [lindex $words 1]
        }
        ACTIV_FG {
          set PREFS(ACTIV_FG) [lindex $words 1]
        }
        ACTIV_BG {
          set PREFS(ACTIV_BG) [lindex $words 1]
        }
        RCSBU_FG {
          set PREFS(RCSBU_FG) [lindex $words 1]
        }
        RCSBU_BG {
          set PREFS(RCSBU_BG) [lindex $words 1]
        }
        SPCBU_FG {
          set PREFS(SPCBU_FG) [lindex $words 1]
        }
        SPCBU_BG {
          set PREFS(SPCBU_BG) [lindex $words 1]
        }
        ENV {
	  if { [lsearch -exact $PREFS(ENV) [lindex $words 1]] < 0} {    
             set items [split [lindex $words 1] "="] 
             set item  [lindex $items 0]
             set value [lindex $items 1]
             if { $item != "" } { 
                lappend PREFS(ENV) [lindex $words 1]
                set env($item) $value
             }
           }
        }
        OPTIONS {
	  if { [lsearch -exact $PREFS(OPTIONS) [lindex $words 1]] < 0} {    
             lappend PREFS(OPTIONS) [lindex $words 1]
             incr PREFS(OPT_COUNT)
           }
        }
        FILE_TYPES {
	  if { [lsearch -exact $PREFS(FILE_TYPES) [lindex $words 1]] < 0} {    
             lappend PREFS(FILE_TYPES) [lindex $words 1]
             incr PREFS(FTYPE_COUNT)
           }
        }
      }
    }
    close $ff
    set PREFS(OPTIONS) [lsort $PREFS(OPTIONS)]
    set PREFS(FILE_TTYPES) [lsort $PREFS(FILE_TYPES)]
#
# Load-up file-type action commands.
#
    set i 0
    foreach item $PREFS(FILE_TYPES) {
      set words [split $item ";"]
      set PREFS(_E${i}) [lindex $words 0]
      set PREFS(_V${i}) [lindex $words 1]
      set PREFS(_O${i}) [lindex $words 2]
      incr i
    }
  }
}

proc tagRcsVersion { widget on} {
#  Procedure to tag/un-tag RCS files with symbolic name. 
#  @param widget : pop-up dialog to be destroyed. 
#  @param on : 1 = tag file with RCS_BASE_VER 
#<p>           0 = Remove RCS tag from file. </p>
#
  global PREFS env

  if { [file isdirectory [lindex $PREFS(SEL_FILES) 0]] } { 
    return
  }

  set rcs_path [pwd] 
  set old_path [pwd]

  set endpart [getEndpart]
  if { [string first $env(RCSROOT) $rcs_path ] >= 0} {
    cd $PREFS(DEVELOPMENT_DIR)/${endpart}
  } else {
    set rcs_path $env(RCSROOT)/${endpart}
  }
  if {[file exists $rcs_path] == 0 } {
     set rcs_path . 
  }

  set sym_tags [split $PREFS(SYM_TAG) ":"] 

  foreach tag $sym_tags {
    if { $tag != "" } {
      foreach item  $PREFS(SEL_FILES) {
        regsub {,v$} [file tail $item] {} tf
        set item "${tf},v"
        if { $on } {
          setMsgArea "Taging: $item with $PREFS(SYM_TAG)" 7000
          if { $PREFS(RCS_TAG) != "" } {
             catch {exec $PREFS(RCS_BIN)/rcs -N$PREFS(SYM_TAG):$PREFS(RCS_TAG) ${rcs_path}/${item}} msg
          } else {
             catch {exec $PREFS(RCS_BIN)/rcs -N$PREFS(SYM_TAG): ${rcs_path}/${item}} msg
          }
        } else {
          setMsgArea "Un-Taging: $item $PREFS(SYM_TAG)" 7000
          catch {exec $PREFS(RCS_BIN)/rcs -N$PREFS(SYM_TAG)  ${rcs_path}/${item}} msg
        }
      }
    }
  }
  cd $old_path
  destroy $widget 
}

proc getEndpart {} {
# Attempt to find the end-part of the path. Assuming that you are in
# the 'rcsroot' or in your 'development' directory otherwise, return [pwd].  
#
# @return A constructed path to that of "pwd". 
#
  global PREFS env
  set endpart ""
  set rcs_path [pwd]
  set len2 [string length $rcs_path]

  if { [string first $env(RCSROOT) $rcs_path ] >= 0} {
     set len1 [string length $env(RCSROOT)]
  } elseif { [string first $PREFS(DEVELOPMENT_DIR) $rcs_path ] >= 0} {
     set len1 [string length $PREFS(DEVELOPMENT_DIR)]
  } else {
     set len1 0
  } 
  return [string range $rcs_path $len1 $len2]
}

proc checkTag { } {
# Check the RCS file for the associated symbolic name (RCS_BASE_VER) 
#
  global PREFS env

  set PREFS(DATA) ""
  set ff  [glob -nocomplain *,v]
  set PREFS(DATA) "$PREFS(DATA)****************************"
  set PREFS(DATA) "$PREFS(DATA)\nVersions for $PREFS(RCS_BASE_VER)"
  set PREFS(DATA) "$PREFS(DATA)\n****************************"
  set PREFS(DATA) "$PREFS(DATA)\n"
  set PREFS(DATA) "$PREFS(DATA)\nBUILD\tRCS\tFile Name"
  set PREFS(DATA) "$PREFS(DATA)\n===\t===\t========="
  foreach f $ff {
    set err [catch {exec rlog $f | grep $PREFS(RCS_BASE_VER):} msg]
    if {! $err} {
      set line ""
      set words [split $msg ]
      set count 0
      foreach word $words {
        if { $word != "" } {
          if { $count == 0 } {
            set line $word
            incr count
          } else {
            set line "$line\t$word\t$f"
          }
        }
      }
    } else {
      set line "No Tag!\t==>\t$f"
    }

    set PREFS(DATA) "$PREFS(DATA)\n$line"
  }
  browseFile "" 
}

proc tagOsp { mode } {
# Tag RCS file with symbolic name (RCS_BASE_VER) 
# @param mode : = 1, tag with symbolic name;  = 0, un-tag symbolic name
#
  if { [winfo exists .tagW] } {
    destroy .tagW
  } 
  global PREFS 
  toplevel .tagW   -background $PREFS(GENRL_BG)  -highlightcolor {#ffffffffffff}
  wm positionfrom .tagW user
  wm sizefrom .tagW program
  wm resizable .tagW 0 0
  wm title .tagW {Tag Symbolic Name to RCS File}

  setFileSelections

  # build widget .tagW.label2
  if { $mode } {
    set text_lab "Tag Symbolic Name to RCS File"
  } else {
    set text_lab "Un-Tag Symbolic Name to RCS File"
  }
  label .tagW.label2 \
    -background $PREFS(GENRL_BG) \
    -font {-adobe-helvetica-medium-o-normal--18-180-75-75-p-98-iso8859-1} \
    -relief {ridge} \
    -text $text_lab 

  # build widget .tagW.frame0
  frame .tagW.frame0 \
    -borderwidth {2} \
    -height {22} \
    -relief {raised} \
    -width {30}

  # build widget .tagW.frame0.frame
  frame .tagW.frame0.frame \
    -relief {raised}

  # build widget .tagW.frame0.frame.frame4
  frame .tagW.frame0.frame.frame4 \
    -borderwidth {2} \
    -height {30} \
    -relief {raised} \
    -width {30}

  # build widget .tagW.frame0.frame.frame4.label4
  label .tagW.frame0.frame.frame4.label4 \
    -background $PREFS(GENRL_BG) \
    -padx {2} \
    -text {RCS Version}

  # build widget .tagW.frame0.frame.frame4.entry5
  entry .tagW.frame0.frame.frame4.entry5 \
    -background $PREFS(ENTRY_BG) \
    -textvariable PREFS(RCS_TAG)

  # build widget .tagW.frame0.frame.label5
  label .tagW.frame0.frame.label5 \
    -background $PREFS(GENRL_BG) \
    -padx {2} \
    -text {(e.g. 1.1 or blank)}

  # build widget .tagW.frame0.frame1
  frame .tagW.frame0.frame1 \
    -relief {raised}

  # build widget .tagW.frame0.frame1.frame4
  frame .tagW.frame0.frame1.frame4 \
    -borderwidth {2} \
    -height {30} \
    -relief {raised} \
    -width {30}

  # build widget .tagW.frame0.frame1.frame4.label4
  label .tagW.frame0.frame1.frame4.label4 \
    -background $PREFS(GENRL_BG) \
    -padx {2} \
    -text {Symbolic Name}

  # build widget .tagW.frame0.frame1.frame4.entry5
  entry .tagW.frame0.frame1.frame4.sym_tag \
    -background $PREFS(ENTRY_BG) \
    -foreground $PREFS(ENTRY_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -textvariable PREFS(SYM_TAG)

  # build widget .tagW.frame0.frame1.label4
  label .tagW.frame0.frame1.label4 \
    -padx {2} \
    -text {(e.g. v2_0)}

  # build widget .tagW.frame5
  frame .tagW.frame5 \
    -borderwidth {2} \
    -height {30} \
    -relief {raised} \
    -width {30}

  # build widget .tagW.frame5.button2
  button .tagW.frame5.button2 \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command "tagRcsVersion .tagW $mode" \
    -padx {12} \
    -pady {4} \
    -text {OK}

  # build widget .tagW.frame5.button3
  button .tagW.frame5.button3 \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {destroy .tagW} \
    -padx {12} \
    -pady {4} \
    -text {Cancel}

  # pack master .tagW.frame0
  pack configure .tagW.frame0.frame \
    -expand 1 \
    -fill x
  pack configure .tagW.frame0.frame1 \
    -expand 1 \
    -fill x

  # pack master .tagW.frame0.frame
  pack configure .tagW.frame0.frame.frame4 \
    -expand 1 \
    -fill x \
    -side left
  pack configure .tagW.frame0.frame.label5 \
    -side left

  # pack master .tagW.frame0.frame.frame4
  pack configure .tagW.frame0.frame.frame4.label4 \
    -side left
  pack configure .tagW.frame0.frame.frame4.entry5 \
    -expand 1 \
    -fill x \
    -side left

  # pack master .tagW.frame0.frame1
  pack configure .tagW.frame0.frame1.frame4 \
    -expand 1 \
    -fill x \
    -side left
  pack configure .tagW.frame0.frame1.label4 \
    -side left

  # pack master .tagW.frame0.frame1.frame4
  pack configure .tagW.frame0.frame1.frame4.label4 \
    -side left
  pack configure .tagW.frame0.frame1.frame4.sym_tag \
    -expand 1 \
    -fill x \
    -side left

  # pack master .tagW.frame5
  pack configure .tagW.frame5.button2 \
    -anchor w \
    -side left
  pack configure .tagW.frame5.button3 \
    -anchor w \
    -side left

  # pack master .tagW
  pack configure .tagW.label2 \
    -fill x
  pack configure .tagW.frame0 \
    -fill x
  pack configure .tagW.frame5
}

proc getStateVersion {name} {
# Get state version from 'pwd' .rcsState.  
# @param name : file name to be checked. 
#
  global PREFS

  set endpart [getEndpart]
  if {[file exists $PREFS(DEVELOPMENT_DIR)/${endpart}/.rcsState] } {
    set ff [open "$PREFS(DEVELOPMENT_DIR)/${endpart}/.rcsState" r]  
    while { [gets $ff line] >= 0 } {
      if {[string length $line] > 1 } {
        set items [split $line ":"]
        if { $name == [lindex $items 0] } {
          close $ff
          setMsgArea "chekin version = [lindex $items 1]" 7000
          return [lindex $items 1]
        }
      } 
    }
    close $ff
  }
  return ""
}

proc mirrorDir {} {
# Switch from RCS directory to current working directory and back. 
#
  global env PREFS
  set endpart [getEndpart]
  if { [string first $env(RCSROOT) [pwd] ] >= 0} {
     cd $PREFS(DEVELOPMENT_DIR)/${endpart}
     loadRcsInfo
  } else { 
    if { [file exists $env(RCSROOT)/${endpart}] } {
      cd $env(RCSROOT)/${endpart}
    } else { 
      cd $PREFS(DEVELOPMENT_DIR)
    }
  }
  refresh
}

proc buildDir {} {
# If PREFS(BUILD_DIR) exists, then switch to that directory...
#
  global env PREFS
  set endpart [getEndpart]
  if { [file exists $PREFS(BUILD_DIR)/${endpart}] } {
    cd $PREFS(BUILD_DIR)/${endpart}
  } else { 
    cd $PREFS(BUILD_DIR)
  }
  refresh
}
   
proc loadRcsInfo {} {
#  Loads info about RCS file activity, for current working directory.
#
  global PREFS env

  set rcs_path [pwd]
  if { [string first $env(RCSROOT) $rcs_path ] >= 0} {
    return
  }
  set endpart [getEndpart]

  if { $PREFS(WORK_DIR) != "$PREFS(DEVELOPMENT_DIR)/${endpart}" } { 
    set PREFS(RCS_COUNT) 0
  }
  set PREFS(WORK_DIR) "$PREFS(DEVELOPMENT_DIR)/${endpart}" 

  if {[file exists $PREFS(WORK_DIR)/.rcsState] } {
    set ff [open "$PREFS(WORK_DIR)/.rcsState" r]  
    set PREFS(RCS_COUNT) 0 
    while { [gets $ff line] >= 0 } {
      if {[string length $line] > 1 } {
        set items [split $line ":"]
        set PREFS(FILE_NAME,$PREFS(RCS_COUNT)) [lindex $items 0]
        set PREFS(VERSION,$PREFS(RCS_COUNT))   [lindex $items 1]
        incr PREFS(RCS_COUNT)
      }
    }
    close $ff
  }
}

proc saveRcsInfo {} {
# Saves info about RCS file activity, for the current working directory.
# It is applied for each RCS check-out, check-in session. 
#
  global PREFS

  set ff [open .rcsState w]  
  for {set i 0} {$i < $PREFS(RCS_COUNT)} {incr i} {
    if { [string length $PREFS(FILE_NAME,${i})] > 0 } {
      puts $ff "$PREFS(FILE_NAME,${i}):$PREFS(VERSION,${i})"
    }
  }
  close $ff
}

proc checkEnv { name } {
#  Check current environment array for "name" 
#  @param name : Name of the environment variable. 
#  @return 1 = found
#<p>       0 = not found. </p>
# 
  global env
  set searchid [array startsearch env]
  while {[array anymore env $searchid]} {
    set element [array nextelement env $searchid]
    if { "$element" == $name } {
      return 1
    }
  }
  array donesearch env $searchid
  return 0
}

proc findWhich { cmd } {
# Given a command name, search through the $path environment variable for its location.    
# @param cmd : command name to be found (e.g. grep) 
# @global tcl_platform : Determine if on <i>UNIX</i> or <i>Windows</i>.
# @global env : environment variables. 
#
  global tcl_platform env

  if {$cmd == ""} {
    return ""
  }
  set token ";"

  if {![string compare "unix" $tcl_platform(platform)]} {
    set token ":"
  }
  set paths [split $env(PATH) $token]

  foreach path $paths {
    if { [file exists ${path}/${cmd} ] > 0 } {
      return $path
      break;
    }
  }
  return ""
}

proc helpAbout {} {
# HelpAbout pop-up menu.     
#  
  global PREFS
   mkDialog .msg "-fg $PREFS(TEXTW_FG) -text { cft v0.82\nWritten by Henry Megan\n\hmeg@alpha1.net} -justify left -aspect 800 " "OK {}"
}

proc helpBookmark {} {
# Help about bookmarks.       
#
   global PREFS
   set PREFS(DATA) { 
Bookmarks:

- To create a bookmark for the current directory Press the 'Pointing Hand' 
  icon on the menu bar.

- To select a bookmark, press the 'bookmark' icon on the menu bar,
  then, select an item from the drop-down menu. This will cause
  the program to navigate to that location.

- To delete the current directory from the bookmark-list, press the 'X' 
  icon on the menu bar. If a book marked directory\nhas become invalid, 
  selecting it will remove it from the list\nwithout changing directory.
}
browseFile "Help Bookmarks"
}

proc unpack { } {
# Unpacks .zip, .Z, .gz (on unix-only)    
#
  global PREFS

  set file_name [lindex $PREFS(SEL_FILES) 0]

  if { [file isdirectory $file_name] } { 
     return
  }

  if { $file_name == "" } {return}

  set name     ""

  if { [file extension $file_name] == ".Z" } {
    set name uncompress
  } elseif {[regexp -nocase ".zip" [file extension $file_name]] } {
    set name unzip
  } elseif {[regexp -nocase ".gz" [file extension $file_name]] } {
    set name gzip
  }  

  set UNPACK  [findWhich ${name}]/${name}
  set TAR     [findWhich tar]/tar

  if { $UNPACK == "" } {
     setErrMsg "Could not Find $name..." 7000
     return
  } elseif { $TAR == ""   } {
     setErrMsg "Could not Find tar..." 7000
     return
  }
#  set ext [file extension $file_name]

  if { $name != "" } {
    set msg ""
    if {[file exists $file_name]} {
    if { [file extension $file_name]  == ".Z"  } { 
      set status [catch {exec $UNPACK -f ${file_name} } msg]
    } elseif { [regexp -nocase ".gz" [file extension $file_name]]} {
      set status [catch {exec $UNPACK -d ${file_name} } msg]
    } elseif { [regexp -nocase ".zip" [file extension $file_name]]} {
      set status [catch {exec $UNPACK ${file_name} } msg]
    }
    if {! $status } {
      set root_name [file rootname $file_name]
      if {[file exists $file_name] > 0} {
        if {[catch {exec $TAR xpfv $root_name } msg ]} {
          setErrMsg "Unpack of $file_name.tar failed...(tar xpfv)" 7000
        }
      }
    } else {
        setErrMsg "uncompress of $file_name failed..." 7000"
        puts "$msg"
      }
    }
  }
  if { ([file extension $file_name] == ".tar") } {
    if {![catch {exec $TAR xpfv $file_name } msg ]} {
      setMsgArea "${file_name} unpacked..." 7000
    } else {
      setErrMsg "Unpack of $file_name failed...(tar xpfv)" 7000 
    }
  } else {
    set new_file [file rootname $file_name] 
    if { ([file extension $new_file] == ".tar") } {
      if {![catch {exec $TAR xpfv $new_file } msg ]} {
        setMsgArea "${file_name} unpacked..." 7000
      } else {
        setErrMsg "Unpack of $new_file failed...(tar xpfv)" 7000
      }
    }
  }
}

proc upb { } {
#  Up button; 64-bit encoded gif file. 
#
  set upb_data {
R0lGODdhFgAWAKUAAPj8+AAAANjY2AAECAAAEAAEAAAIAAAQAAAYABgkAPj8ABAYAAAgAAAcABAU
AAgEABgQAAgMAAAMAAAUAAgUAAgIAAAACBAIABAMAPgAAAgQABgIABgUADAYAPj8QBgAACAQAAgA
APj8OBgEAAgACPj8aBAAACgYABgMABAEACAMICAMKAgAEAAICAgECAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAFgAWAAAGzUCAcEgsGgMAgXLJ
bDYHSafUSYgKCoYDIhGYLqvKgGJMLngFYMECwWA0HA9IJCKZUCqPh9KSvJD/gH8RAkgCGIEZYoEK
FQIUSRWAGZOKgF2PAn5kk5yVZA4CGkkbm5ydgBwCBkkdZAEBna8efxBXSR+SlIsgAiG3uYmAIgoj
vUkgwKaTYx8CJH0lf8qmzMYCEZbTywom1hKBr+HhY90YSRyL6QonhEkhHA8VF/MoG+IfHynd7Wdn
ASokVrBgQUJcAg0FArQIcCFFiFcuggAAOw==
}
  image create photo upb_im -data $upb_data
  return upb_im
}

proc rmdb {  } {
#  Remove "bookmark"; 64-bit encoded gif file.    
#
  set rmdb_data {
R0lGODdhFgAWAIQAAPj8+AAEANjY2AgQCPgAABgQCBgYEOgoOBAAAAAAAAgAANDMyDgAABgICCgA
AAAIAAAUAAAMABgAABAICPj88BAYEAAQACAQGAgEAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAA
FgAWAAAFiyAgjmRpBoCgrmzbDqlAzITbEoVgpPNB2yoCQpVIJRK0mWuWWCliiyNSuZoxWI3Y6viT
ERytom1Ka7Ye2nDZhgYmzS1IupokwFeRudfOtYfna3R3YkGBLH5bMW82TIl7iIxwYoZuEkQ8kEAy
ZmJHmjdNT5+fExSjmgkPEQEVRxEWUlIKCAoXCgoJGCEAOw==
}
  image create photo rmdb_im -data $rmdb_data
  return rmdb_im
}

proc downb {  } {
#  Down button; 64-bit encoded gif file.    
#
  set downb_data {
R0lGODdhFgAWAKUAAPj8+AAAANjY2AAEAAAIAAAMAAgYAAAIEAAQAAgIAPj86Pj88PD84PD88AgA
AAAcABgQABgAAAgEAAgICBgMAPj8ANDQ0AgMABgIACgIADAEADAAADAMACAQAPj8KCAAAPgQQAAY
AAgUABAUABgUABAYABAQABgYABAMACAcABAcAAgQACg0ACAcKBAQEAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAFgAWAAAG0ECAcEgsGgMAgXLJ
bDYHyQBhUCgYpofAgIAYJAJgAVIANRIVi2FAHGU0zOb12JHYFh7VgRcScUgCEwNkSRQVhoeIhwEW
SxNJEhVgkpNgkUxjCImahmtLYxcVGBkaARsbHB0BHpyXSR+bmp1KYwEVILe4uayeUbCJsmwCIRUG
IiMkEJvAYyK+iMtJCRUlFxcmJygpJiQUtdACkM67s0kokSIlIiIqIissiq3g4uODYigXCRcjVQUr
BAQnBnxzQtDJhBaTTIDRIymBCYVaArgIEAQAOw==
}
  image create photo downb_im -data $downb_data
  return downb_im
}

proc rgtb {  } {
#  Right button; 64-bit encoded gif file.    
#
  set rgtb_data {
R0lGODdhFgAWAIQAAPD8+Pj8+AAUENjY2AAAAAAIAPj8AAAMCAAEAAAQEAAICPj4+AgMCBgYGAgI
CBAUECAgIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAA
FgAWAAAFgyAQjGRpmkIwEGzrvu1QqETJGrhR28NBk4ScbsebrUbBHNFEGCB+SSWs1kwEWsJsluW8
3rRgrg8bfl27ZLCOp/BGwzzEIi1sMY/07Z3hVq95VF91LCdNgW91hUd4iH+AP0hmik9HJ5ZIi1Oa
MTUDnp+goaEtDAQIBA0OpggPqi6nEAQhADs=
}
  image create photo rgtb_im -data $rgtb_data
  return rgtb_im
}

proc hiloaz {  } {
# hiloaz: File sort a-z, hi->lo; 64-bit encoded gif file.    
#
  set hiloaz_data {
R0lGODdhFgAWAKUAAPj8+AAIANjY2AAAAAgEAAgAABAAABAACAAACAAAEPgAACAAACAYIAAEAAAM
AAgYCAAUABAIABAMAAgIABgUCBAIGAAMCAAQEAAECAAUCNjY0CAQEBAEABAICNDQ0AgMCBAQEBgY
GAgICAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAFgAWAAAGpkCAcEgsGgMAwYBQ
MBwQCYRgqqguptNBcoDNMrBVBRer7U4bgW54nE12Aw7zulvGPtLg8FzpVkLMAnpiZG4DeIB7bUoR
gGpsigMSZlKNhAITkRQDAxUJWA0WgHWVUxcOcXR9lRhpGWajlQMNAmgalqQFG1gFqaQCBgUFHMFs
sGYdj0q3jZsCHlgfY8bQyVmKopsDz2QNXNO+dCDZspvimyGbIuWbH0EAOw==
}
  image create photo hiloaz_im -data $hiloaz_data
  return hiloaz_im
}

proc hilodat {  } {
#  Date sort hi->low; 64-bit encoded gif file.    
#
  set hilodat_data {
R0lGODdhFgAWAOMAAPj8+AAEANjY2AAAAPj8APgAAPgQQNDU0AgICAgMCAgIABAQEAAAAAAAAAAA
AAAAACwAAAAAFgAWAAAEexDISasNQOjNex/ZII6k6AkgSqxsO5zpsBZ04cIhYRhyUf6onI8la91i
hOGqV6PJXkhnktl8BlXJWq8ohQqHSlb3uiW2pASvKlycKdXMsrsNd6OzdLIxPT+GflxhaVcweEZq
hXtLhAcfgCOEJ5IbAwGPCAmWlQoilgsDEQA7
}
  image create photo hilodat_im -data $hilodat_data
  return hilodat_im
}

proc hilosz {  } {
#  File size sort, hi->lo; 64-bit encoded gif file.    
#
  set hilosz_data {
R0lGODdhFgAWAIQAAPD8+Pj8+AAUENjY2AAIAAAAABAICPgAAAAMCAAEAAgUEAAQENjc2AgAACAU
EAgkGAAICPj4+BAAAAgMCCgQAAgECDAAAEgAABAQEBgYGAgICBAUECAgIAAAAAAAAAAAACwAAAAA
FgAWAAAFkiAQjGRpmkIwrGzruoS6FoXxDkdesIi8z6/c4TeIDYjHoI6VUBELCuWQtVAxCg3HICEl
Nl9cl5DYc4XFy9W39biNWRAZ053eRm5dVkE+aJxbYwUSAxNyDUmAQkIUR3wDFVI5FjOOSCxCF3qV
dFOULpaXSGssGHgve3A0GKWmnq2mNAUTBQkFGRq0CRu4Bby1HAUhADs=
}
  image create photo hilosz_im -data $hilosz_data
  return hilosz_im
}

proc lohiaz {  } {
#  File sort a-z, lo->hi; 64-bit encoded gif file.    
#
  set lohiaz_data {
R0lGODdhFgAWAKUAAPj8+AAIANjY2AAAABgACPgAAAgUAAgUGAgAABAACODQ4BgYEAAEAAgACAAM
AAAUCAgECAAECCAUEBAAAAgYEAAcEAAICBgECAgIABAICAAMCBAMEAgMECAgIMjU0AAUABAMCBAQ
EBgcGPj4+AgMCPDw8AgICAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAFgAWAAAGq0CAcEgsGgMAgVIw
ICyfhehgaUguD4iE4imIFqbKhVUQYAga3K50ORg7HgJIhOsd2AUSK8PBXnr/UxNWFAEVFAMWFn6A
ShdJA2ZPYEp1SwiPk0oDGFCZGUkaaUyibACQmQIbHKhPHUkepEoOBh92kExjsZFKDFMgubFsYG3B
XAgIS7/FbMily0yoIcCiHazExXdLIkwjy70kvSFTAyXPoiTitr0DJLZ2Juq2QQA7
}
  image create photo lohiaz_im -data $lohiaz_data
  return lohiaz_im
}

proc lohidat {  } {
# Date sort lo->hi; 64-bit encoded gif file.    
#
  set lohidat_data {
R0lGODdhFgAWAOMAAPj8+AAEANjY2AAAAPj8APgAAPgQQNDU0AgICAgMCAgIABAQEAAAAAAAAAAA
AAAAACwAAAAAFgAWAAAEfxDISasNQOjNex/ZII6k6AkgSqxsO5zpQBR0XcivFxNGb9ylEipEIN1a
yNeudZzVWEoiiyajOnFD1fTYnGGX16psdYxqw9e0eWxl18Zrcjndzlab4ulX6vLqi3ZBd4OAKTBy
VoUZh0hQWQIHH4IjjyeWGwMBkwgJmpkKIpoLAxEAOw==
}
  image create photo lohidat_im -data $lohidat_data
  return lohidat_im
}

proc lohisz {  } {
#  File size lo->hi; 64-bit encoded gif file.    
#
  set lohisz_data {
R0lGODdhFgAWAIQAAPj8+AAUENjY2PgAAAAAAAAIABAAABAMCAAMCAAEANjg4AgMCAAQEBAEAAAQ
CAAICAgAAAAcGAgUGAgACAgUCAgEAAgQCAgQEBAQEAgICCAgIAAAAAAAAAAAAAAAAAAAACwAAAAA
FgAWAAAFjyAgjmRpBoCgruw6vMRapKtxtOo7xCpCCwYBr6UbzlpDVnGVSClWC5xgqWL8VAkpVdBs
ZXFbn1cLY/4aBEcgQCyrHldpzs29QhIRMJ3wg6wkbTsEMQs0SUM6iTF8KkMEE0qKjTQUgzGQkTsr
jDhJOYdxKhVyLF0tFqQsnKWpm6Gtm5YEF4MJGLIZsgkEGgQhADs=
}
  image create photo lohisz_im -data $lohisz_data
  return lohisz_im
}

proc refresh_im {  } {
#  Refresh; 64-bit encoded gif file.    
#
  set refresh_data {
R0lGODdhFgAWAIQAAPj88Pj8+AAEANjY2PgAAAAAAAAMAAAUAAgAACAAABAAAAAIAAgAEBAgGAAU
CAgIEBAgKAgMCBgACAgcGCgMANjU0AgEABAECAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAA
FgAWAAAFkiAQjGRpmkIwrGxLtHChwizx0qtMv3Z/tymYbVCwFYq/lWG2MuYIBeKQdWA6WcfnDzG7
4qS3RDf6xSnG2MLCsBBGxT7oSsBi1Iy6HnnQcAged3poLAYsEC5vTEAREnMTNVEUVl8Vd5FWSTty
A1xYUwNJXjqeN1NeRIpgPqB7KxapREenLaM0Ra0xEUe7vL0XvRYhADs=
}
  image create photo refresh_im -data $refresh_data
  return refresh_im
}

proc home_im {  } {
#  home; 64-bit encoded gif file.    
#
  set home_data {
R0lGODdhFgAWAKUAAPj8+NjY2AAIAAgQAAAAAAgIAAAkCPgAAAgEABgMCAAACCAAABgAEAgEEPj8
ABAMAAAUAAgMAAAcABAUABAYABgcAAAEAAgICAAQAPj8SBggABgEAPj8QBAIAAgAAAAMABAQABAE
APj88AgMCCAgKAAAEAgAGBAEIBAQCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAFgAWAAAGvkCAcEgsGoWBZEAw
UBKUUGUBADU8A4TDNZpEUJWCBPZA3kYJ36RikSWXudh0gNF2v8/yuv2ubKT1e3wBfkmAgXwKVASL
jI2Oi2pfBA6UlZaVD0qJhQ4QAxEPk5cOCE6SDhJDohMFFAIOFaacqUKiUwAWDhFKF6cYqg4Zt5Ma
slgOGkIbkxwRCB0eDh/GkxbAGZcC1A4gwKMUShOSjh4hj1tocOpRAyLr7wEjBBEWiwokCiX6JiUn
JQrz6qEgEAQAOw==
}
  image create photo home_im -data $home_data
  return home_im
}

proc dev_im {  } {
#  dev; 64-bit encoded gif file.    
#
  set dev_data {
R0lGODdhFgAWAIQAAPj8+AgcGNjY2AAEAAAAAAAMABAYABgUABgQAAgIABAcAAAYAAgMAAgICAgQ
CPj8APj4QBAEAPj8UBAAABgYEPgAAAAAGAAAIAgYECAgIBAQEAgMCBgYGAAAAAAAAAAAACwAAAAA
FgAWAAAFpiAgjmRpBoCgrmzbDgBRGAdyJMpSEDzDNwSHAEZ4GI/IpJEgcMSWvAfkUVwiI8OYhMel
RrvGiYDwjFKt6LCAUq4qjxU10ftGVuJMctHsvvv9eW1gXlx3PAIMT4R1BBV7Y4p1SFVMRFxcCQYE
FhcWl4cYKS6jLjArXCqoTKmnomOsq7AsZKewh6+xWbW4LbmQp7eorLOupMYNGZcDGjwbXBxAAwPO
QCEAOw==
}
  image create photo dev_im -data $dev_data
  return dev_im
}

proc mirror_im {  } {
#  mirror; 64-bit encoded gif file.    
#
  set mirror_data {
R0lGODdhFgAWAKUAAPj48Pj8+Pj06PD04Pj86Pj88PD88Oj88Oj8+PD4+Pjs8Pj0+Pj4+Ojs8AgQ
EPDs8NjY2AAEAAAACAgEEBgMIAgACPD8+BAIEAAIAND8+PgAANDYyAAAABgQAOD86DAAAPjs2GAA
APjw4EgAAFgAADgAABAAAEAAACgAABAICAgAAAgMCBAUEPDw8AgICBAQEAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAFgAWAAAGrUBAQDAgEAqGAyKQ
UCwUzgUj0HA8INisdruNMLhYyUQCxkYWZQglDfGmK+yIJX1hYzJbTTayweq3HHhZGn8QHYOFWBwe
iIUfjVocBH6ElZaXWRwgEJeVIZ2EiiIQI6AkoCVYJgVYJZUjJx8oHyenhCdZKXOKoVgqiByRAZGF
dX7BwoCZy4DDZStsHM5gyGXSaRFxX2ARLNVcHC1sbC4vHOccEecuHOzqL+zpHOZBADs=
}
  image create photo mirror_im -data $mirror_data
  return mirror_im
}

proc build_im {  } {
#  build; 64-bit encoded gif file.    
#
  set build_data {
R0lGODdhFgAWAIQAAPj8+AAAANjY2AgMEPgAAAgECAAEAAAMAAAQAAAUAAAgAAgkGAgAABAQGAAA
CBAAAAgICBgACAAICBAUEAgMCBgcGBAQEBgYGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAA
FgAWAAAFnSAgjmRpBoCgrkHrBms8pKpL3DjhxgUd5MAcrJb6CV/AIUpgvA1ZQpWhGI01daoD9Wir
IorXIK6lShSZ4TF5aGa6X/C3SuGDPe/oVZuFrz1VCzRWcH8sgjGIiEMMKQwNDokPbisQKhFnApAG
k5MBEkopBmRydpOVAlOdApUTbq2npxQpEAGbTBQwFZ2iRIm+vrUBFoQGuBe1FKLDLSEAOw==
}
  image create photo build_im -data $build_data
  return build_im
}

proc cut_im {  } {
#  cut; 64-bit encoded gif file.    
#
  set cut_data {
R0lGODdhFgAWAIQAAPD8+Pj8+AAUENjY2AAIAAAMCAAAAAAEAAAQENjc2AAICPj4+AgMCBgYGAgI
CBAUECAgIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAA
FgAWAAAFciAQjGRpmkIwrGzruoT6zm8h0/gQD0bf561D4LciAhHDRMvo8hmEhle0Gf3ZmE5WdiXk
Oaffl+I2q84OC+823BxOiz5tfMUYSqXVqn35pvrcckBFKmyCBmSCQYiJg4xSi4w+DE8GDQ5PBw+X
BpsHBhAGIQA7
}
  image create photo cut_im -data $cut_data
  return cut_im
}

proc copy_im {  } {
#  copy; 64-bit encoded gif file.    
#
  set copy_data {
R0lGODdhFgAWAIQAAPD8+Pj8+AAUENjY2AAIAAAMCAAAAAAEAAAQEPj8AAAICPj4+AgMCBgYGAgI
CBAUECAgIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAA
FgAWAAAFiCAQjGRpmkIwrGzruoT6zm8hG3hu0Gy8GiYcb3C4BXLHIw9hLOloxd8Rl1TObFKS7tmK
DoDahHgsZCmMukTaoGYdFtkReyzmAn9bNU5NXjGacnSCO1+AR3p7iVJ4aYJ9hTN5bJOLL3OObUQy
LnN7epl3lltblUM0OQwGBwYNDqoGD64GsqsQBiEAOw==
}
  image create photo copy_im -data $copy_data
  return copy_im
}

proc paste_im {  } {
#  paste; 64-bit encoded gif file.    
#
  set paste_data {
R0lGODdhFgAWAIQAAPD8+Pj8+AAUENjY2AAAAAAIAAAMCAAEAAAQEPj8AAAICPj4+AgMCBgYGAgI
CBAUECAgIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAA
FgAWAAAFhyAQjGRpmkIwrOxAtDBbqPD7xq1BE3zv87GZi3UbroqsgwrZayFXiCXOGVMaiT9gTupM
eL/alfVJSPjMZpaCS/yCm4PD4no089DeG4Fdd7tvDHwudneFR4JlfmCHdIM/iy6IipB7jWVnhnE7
j5NpkThZP4xTpEc8DAQHBA0OqQQPrQSxqhAEIQA7
}
  image create photo paste_im -data $paste_data
  return paste_im
}

proc rename_im {  } {
#  rename; 64-bit encoded gif file.    
#
  set rename_data {
R0lGODdhFgAWAIQAAPD8+Pj8+AAUENjY2AAIAAAAAAAMCAAEAAAQEAAICPgAAPj4+AgMCBgYGAgI
CBAUECAgIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAA
FgAWAAAFkSAQjGRpmkIwrGzruoRazPT8uoZ82vcaD4VdrcY66Eg14QpxDNCco6TNCERCg0PsIFd1
Ymdea2FADUKjX9M4ccyGFUjyoprFBhT4aJVeAt/xeWMMMkGAb4CAY0Fdhmd/cE57Zo1mj3qLNIl+
lpGLLIiglGQqn6GgNHstpoAunj2vQDMMBQcFDQ60Bw+4NbUQBSEAOw==
}
  image create photo rename_im -data $rename_data
  return rename_im
}

proc mkdir_im {  } {
#  mkdir; 64-bit encoded gif file.    
#
  set mkdir_data {
R0lGODdhFgAWAIQAAPj8+AAAANjY2PgQQAAAEAAACPj8AAgUAAgIABAIAAgQABgIAAAIADAYAAAE
ABgAAAgAACAQAAgACPj8aBAMACAMICAMKAgAEBgkAAAICBAEAAgECAAAAAAAAAAAAAAAACwAAAAA
FgAWAAAFoyAgjmRpBoAwDIHguiv7qixKt3OMwyyRqruXLNf7AWdHocz3CjidsOCw8AsYrtcg0mUT
PL/gr+uQQmDP6HOLLEik39iWIrUwWO12J97KFzBSDXl7cYMtDikPgnyEiy0QiHl6T4V2Ao8CEXuL
jFkCEikJE3ybWXiVl5ujd6mWKXdwaS0UVWG1UF5GW7ozXbu+XhUSFhcXEl8YCg4BGQEJGhBOGyEA
Ow==
}
  image create photo mkdir_im -data $mkdir_data
  return mkdir_im
}

proc convert_im {  } {
#  convert; 64-bit encoded gif file.    
#
  set convert_data {
R0lGODdhFgAWAKUAAPj4+AAAABAQEAgAABAAABgAEAgICBAAEAAACMjIyPj8+AAIAAAICPj8ABAI
CBgYGBAIAPgAACgAADAAABgAACAICAgYCEAAAEgAAFAAACAAACAQECgIACAQCPjw+CAgICgoKAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAFgAWAAAG3ECAcEgsGgMAQWBA
KBiWB0QgkKhaq8ipQhHYcrfUqzWrWIC5DEZgMW1bDQDGmRto2O8NR+OBBSC8A2ANARARARJLTwYJ
SANdZwt3ERF4g4wABF9bExKSkw0UbkgVW5Omp6Z3VI2lqK6UU5dar6h1DYtwFl8XvBi+GaZ1D7Fk
mlx2GpO2dlQPAI8KG1sSHA0dEReDDqLP0F22AQTLdotkAR5gassEBNvEAIHG45WWcAbDbQEGg/oB
H1P/BFwSg4UenlUACDIKgO+foicDFUq80g/Ek34BlGQ0oLHNkyAAOw==
}
  image create photo convert_im -data $convert_data
  return convert_im
}

proc help_im {  } {
#  help; 64-bit encoded gif file.    
#
  set help_data {
R0lGODdhFgAWAIQAAPj8+AAIANjY2AgUAPgAAAAAABgYECAUEBAAABgECAgAABAICCAgIBAMCBAQ
EPj4+PDw8AgMCAAEAAgICAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAA
FgAWAAAFbSAgjmRpBoCgrmzbDmlLzHThCka80jxhtwWdYFYoGomtgxDJYq4QS59MykoIb0PqSnF1
1VqLbtO5CmKzWhZDjP65zDdyq8GWs+De9Jx9LvP7Ag51eneDbm8PWHZlEIBnEQ5GBRJFEZIFE0aU
RSEAOw==
}
  image create photo help_im -data $help_data
  return help_im
}

proc config_im {  } {
#  help; 64-bit encoded gif file.    
#
  set conf_data {
R0lGODdhFgAWAOMAAPj8+BAQENjY2AAAAPj8AAAEAPgAAAgICBAUEAgMCAAAAAAAAAAAAAAAAAAA
AAAAACwAAAAAFgAWAAAEiRDISasNQOg9xv7gkGmdWILhKAwEwbroJ5Js6XrxOr5vi8eFHc/3Q81I
rWSpyFHZlgZc8cjpRA1Y6w8Twnq/UamKk40CBtnNwWm9iiTosADh/HYo8aiuqjXDwx5rRmUmaSRj
K2CKYiFobUs/VCQrj5NNOZQdMYKYnR0JBQcDogMJAwgFJakHqaMRADs=
}
  image create photo conf_im -data $conf_data
  return conf_im
}

proc delete_im {  } {
#  delete; 64-bit encoded gif file.    
#
  set delete_data {
R0lGODdhFgAWAOMAAPj8+AAUENjY2AAIAPgAAAAAAAAMCAAEAAAQEAAICPj4+AgMCBgYGAgICBAU
ECAgICwAAAAAFgAWAAAElBDISasNQOjNex8ZIRZkaW6iYGSFSFgSKYwCqLUiYBY6QAuHzM0F+wkQ
QgGJWPIRZJrghod7SUa6zWoaw2Kz0SSv66JCBQlxEzeObQ4K7sT1IoGVYh0bNylsFnlOVER3PFxl
ZFRcU4h9OX43SY1rRoYzXxYtkEBCmDtdi5c7o0uRHqenJQsFBwUMDawHDrAFtK0PBREAOw==
}
  image create photo delete_im -data $delete_data
  return delete_im
}

proc dup_im {  } {
#  duplicate; 64-bit encoded gif file.    
#
  set dup_data {
R0lGODdhFgAWAOMAAPj8+AAAANjY2AAMCPj8AAAIAAAEAAAQEPgQQAgQEBAQEAgICCAgIAAAAAAA
AAAAACwAAAAAFgAWAAAEexDISasNQOjNe8dCII6ktw1ZQKzsKppCkbaqSwSmMbMqWW6H3e1Wo+E0
uhCPSBseQTWfsQS1WZ280Kw4tBVxVW6U5NIqEWhrAKE2q9BsbNrpJsDveHoVz5+DZ315ZVA+Iixz
ZUkmRXFZIIuFVBkwlBo+CSIGCiQLhQwBEQA7

}
  image create photo dup_im -data $dup_data
  return dup_im
}

proc browse_im {  } {
#  browse; 64-bit encoded gif file.    
#
  set browse_data {
R0lGODdhFgAWAOMAAPj8+AAUENjY2AAAAAAIAAAMCAAEAAAQEPj8AAgQEBAQEAgICCAgIAAAAAAA
AAAAACwAAAAAFgAWAAAEeRDISasNQGg9uv+bRgBfaXZbQYJh64mZe26oEXODJaHCIBy33ORD8Wls
nCJiiRDukj0lc+kkRasDZkdbzGGpHmqXJP2Ih15pM3ve5aLDadv6hu+mWGgS3SnSbj1VXSF1hDMt
SC2Ki1GMjn+PjyUJHQYKHwsfBgMMAxEAOw==
}
  image create photo browse_im -data $browse_data
  return browse_im
}

proc search_im {  } {
#  search; 64-bit encoded gif file.    
#
  global PREFS
  set search_data {
R0lGODdhFgAWAOMAAPj8+BAQENjY2AAAAAgMCCAkIPDw8AAEAODg4AgICBAUENjc2BgcGBgYGAAA
AAAAACwAAAAAFgAWAAAEghDISasNQOjNex+ZJ3qgRwxDMYxCyQ1G2I6uBsq2eMi3GJA83Au4qX2I
NmHRgxmSEMjlC+VJKAcK1GCBYnQUStqqmNHOaF6NVZBgcRiDX6s8bicGhGLiIDisSnk5YysNGoFt
JWMzgX85ZAKBAgpncmYba24sKAQHd3d4WH4ofnsoCREAOw==
}
  image create photo search_im$PREFS(HELP_COUNT) -data $search_data
  return search_im$PREFS(HELP_COUNT)
}

proc next_im {  } {
#  next; 64-bit encoded gif file.    
#
  global PREFS
  set next_data {
R0lGODdhFgAWAKUAAPj8+BAECNjY2AAAACAMEBAAABAACAAACBgUGBgACBAQEAgICAgAAAAEABAc
GBgICAAQCCAEEBgYGAgUCAAUAAAMANDc0Ojk4AAIAPgAACgAADAAADgAABgAACAYABAMACAAACAE
ABgoEBgQECAYGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAFgAWAAAGtUCAcEgsGgMAgXLJ
bDYHyYGSICgYDgKpUjroChDRgCAxZioEhuViG80WBAxGYylezrNJh/IhgDClEXZKEkl3EwIUFQ0W
UhdwSndQTpOTkpSXShhJkxmYApqUGZ2Xlkqip6JaTqWop6oCqWxLqV0Zr7AZGrKmtltOohu7uLdM
ohyQm8OXorp4s63QsXDJA9GtqgzJWQMFGhscHBsdHl5LpZ6rBQwDDRgYDR8FIPMhciIDI+sDJEEA
Ow==
}
  image create photo next_im$PREFS(HELP_COUNT) -data $next_data
  return next_im$PREFS(HELP_COUNT)
}

proc prev_im {  } {
#  prev; 64-bit encoded gif file.    
#
  global PREFS 
  set prev_data {
R0lGODdhFgAWAKUAAPj8+BAICNjY2AAAABAAABgEAAgAAAgUGAAMEBgMEAgACAAEABgwKBAUEDgc
IBgAAAAMCAgICAAIAAAICAAUCAgIAAAQCPgAAEAAADAAACgAACgIABAUAAgEACAAADAQABgECBAI
ABAQEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAFgAWAAAGu0CAcEgsGgMAgXLJ
bDYHAELBoCQEBsrBASHAZrsAqiAhEFPFAsVyAWYs2IJGQOx4PJQNAUQZAUiYWBFYBIALE0oLAF5K
ewIUXRWLcGBOlZVQlplLFkmaF4tMiZ6fA6WhnZUXqqufSxKoqoRKGKyrXqJKsYAXGbmtAq9LqqAC
Ghu+Xhywv6m/HcvETMNKBsu117/VSwPYtaZlqF0DDxoZ5hoeH6WLmJqZAyAGEgsS8yEPHuga6wMG
BqUiggAAOw==
}
  image create photo prev_im$PREFS(HELP_COUNT) -data $prev_data
  return prev_im$PREFS(HELP_COUNT)
}
  
proc taritMultiple {type} {
# Tars-up a list files (unix-only)    
# @param type : "compress" or "gzip" action to be taken after files are tared-up.   
#
  global PREFS

  set PREFS(TAR_FILE_NAME) $PREFS(DOIT)

  if { $PREFS(TAR_FILE_NAME) == "" } {return}

  set TAR [findWhich tar]/tar

  if { [file extension $PREFS(TAR_FILE_NAME)] == "" } {
    set PREFS(TAR_FILE_NAME) $PREFS(TAR_FILE_NAME).tar 
  }

  if { $TAR == ""   } {
    setErrMsg "Could not find $TAR" 7000
    return 
  }
  if { [file exists $PREFS(TAR_FILE_NAME)] == 0}  {
    set tarcmd "cvf"
  } else {
    set tarcmd "uvf"
  }
  set msg ""
  set fn [lindex $PREFS(SEL_FILES) 0]
  if {[catch {exec $TAR $tarcmd $PREFS(TAR_FILE_NAME) $fn} msg ]} {
    setErrMsg "tar of $PREFS(TAR_FILE_NAME) failed..." 7000
  } else {
    if { $PREFS(DELETE)} {
      file delete -force $fn
    }
  }
   
  for {set i 1} {$i < [llength $PREFS(SEL_FILES)]} {incr i} {
    set fn [lindex $PREFS(SEL_FILES) $i]
    if {[catch {exec $TAR uvf $PREFS(TAR_FILE_NAME) $fn} msg]} {
      setErrMsg "Could not add $fn to $PREFS(TAR_FILE_NAME)..." 7000
    } else {
      if { $PREFS(DELETE)} {
        file delete -force $fn
      }
    }
  }
  tarit 1 $type 
  refresh
}

proc tarit {count type} {
# Tar and compress files (unix-only)    
# <p>
# If a single file is selected, then the .Z or .gz file takes on the name of the 
# file selected.  
# </p>
# <p>
# If multiple files are selected, then "doIt type"  is called to get 
# the name of the .Z or .gz file and tarit is called a second time "count = 1"
# to indecate that a PREFS(TAR_FILE_NAME) has been entered.  
# </p>
#  Multiple file flow:
# <li>fileOptions</li>
# <li>tarit 0 type</li>
# <li>doIt type</li>
# <li>taritMultiple type</li>
# <li>tarit 1 type</li>
#
# @param count : Indicates who called tarit.
# @param type : Either "compress" or "gzip".
#
  global PREFS

  set file_name ""

  if { $count == 0 } {
    if { [llength $PREFS(SEL_FILES)] > 1 } {
      doIt $type 
      return
    } 
    set file_name [lindex $PREFS(SEL_FILES) 0]
  } else {
    set file_name $PREFS(TAR_FILE_NAME)
  }

  if { $file_name == "" } {return}

  if { $type == "compress" } {
    set cmp_ext ".Z"
  } elseif { $type == "gzip" } {
    set cmp_ext ".gz"
  } else {
    return
  }

  set COMPRESS [findWhich $type]/$type
  set TAR      [findWhich tar]/tar 

  if { $COMPRESS == "" } {
    setErrMsg "Could not find $COMPRESS" 7000
    return 
  } elseif { $TAR == ""   } {
    setErrMsg "Could not find $TAR"
    return 
  }
  if { [file exists ${file_name}.tar${cmp_ext}] == 0}  {
    if { ([file extension $file_name] == "") || \
         ([file extension $file_name] != ${cmp_ext}) } {
      if {[file isdirectory $file_name] != 0} {
        if {[catch {exec $TAR cvf ${file_name}.tar $file_name} msg ]} {
          setErrMsg "tar of $file_name.tar failed...(tar cvf)"
        }
        if {[catch {exec $COMPRESS ${file_name}.tar} msg]} {
          setErrMsg "$type of $file_name.tar failed..." 7000
          puts $msg
        } else {
          if { $PREFS(DELETE)} {
            file delete -force ${file_name}
          }
        }
      } else { 
        if {[catch {exec $COMPRESS ${file_name} } msg]} {
          setErrMsg "compress of $file_name failed..." 7000
        } else {
          if { $PREFS(DELETE)} {
            file delete -force ${file_name}
          }
        }
      }
    }
  } else {
     setErrMsg "Tarit of $file_name failed...$file_name.tar$cmp_ext already exists!" 7000
  }
}

proc fileOptions {type} {
#  Pop-up menu with buttons generated from user-defined options.  
#  @param type : Input is either a "file" or "directory" 
#  @see Help options for more info
#
# Window manager configurations
  if { [winfo exists .dOpt] } {
    destroy .dOpt
  } 
  global PREFS env tcl_platform
  toplevel .dOpt   -background $PREFS(GENRL_BG)\
                   -highlightcolor {#ffffffffffff}
  wm positionfrom .dOpt user
  wm sizefrom .dOpt program
  wm resizable .dOpt 0 0
  wm title .dOpt {File Options}
#
# find position to put window relative to "."
#
  set geom [split [winfo geometry "."] +]
  set size [split $geom x]
  if { $type == "file" } {
    set x2 [expr ( [lindex $size 0] / 3)  ] 
    set x [expr [lindex $geom 1] + $x2 -90]
  } else {
    set x2 [expr ( [lindex $size 0] / 5)  ] 
    set x [expr [lindex $geom 1] + $x2 + 50]
  }
 
#
# Get current file selections...
#
  setFileSelections 

  set num_buttons 0 
  set i 0
  foreach item $PREFS(OPTIONS) {
    set words [split $item ";"]
    set PREFS(_N${i}) [lindex $words 0]
    set PREFS(_F${i}) [lindex $words 1]
    set PREFS(_D${i}) [lindex $words 2]
    set PREFS(_B${i}) [lindex $words 3]
    set PREFS(_X${i}) [lindex $words 4]
    if { $PREFS(_N${i}) == "diff" } {
      set num_buttons 1
    }
    incr i
  }
    
  set y [expr [lindex $geom 2] + 50]
  wm geometry .dOpt +$x+$y

  if { $type == "file" } {
    set w_file .main.files.file_list
    set w_date .main.date.date_list
    set w_size .main.sizes.f.size_list 
  } else {
    set w_file .main.dir.f.list
    set w_date "x" 
    set w_size "x" 
  }

  set chk_ff  [glob -nocomplain *,v]
  if {[llength $chk_ff] == 0 } {
    set chk_ff  [glob -nocomplain .*,v]
  }
  set num_buttons [expr $num_buttons + 9]

  if {[llength $chk_ff] > 0 } {
    set num_buttons [expr $num_buttons + 9]
  }
  if {![string compare "unix" $tcl_platform(platform)]} {
    set num_buttons [expr $num_buttons + 6] 
  }
  set num_buttons [expr $num_buttons + $PREFS(OPT_COUNT)] 
  set num_rows    [expr ($num_buttons/10)]

  set nb 0
  set numx 1
  set k 0

  frame .dOpt.g \
    -background  $PREFS(GENRL_BG) \
    -borderwidth 2 \
    -relief ridge
#
# Add Standard commands that apply only to directories.
#
  if { $type != "file" } {
    lappend b_names Mkdir
    lappend b_cmds "doIt MKDIR; destroy .dOpt "
    lappend b_color $PREFS(GENRL_BG)
    incr nb
  }
#
# Add Standard commands that apply to files and directories...
#
  set names [list \
             Rename \
             Delete \
             Duplicate \
             Cut \
             Copy \
             Paste \
             Browse \
             Convert]
  lappend b_cmds "renameFile; destroy        .dOpt"
  lappend b_cmds "rmFiles;destroy            .dOpt"
  lappend b_cmds "duplicateFiles;destroy     .dOpt"
  lappend b_cmds "copyTheFile 0;  destroy    .dOpt"
  lappend b_cmds "copyTheFile 1;  destroy    .dOpt"
  lappend b_cmds "pasteTheFile;   destroy    .dOpt"
  lappend b_cmds "browseSelectedFile;destroy .dOpt"
  lappend b_cmds "convertTextFile;   destroy .dOpt"

  if {![string compare "unix" $tcl_platform(platform)]} {
    lappend names Chmod
    lappend b_cmds "doIt CHMOD; destroy .dOpt"
    lappend names Tarit  
    lappend b_cmds "tarit 0 compress;refresh;destroy .dOpt"
    lappend names Gzip
    lappend b_cmds "tarit 0 gzip;refresh;destroy .dOpt"
  }

  foreach name $names {
    lappend b_names $name
    lappend b_color $PREFS(GENRL_BG)
    incr nb
  }
#
# Add Upack command for .zip, .gzip, .Z files, if on a Unix platform
# 
    if {![string compare "unix" $tcl_platform(platform)]} {
      lappend b_names UnPack  
      lappend b_cmds "unpack;refresh;destroy .dOpt"
      lappend b_color $PREFS(GENRL_BG)
      incr nb
    }
#
# If not an even multiple of num_rows then add a blank button.
#
#  while { 1 } {
#    if { [expr fmod($nb,$num_rows)] > 0.0 } {
#      incr nb
#      lappend b_names "" 
#      lappend b_cmds  ""
#      lappend b_color $PREFS(GENRL_BG)
#    } else {
#      break;
#    }
#  }

  for {set i 0} {$i < $PREFS(OPT_COUNT)} {incr i} {
    if { [string compare [string tolower $PREFS(_N${i})] "diff"] == 0 } {
      if { $PREFS(DIFF) != "" } {
        lappend b_names Diff1-OK 
      } else { 
        lappend b_names Diff1
      }
      lappend b_names Diff2
      lappend b_cmds "diffFilesSelected 1;refresh;destroy .dOpt"
      lappend b_cmds "diffFilesSelected 2;refresh;destroy .dOpt"
      if { $PREFS(DIFF) != "" } {
        lappend b_color green 
      } else { 
        lappend b_color $PREFS(SPCBU_BG)
      }
      lappend b_color $PREFS(SPCBU_BG)
      set nb  [expr $nb +2]
      break;
    }
  }
#
# Populate Directory type commands
#
  if {$type != "file"} {
    for {set i 0} {$i < $PREFS(OPT_COUNT)} {incr i} {

      if { [string compare [string tolower $PREFS(_N${i})] "diff"] != 0 } {
        if {$PREFS(_D${i})} {
          if {[string first "#_UIP_#" $PREFS(_X${i})] > 0} {
            lappend b_cmds "doItOptions $i 1;refresh;destroy .dOpt"
          } else {
            lappend b_cmds "doCmd $i 1;refresh;destroy .dOpt"
          }
          lappend b_names $PREFS(_N${i})
          lappend b_color $PREFS(SPCBU_BG)
          incr nb
        }
      }
    } 
  }

#
# Add commands that are common to files only.
#
  if {$type == "file"} {
    for {set i 0} {$i < $PREFS(OPT_COUNT)} {incr i} {
      if { [string compare [string tolower $PREFS(_N${i})] "diff"] != 0 } {
        if {$PREFS(_F${i})} {
          if {[string first "#_UIP_#" $PREFS(_X${i})] > 0 } {
            lappend b_cmds "doItOptions $i 1;refresh;destroy .dOpt"
          } else {
            lappend b_cmds "doCmd $i 1;refresh;destroy .dOpt"
          }
          lappend b_names $PREFS(_N${i})
          lappend b_color $PREFS(SPCBU_BG)
          incr nb
        }
      }        
    }
#
# If not an even multiple of num_rows then add a blank button.
#
#    while { 1 } {
#      if { [expr fmod($nb,$num_rows)] > 0.0 } {
#        incr nb
#        lappend b_names "" 
#        lappend b_cmds  ""
#        lappend b_color $PREFS(GENRL_BG)
#      } else {
#        break;
#      }
#    }
    if { $PREFS(RCS_BIN) != "" } { 
#
# Start rcs commands.  This assumes that rcs is in your path.
#
      lappend b_names RCS-diff
      lappend b_names RCS-Create
      lappend b_cmds "diffRcsFilesSelected;destroy .dOpt"
      lappend b_cmds "createCheckinMsg checkin;destroy .dOpt"
      lappend b_color $PREFS(RCSBU_BG)
      lappend b_color $PREFS(RCSBU_BG)
      set nb [expr $nb +2]

      if {[file exists ".rcsState"]} {
        set names [list \
                  RCS-Checkin \
                  RCS-Tag \
                  RCS-Un-lock \
                  RCS-Rlog ] 
  
        foreach name $names {
          incr nb
          lappend b_names $name
          lappend b_color $PREFS(RCSBU_BG)
        }
        lappend b_cmds "createCheckinMsg checkin;destroy .dOpt"
        lappend b_cmds "tagOsp 1;destroy .dOpt"
        lappend b_cmds "unlockFilesSelected;destroy .dOpt"
        lappend b_cmds "rlogFileSelected;destroy .dOpt"
      }
#
# Add commands that are common if in a RCS repository.
#
      if {[llength $chk_ff] > 0 } {
        if {[file exists ".rcsState"]} {
          set names [list \
                    RCS-Get \
                    RCS-Un-Tag \
                    Check-Tags \
                    RCS-Checkout \
                    RCS-Lock] 

          foreach name $names {
            incr nb
            lappend b_names $name
            lappend b_color $PREFS(RCSBU_BG)
          }
          lappend b_cmds "getFilesSelected;destroy .dOpt"
          lappend b_cmds "tagOsp 0;destroy .dOpt"
          lappend b_cmds "checkTag;destroy .dOpt"
          lappend b_cmds "checkoutFilesSelected ;destroy .dOpt"
          lappend b_cmds "rcsLockFilesSelected ;destroy .dOpt"
        } else {
          set names [list \
                    RCS-Checkin \
                    RCS-Tag \
                    RCS-Un-lock \
                    RCS-Rlog \
                    RCS-Get \
                    RCS-Un-Tag \
                    Check-Tags \
                    RCS-Checkout \
                    RCS-Lock] 

          foreach name $names {
            incr nb
            lappend b_names $name
            lappend b_color $PREFS(RCSBU_BG)
          }
          lappend b_cmds "createCheckinMsg checkin ;destroy .dOpt"
          lappend b_cmds "tagOsp 1;destroy .dOpt"
          lappend b_cmds "unlockFilesSelected;destroy .dOpt"
          lappend b_cmds "rlogFileSelected;destroy .dOpt"
          lappend b_cmds "getFilesSelected;destroy .dOpt"
          lappend b_cmds "tagOsp 0;destroy .dOpt"
          lappend b_cmds "checkTag;destroy .dOpt"
          lappend b_cmds "checkoutFilesSelected;destroy .dOpt"
          lappend b_cmds "rcsLockFilesSelected ;destroy .dOpt" 
        }
#        while { 1 } {
#          if { [expr fmod($nb,$num_rows)] > 0.0 } {
#            incr nb
#            lappend b_names "" 
#            lappend b_cmds  ""
#            lappend b_color $PREFS(GENRL_BG)
#          } else {
#            break;
#          }
#        }
      } 
    }
  }
#
# If not an even multiple of num_rows then add a blank button.
#
#  while { 1 } {
#    if { [expr fmod($nb,$num_rows)] > 0.0 } {
#      incr nb
#      lappend b_names "" 
#      lappend b_cmds  ""
#      lappend b_color $PREFS(GENRL_BG)
#    } else {
#      break;
#    }
#  }
  lappend b_names Cancel
  lappend b_cmds "destroy .dOpt"
  lappend b_color $PREFS(GENRL_BG)
  incr nb

  if {$nb > 20 } {
    set numx 2
  } 
  if {$nb > 30} {
    set numx 3
  } 
  if {$nb > 40} {
    set numx 4
  } 
  if {$nb > 50} {
    set numx 5
  } 
  if {$nb > 60} {
    set numx 6
  } 
  if {$nb > 70} {
    set numx 7
  } 
  if {$nb > 80} {
    set numx 8
  }
  if {$nb > 90} {
    set numx 9
  }
  if {$nb > 100} {
    set numx 10 
  }

  set numy [expr int(ceil($nb/($numx * 1.0)))]

#   puts "Num names = [llength $b_names] "
#   foreach names $b_names {
#     puts $names
#   } 
#   foreach cmds  $b_cmds {
#     puts "$cmds"
#   }
#   foreach color  $b_color {
#     puts "$color"
#   }

#  if {$nb <= [expr $n +2] } {
#     set numx  1
#     set numy  $nb 
#  }

  for {set i 0} {$i < $numy} {incr i} {
    for {set j 0} {$j < $numx} {incr j} {
#      puts "name = [lindex $b_names $k]\t\tcolor = [lindex $b_color $k] "
      if { [lindex $b_names $k]  != ""} {
       button .dOpt.g.${k} -text [lindex $b_names $k] \
               -activeforeground $PREFS(ACTIV_FG) \
               -activebackground $PREFS(ACTIV_BG) \
               -background [lindex $b_color $k] \
               -foreground $PREFS(GENRL_FG) \
               -width 10 -command "[lindex $b_cmds $k]"
          grid .dOpt.g.${k}  -row $i -column $j 
      }
      incr k
    }
  }
  pack .dOpt.g
#               -width 10 -command [lindex $b_cmds $k]
}

proc goHome {} {
#  Being a separate proc, this allows one to reset HOME env, while cft is running. 
# 
  global env
  cd $env(HOME)
}

proc processDirSelection { } {
  global PREFS
  set PREFS(DIR_FIND)  ""
  set PREFS(FILE_FIND) ""

  if {[winfo exists .dOpt]} {
     destroy .dOpt
  }
  # Get selected list item
  setFileSelections

  # Get selected list item
  set diritem [.main.dir.f.list curselection]

  set PREFS(D_VIEW_POS) $diritem

  if { $diritem == "" } {
     return
  }
  set dir [.main.dir.f.list get $diritem]

  # Change directories
  if { [file isdirectory $dir] != 0 } {
    set PREFS(OLD_DIR) $dir
    cd $dir
  }
  # Fill lists
  refresh
  .main.dir.f.list selection clear 0 end
}

proc processFileSelection { } {
# Process file selection...  
# 
  global PREFS tcl_platform PREFS(DATA) 
  set PREFS(FILE_FIND) ""

  if {[winfo exists .dOpt]} {
     destroy .dOpt
  }

  setFileSelections

  # Get selected list item
  if {[llength $PREFS(SEL_FILES)] == 0 } {
    return
  } 
  set file_name [lindex $PREFS(SEL_FILES) 0]
#
# Search through defined file types and open if necessary. 
#
  set type  [identifyFile $file_name]

  for {set i 0} {$i < $PREFS(FTYPE_COUNT)} {incr i} {
    if { $type == $PREFS(_E${i}) } {
      if {[string first "#_UIP_#" $PREFS(_O${i})] > 0 } {
         doItOptions $i 0
      } else {
         doCmd $i 0
      }
      return
    }    
  } 
  if { ($type == ".gif") ||\
       ($type == ".ppm") ||\
       ($type == ".pgm") ||\
       ($type == ".xbm") } {
    showImage  $file_name
  } elseif { $type == "7" } {
    viewRcsFileSelected $file_name
  } elseif { $type == ".a" }  {
    if {![string compare "unix" $tcl_platform(platform)]} {
      set path [findWhich ar]
      if { $path != "" } {
        catch {exec $path/ar -tv $file_name } PREFS(DATA) 
        browseFile "" 
      }
    }
  } elseif { $type == ".xwd" } {
    if {![string compare "unix" $tcl_platform(platform)]} {
      catch {exec [findWhich xwud]/xwud -in $file_name & }
    }
  } else {
    set PREFS(DATA) ""
    .main configure -cursor          watch
    browseFile $file_name
    .main configure -cursor          left_ptr
  }
}

proc BindDragto { x y args } {
# Get cursor's x y position as it it is moving for listbox selection.
# @param x : cursor's x screen coordinate.
# @param y : cursor's y screen coordinate.
# @param args : An array of listbox widgets.
#  
   foreach w $args {
      $w scan dragto $x $y
   }
}

proc BindMark { x y args } {
# Get marked cursor's x y position for listbox selection.
# @param x : cursor's x screen coordinate.
# @param y : cursor's y screen coordinate.
# @param args : An array of listbox widgets.
#  
   foreach w $args {
      $w scan mark $x $y
   }
}

proc BindSelect { y args } {
# Clear selections, and set selection to nearest y listbox location. 
# @param y : cursor's y screen coordinate.
# @param args : An array of listbox widgets.
# 
    foreach w $args {
       $w select clear 0 end
       $w select anchor [$w nearest $y]
       $w select set anchor [$w nearest $y]
    }
}

proc BindIndex { ind } {
# Clear selections, and set all associaed file widgets to the given index. 
# @param ind : item selected. 
# 
    set flist [list .main.files.file_list .main.sizes.f.size_list .main.date.date_list]
    foreach w $flist {
       $w selection clear 0 end
       if {$ind >=0 } {
         $w selection set $ind $ind
         $w activate $ind
         $w yview [expr $ind -3]
       }
    }
}


proc BindAllSelect { w_in y args } {
# Set selections to nearest y listbox location.
# @param w_in : widget not bound by this event. 
# @param y : cursor's y screen coordinate.
# @param args : An array of listbox widgets.
# 
    foreach w $args {
       if {$w != $w_in } { 
         $w select anchor [$w nearest $y]
         $w select set anchor [$w nearest $y]
       }
    }
}

proc cftMain {} {
#  <b>cfg</b> Main widget that displays files and directories.
#
  # Window manager configurations
  wm positionfrom . user
  wm sizefrom     . ""
  wm maxsize      . 1265 994
  wm minsize      . 1 1
  wm title        . {cft}

  global PREFS env tcl_platform

  # build widget .menubar
  frame .menubar \
    -background $PREFS(GENRL_BG) \
    -borderwidth {1} \
    -highlightcolor {#ffffffffffff} \
    -relief {raised}

  # build widget .menubar.file
  menubutton .menubar.file \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -highlightcolor {#ffffffffffff} \
    -menu {.menubar.file.menu} \
    -padx {6} \
    -pady {4} \
    -text {File} \
    -underline {0}

  # build widget .menubar.file.menu
  menu .menubar.file.menu \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -selectcolor $PREFS(SELCT_BG) 
  .menubar.file.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {exit} \
    -label {Exit} \
    -underline {1}

  # build widget .menubar.view
  menubutton .menubar.view \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -highlightcolor {#ffffffffffff} \
    -menu {.menubar.view.menu} \
    -padx {6} \
    -pady {4} \
    -text {View} \
    -underline {0}

  # build widget .menubar.view.menu
  menu .menubar.view.menu \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -selectcolor {yellow}
  .menubar.view.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {dispCanvas} \
    -label {Images} \
    -underline {1}
  if {![string compare "unix" $tcl_platform(platform)]} {
  .menubar.view.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {checkDiskSpace} \
    -label {Disk Space} \
    -underline {1}
  .menubar.view.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {snapShot} \
    -label {xwd-Snap-Shot} \
    -underline {1}
  }

  # build widget .menubar.conf
  menubutton .menubar.conf \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -highlightcolor {#ffffffffffff} \
    -menu {.menubar.conf.menu} \
    -padx {6} \
    -pady {4} \
    -image [config_im] \
    -underline {0}
   bind .menubar.conf <Enter> {
     .bf.labq configure -text "Configure: Colors, Launch Programs, Associate File Types, Edit Environment variables, RCS_HOME"
   }
   bind .menubar.conf <Leave> {
     .bf.labq configure -text $PREFS(MSG) 
   }
 

  # build widget .menubar.conf.menu
  menu .menubar.conf.menu \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -selectcolor {yellow}
  .menubar.conf.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {colorConf} \
    -label {Change Colors} \
    -underline {1}
  .menubar.conf.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {showOptions} \
    -label {Configure Options} \
    -underline {1}
  .menubar.conf.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {showFileTypes} \
    -label {Associated File Types } \
    -underline {1}
  .menubar.conf.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {envConfig} \
    -label {Environment Variables} \
    -underline {1}
  
  .menubar.conf.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {doIt DEVELOPMENT_DIR} \
    -label {Set Development Directory} \
    -underline {1}
  .menubar.conf.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {doIt BUILD_DIR} \
    -label {Set Build Directory} \
    -underline {1}
  if {![string compare "unix" $tcl_platform(platform)]} {
  .menubar.conf.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {doIt RCS_BASE_VER} \
    -label {Set RCS_BASE_VER} \
    -underline {1}
  .menubar.conf.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {doIt RCSROOT} \
    -label {Set RCSROOT} \
    -underline {1}
  .menubar.conf.menu add check -label "Delete After Compress" \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -variable PREFS(DELETE) \
    -selectcolor {red} 
  }

  # build widget .menubar.help
  menubutton .menubar.help \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -highlightcolor {#ffffffffffff} \
    -menu {.menubar.help.menu} \
    -padx {6} \
    -pady {4} \
    -image [help_im] \
    -underline {0}
   bind .menubar.help <Enter> {
     .bf.labq configure -text "Help - menu "
   }
   bind .menubar.help <Leave> {
     .bf.labq configure -text $PREFS(MSG) 
   }

  # build widget .menubar.help.menu
  menu .menubar.help.menu \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -selectcolor {yellow}
  .menubar.help.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {helpAbout} \
    -label {Help About} \
    -underline {1}
  .menubar.help.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {helpBookmark} \
    -label {Help Bookmarks} \
    -underline {1}
  .menubar.help.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {helpOptions} \
    -label {Help Options} \
    -underline {1}
  .menubar.help.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {helpFileTypes} \
    -label {Help File Types} \
    -underline {1}
  .menubar.help.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {helpEnv} \
    -label {Help Environment Variables} \
    -underline {1}
  .menubar.help.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {helpBrowseFile} \
    -label {Help Browse File} \
    -underline {1}
  .menubar.help.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {sampleUnixConfig} \
    -label {Sample Unix Config File} \
    -underline {1}
  .menubar.help.menu add command \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {sampleWindowsConfig} \
    -label {Sample Windows Config File} \
    -underline {1}

  # build widget .menubar.lab
  label .menubar.lab \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -highlightcolor {#ffffffffffff} \
    -text {Filter}

  # build widget .menubar.ent
  entry .menubar.ent \
    -background $PREFS(ENTRY_BG) \
    -foreground $PREFS(ENTRY_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -highlightcolor {#ffffffffffff} \
    -insertbackground $PREFS(SELCT_FG) \
    -textvariable PREFS(TYPES) \
    -width {7}
  # bindings
  bind .menubar.ent <Key-Return> {
    readDir .main.dir.f.list   \
             .main.files.file_list  \
             .main.sizes.f.size_list   \
             .main.date.date_list
}

  # build widget .menubar.add
  button .menubar.add \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -padx {4} \
    -command "addDir" \
    -highlightcolor {#ffffffffffff} \
    -text {+} \
    -image [rgtb]
   bind .menubar.add <Enter> {
     .bf.labq configure -text "Add a bookmark to the current list of bookmarks if it doesn't already exist. "
   }
   bind .menubar.add <Leave> {
     .bf.labq configure -text $PREFS(MSG) 
   }

  menubutton .menubar.bookmarks \
     -background $PREFS(GENRL_BG) \
     -foreground $PREFS(GENRL_FG) \
     -activebackground $PREFS(ACTIV_FG) \
     -activeforeground $PREFS(ACTIV_BG) \
     -text "Dir:" \
     -image [downb] \
     -menu .menubar.bookmarks.menu
   bind .menubar.bookmarks <Enter> {
     .bf.labq configure -text "Bookmarks - CD to it, if if exists, else remove it."
   }
   bind .menubar.bookmarks <Leave> {
     .bf.labq configure -text $PREFS(MSG) 
   }

  menu .menubar.bookmarks.menu

  foreach item $PREFS(DIRS) {
    .menubar.bookmarks.menu add command \
       -activeforeground $PREFS(ACTIV_FG) \
       -activebackground $PREFS(ACTIV_BG) \
       -background $PREFS(GENRL_BG) \
       -foreground $PREFS(GENRL_FG) \
       -label $item -underline 0 \
       -command "setCd $item"
  }

  # build widget .menubar.ent2
  entry .menubar.ent2 \
    -background       $PREFS(ENTRY_BG) \
    -foreground       $PREFS(ENTRY_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -highlightcolor {#ffffffffffff} \
    -insertbackground $PREFS(SELCT_FG) \
    -textvariable PREFS(CUR_DIR) \
    -width {30}
  # bindings
  bind .menubar.ent2 <Key-Return> {
   cd $PREFS(CUR_DIR)
   refresh
}
  button .menubar.rmdb \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -padx {4} \
    -command rmFavoriteDirectory \
    -highlightcolor {#ffffffffffff} \
    -text {-} \
    -image [rmdb]
   bind .menubar.rmdb <Enter> {
     .bf.labq configure -text "Remove a bookmark from the current list of bookmarks. "
   }
   bind .menubar.rmdb <Leave> {
     .bf.labq configure -text $PREFS(MSG) 
   }

  # build widget .main
  frame .main \
    -background $PREFS(GENRL_BG) \
    -cursor {left_ptr} \
    -highlightcolor {#ffffffffffff}

  # build widget .toolbar
  frame .toolbar \
    -relief {sunken} \
    -background $PREFS(GENRL_BG) \
    -highlightcolor {#ffffffffffff}

  # build widget .toolbar.up
  button .toolbar.up \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -command {goUp} \
    -highlightcolor {#ffffffffffff} \
    -text {Up} \
    -image [upb]
   bind .toolbar.up <Enter> {
     .bf.labq configure -text "Change Directory - to the directory above current location."
   }
   bind .toolbar.up <Leave> {
     .bf.labq configure -text $PREFS(MSG) 
   }

  # build widget .toolbar.refresh
  button .toolbar.refresh \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {refresh} \
    -highlightcolor {#ffffffffffff} \
    -image [refresh_im] 
   bind .toolbar.refresh <Enter> {
     .bf.labq configure -text "Refresh - file information in list boxes."
   }
   bind .toolbar.refresh <Leave> {
     .bf.labq configure -text $PREFS(MSG) 
   }
#
#  # build widget .toolbar.home
  button .toolbar.home \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command "goHome;refresh" \
    -highlightcolor {#ffffffffffff} \
    -image [home_im] 
   bind .toolbar.home <Enter> {
     .bf.labq configure -text "Home - changes directory to the one defined as 'HOME'."
   }
   bind .toolbar.home <Leave> {
     .bf.labq configure -text $PREFS(MSG) 
   }

#  # build widget .toolbar.rename
  button .toolbar.rename \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command "renameFile" \
    -highlightcolor {#ffffffffffff} \
    -image [rename_im] 
   bind .toolbar.rename <Enter> {
     .bf.labq configure -text "Rename - a file to a new name."
   }
   bind .toolbar.rename <Leave> {
     .bf.labq configure -text  $PREFS(MSG)
   }

#  # build widget .toolbar.mkdir
  button .toolbar.mkdir \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command "doIt MKDIR" \
    -highlightcolor {#ffffffffffff} \
    -image [mkdir_im] 
   bind .toolbar.mkdir <Enter> {
     .bf.labq configure -text "Make A New Directory - at current location"
   }
   bind .toolbar.mkdir <Leave> {
     .bf.labq configure -text  $PREFS(MSG)
   }

#  # build widget .toolbar.delete
  button .toolbar.delete \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command  "rmFiles" \
    -highlightcolor {#ffffffffffff} \
    -image [delete_im] 
   bind .toolbar.delete <Enter> {
     .bf.labq configure -text "Delete - file(s) from disk!"
   }
   bind .toolbar.delete <Leave> {
     .bf.labq configure -text $PREFS(MSG) 
   }

#  # build widget .toolbar.duplicate
  button .toolbar.duplicate \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command  "duplicateFiles" \
    -highlightcolor {#ffffffffffff} \
    -image [dup_im] 
   bind .toolbar.duplicate <Enter> {
     .bf.labq configure -text "Duplicate - selected file(s)"
   }
   bind .toolbar.duplicate <Leave> {
     .bf.labq configure -text $PREFS(MSG) 
   }


#  # build widget .toolbar.cut
  button .toolbar.cut \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command "copyTheFile 0" \
    -highlightcolor {#ffffffffffff} \
    -image [cut_im] 
   bind .toolbar.cut <Enter> {
     .bf.labq configure -text "Cut/Move - file(s) to a new location; use 'Paste' to complete the command."
   }
   bind .toolbar.cut <Leave> {
     .bf.labq configure -text $PREFS(MSG) 
   }

#  # build widget .toolbar.copy
  button .toolbar.copy \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command "copyTheFile 1" \
    -highlightcolor {#ffffffffffff} \
    -image [copy_im] 
   bind .toolbar.copy <Enter> {
     .bf.labq configure -text "Copy - file(s) to a new location;   Use 'Paste' to complete the command."
   }
   bind .toolbar.copy <Leave> {
     .bf.labq configure -text $PREFS(MSG) 
   }

#  # build widget .toolbar.paste
  button .toolbar.paste \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command  "pasteTheFile" \
    -highlightcolor {#ffffffffffff} \
    -image [paste_im] 
   bind .toolbar.paste <Enter> {
     .bf.labq configure -text "Paste - files from the 'Cut' or 'Copy' command."
   }
   bind .toolbar.paste <Leave> {
     .bf.labq configure -text $PREFS(MSG) 
   }

#  # build widget .toolbar.browse
  button .toolbar.browse \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command  "browseSelectedFile" \
    -highlightcolor {#ffffffffffff} \
    -image [browse_im] 
   bind .toolbar.browse <Enter> {
     .bf.labq configure -text "Browse - Open Selected file in a browser."
   }
   bind .toolbar.browse <Leave> {
     .bf.labq configure -text $PREFS(MSG) 
   }


#  # build widget .toolbar.convert
  button .toolbar.convert \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command "convertTextFile;refresh" \
    -highlightcolor {#ffffffffffff} \
    -image [convert_im] 
   bind .toolbar.convert <Enter> {
     .bf.labq configure -text "Convert - an ascii file from its original format to current system's native format (e.g. DOS->Unix)."
   }
   bind .toolbar.convert <Leave> {
     .bf.labq configure -text $PREFS(MSG) 
   }

  # build widget .main.dir
  frame .main.dir \
    -background $PREFS(GENRL_BG) \
    -borderwidth {1} \
    -highlightcolor {#ffffffffffff}

  frame .main.dir.le \
    -background $PREFS(GENRL_BG) \
    -borderwidth {1} \
    -highlightcolor {#ffffffffffff}

  # build widget .main.dir.le.label
  label .main.dir.le.label \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -text {Directories}

  # build widget .main.dir.le.fentry
  entry .main.dir.le.fentry \
    -background $PREFS(ENTRY_BG) \
    -foreground $PREFS(ENTRY_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -textvariable PREFS(DIR_FIND) \
    -width {10}
#
# Find File Item
#
  bind .main.dir.le.fentry <KeyRelease> {
     if {"%K" == "Down" } {return}
     update idletasks
     set items [.main.dir.f.list get 0 end]
     set ind [lsearch $items *$PREFS(DIR_FIND)*]
     if { $ind >= 0 } {
       .main.dir.f.list selection clear 0 end
       .main.dir.f.list selection set $ind $ind
       .main.dir.f.list activate $ind
       .main.dir.f.list yview [expr $ind -3]
       BindIndex -1
     }
   }
#
# Find Next Item using the 'Down arrow'
#
   bind .main.dir.le.fentry <Down> {
     set i [.main.dir.f.list curselection] 
     if { $i == "" } { return }
     set items [.main.dir.f.list get 0 end]
     for {set j 0} {$j < [llength $items] } { incr j} {
       if {$j > $i } { 
         if {[string first $PREFS(DIR_FIND) [lindex $items $j]] >= 0} {
           .main.dir.f.list selection clear 0 end
           .main.dir.f.list selection set $j $j
           .main.dir.f.list activate $j
           .main.dir.f.list yview [expr $j -3]
           break
         }
       }
     }
   }
   bind .main.dir.le.fentry <Return> {
     processDirSelection
   }
  # build widget .main.dir.f
  frame .main.dir.f \
    -background $PREFS(GENRL_BG) \
    -highlightcolor {#ffffffffffff}

  # build widget .main.dir.f.list
  listbox .main.dir.f.list \
    -background $PREFS(LSTBX_BG) \
    -foreground $PREFS(LSTBX_FG) \
    -highlightcolor {#ffffffffffff} \
    -selectforeground $PREFS(SELCT_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -width {25} \
    -selectborderwidth {2} \
    -yscrollcommand {.main.dir.f.scrb set}

  # bindings
  bind .main.dir.f.list <Button-3> {
    fileOptions dir  
  }
  bind .main.dir.f.list <Double-Button-1> {
    processDirSelection
  }
  bind .main.dir.f.list <ButtonRelease-1> {
    update idletasks
    setFileSelections 
    set flist [list .main.files.file_list .main.sizes.f.size_list .main.date.date_list]
    foreach w $flist {
       $w selection clear 0 end
    }
  }
  # build widget .main.dir.f.scrb
  scrollbar .main.dir.f.scrb \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -troughcolor $PREFS(GENRL_BG) \
    -command { multiScroll  {.main.dir.f.list  .main.dir0.f.list} } \
    -highlightcolor {#ffffffffffff}

  # build widget .main.dir0
  frame .main.dir0 \
    -background $PREFS(GENRL_BG) \
    -borderwidth {1} \
    -highlightcolor {#ffffffffffff}

  # build widget .main.dir0.f
  frame .main.dir0.f \
    -background $PREFS(GENRL_BG) \
    -highlightcolor {#ffffffffffff}

  # build widget .main.dir0.f.list
  listbox .main.dir0.f.list \
    -background $PREFS(LSTBX_BG) \
    -foreground $PREFS(LSTBX_FG) \
    -height {10} \
    -highlightcolor {#ffffffffffff} \
    -selectbackground $PREFS(LSTBX_BG) \
    -selectforeground $PREFS(ACTIV_FG) \
    -selectborderwidth {2} \
    -width {8} \
    -yscrollcommand {.main.dir.f.scrb set}

  # build widget .main.dir0.checkbutton0
  checkbutton .main.dir0.checkbutton0 \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -width 1 \
    -command { if {$PREFS(DU_TOGGLE)} {   \
    pack configure .main.dir0.f   \
    -expand 1   \
    -fill both  \
    -side bottom;  \
    pack configure .main.dir0.f.list   \
    -anchor n   \
    -expand 1   \
    -fill both   \
    -side bottom   \
    } else {
      .main.dir0.checkbutton0 configure -width {1} 
      pack forget .main.dir0.f   \
      pack forget .main.dir0.f.list  \
    }  } \
    -height {1} \
    -highlightcolor {#ffffffffffff} \
    -selectcolor {red} \
    -text {du} \
    -textvariable PREFS(DU_OPP) \
    -variable PREFS(DU_TOGGLE) \
    -width {1}

  # build widget .main.date
  frame .main.date \
    -background $PREFS(GENRL_BG) \
    -highlightcolor {#ffffffffffff}

  # build widget .main.date.top
  frame .main.date.top \
    -background $PREFS(GENRL_BG) \
    -highlightcolor {#ffffffffffff}

  # build widget .main.date.top.p
  button .main.date.top.p \
    -background $PREFS(GENRL_FG) \
    -foreground $PREFS(GENRL_BG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -activebackground $PREFS(ACTIV_FG) \
    -command {setSortMode dm} \
    -highlightcolor {#ffffffffffff} \
    -text {dm} \
    -image [lohidat]
    bind .main.date.top.p <Enter> {
      .bf.labq configure -text "Sort Files by Date Ascending...(newer files first)"
    }
    bind .main.date.top.p <Leave> {
      .bf.labq configure -text $PREFS(MSG) 
    }

  # build widget .main.date.top.lab
  label .main.date.top.lab \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -highlightcolor {#ffffffffffff} \
    -text {Date}

  # build widget .main.date.top.m
  button .main.date.top.m \
    -background $PREFS(GENRL_FG) \
    -foreground $PREFS(GENRL_BG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -activebackground $PREFS(ACTIV_FG) \
    -command {setSortMode dp} \
    -highlightcolor {#ffffffffffff} \
    -text {-} \
    -image [hilodat]
    bind .main.date.top.m <Enter> {
      .bf.labq configure -text "Sort Files by Date Decending...(older files first)"
    }
    bind .main.date.top.m <Leave> {
      .bf.labq configure -text $PREFS(MSG) 
    }

  # build widget .main.date.date_list
  listbox .main.date.date_list \
    -background $PREFS(LSTBX_BG) \
    -foreground $PREFS(LSTBX_FG) \
    -width {23} \
    -selectmode {extended} \
    -highlightcolor {#ffffffffffff} \
    -selectforeground $PREFS(SELCT_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectborderwidth {2} \
    -yscrollcommand {.main.sizes.f.scrb set} \
    -export false
  bind .main.date.date_list <Button-3> {
    fileOptions file  
  }
  bind .main.date.date_list <Double-Button-1> {
    processFileSelection
  }

  # build widget .main.files
  frame .main.files \
    -background $PREFS(GENRL_BG) \
    -highlightcolor {#ffffffffffff}

  # build widget .main.files.top
  frame .main.files.top \
    -background $PREFS(GENRL_BG) \
    -highlightcolor {#ffffffffffff}

  # build widget .main.files.top.p
  button .main.files.top.p \
    -background $PREFS(GENRL_FG) \
    -foreground $PREFS(GENRL_BG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -activebackground $PREFS(ACTIV_FG) \
    -command {setSortMode fp} \
    -highlightcolor {#ffffffffffff} \
    -text {+} \
    -image [lohiaz]
    bind  .main.files.top.p <Enter> {
      .bf.labq configure -text "Sort Files alphapbetically Ascending..."
    }
    bind  .main.files.top.p <Leave> {
      .bf.labq configure -text $PREFS(MSG) 
    }

  # build widget .main.files.top.lab
  label .main.files.top.lab \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -highlightcolor {#ffffffffffff} \
    -text {Files}
  # build widget .bf.fentry
  entry .main.files.top.fentry \
    -background $PREFS(ENTRY_BG) \
    -foreground $PREFS(ENTRY_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -textvariable PREFS(FILE_FIND) \
    -width {10}
  bind .main.files.top.fentry <Return> {
     processFileSelection
  }
#
# Find File Item
#
  bind .main.files.top.fentry <KeyRelease> {
     update idletasks
     if {("%k" == 36) || ("%K" == "Down")} { return }
     set items [.main.files.file_list get 0 end]
     set ind [lsearch $items *$PREFS(FILE_FIND)*]
     if { $ind >= 0 } {
       BindIndex $ind
       .main.dir.f.list selection clear 0 end
     }
   }
#
# Find Next Item using the 'Down arrow'
#
   bind .main.files.top.fentry <Down> {
     set i [.main.files.file_list curselection] 
     if { $i == "" } { return }
     set items [.main.files.file_list get 0 end]
     for {set j 0} {$j < [llength $items] } { incr j} {
       if {$j > $i } { 
         if {[string first $PREFS(FILE_FIND) [lindex $items $j]] >= 0} {
           BindIndex $j
           break
         }
       }
     }
   }

  # build widget .main.files.top.m
  button .main.files.top.m \
    -background $PREFS(GENRL_FG) \
    -foreground $PREFS(GENRL_BG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -activebackground $PREFS(ACTIV_FG) \
    -command {setSortMode fm} \
    -highlightcolor {#ffffffffffff} \
    -text {-} \
    -image [hiloaz]
    bind .main.files.top.m <Enter> {
      .bf.labq configure -text "Sort Files alphabetically Descending..."
    }
    bind .main.files.top.m <Leave> {
      .bf.labq configure -text $PREFS(MSG) 
    }

  # build widget .main.files.file_list
  listbox .main.files.file_list \
    -background $PREFS(LSTBX_BG) \
    -foreground $PREFS(LSTBX_FG) \
    -highlightcolor {#ffffffffffff} \
    -selectforeground $PREFS(SELCT_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectborderwidth {2} \
    -selectmode {extended} \
    -yscrollcommand {.main.sizes.f.scrb set} \
    -export false
  # bindings
#  bind .main.files.file_list <Button-2> {
#    processFileSelection
#  }
  bind .main.files.file_list <Button-3> {
    fileOptions file 
  }
  bind .main.files.file_list <Double-Button-1> {
    processFileSelection
  }

  # build widget .main.sizes
  frame .main.sizes \
    -background $PREFS(GENRL_BG) \
    -highlightcolor {#ffffffffffff}

  # build widget .main.sizes.top
  frame .main.sizes.top \
    -background $PREFS(GENRL_BG) \
    -highlightcolor {#ffffffffffff}

  # build widget .main.sizes.top.p
  button .main.sizes.top.p \
    -background $PREFS(GENRL_FG) \
    -foreground $PREFS(GENRL_BG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -activebackground $PREFS(ACTIV_FG) \
    -command {setSortMode sp} \
    -highlightcolor {#ffffffffffff} \
    -text {+} \
    -image [lohisz]
    bind .main.sizes.top.p <Enter> {
      .bf.labq configure -text "Sort Size - from SMALLER size to LARGER file sizes" 
    }
    bind .main.sizes.top.p <Leave> {
      .bf.labq configure -text $PREFS(MSG) 
    }

  # build widget .main.sizes.top.lab
  label .main.sizes.top.lab \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -highlightcolor {#ffffffffffff} \
    -text {Size}

  # build widget .main.sizes.top.m
  button .main.sizes.top.m \
    -background $PREFS(GENRL_FG) \
    -foreground $PREFS(GENRL_BG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -activebackground $PREFS(ACTIV_FG) \
    -command {setSortMode sm} \
    -highlightcolor {#ffffffffffff} \
    -text {-} \
    -image [hilosz]
    bind .main.sizes.top.m <Enter> {
      .bf.labq configure -text "Sort Size - from LARGER size to SMALLER file sizes" 
    }
    bind .main.sizes.top.m <Leave> {
      .bf.labq configure -text $PREFS(MSG) 
    }

  # build widget .main.sizes.size
  label .main.sizes.size \
    -background $PREFS(GENRL_FG) \
    -foreground $PREFS(GENRL_BG) \
    -highlightcolor {#ffffffffffff} \
    -text {Size}

  # build widget .main.sizes.f
  frame .main.sizes.f \
    -background $PREFS(GENRL_BG) \
    -highlightcolor {#ffffffffffff}

  # build widget .main.sizes.f.size_list
  listbox .main.sizes.f.size_list \
    -background $PREFS(LSTBX_BG) \
    -foreground $PREFS(LSTBX_FG) \
    -width {14} \
    -selectmode {extended} \
    -highlightcolor {#ffffffffffff} \
    -selectforeground $PREFS(SELCT_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectborderwidth {2} \
    -yscrollcommand {.main.sizes.f.scrb set} \
    -export false
  bind .main.sizes.f.size_list <Button-3> {
    fileOptions file  
  }
  bind .main.sizes.f.size_list <Double-Button-1> {
    processFileSelection
  }

#
# Bind - Control for Listboxes  
#
  foreach l [list .main.files.file_list \
                  .main.sizes.f.size_list \
                  .main.date.date_list] {

  bind $l <ButtonRelease-1> {
    setFileSelections 
    .main.dir.f.list selection clear 0 end
  }
#
# Scroll all three Listboxes if Button -2 is down...
#
  bind $l <B2-Motion> \
   [list BindDragto %x %y .main.files.file_list \
                          .main.sizes.f.size_list \
                          .main.date.date_list] 
  bind $l <Button-2> \
     [list BindMark %x %y .main.files.file_list   \
                          .main.sizes.f.size_list \
                          .main.date.date_list]
#
# Select Single item when Button-1 is down...
#
  bind $l <Button-1> \
      [list BindSelect %y .main.files.file_list   \
                          .main.sizes.f.size_list \
                          .main.date.date_list]

 bind $l <B1-Motion> \
      [list BindAllSelect $l  %y \
                          .main.files.file_list   \
                          .main.sizes.f.size_list \
                          .main.date.date_list]

 bind $l <Control-Button-1> \
     [list BindAllSelect  $l  %y  \
                          .main.files.file_list   \
                          .main.sizes.f.size_list \
                          .main.date.date_list]

 bind $l <Control-B1-Motion> \
     [list BindAllSelect $l %y  \
                          .main.files.file_list   \
                          .main.sizes.f.size_list \
                          .main.date.date_list]
#
# Ignore Shift Button- Motion/ Shift Motion
#
    bind $l <Shift-B1-Motion> {}
    bind $l <Shift-Motion> {}
 }

  # build widget .main.sizes.f.scrb
  scrollbar .main.sizes.f.scrb \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -troughcolor $PREFS(GENRL_BG) \
    -command { multiScroll  \
    {.main.files.file_list  .main.date.date_list  .main.sizes.f.size_list} } \
    -highlightcolor {#ffffffffffff}

  # build widget .bf
  frame .bf \
    -background $PREFS(GENRL_BG) \
    -highlightcolor {#ffffffffffff}

  # build widget .toolbar.dev
   button .toolbar.dev \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {cd $PREFS(DEVELOPMENT_DIR);refresh} \
    -highlightcolor {#ffffffffffff} \
    -padx {12} \
    -pady {4} \
    -image [dev_im] 
    bind .toolbar.dev <Enter> {
      .bf.labq configure -text "Go to - Development area; defined as 'DEVELOPMENT_DIR'" 
    }
    bind .toolbar.dev <Leave> {
      .bf.labq configure -text $PREFS(MSG) 
    }

  # build widget .toolbar.mirror
   button .toolbar.mirror \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {mirrorDir} \
    -highlightcolor {#ffffffffffff} \
    -padx {12} \
    -pady {4} \
    -image [mirror_im]
    bind .toolbar.mirror <Enter> {
      .bf.labq configure -text "Switch from RCSROOT to development area'" 
    }
    bind .toolbar.mirror <Leave> {
      .bf.labq configure -text $PREFS(MSG) 
    }

  # build widget .toolbar.build
   button .toolbar.build \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command {buildDir} \
    -highlightcolor {#ffffffffffff} \
    -padx {12} \
    -pady {4} \
    -image [build_im] 
  bind .toolbar.build <Enter> {
    .bf.labq configure -text "Go to - build area; defined as 'BUILD_DIR'" 
  }
  bind .toolbar.build <Leave> {
    .bf.labq configure -text $PREFS(MSG) 
  }
  
  # build widget .bf.labeq
   label .bf.labq \
    -anchor {w} \
    -borderwidth {3} \
    -relief {ridge} \
    -width {80} \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -text {}
    
  # pack master .menubar
  pack configure .menubar.file \
    -fill x \
    -side left
  pack configure .menubar.view \
    -fill x \
    -side left
  pack configure .menubar.conf \
    -fill x \
    -side left
  pack configure .menubar.lab \
    -fill x \
    -side left
  pack configure .menubar.ent \
    -fill x \
    -side left
  pack configure .menubar.add \
    -fill x \
    -side left
  pack configure .menubar.bookmarks \
    -fill x \
    -side left
  pack configure .menubar.ent2 \
    -expand 1 \
    -fill x \
    -side left
  pack configure .menubar.rmdb \
    -fill x \
    -side left
  pack configure .menubar.help \
    -fill x \
    -side right

  # pack master .main
  pack configure .main.dir \
    -expand 0 \
    -fill both \
    -side left

  if {![string compare "unix" $tcl_platform(platform)]} {
    pack configure .main.dir0 \
      -expand 0 \
      -fill both \
      -side left
  }
  pack configure .main.date \
    -expand 0 \
    -fill both \
    -side left
  pack configure .main.files \
    -expand 1 \
    -fill both \
    -side left
  pack configure .main.sizes \
    -expand 0 \
    -fill both \
    -side left

  # pack master .main.dir 
  pack configure .main.dir.le.label \
    -side left \
    -pady {2} \
    -fill x
  pack configure .main.dir.le.fentry \
    -side left \
    -expand 1 \
    -padx {3} \
    -fill x
  pack configure .main.dir.le \
    -expand 0 \
    -fill x 
  pack configure .main.dir.f \
    -expand 1 \
    -fill both \
    -side bottom

  # pack master .main.dir.f
  pack configure .main.dir.f.scrb \
    -fill y \
    -side left
  pack configure .main.dir.f.list \
    -anchor n \
    -expand 1 \
    -fill both \
    -side left

  # pack master .main.dir0
#  pack configure .main.dir0.f \
#    -expand 1 \
#    -fill both \
#    -side bottom
  pack configure .main.dir0.checkbutton0 \
    -pady {2} \
    -fill x \
    -side top 

  # pack master .main.dir0.f
  pack configure .main.dir0.f.list \
    -anchor n \
    -expand 0 \
    -fill both \
    -side left

  # pack master .main.date
  pack configure .main.date.top \
    -fill x
  pack configure .main.date.date_list \
    -anchor n \
    -expand 1 \
    -fill both \
    -side bottom

  # pack master .main.date.top
  pack configure .main.date.top.p \
    -side left
  pack configure .main.date.top.lab \
    -expand 1 \
    -fill x \
    -side left
  pack configure .main.date.top.m \
    -side right

  # pack master .main.files
  pack configure .main.files.top \
    -fill x
  pack configure .main.files.file_list \
    -anchor n \
    -expand 1 \
    -fill both \
    -side bottom

  # pack master .main.files.top
  pack configure .main.files.top.p \
    -side left
  pack configure .main.files.top.lab \
    -expand 0 \
    -fill x \
    -side left
  pack configure .main.files.top.fentry \
    -expand 1 \
    -padx {3} \
    -fill x \
    -side left
  pack configure .main.files.top.m \
    -side right

  # pack master .main.sizes
  pack configure .main.sizes.top \
    -fill x
  pack configure .main.sizes.f \
    -anchor n \
    -expand 1 \
    -fill both \
    -side left

  # pack master .main.sizes.top
  pack configure .main.sizes.top.p \
    -side left
  pack configure .main.sizes.top.lab \
    -expand 1 \
    -fill x \
    -side left
  pack configure .main.sizes.top.m \
    -side right

  # pack master .main.sizes.f
  pack configure .main.sizes.f.size_list \
    -anchor n \
    -expand 1 \
    -fill both \
    -side left
  pack configure .main.sizes.f.scrb \
    -expand 1 \
    -fill y \
    -side right

  # pack master .
  pack configure .menubar \
    -anchor n \
    -fill x
#
# toolbar
#
  pack configure .toolbar.up \
    -fill x \
    -side left
  pack configure .toolbar.refresh \
    -fill x \
    -side left
  pack configure .toolbar.home \
    -fill x \
    -side left
  pack configure .toolbar.mkdir \
    -fill x \
    -side left
  pack configure .toolbar.rename \
    -fill x \
    -side left
  pack configure .toolbar.delete \
    -fill x \
    -side left
  pack configure .toolbar.duplicate \
    -fill x \
    -side left
  pack configure .toolbar.cut \
    -fill x \
    -side left
  pack configure .toolbar.copy \
    -fill x \
    -side left
  pack configure .toolbar.paste \
    -fill x \
    -side left
  pack configure .toolbar.browse \
    -fill x \
    -side left
  pack configure .toolbar.convert \
    -fill x \
    -side left

  pack configure .toolbar.dev \
    -side left
  pack configure .toolbar.mirror \
    -side left
  pack configure .toolbar.build \
    -side left

  # Pack info messages...
  pack configure .bf.labq \
    -side left \
    -expand 1 \
    -fill x
  pack configure .toolbar \
    -expand 0 \
    -fill both


  pack configure .main \
    -expand 1 \
    -fill both
  pack configure .bf \
    -fill x
}

proc GetSpace {} {
#  Function to get available disk-space.  
# 
# <b>NOTE:</b> Currently a stubb function.   
#
}

proc gotoLineNo { widget } {
#  Procedure to set brwose widget to line-number 
  global PREFS
  $widget.top.text yview $PREFS(LINE_NO)
}

proc findText {widget} {
# Find an item in a text widget.  
# @param widget : text widget.
#
  global PREFS
  set PREFS(LINE_NUMBERS) ""
  set PREFS(LINE_INDEX)   0
  set found 0
  $widget.top.text tag delete big everywhere 1.0 end
  if { $PREFS(SEARCH) != "" } {
    set found [forAllMatches \
       $widget.top.text $PREFS(SEARCH) {$widget.top.text tag add big first last
} ]
    $widget.top.text tag configure big \
       -background yellow -foreground red -borderwidth 2
  }
  set PREFS(LINE_NO) $found
  set found [expr $found -12]
  $widget.top.text yview $found
}

proc findNext {widget mo} {
# Find next or previous <i>search</i> item.  
# @param mo : mode N = Next,  P = Previous.
#
  global PREFS
  $widget.top.text tag delete big everywhere 1.0 end
  if { [llength $PREFS(LINE_NUMBERS)] == 0 } {
    return
  }
  if { $mo == "N"} { 
    incr PREFS(LINE_INDEX)
  } else {
    set PREFS(LINE_INDEX) [expr $PREFS(LINE_INDEX) - 1] 
  }
  if { $PREFS(LINE_INDEX) >= [llength $PREFS(LINE_NUMBERS)] } {
    set PREFS(LINE_INDEX) 0
  } 
  if { $PREFS(LINE_INDEX) < 0 } {
    set PREFS(LINE_INDEX) [lindex $PREFS(LINE_NUMBERS) end]  
    set PREFS(LINE_INDEX) [expr [llength $PREFS(LINE_NUMBERS)] - 1]
  } 

  set line_value [lindex $PREFS(LINE_NUMBERS) $PREFS(LINE_INDEX)]
  set line_value [expr $line_value -12]
  $widget.top.text yview $line_value

  forLineMatch $widget.top.text $PREFS(SEARCH) $line_value \
    {$widget.top.text tag add big first last}
    $widget.top.text tag configure big \
       -background yellow -foreground red -borderwidth 2
}

proc scrollText { widget args } {
# This procedure attempts to compute the current line-number while scrolling 
# @param widget : Text widget to scroll
# @param args : y-scroll.
# 
# Bug: Line calculation does not work with dos-windows/NT
# 
  global PREFS tcl_platform
  if {![string compare "windows" $tcl_platform(platform)]} {
    set PREFS(LINE_NO) 0; set PREFS(COL_NO) 0
    eval $widget yview $args
  	return
  }
  set hw  [split [winfo geometry $widget] x]
  set hh  [split [lindex $hw 1 ] +]
  set ph [lindex $hh 0]
  if {$ph != $PREFS(${widget}_TEXT_W_SIZE) } {
    set PREFS(${widget}_NUM_LINES) [expr 24 * $ph/$PREFS(BASE_TEXT_W_SIZE)]
  }
  eval $widget yview $args
  set lend [$widget index end]
  set lscr [lindex [$widget yview] 1]
  set lcur int([expr $lend * $lscr - $PREFS(${widget}_NUM_LINES) + .5 ])
  set PREFS(LINE_NO) [expr $lcur] 
}

proc getLineNumber { w } { 
  global PREFS
  scan [$w index insert] %d.%d PREFS(LINE_NO) PREFS(COL_NO)
} 


proc helpBrowseFile { } {
# Help browse file.       
#
   global PREFS
   set PREFS(DATA) { 
Browse File:
  This is a simple browsing tool, used to quickly browse files and find text.

- Use the 'Find' or <Return> key after typing in some text in the find field. 

- Once the find command has been activated, use the 'Next' and 'Previous' buttons
  to navigate through the file.

- Type in a Line Number in the 'L:' field, to go-to that line number. 

Key short-cuts.
==============
- Use <Ctrl-s> to clear the previous find command and place the cursor in the 
  find field.

- Use <Ctrl-n> to navigate to the 'Next' found item (same as 'NEXT' button) 

- Use <Ctrl-p> to navigate to the 'Previous' found item (same as 'PREV' button) 
}
browseFile "Help Browse File"
}
  

proc browseFile {filnam} {
#  Displays either a file or global PREFS(DATA). 
#  @param filenam : filename to display or if it does not exist, 
#                 it becomes the title of the browser. 
#  @global PREFS(DATA) : Help info or output from some program execution.
#
  global PREFS

  if { $filnam == "none" } { return }
  set wtext .txt$PREFS(HELP_COUNT)

  if {[file exists $filnam] > 0 } { 
    if { [file size $filnam] > $PREFS(MAX_SIZE) } {
      setErrMsg "File to big: $filnam > $PREFS(MAX_SIZE)" 7000
      return
    }
  }
    
  toplevel $wtext -relief raised
  wm title $wtext ${filnam}
  set data ""
  if {[file exists $filnam] <= 0 } { set filnam "" }

  # build widget $wtext.s
  frame $wtext.s \
    -background $PREFS(GENRL_BG) \
    -highlightcolor {#ffffffffffff}

  # build widget $wtext.s.search
  button $wtext.s.search \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command "findText $wtext" \
    -highlightcolor {#ffffffffffff} \
    -padx {11} \
    -pady {4} \
    -text {Search:} \
    -image [search_im]

  # build widget $wtext.s.next
  button $wtext.s.next \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command "findNext $wtext N" \
    -highlightcolor {#ffffffffffff} \
    -padx {11} \
    -pady {4} \
    -text {N:} \
    -image [next_im]

  # build widget $wtext.s.prev
  button $wtext.s.prev \
    -activebackground $PREFS(ACTIV_FG) \
    -activeforeground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command "findNext $wtext P" \
    -highlightcolor {#ffffffffffff} \
    -padx {11} \
    -pady {4} \
    -text {P:} \
    -image [prev_im]

  # build widget $wtext.s.ent
  entry $wtext.s.ent \
    -background $PREFS(ENTRY_BG) \
    -foreground $PREFS(ENTRY_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -highlightcolor {#ffffffffffff} \
    -insertbackground  $PREFS(SELCT_FG) \
    -textvariable PREFS(SEARCH) \
    -width {45}
  # bindings
  bind $wtext.s.ent <Key-Return>  "findText $wtext"
  bind $wtext.s.ent <Control-KeyPress-n> "findNext $wtext N"
  bind $wtext.s.ent <Control-KeyPress-p> "findNext $wtext P"
  bind $wtext.s.ent <Control-KeyPress-N> "findNext $wtext N"
  bind $wtext.s.ent <Control-KeyPress-P> "findNext $wtext P"
  bind $wtext.s.ent <Control-KeyPress-S> "focus $wtext.s.ent;set PREFS(SEARCH) {};update idletasks"
  bind $wtext.s.ent <Control-KeyPress-s> "focus $wtext.s.ent;set PREFS(SEARCH) {};update idletasks"

  label $wtext.s.lab_l -text "L:" \
     -width {2} \
     -foreground $PREFS(GENRL_FG) \
     -background $PREFS(GENRL_BG)

  # build widget $wtext.s.line_no
  entry $wtext.s.line_no \
    -background $PREFS(ENTRY_BG) \
    -foreground $PREFS(ENTRY_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -highlightcolor {#ffffffffffff} \
    -textvariable PREFS(LINE_NO) \
    -width {6}
  # bindings
  bind $wtext.s.line_no <Key-Return> "gotoLineNo  $wtext"


  label $wtext.s.lab_c -text "C:" \
     -width {2} \
     -foreground $PREFS(GENRL_FG) \
     -background $PREFS(GENRL_BG)

  # build widget $wtext.s.col_no
  entry $wtext.s.col_no \
    -background $PREFS(ENTRY_BG) \
    -foreground $PREFS(ENTRY_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -highlightcolor {#ffffffffffff} \
    -textvariable PREFS(COL_NO) \
    -width {6}
  # bindings
#  bind $wtext.s.line_no <Key-Return> "gotoColNo  $wtext"

  # build widget $wtext.top
  frame $wtext.top \
    -background $PREFS(GENRL_BG) \
    -highlightcolor {#ffffffffffff}

  # build widget $wtext.top.text
  text $wtext.top.text \
    -background $PREFS(TEXTW_BG) \
    -foreground $PREFS(TEXTW_FG) \
    -highlightcolor {#ffffffffffff} \
    -insertbackground $PREFS(SELCT_FG) \
    -relief {sunken} \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -width {80} \
    -wrap {none} \
    -xscrollcommand "$wtext.top.scrollbar0 set" \
    -yscrollcommand "$wtext.top.scrb set"
  # build widget $wtext.top.scrb
  bind $wtext.top.text <Button-1> "focus $wtext.top.text;$wtext.top.text mark set insert 1.0" 
  bind $wtext.top.text <Control-KeyPress-S> "focus $wtext.s.ent;set PREFS(SEARCH) {};update idletasks"
  bind $wtext.top.text <Control-KeyPress-s> "focus $wtext.s.ent;set PREFS(SEARCH) {};update idletasks"
  bind $wtext.top.text <ButtonRelease-1>  "getLineNumber $wtext.top.text" 

  scrollbar $wtext.top.scrb \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -troughcolor $PREFS(GENRL_BG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -command "scrollText $wtext.top.text" \
    -highlightcolor {#ffffffffffff}

  # build widget $wtext.top.scrollbar0
  scrollbar $wtext.top.scrollbar0 \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -troughcolor $PREFS(GENRL_BG) \
    -activerelief {sunken} \
    -command "$wtext.top.text xview" \
    -highlightcolor {#ffffffffffff} \
    -orient {horizontal}

  # build widget $wtext.top.frame
  frame $wtext.top.frame \
    -background $PREFS(GENRL_BG) \
    -highlightcolor {#ffffffffffff}

  # build widget $wtext.top.frame.ok
  button $wtext.top.frame.ok \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command "destroy $wtext;image delete prev_im$PREFS(HELP_COUNT);image delete next_im$PREFS(HELP_COUNT);image delete search_im$PREFS(HELP_COUNT)" \
    -highlightcolor {#ffffffffffff} \
    -text {OK}

  # build widget $wtext.top.frame.help
  button $wtext.top.frame.help \
    -activeforeground $PREFS(ACTIV_FG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -foreground $PREFS(GENRL_FG) \
    -command "helpBrowseFile" \
    -highlightcolor {#ffffffffffff} \
    -text {Help}

  # pack master $wtext.s
  pack configure $wtext.s.search \
    -anchor w \
    -side left
  pack configure $wtext.s.next \
    -anchor w \
    -side left
  pack configure $wtext.s.prev \
    -anchor w \
    -side left
  pack configure $wtext.s.ent \
    -anchor w \
    -expand 1 \
    -fill x \
    -side left

  pack configure $wtext.s.lab_l \
    -anchor w \
    -expand 0 \
    -fill x \
    -side left

  pack configure $wtext.s.line_no \
    -anchor w \
    -expand 0 \
    -fill x \
    -side left

  pack configure $wtext.s.lab_c \
    -anchor w \
    -expand 0 \
    -fill x \
    -side left
  pack configure $wtext.s.col_no \
    -anchor w \
    -expand 0 \
    -fill x \
    -side left

  # pack master $wtext.top
  pack configure $wtext.top.scrb \
    -fill y \
    -side right
  pack configure $wtext.top.text \
    -expand 1 \
    -fill both
  pack configure $wtext.top.scrollbar0 \
    -fill x
  pack configure $wtext.top.frame

  pack configure $wtext.top.frame.ok \
    -side left
  pack configure $wtext.top.frame.help \
    -side left

  # pack master $wtext
  pack configure $wtext.s \
    -fill x
  pack configure $wtext.top \
    -expand 1 \
    -fill both

  incr PREFS(HELP_COUNT)

  set line_len 0
  if { $filnam != "" } {  
    set f [open $filnam r]
    while { [gets $f line] >= 0 } {
      set t_len [string length $line]
      if { $t_len > $line_len } {
        set line_len $t_len
      }
      set data "${data}${line}\n"
    }
    close $f
    $wtext.top.text insert end $data
  } else {
    $wtext.top.text insert end $PREFS(DATA)
  }

  update idletasks
  focus $wtext.s.ent
  if { $PREFS(BASE_TEXT_W_SIZE) == 0 } {
    set hw  [split [winfo geometry $wtext.top.text] x]
    set hh  [split [lindex $hw 1 ] +]
    set ph [lindex $hh 0]
    set PREFS(BASE_TEXT_W_SIZE) $ph
  }

  set PREFS(${wtext}.top.text_TEXT_W_SIZE) $PREFS(BASE_TEXT_W_SIZE) 
  set PREFS(${wtext}.top.text_NUM_LINES)   24
  setWindowPos . $wtext 30 30
}


proc checkDiskSpace {} {
#  Displays the output from the df program (unix-only) 
#
  global PREFS
  if { [findWhich df] == "" } {
    setErrMsg "df command not in your path..." 7000
    return
  }
  catch { exec df  . } msg
  mkDialog .msg "-fg $PREFS(TEXTW_FG) -text {Space:\n$msg } -justify left -aspect 800 " "OK {}"
}

proc gtCompare {a b} {
# Compare "a" with "b" and return a 0 or 1. 
# @param a : If a greater than b? return 1
# @param b : If b greater than a? return 0 
# @return  0 or 1
#
  set a_item [lindex [split $a ^] 0]
  set b_item [lindex [split $b ^] 0]
  if { $a_item > $b_item } {
    return 1 
  } else {
    return 0 
  }
}

proc ltCompare {a b} {
# Compare "a" with "b" and return a 0 or 1. 
# @param a : If a less than b? return 1
# @param b : If b less than a? return 0 
# @return  0 or 1
#
  set a_item [lindex [split $a ^] 0]
  set b_item [lindex [split $b ^] 0]
  if { $a_item < $b_item } {
    return 1
  } else {
    return 0
  }
}

proc destroyImages {w} {
# Re-set image count and destroy image widget.
# @param w : Widget to be destroyed.
# @global PREFS(IM_COUNT) : Image number displayed.
#
  global PREFS(IM_COUNT)
  set PREFS(IM_COUNT) 0
  destroy $w
}

proc dispCanvas {} {
#  Display thumb-nailed sized images on a scrolling canvas widget.
#  @global PREFS(X_POS)    : X image coordinate.
#  @global PREFS(Y_POS)    : Y image coordinate.
#  @global PREFS(IM_COUNT) : image widget id on canvas widget
#
  global PREFS

  if {[winfo exists .top] } {
    focus .top.im.can
    update idletasks 
    return
  }

  set PREFS(IM_COUNT) 0
  set PREFS(X_POS)   50
  set PREFS(Y_POS)   50

  toplevel .top 
  wm title .top "Images"

  frame .top.im

  canvas .top.im.can  \
    -background $PREFS(GENRL_BG) \
    -xscrollcommand ".top.im.hscr set"  \
    -yscrollcommand ".top.im.vscr set"  \
    -confine false

  scrollbar .top.im.hscr  \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -troughcolor $PREFS(GENRL_BG) \
    -command ".top.im.can xview"  \
    -orient horizontal

  scrollbar .top.im.vscr -background $PREFS(GENRL_BG) \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -troughcolor $PREFS(GENRL_BG) \
    -command ".top.im.can yview"
  
  pack .top.im.vscr \
    -side right \
    -fill y
  pack .top.im.hscr \
    -side bottom \
    -fill x
  
  pack .top.im.can \
    -side left  \
    -expand yes \
    -fill both
 
  set files [glob -nocomplain *]
  
  if { $files != "" } {

     set sorted [lsort $files]
 
      foreach filename $sorted {
         dispFile .top.im.can $filename
      }
  
      set w 900
      set h [expr $PREFS(Y_POS) + 80]
      .top.im.can configure  -scrollregion "0 0 $w $h"
  }
  pack .top.im -fill both -expand yes
  button  .top.b -text "Exit" -command { destroyImages .top } 
  pack .top.b -side bottom -fill x
}

proc dispFile { can filename} {
#  Make thumb-nail images and put them on a scrolling canvas widget. 
#  @global PREFS(IM_COUNT) : Image count (keeps the widget id unique). 
#
  global PREFS 

  set type [identifyFile $filename]

  if {($type == ".gif") || \
      ($type == ".ppm") || \
      ($type == ".pgm") || \
      ($type == ".xbm")} {

    set PREFS(MSG) "Loading Image File: $filename"
    .bf.labq configure -text $PREFS(MSG) 
    update idletasks
    frame $can.$PREFS(IM_COUNT) -background $PREFS(GENRL_BG) 
    label $can.$PREFS(IM_COUNT).tx \
       -background {#00d8ff} \
       -font {-*-Courier-Bold-R-Normal--*-120-*-*-*-*-*-*} \
       -text $filename 

    if { $type == ".xbm" }  {
#      image create bitmap $PREFS(IM_COUNT)  -file $filename
      button $can.$PREFS(IM_COUNT).im \
             -background $PREFS(GENRL_BG) \
             -bitmap @${filename}  \
             -command "showImage $filename"  \
             -relief flat
    } else {
      image create photo $PREFS(IM_COUNT) -file $filename
      set small [shrinkImage $PREFS(IM_COUNT) 100 60]
      button $can.$PREFS(IM_COUNT).im \
             -background $PREFS(GENRL_BG) \
             -image $small  \
             -command "showImage $filename"  \
             -relief flat
      image delete $PREFS(IM_COUNT)
    }

    pack $can.$PREFS(IM_COUNT).im $can.$PREFS(IM_COUNT).tx -side top
    $can create window $PREFS(X_POS) $PREFS(Y_POS) -window $can.$PREFS(IM_COUNT)

    set PREFS(X_POS) [expr $PREFS(X_POS) + 110]

    if { $PREFS(X_POS) > 800 } {

      set PREFS(X_POS) 50
      set PREFS(Y_POS) [expr $PREFS(Y_POS) + 100]
    }
    set PREFS(IM_COUNT) [incr PREFS(IM_COUNT)]
  }
  after 20000 clearMsgArea
}

proc forAllMatches { w pattern script } {
# Hilite all instances of "Search for"" in a text widget. 
# @param       w : Text widget.
# @param pattern : Search pattern. 
# @param  script : Procedure used to define tags.  
#
  global PREFS
  set found 0
  set old_i 1
  set PREFS(LINE_NUMBERS)   "" 
  scan [$w index end] %d numLines
  for {set i 1} {$i < $numLines} {incr i} {
    $w mark set last $i.0
    while {[regexp -nocase -indices $pattern \
           [$w get last "last lineend"] indices]} {
      $w mark set first \
            "last + [lindex $indices 0] chars"
      $w mark set last "last + 1 chars \
            + [lindex $indices 1] chars"
      if {$i != $old_i} {
        lappend PREFS(LINE_NUMBERS) $i
      }
      set old_i $i
      if { $found == 0 } {
        set found $i
      }
      uplevel $script
    }
  }
  return $found
}

proc forLineMatch { w pattern line script } {
#  Hilite all instances of "Search for"" in the selected file. 
#  @param      w : Text widget.
#  @param   line : Text from a line. 
#  @param script : Procedure used to define tags.  
#
  global PREFS
  set found 0
  set line [expr $line + 12]
  $w mark set last $line.0
  while {[regexp -nocase -indices $pattern \
         [$w get last "last lineend"] indices]} {
    $w mark set first \
          "last + [lindex $indices 0] chars"
    set PREFS(LINE_NO) $line
    set PREFS(COL_NO)  [lindex $indices 0]
    $w mark set last "last + 1 chars \
          + [lindex $indices 1] chars"
    uplevel $script
  }
}

proc getDate { value} {
#  Return a file date in a displayable format  
#  @param value : Clock-seconds to be converted into a date.
#
   return [clock format $value -format "%b-%d-%Y  %I:%M:%S%p"]
#  return [fmtclock $value "%Y %d %h"] 
#  set y 1970.0000000
#  set m {{Jan} {Feb} {Mar} {Apr} {May} {Jun}  #         {Jul} {Aug} {Sep} {Oct} {Nov} {Dec}}
#  set dd {{31} {28} {31} {30} {31} {30}  #          {31} {31} {30} {31} {30} {31}}
#  set ry [expr $y +  $value/3600.0/24.0/365]
#  set iy [expr int($ry)]
#  set yp [expr $ry - $iy]
#  set dy [expr ($yp * 365.0) - int([expr $ry - $y]/4.0)]
#  set count 0
#  if {$dy > 31} {
#    foreach v $dd {
#      set dy [expr $dy - $v]
#      if { $dy < 28.0 } {
#        set $dy [expr $dy +1];
#        break;
#      }
#      set count [expr $count +1]
#    }
#  }
#  set dy [expr int($dy)]
#  set month [lindex  $m  [expr int([expr $yp * 12])]]
#  set tdate "$month $dy $iy"
#  return $tdate
}


proc goUp {} {
#  Change directory to the level above.
#  @global PREFS(D_VIEW_POS) : Previous directory menu position.  
#
  global PREFS

  if { $PREFS(D_VIEW_POS) == "" } {
    set PREFS(D_VIEW_POS) 0
  }

  # Go up one.
  cd ..

  if { [string compare $PREFS(OLD_DIR) $PREFS(SAVE_DIR)] == 0 } {
    set PREFS(OLD_DIR) "" 
  } else {
    set PREFS(SAVE_DIR) $PREFS(OLD_DIR)
  }

  # Read directory.
  refresh
  if {! $PREFS(DU_TOGGLE) } {
    .main.dir.f.list yview $PREFS(D_VIEW_POS) 
  }
  if { $PREFS(IM_COUNT) > 0 } {
    destroy .top
    set PREFS(IM_COUNT) 0
  }
}

proc identifyFile {filename} {
#  Return (lower-case) file extension.   
#  @param filename : File Name to be identified (extension). 
#
  if {[string first ",v" $filename] > 0 } {
    return 7 
  } else {
    set ext [file extension $filename]
  }
  set ext [string tolower $ext]
  return $ext
}

proc mkDialog { w msgArgs args} {
# General purpose message pop-up dialog.    
# @param w : toplevel widget
# @param msgArgs : Text message  
# @param args :  Extra buttons, foreground background, etc  
#
    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w "Dialog box"
    wm iconname $w "Dialog"

    global PREFS

    # Create two frames in the main window. The top frame will hold the
    # message and the bottom one will hold the buttons.  Arrange them
    # one above the other, with any extra vertical space split between
    # them.

    frame $w.top -relief raised -border 1 -bg lightGray
    frame $w.bot -relief raised -border 1 -bg lightGray
    pack $w.top $w.bot -side top -fill both -expand yes

    # Create the message widget and arrange for it to be centered in the
    # top frame.

    eval message $w.top.msg \
        -justify center  \
        -font {-*-Courier-Bold-R-Normal--*-140-*-*-*-*-*-*}  \
        -bg $PREFS(TEXTW_BG) $msgArgs
    pack $w.top.msg -side top -expand yes -padx 3 -pady 3

    # Create as many buttons as needed and arrange them from left to right
    # in the bottom frame.  Embed the left button in an additional sunken
    # frame to indicate that it is the default button, and arrange for that
    # button to be invoked as the default action for clicks and returns in
    # the dialog.

    if {[llength $args] > 0} {
        set arg [lindex $args 0]
        frame $w.bot.0 -relief sunken -border 1 -bg lightGray
        pack $w.bot.0 -side left -expand yes -padx 10 -pady 10
        button $w.bot.0.button -background $PREFS(GENRL_BG) \
             -text [lindex $arg 0]  \
             -command "[lindex $arg 1]; destroy $w"
        pack $w.bot.0.button -expand yes -padx 6 -pady 6
        bind $w <Return> "[lindex $arg 1]; destroy $w"
        focus $w

        set i 1
        foreach arg [lrange $args 1 end] {
            button $w.bot.$i \
			     -text [lindex $arg 0] \
			     -background $PREFS(GENRL_BG) \
				 -command "[lindex $arg 1]; destroy $w"
            pack $w.bot.$i -side left -expand yes -padx 10
            set i [expr $i+1]
        }
    }
    bind $w <Any-Enter> [list focus $w]
    focus $w
    setWindowPos . $w 60 60
}

proc multiScroll { scroll_list args} {
# scrolls multiple list-boxes.    
# @param scroll_list : list of widgets to scroll
#

 # Get info on list of args.
 set len [llength $scroll_list]

 for {set i 0} {$i < $len} {incr i} {
     set temp_list [lindex $scroll_list $i]

     # Uncomment next line for debugging.
     # puts "Command: $temp_list yview $args"

     eval $temp_list yview $args
 }
}

proc readDir { dirlist filelist sizelist datelist} {
# Update list-boxes with current directory info.    
# @param  dirlist : directory listbox.
# @param filelist : file listbox.
# @param sizelist : size listbox.
# @param datelist : date listbox.
#
  global PREFS tcl_platform
  # Clear listboxes
  .main.dir0.f.list delete 0 end
  $dirlist  delete 0 end
  $filelist delete 0 end
  $datelist delete 0 end
  $sizelist delete 0 end
  set flist     ""
  set unsorted  ""
  set sort_list ""
  set dirs      ""

  .main configure -cursor watch
  update idletasks
 
  set types [split $PREFS(TYPES) ,] 
  foreach ft {.* *} {
    set file_list [glob -nocomplain $ft]
    foreach file $file_list {
      if {[string first "~" $file] == 0} {
         continue
      }
      if {([file isdirectory $file] != 0) } { 
        lappend unsorted $file
      } else {
        foreach type $types {
          if { [string match $type $file] > 0 } {
            if { [lsearch $unsorted $file] == -1 } { 
              lappend unsorted $file 
            }
          }
        } 
      }
    }
  }
  if {$unsorted != ""} {
    foreach filename $unsorted {
      if { $filename != "." } {
	if { ([file isdirectory $filename] != 0) && ($filename != "..") } {
	  lappend dirs $filename
	} elseif { $filename != ".." } {
	  if { [file readable $filename ] } { 
	    set sz [file size $filename]
	    set date [file mtime $filename]
	    set sz [file size $filename]
	    if { $PREFS(SORT_MODE) == "" } {
	      $filelist insert end "$filename"
	      set tdate [getDate $date]
	      $datelist insert end $tdate
	      $sizelist insert end $sz
	    } else {
	      if {$PREFS(SORT_MODE) == "fp"} {
		lappend flist "${filename}^${date}^${sz}"
	      } elseif {$PREFS(SORT_MODE) == "fm"} {
		lappend flist "${filename}^${date}^${sz}"
	      } elseif {$PREFS(SORT_MODE) == "dp"} {
		lappend flist "${date}^${filename}^${sz}"
	      } elseif {$PREFS(SORT_MODE) == "dm"} {
		lappend flist "${date}^${filename}^${sz}"
	      } elseif {$PREFS(SORT_MODE) == "sp"} {
		lappend flist "${sz}^${filename}^${date}"
	      } elseif {$PREFS(SORT_MODE) == "sm"} {
		lappend flist "${sz}^${filename}^${date}"
	      }
	    }
	  }
	}
      }
    } 
    .main.dir.f.list insert end ".." 
    set dirs [lsort $dirs]
#
# DU
#
    if { $PREFS(DU_TOGGLE) } {
      .main.dir0.f.list insert end "" 
#       set fs [open "|c:/cygnus/cygwin-b20/H-i586-cygwin32/bin/du $dirs"]
      set fs [open "|du $dirs"]
      set count 0
      while {[gets $fs line] >= 0} {
	scan $line "%d %s" size  name
	if { $name == [lindex $dirs $count]} {
	  incr count
	  .main.dir0.f.list insert end $size
	  .main.dir.f.list insert end $name 
	}
      }
      close $fs
    } else {
      foreach dir $dirs {
	.main.dir.f.list insert end $dir
      }
    }
    
    if { $PREFS(SORT_MODE) != ""} {
      if {[string range $PREFS(SORT_MODE) 0 0] == "f"} {
	set ff 0
	set ss 1
	set tt 2
	if {[string range $PREFS(SORT_MODE) 1 1] == "p"} {
	  set sort_list [lsort -ascii $flist]
	} else {
	  set sort_list [lsort -ascii -decreasing $flist]
	}
      } elseif {[string range $PREFS(SORT_MODE) 0 0] == "d"} {
	set ff 1
	set ss 0
	set tt 2
	if {[string range $PREFS(SORT_MODE) 1 1] == "p"} {
	  set sort_list [lsort -command gtCompare $flist]
	} else {
	  set sort_list [lsort -command ltCompare $flist]
	}
      } elseif {[string range $PREFS(SORT_MODE) 0 0] == "s"} {
	set ff 1
	set ss 2
	set tt 0
	if {[string range $PREFS(SORT_MODE) 1 1] == "p"} {
	  set sort_list [lsort -command gtCompare $flist]
	} else {
	  set sort_list [lsort -command ltCompare $flist]
	}
      } 
      foreach fl $sort_list {
	set items [split $fl ^] 
	$filelist insert end [lindex $items $ff]
	#          puts [lindex $items $ss]
	set tdate [getDate [lindex $items $ss]]
	$datelist insert end $tdate 
	$sizelist insert end [lindex $items $tt] 
      }
    }
    set unsorted ""
    set sort_list ""
  }
  if { [info exists items] > 0 } {
    set items [ lreplace $items 0 end ] 
  }
  set PREFS(CUR_DIR) [pwd]
  .main configure -cursor left_ptr
}


proc refresh {} {
# Update list-boxes with current file info.    
#
#  global PREFS
#
  loadRcsInfo
  GetSpace
  readDir .main.dir.f.list  \
      .main.files.file_list \
      .main.sizes.f.size_list \
      .main.date.date_list
}

proc diffTheRcsFile { } {
#  Procedure rcs-diff using tkdiff.    
#
  global PREFS env

  set old_path [pwd]

  set endpart [getEndpart]
  if {[file exists $PREFS(DEVELOPMENT_DIR)/${endpart}] } {
    set local_path $PREFS(DEVELOPMENT_DIR)/${endpart}
  } else {
    set local_path [pwd]
  }

  set tmp_dir "/var/tmp/[getUid]"
  if {[file exists ${tmp_dir}] <= 0}  {
    file mkdir ${tmp_dir}
  }
  if {[file exists ${tmp_dir}] <= 0}  {
    setErrMsg "Failed to create temporary directory ${tmp_dir}" 7000
    cd $old_path
    return;
  }
  cd $tmp_dir

  catch {exec $PREFS(RCS_BIN)/co -r$PREFS(RCS_BASE_VER) $PREFS(RCS_FILE)} msg
  set file_name [file tail $PREFS(RCS_FILE)]
  regsub {,v$} [file tail $file_name] {} tf
  if { [string first "done" $msg] <= 0 } {
    mkDialog .msg "-fg $PREFS(TEXTW_FG) -text {Get of: $tf failed for the following reason:\n$msg.} -justify left -aspect 600" "OK {}"
    cd $old_path
    return
  }

  catch {exec tkdiff ${tmp_dir}/$PREFS(LOCAL_FILE) ${local_path}/$PREFS(LOCAL_FILE) &}
  cd $old_path
}

proc viewRcsFileSelected { file } {
# Checkout(unlocked) a temporary copy of the RCS ,v files to be browsed. 
# @param file : RCS file to be browsed. 
#
  global PREFS env

  set rcs_path [pwd] 
  set old_path  [pwd]

  set tmp_dir "/var/tmp/[getUid]"
  if {[file exists ${tmp_dir}] <= 0}  {
      file mkdir ${tmp_dir}
  }
  if {[file exists ${tmp_dir}] <= 0}  {
    setErrMsg "Failed to create temporary directory ${tmp_dir}" 7000
    return;
  }
  cd $tmp_dir

  regsub {,v$} [file tail $file] {} tf
  if {[file isdirectory ${rcs_path}] } {
    set rcs_file ${rcs_path}/${file}
  } else { 
    set rcs_file ${file}
  }
  catch {exec $PREFS(RCS_BIN)/co -r$PREFS(RCS_BASE_VER) ${rcs_file}} msg
  if { [string first "done" $msg] <= 0 } { 
    set PREFS(DATA) "Get of: $tf failed for the following reason:\n$msg."
  } else {
    catch {exec /bin/cat ${tf} } PREFS(DATA)
    file delete -force ${tf}
  }

  browseFile "$file"
  cd $old_path
#  refresh
}

proc rlogFileSelected { } {
#  View the output from the RCS rlog command.
#
  global PREFS env

  if { [file isdirectory [lindex $PREFS(SEL_FILES) 0]] } { 
     return
  }
  set rcs_path [pwd] 

  set endpart [getEndpart]
  if { [string first $env(RCSROOT) $rcs_path ] == -1} {
    set rcs_path $env(RCSROOT)${endpart}
  }
  set item [lindex $PREFS(SEL_FILES) 0]
  if {$item != ""} {
    regsub {,v$} [file tail $item] {} tf
    set item "${tf},v"
    if {([file isdirectory ${rcs_path}]) && ([file exists ${rcs_path}/${item}]) } {
      set rcs_file ${rcs_path}/${item}
    } else { 
      set rcs_file ${item}
    }
    setMsgArea "Rlog of: $item " 7000
    catch {exec $PREFS(RCS_BIN)/rlog ${rcs_file} } PREFS(DATA)
    browseFile "Rlog of $item"
  }
}


proc diffRcsFilesSelected { } {
# Cycle through all selected  files and perform "tkdiff" on each against 
# the RCS repository. 
#
  global PREFS env

  if { [file isdirectory [lindex $PREFS(SEL_FILES) 0]] } { 
     return
  }

  set old_path [pwd]

  set endpart [getEndpart]
  if { [file exists $PREFS(DEVELOPMENT_DIR)/${endpart}] } {
    cd $PREFS(DEVELOPMENT_DIR)/${endpart}
  }
  if { [file exists [pwd]/RCS] } {
    set rcs_path [pwd]/RCS
  } else {
    set rcs_path $env(RCSROOT)/${endpart}
  }
  if {[file exists $rcs_path] == 0 } {
     set rcs_path [pwd] 
  }

  foreach item $PREFS(SEL_FILES) {
    set PREFS(SKIP) -1
    regsub {,v$} [file tail $item] {} tf
    set PREFS(LOCAL_FILE) $tf
    set PREFS(RCS_FILE)   ${rcs_path}/${tf},v
    diffTheRcsFile
  }
  cd $old_path
  refresh
}

proc getFilesSelected { } {
# Get an unlocked copy (latest version) of a file in the RCS repository. 
#
  global PREFS env 

  if { [file isdirectory [lindex $PREFS(SEL_FILES) 0]] } { 
     return
  }

  set rcs_path [pwd] 
  set old_path [pwd]
  
  set endpart [getEndpart]
  if { [string first $env(RCSROOT) $rcs_path ] >= 0} {
    if {[file exists $PREFS(DEVELOPMENT_DIR)/${endpart}] == 0 } {
      file mkdir $PREFS(DEVELOPMENT_DIR)/${endpart}
      #      catch { exec /bin/mkdir -p $PREFS(DEVELOPMENT_DIR)/${endpart}} msg
    }
    cd $PREFS(DEVELOPMENT_DIR)/${endpart}
  } else {
    set rcs_path $env(RCSROOT)/${endpart}
    if {[file exists $rcs_path] == 0 } {
       set rcs_path . 
    }
  }

  foreach item $PREFS(SEL_FILES) {
    set PREFS(SKIP) -1
    regsub {,v$} [file tail $item] {} tf
    set PREFS(LOCAL_FILE) $tf 
    set PREFS(RCS_FILE)   ${rcs_path}/$item  
    if {[file exists $tf]  && [file writable $tf]} {
      mkDialog .msg "-fg $PREFS(TEXTW_FG) -text {Writable File: $tf already exists...\nDo You want to delete? or diff?} -justify left -aspect 600" "Yes {global PREFS;set PREFS(SKIP) 0}" "tkdiff {global PREFS;set PREFS(SKIP) 1; diffTheRcsFile }" " Cancel {global PREFS;set PREFS(SKIP) 1}"
      tkwait variable PREFS(SKIP)
      if { $PREFS(SKIP) == 0 } {
        file delete -force ${tf}
      }
    } else {
      set PREFS(SKIP) 0
    }
    if { $PREFS(SKIP) == 0 } {
      setMsgArea "RCS get: $item " 7000
      if { $PREFS(RCS_BASE_VER) != "" } {
        catch {exec $PREFS(RCS_BIN)/co -r$PREFS(RCS_BASE_VER) ${rcs_path}/$item} msg
        if { [string first "done" $msg] <= 0 } { 
          mkDialog .msg "-fg $PREFS(TEXTW_FG) -text {Get of: $tf failed for the following reason:\n$msg.} -justify left -aspect 600" "OK {}"
          cd $old_path
          return
        }
        catch {exec $PREFS(RCS_BIN)/co -r$PREFS(RCS_BASE_VER) ${rcs_path}/$item} msg
      } else {
        catch {exec $PREFS(RCS_BIN)/co ${rcs_path}/$item} msg
      }
      puts $msg
    }
  }
  cd $old_path
  refresh
}

proc unlockFilesSelected { } {
# Unlock the latest copy checked-out 
#

  global PREFS env

  if { [file isdirectory [lindex $PREFS(SEL_FILES) 0]] } { 
     return
  }

  set start_dir [pwd] 
  set rcs_path [pwd] 
  set old_path [pwd]

  set endpart [getEndpart]
  if { [string first $env(RCSROOT) $rcs_path ] >= 0} {
    cd $PREFS(DEVELOPMENT_DIR)/${endpart}
  } else {
    set rcs_path $env(RCSROOT)/${endpart}
  }
  if {[file exists $rcs_path] == 0 } {
     set rcs_path . 
  }

  loadRcsInfo
  
  foreach item  $PREFS(SEL_FILES) {
    regsub {,v$} [file tail $item] {} tf
    set item "${tf},v"
    setMsgArea "Unlock: $item " 7000

#      if { $PREFS(RCS_BASE_VER) != "" } {
#        catch {exec $PREFS(RCS_BIN)/rcs -N$PREFS(RCS_BASE_VER) -u ${rcs_path}/${item}} msg
#      } else {
#        catch {exec $PREFS(RCS_BIN)/rcs -u ${rcs_path}/${item}} msg
#      }
      catch {exec $PREFS(RCS_BIN)/rcs -u ${rcs_path}/${item}} msg

    puts $msg
    for {set j 0} {$j < $PREFS(RCS_COUNT)} {incr j} {
      if {$tf == $PREFS(FILE_NAME,$j) } {
        set PREFS(FILE_NAME,$j) ""
        set PREFS(VERSION,$j)   ""
      }
    }
  }
  saveRcsInfo 

  cd $old_path
  refresh
}

proc createCheckinMsg { mode } {    
# Get user's check-in message and issue the check-in commad if "OK" is selected.      
# @param mode : either "checkin" or "create". 
#
  global PREFS

  if { [file isdirectory [lindex $PREFS(SEL_FILES) 0]] } { 
     return
  }

  # build widget .cmsg
  toplevel .cmsg  \
    -background $PREFS(GENRL_BG)

  # Window manager configurations
  wm positionfrom .cmsg ""
  wm sizefrom .cmsg program
  wm resizable .cmsg 0 0
  wm title .cmsg "$mode" 

  setFileSelections

  # build widget .cmsg.frame
  frame .cmsg.frame \
    -relief {raised}

  # build widget .cmsg.frame.scrollbar1
  scrollbar .cmsg.frame.scrollbar1 \
    -activebackground $PREFS(ACTIV_BG) \
    -background $PREFS(GENRL_BG) \
    -troughcolor $PREFS(GENRL_BG) \
    -command {.cmsg.frame.text2 yview} \
    -relief {raised}

  # build widget .cmsg.frame.text2
  text .cmsg.frame.text2 \
    -background $PREFS(TEXTW_BG) \
    -foreground $PREFS(TEXTW_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -height {7} \
    -bd 4 \
    -relief {sunken} \
    -width {60} \
    -wrap {none} \
    -yscrollcommand {.cmsg.frame.scrollbar1 set}

  # build widget .cmsg.frame1
  frame .cmsg.frame1 \
    -background $PREFS(GENRL_BG) \
    -borderwidth {2} \
    -height {30} \
    -relief {raised} \
    -width {30}

  # build widget .cmsg.frame1.button2
if { $mode == "checkin" } {
  set cmd "checkinFilesSelected"
} else {
  set cmd "createFilesSelected"
}
  button .cmsg.frame1.button2 \
    -padx {9} \
    -command $cmd \
    -pady {3} \
    -text {OK}
  # build widget .cmsg.frame1.button3
  button .cmsg.frame1.button3 \
    -padx {9} \
    -command "destroy .cmsg" \
    -pady {3} \
    -text {Cancel}

  # pack master .cmsg.frame
  pack configure .cmsg.frame.scrollbar1 \
    -fill y \
    -side left
  pack configure .cmsg.frame.text2 \
    -expand 1 \
    -fill both

  # pack master .cmsg.frame1
  pack configure .cmsg.frame1.button2 \
    -side left
  pack configure .cmsg.frame1.button3

  # pack master .cmsg
  pack configure .cmsg.frame \
    -fill both
  pack configure .cmsg.frame1

  .cmsg.frame.text2 insert end $PREFS(RCS_MSG) 
  setWindowPos . .cmsg 30 30
}

proc createFilesSelected { } {
# Create new RCS managed file(s)
# @global PREFS(SEL_FILES) : A list of files selected to be created. 
#
  global PREFS env 

  if { [file isdirectory [lindex $PREFS(SEL_FILES) 0]] } { 
     return
  }

  set PREFS(RCS_MSG) [.cmsg.frame.text2 get 1.0 "end -1 char"]

  set rcs_path [pwd] 
  set old_path [pwd] 

  set endpart [getEndpart]
  if { [string first $env(RCSROOT) $rcs_path ] == -1} {
    set rcs_path $env(RCSROOT)/${endpart}
  }
  if {[file exists $rcs_path] == 0 } {
     set rcs_path . 
  }

  set tmp_dir "/var/tmp/[getUid]"
  if {[file exists ${tmp_dir}] <= 0}  {
    file mkdir ${tmp_dir}
  }
  if {[file exists ${tmp_dir}] <= 0}  {
    setErrMsg "Failed to create temporary directory ${tmp_dir}" 7000
    return;
  }
  set tmpf $tmp_dir/ci.[pid]

  set cf [open $tmpf w]
  puts $cf $PREFS(RCS_MSG)
  close $cf
  
  foreach item  $PREFS(SEL_FILES) {
    regsub {,v$} [file tail $item] {} tf
    set item "$tf,v"
    setMsgArea "Checkin: $item " 7000
    if { $PREFS(RCS_BASE_VER) != "" } {
     catch {exec $PREFS(RCS_BIN)/ci -N$PREFS(RCS_BASE_VER) -r1.1 ${rcs_path}/$item $tf < $tmpf} msg
    } else {
      catch {exec $PREFS(RCS_BIN)/ci -r1.1 ${rcs_path}/$item $tf < $tmpf} msg
    }
    puts $msg
    for {set j 0} {$j < $PREFS(RCS_COUNT)} {incr j} {
      if {$tf == $PREFS(FILE_NAME,$j) } {
        set PREFS(FILE_NAME,$j) ""
        set PREFS(VERSION,$j)   ""
      } 
    }
  }
  file delete -force $tmpf

  cd $old_path

  refresh
  destroy .cmsg
}

proc checkinFilesSelected { } {
# Check-in RCS managed files.      
#
  global PREFS env 

  if { [file isdirectory [lindex $PREFS(SEL_FILES) 0]] } { 
     return
  }

  set PREFS(RCS_MSG) [.cmsg.frame.text2 get 1.0 "end -1 char"]

  set old_path [pwd]


  set endpart [getEndpart]
  set rcs_path $env(RCSROOT)/${endpart}

  if {[file exists $rcs_path] == 0 } {
     set rcs_path . 
  }

  set tmp_dir "/var/tmp/[getUid]"
  if {[file exists ${tmp_dir}] <= 0}  {
    file mkdir ${tmp_dir} 
#   catch { exec /bin/mkdir -p ${tmp_dir}} msg
  }
  if {[file exists ${tmp_dir}] <= 0}  {
    setErrMsg "Failed to create temporary directory ${tmp_dir}" 7000
    return;
  }
  set tmpf $tmp_dir/ci.[pid]

  set cf [open $tmpf w]
  puts $cf $PREFS(RCS_MSG)
  close $cf
  
  foreach item $PREFS(SEL_FILES) {
    regsub {,v$} [file tail $item] {} tf
    set item "$tf,v"
    setMsgArea "Checkin: $item " 7000
    if { $PREFS(RCS_BASE_VER) != "" } {
      set state_ver [getStateVersion $tf]
      if { ($state_ver != "") && ($state_ver != $PREFS(RCS_BASE_VER)) } {
        mkDialog .msg "-fg $PREFS(TEXTW_FG) -text {File: $tf was checkout with version: $state_ver\nYour current RCS_BASE_VER is: $PREFS(RCS_BASE_VER)\n Checkin Not Completed...} -justify left -aspect 600" "OK {}"
        return
      }
      catch {exec $PREFS(RCS_BIN)/ci -N$PREFS(RCS_BASE_VER) ${rcs_path}/$item $tf < $tmpf} msg
      puts $msg
    } else {
      catch {exec $PREFS(RCS_BIN)/ci ${rcs_path}/$item $tf < $tmpf} msg
      puts $msg
    }
    puts $msg
    for {set j 0} {$j < $PREFS(RCS_COUNT)} {incr j} {
      if {$tf == $PREFS(FILE_NAME,$j) } {
        set PREFS(FILE_NAME,$j) ""
        set PREFS(VERSION,$j)   ""
      } 
    }
  }
  file delete -force $tmpf

  cd $old_path 

  refresh
  destroy .cmsg
}

proc rcsLockFilesSelected { } {
# Lock RCS managed files without getting a copy from the repository.      
#
  global PREFS env 

  if { [file isdirectory [lindex $PREFS(SEL_FILES) 0]] } { 
     return
  }

  loadRcsInfo

  set rcs_path [pwd] 
  set old_path [pwd]

  set endpart [getEndpart]
  if { [string first $env(RCSROOT) $rcs_path ] >= 0} {
    cd $PREFS(DEVELOPMENT_DIR)/${endpart}
  } else {
    set rcs_path $env(RCSROOT)/${endpart}
  }
  if {[file exists $rcs_path] == 0 } {
     set rcs_path . 
  }

  foreach item $PREFS(SEL_FILES) {
    regsub {,v$} [file tail $item] {} tf
    set PREFS(LOCAL_FILE) $tf 
    set PREFS(RCS_FILE)   ${rcs_path}/$item  
    setMsgArea "RCS Lock: $item " 7000
    catch {exec $PREFS(RCS_BIN)/rcs -l ${rcs_path}/$item} msg
    puts $msg
    set found 0
    for {set j 0} {$j < $PREFS(RCS_COUNT)} {incr j} {
      if {$tf == $PREFS(FILE_NAME,$j) } {
        set found 1
        break
      } 
    }
    if { ($found == 0) && ($tf != "") } {
      set PREFS(FILE_NAME,$PREFS(RCS_COUNT)) $tf
      set PREFS(VERSION,$PREFS(RCS_COUNT))    $PREFS(RCS_BASE_VER)
      incr PREFS(RCS_COUNT)
    }
  }
  saveRcsInfo

  cd $old_path

  refresh
}

proc checkoutFilesSelected { } {
# Check-out RCS managed files  
#
  global PREFS env 

  if { [file isdirectory [lindex $PREFS(SEL_FILES) 0]] } { 
     return
  }
  loadRcsInfo

  set rcs_path [pwd] 
  set old_path [pwd]

  set endpart [getEndpart]
  if { [string first $env(RCSROOT) $rcs_path ] >= 0} {
    file mkdir $PREFS(DEVELOPMENT_DIR)/${endpart}
    cd $PREFS(DEVELOPMENT_DIR)/${endpart}
  } else {
    set rcs_path $env(RCSROOT)/${endpart}
  }
  if {[file exists $rcs_path] == 0 } {
     set rcs_path . 
  }

  foreach item  $PREFS(SEL_FILES) {
    set PREFS(SKIP) -1
    regsub {,v$} [file tail $item] {} tf
    set PREFS(LOCAL_FILE) $tf 
    set PREFS(RCS_FILE)   ${rcs_path}/$item  
    if {[file exists $tf]  && [file writable $tf]} {
      mkDialog .msg "-fg $PREFS(TEXTW_FG) -text {Writable File: $tf already exists...\nDo You want to delete? or diff?} -justify left -aspect 600" "Yes {global PREFS;set PREFS(SKIP) 0}" "tkdiff {global PREFS;set PREFS(SKIP) 1; diffTheRcsFile}" "Cancel {global PREFS;set PREFS(SKIP) 1}"
      tkwait variable PREFS(SKIP)
      if { $PREFS(SKIP) == 0 } {
        file delete -force ${tf}
      }
    } else {
      set PREFS(SKIP) 0
    }
    if { $PREFS(SKIP) == 0 } {
      setMsgArea "Checkout: $item " 7000
      if { $PREFS(RCS_BASE_VER) != "" } {
        catch {exec $PREFS(RCS_BIN)/co -l$PREFS(RCS_BASE_VER) ${rcs_path}/$item} msg
        if { [string first "locked" $msg] <= 0 } { 
          mkDialog .msg "-fg $PREFS(TEXTW_FG) -text {Checkout of: $tf failed for the following reason:\n$msg.} -justify left -aspect 600" "OK {}"
          cd $old_path
          return
        }
      } else {
        catch {exec $PREFS(RCS_BIN)/co -l ${rcs_path}/$item} msg
      }
      puts $msg
      set found 0
      for {set j 0} {$j < $PREFS(RCS_COUNT)} {incr j} {
        if {$tf == $PREFS(FILE_NAME,$j) } {
          set found 1
          break
        } 
      }
      if { ($found == 0) && ($tf != "") } {
        set PREFS(FILE_NAME,$PREFS(RCS_COUNT)) $tf
        set PREFS(VERSION,$PREFS(RCS_COUNT))   $PREFS(RCS_BASE_VER) 
        incr PREFS(RCS_COUNT)
      }
    }
  }
  saveRcsInfo
  cd $old_path
  refresh
}

proc clearMsgArea { } {
# Clear out message area 
#
   global PREFS
   set PREFS(MSG) ""
   .bf.labq configure -foreground $PREFS(GENRL_FG) 
   .bf.labq configure -text $PREFS(MSG) 
}

proc setMsgArea {msg time} {
# Set a message 
#
   global PREFS 
   set PREFS(MSG) $msg
   .bf.labq configure -text $msg 
   if { $time } {
     after $time clearMsgArea
   }
}

proc setErrMsg {msg time} {
# Set an error message 
#
   global PREFS
   set PREFS(MSG) $msg
   .bf.labq configure -foreground {#ff0000} 
   .bf.labq configure -text $msg 
   after 300  .bf.labq configure -foreground $PREFS(GENRL_BG)
   after 600  .bf.labq configure -foreground {#ff0000}
   after 900  .bf.labq configure -foreground $PREFS(GENRL_BG)
   after 1200 .bf.labq configure -foreground {#ff0000}
   bell;after 200 bell
   after $time clearMsgArea
}

proc diffFilesSelected { num } {
# Procedure to display differences between two text files.  
# @param num : Index count for wich file has been selected.    
#
  global PREFS tcl_platform
  setFileSelections

#  if { [file isdirectory [lindex $PREFS(SEL_FILES) 0]] } { 
#    return
#  } 

  set diff_cmd ""
  set num_cmd -1 

  for {set i 0} {$i < $PREFS(OPT_COUNT)} {incr i} {
    if { [string first "diff" $PREFS(_N${i})] >= 0} {
      set diff_cmd $PREFS(_X${i})
      set num_cmd $i
      break;
    }
  }
  if {$diff_cmd == "" } {
    return
  }

  set item [lindex $PREFS(SEL_FILES) 0]
  if {$item != "" } { 
    if {$num == 1} {
      if {[file isdirectory $item]} {
        set PREFS(MSG) "Diff->Directory-1: $item" 
      } else {
        set PREFS(MSG) "Diff->File-1: $item" 
      }
      set PREFS(DIFF) [pwd]/$item
      setMsgArea $PREFS(MSG) 7000 
    } else {
      if {$PREFS(DIFF) == ""} {
        setErrMsg "Diff1: Not Specified... Please select Diff1 first." 6000
        return
      } elseif {[file isdirectory $PREFS(DIFF)]} {
        if {[file isdirectory $item] == 0} {
          set PREFS(DIFF) ""
          setErrMsg  "File 1: $PREFS(DIFF)  is a Directory...  File 2: $item is NOT a Directory!" 6000
          return
        } 
        if {![string compare "unix" $tcl_platform(platform)]} {
          set PREFS(MSG) "$PREFS(MSG) -vs- Directory-2: $item "
          set cmd "diff+$PREFS(DIFF)+$item"
          runCmd ${cmd} 1 -1 
        }
      } else {
        if {[file isdirectory $item]} {
          set PREFS(DIFF) ""
          setErrMsg "File-1: $PREFS(DIFF) is NOT a Directory...  File-2: $item is a Directory!" 6000 
          return
        }
        set PREFS(MSG) "$PREFS(MSG) -vs- File-2: $item "
        set cmd "$diff_cmd+$PREFS(DIFF)+$item+&"
        runCmd ${cmd} 1 $num_cmd
      }
      setMsgArea $PREFS(MSG) 7000 
      set PREFS(DIFF) ""
      set PREFS(MSG)  ""
    }
  }
}

proc rmFiles { } {
# Remove files and directories 
#
  global PREFS 

  set count 0

  foreach item $PREFS(SEL_FILES) {
    set type [identifyFile $item] 
    setMsgArea "Removing: $item " 7000

    file delete -force -- $item

    set count 1

    if { ($type == ".gif") || \
         ($type == ".ppm") || \
         ($type == ".pgm") || \
         ($type == ".xbm") } {
      if { [winfo exists .$PREFS(PIC_COUNT)] == 1 } {
        destroy .$PREFS(PIC_COUNT)
      }
    }
    if { [winfo exists .brow] == 1 } {
      destroy .brow
    }
  }
  if {$count} {
     refresh
  }
}

proc doIt { type } {
#  Pop-up dialog to get arguments for chmod, and mkdir, RCSROOT, etc.  
#
  global PREFS env

  set title "$type Options"

  if {[info exists PREFS(doit_${type})] == 0} {
    set PREFS(doit_${type})  ""
  }

  set lname "Parameters"
  if { $type == "RCSROOT" } {
    set PREFS(DOIT) $env(RCSROOT) 
    set cmd_name setRCSROOT
    set lname { RCSROOT = }
  } elseif { $type == "compress" } {
    set PREFS(DOIT) $PREFS(TAR_FILE_NAME)
    set lname { Tar File Name = }
    set cmd_name "taritMultiple compress"
  } elseif { $type == "gzip" } {
    set PREFS(DOIT) $PREFS(TAR_FILE_NAME)
    set lname { Tar File Name = }
    set cmd_name "taritMultiple gzip"
  } else {
    set PREFS(DOIT) $PREFS(${type}) 
    set cmd_name cmd${type}
    set lname "$type ="
  }

  set w .doit
  catch {destroy $w}				
  toplevel $w -class Dialog  \
              -background $PREFS(GENRL_BG) \
              -highlightcolor {#ffffffffffff}
  wm title $w $title 

  label $w.lab -text $title \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -foreground $PREFS(GENRL_FG) \
     -background $PREFS(GENRL_BG)

  pack $w.lab \
     -side top \
     -expand 1 -ipady 10

  frame $w.top -background $PREFS(GENRL_BG)

  label $w.top.l -text $lname \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -foreground $PREFS(GENRL_FG) \
     -background $PREFS(GENRL_BG)

  entry $w.top.e  -width 40 \
    -background $PREFS(ENTRY_BG) \
    -foreground $PREFS(ENTRY_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -textvariable PREFS(DOIT) \
    -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} 
  bind $w.top.e <Return> "$cmd_name; destroy $w"
  pack $w.top.l $w.top.e \
     -side left \
     -expand true \
     -fill x
  pack $w.top \
     -expand true \
     -fill x \
     -ipady 10

  frame $w.bot
  button $w.bot.ok -text "OK" \
     -foreground $PREFS(GENRL_FG) \
     -background $PREFS(GENRL_BG) \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -command  "$cmd_name; destroy $w" 
  button $w.bot.can -text "Cancel" \
     -foreground $PREFS(GENRL_FG) \
     -background $PREFS(GENRL_BG) \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -command  "destroy $w" 

  pack $w.bot.ok $w.bot.can \
      -side left -expand true -fill x
  pack $w.bot -expand true \
      -fill x

  setWindowPos . $w 30 30
  wm focusmodel $w active  
  focus $w.top.e 
}

proc doitCmd {num mode} {
#  Parse the output from the doit_test pop-up dialog,
#       combine static user defined commands and call runCmd.    
# @param mode : = 1, Run a command from the options pop-up menu.
# <p>           = 0, Run a file-associated command.</p> 
# @param num : Index number for command to run.   
#
  global  PREFS

  set type $PREFS(_N${num})
  set PREFS(doit_${type}) $PREFS(DOIT)
  set uip "$PREFS(DOIT)" 
  set cmd $PREFS(_X${num})
   
  if {[llength $PREFS(SEL_FILES)] > 0} {
    set file_name [lindex $PREFS(SEL_FILES) 0]
    set froot [file rootname $file_name]
    if {[regsub -all {#_FILE_#}  $cmd $file_name    cmd]} {
      regsub    -all {#_FROOT_#} $cmd $froot        cmd
      regsub    -all {#_PWD_#}   $cmd [pwd]         cmd
    } elseif {[regsub -all {#_FROOT_#} $cmd $froot  cmd]} {
      regsub    -all {#_PWD_#}   $cmd  [pwd]        cmd
      } elseif {[regsub -all {#_PWD_#} $cmd [pwd]   cmd]} {
    } else {
      regsub -all {#_FILE_#}  $cmd {} cmd
      regsub -all {#_FROOT_#} $cmd {} cmd
      regsub -all {#_PWD_#}   $cmd {} cmd
    }
  }

  if {[winfo exists .doit_opt] } {
    .doit_opt configure -cursor watch
    .doit_opt.top.e configure -cursor watch
    .doit_opt.bot.ok configure -cursor watch 
    update idletasks
  }

  regsub -all { } $uip {+} uip
  regsub {#_UIP_#} $cmd $uip cmd
  runCmd ${cmd} $mode $num
}

proc doItOptions {num mode} {
# This pop-up dialog appears when User Input Parameters #_UIP_#
# is in the command string PREFS(_X).    
# @param num : Index number for command to run.   
# @param mode : = 1, Run a command from the options pop-up menu.
# <p>           = 0, Run a file-associated command.</p> 
# @global PREFS(_X$num) : Command to run. 
#

  global PREFS

  setFileSelections

  if { $mode } {
    set type $PREFS(_N${num})
  } else {
    regsub {.} $PREFS(_E${num}) {} type 
    if { $type == ""} {
       set type "Args"
    }
  } 
 
  set w .doit_opt
  catch {destroy $w}
  toplevel $w -class Dialog  \
              -background $PREFS(GENRL_BG) \
              -highlightcolor {#ffffffffffff}


  set title "$type Options"

  if {[info exists PREFS(doit_${type})] == 0} {
    set PREFS(doit_${type})  ""
  }

  set lname "Parameters"
  set PREFS(DOIT) $PREFS(doit_${type})
  set lname "${type}: "

  wm title $w $title 
  label $w.lab -text $title \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -foreground $PREFS(GENRL_FG) \
     -background $PREFS(GENRL_BG)

  pack $w.lab \
     -side top \
     -expand 1 -ipady 10

  frame $w.top -background $PREFS(GENRL_BG)

  label $w.top.l -text $lname \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -foreground $PREFS(GENRL_FG) \
     -background $PREFS(GENRL_BG)

  entry $w.top.e  -width 40 \
    -background $PREFS(ENTRY_BG) \
    -foreground $PREFS(ENTRY_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -textvariable PREFS(DOIT) \
    -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} 
  bind $w.top.e <Return> "doitCmd $num $mode; destroy $w"
  pack $w.top.l $w.top.e \
     -side left \
     -expand true \
     -fill x
  pack $w.top \
     -expand true \
     -fill x \
     -ipady 10

  frame $w.bot
  button $w.bot.ok -text "OK" \
     -foreground $PREFS(GENRL_FG) \
     -background $PREFS(GENRL_BG) \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -command  "doitCmd $num $mode; destroy $w" 
  button $w.bot.can -text "Cancel" \
     -foreground $PREFS(GENRL_FG) \
     -background $PREFS(GENRL_BG) \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -command  "destroy $w" 

  pack $w.bot.ok $w.bot.can \
      -side left -expand true -fill x
  pack $w.bot -expand true \
      -fill x

  setWindowPos . $w 30 30
  wm focusmodel $w active  
  focus $w.top.e 
}


proc getScreenShot {} {
# (unix-only) runs xwd command. 
#
  global PREFS
  if {[file extension $PREFS(SNAPSHOT)] != ".xwd" } {
    catch {exec xwd -nobdrs -out $PREFS(SNAPSHOT).xwd} 
  } else { 
    catch {exec xwd -nobdrs -out $PREFS(SNAPSHOT)} 
  }
  if { [winfo exists .snap_shot] == 1 } {
    destroy .snap_shot
  }
  refresh
}


proc snapShot {} {
# (unix-only) Pop-up dialog to get the name of the xwd 
# file, waits 5 seconds and runs getScreenShot. 
#
  global PREFS

  if {[findWhich xwd] == "" } {
    setErrMsg "xwd not in your path... You can use Conf->Environment Variables to set it." 6000
    return
  }
  set w .snap_shot
  catch {destroy $w}
  toplevel $w -class Dialog  \
              -background $PREFS(GENRL_BG)  \
              -highlightcolor {#ffffffffffff}
  wm title $w "Snap Shot"
  wm iconname $w "Snap Shot"

  global PREFS

  label $w.lab -text "XWD Window Capture" \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -background $PREFS(GENRL_BG)
  label $w.lab2 \
-text "After the 'OK', a 5 second delay will allow time to arrange the" \
     -font {-*-Courier-Bold-R-Normal--*-140-*-*-*-*-*-*} \
     -background $PREFS(GENRL_BG)
  label $w.lab3 \
-text "target window into position. The the cursor will chage to a '+'. Click" \
     -font {-*-Courier-Bold-R-Normal--*-140-*-*-*-*-*-*} \
     -background $PREFS(GENRL_BG)
  label $w.lab4 \
-text "the left mouse button to capture. A 'BEEP' indicates that it is done." \
     -font {-*-Courier-Bold-R-Normal--*-140-*-*-*-*-*-*} \
     -background $PREFS(GENRL_BG)
  pack $w.lab \
     -side top \
     -expand 1 -ipady 10
  pack $w.lab2 -side top  -expand 1 
  pack $w.lab3 -side top  -expand 1 
  pack $w.lab4 -side top  -expand 1 
  frame $w.top -background $PREFS(GENRL_BG)
  label $w.top.l -text "File Name: " \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -background $PREFS(GENRL_BG)
  entry $w.top.e  -width 40 \
    -background $PREFS(ENTRY_BG) \
    -foreground $PREFS(ENTRY_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -textvariable PREFS(SNAPSHOT) \
    -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*}

  pack $w.top.l $w.top.e \
     -side left \
     -expand true \
     -fill x
  pack $w.top \
     -expand true \
     -fill x \
     -ipady 10

  frame $w.bot
  button $w.bot.ok -text "OK" \
     -background $PREFS(GENRL_BG) \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -command  "after 5000 getScreenShot" 
  button $w.bot.can -text "Cancel" \
     -background $PREFS(GENRL_BG) \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -command  "destroy $w"

  pack $w.bot.ok $w.bot.can \
      -side left -expand true -fill x
  pack $w.bot -expand true \
      -fill x

  setWindowPos . $w 30 30
}

proc renameFile {} {
# Pop-up dialog to get new file name for file rename.   
# It also checks to prevent rename - that will delete an existing file.
#
  global PREFS
  setFileSelections
  set PREFS(WORKING_FILE)  [lindex $PREFS(SEL_FILES) 0]

  set w .rename_file
  catch {destroy $w}
  toplevel $w -class Dialog  \
              -background $PREFS(GENRL_BG)  \
              -highlightcolor {#ffffffffffff}
  wm title $w "Rename-File"
  wm iconname $w "Rename-File"
  label $w.lab -text "Rename File" \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -background $PREFS(GENRL_BG)
  pack $w.lab \
     -side top \
     -expand 1 -ipady 10
  frame $w.top -background $PREFS(GENRL_BG)
  label $w.top.l -text "File Name: " \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -background $PREFS(GENRL_BG)

  entry $w.top.e  -width 40 \
    -background $PREFS(ENTRY_BG) \
    -foreground $PREFS(ENTRY_FG) \
    -selectbackground $PREFS(SELCT_BG) \
    -selectforeground $PREFS(SELCT_FG) \
    -textvariable PREFS(WORKING_FILE) \
    -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*}

  bind $w.top.e <Return> {
   renameTheFile .rename_file
  }
  pack $w.top.l $w.top.e \
     -side left \
     -expand true \
     -fill x
  pack $w.top \
     -expand true \
     -fill x \
     -ipady 10

  frame $w.bot
  button $w.bot.ok -text "OK" \
     -background $PREFS(GENRL_BG) \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -command  "renameTheFile $w "
  button $w.bot.can -text "Cancel" \
     -background $PREFS(GENRL_BG) \
     -font {-*-Courier-Bold-R-Normal--*-180-*-*-*-*-*-*} \
     -command  { destroy .rename_file }

  pack $w.bot.ok $w.bot.can \
      -side left -expand true -fill x
  pack $w.bot -expand true \
      -fill x

  setWindowPos . $w 30 30
  focus $w
}

proc renameTheFile {w} {
# Procedure to rename a file.   
# @param w : re-name widget to delete when finished.
#
  global PREFS
  if {[llength $PREFS(SEL_FILES)] > 0} {
    set old_file [lindex $PREFS(SEL_FILES) 0]
  } else {
    return
  }
  if { [file exists $PREFS(WORKING_FILE)] == 1 } {
    setErrMsg "File: $PREFS(WORKING_FILE) already exists...Please try a new name." 6000
  } else {
     file rename -force -- $old_file $PREFS(WORKING_FILE)
     refresh
     destroy $w 
  }
}

proc  cmdCHMOD {} {
# (unix-only) procedure to change file permissions.   
#
  global PREFS
  set PREFS(CHMOD) $PREFS(DOIT) 
  if { [string length $PREFS(CHMOD)] > 0 } {
    foreach item  $PREFS(SEL_FILES) {
      catch {exec [findWhich chmod]/chmod $PREFS(CHMOD) $item} msg 
    }
  }
}

proc  cmdMKDIR {} {
#  Uses the tcl <b>file</b> command to make a new directory.   
#
  global PREFS
  set PREFS(MKDIR) $PREFS(DOIT)
  if { [string length $PREFS(MKDIR)] > 0 } {
    file mkdir $PREFS(MKDIR)
  }
  refresh
}

proc  cmdRCS_BASE_VER {} {
#  Sets RCS_BASE_VER variable and saves current state.    
#
  global PREFS
  set PREFS(RCS_BASE_VER) $PREFS(DOIT)
  writeInfo
}

proc  cmdDEVELOPMENT_DIR {} {
#  Sets DEVELOPMENT_DIR variable and saves current state.    
#
  global PREFS
  set PREFS(DEVELOPMENT_DIR) $PREFS(DOIT)
  writeInfo
}

proc  cmdBUILD_DIR {} {
#  Sets BUILD_DIR variable and saves current state.    
#
  global PREFS
  set PREFS(BUILD_DIR) $PREFS(DOIT)
  writeInfo
}

proc  setRCSROOT {} {
#  Sets RCSROOT variable and saves current state.    
#
  global PREFS env 
  set env(RCSROOT) $PREFS(DOIT)
  set count 0
  set found 0
  foreach item $PREFS(ENV) {
    set words [split $item "="] 
    if { [lindex $words 0] == "RCSROOT" } { 
      set tmp [lreplace $PREFS(ENV) $count $count "RCSROOT=$env(RCSROOT)" ]
      set PREFS(ENV) $tmp
       set found 1
       break;
     }
     incr count
   }
   if { $found == 0 } {
     lappend PREFS(ENV) "RCSROOT=$env(RCSROOT)"
   }
  writeInfo
}
  
proc copyTheFile {mode} {
#  Saves items selected from the listbox for a later "paste" operation.    
#  @param mode : 0 = cut, 1 = copy.
#  @global PREFS(COPY_PASTE) : Array of file names selected. 
#  @global PREFS(CUT_COPY)   : 0 = cut, 1 = copy. 
#
  global PREFS
  set PREFS(CUT_COPY) $mode

  set PREFS(COPY_PASTE) ""
  if {$mode } {
    set PREFS(MSG) "Copy:"
  } else {
    set PREFS(MSG) "Cut:"
  }

  foreach item  $PREFS(SEL_FILES) {
    set PREFS(MSG) "$PREFS(MSG) $item" 
    lappend PREFS(COPY_PASTE) [pwd]/$item
  }
  setMsgArea $PREFS(MSG) 0
}

proc duplicateFiles { } {
  global PREFS

  setFileSelections 

  foreach file $PREFS(SEL_FILES) {
    set fext   [file extension $file]
    set froot  [file rootname $file]
    set fc     0
    set ftarget ""
    while { 1 } {
      if { $fext != "" } {
        set ftarget ${froot}_${fc}${fext}
      } else {
        set ftarget ${froot}_${fc}
      }
      if { [file exists $ftarget] == 0} {
         break;
      }
      incr fc;
    }
    if {$ftarget != ""} {
      file copy -force $file $ftarget
    }
  }
  refresh
}

proc browseSelectedFile { } {
  global PREFS
  setFileSelections
  if {[llength $PREFS(SEL_FILES)] == 0 } {
     return
  }  
  browseFile [lindex $PREFS(SEL_FILES) 0]
}

proc pasteTheFile { } {
# "move" or "copy" files saved in the copy or cut sequence.   
#  Uses the tcl <b>file</b> command to "copy" or "rename".  
#
  global PREFS
  set target [pwd] 

  if {([file isdirectory [lindex $PREFS(SEL_FILES) 0]]) && ($PREFS(SEL_FILES) != "..") } { 
    set target [lindex $PREFS(SEL_FILES) 0] 
  }
  .main configure -cursor          watch
  update idletasks 
  set PREFS(SKIP) 0
  foreach source  $PREFS(COPY_PASTE) {
    set tf [file tail $source]
    if { $source == "${target}/${tf}"} {
      set PREFS(SKIP) 1
      setErrMsg "Files NOT Copied - Source and Target Files are the same!" 6000 
    }
    if { $PREFS(SKIP) == 0 } {
      if {[file exists $target/$tf] } {
        set date [file mtime $source]
        set date1 [getDate $date]
        set date [file mtime $target/$tf]
        set date2 [getDate $date]

        mkDialog .msg "-fg $PREFS(TEXTW_FG) -text {File: $target/$tf already exists...\n\nDo You want to replace?\nTarget File: $target/$tf\n       Size: [file size $target/$tf]\n   Modified: $date2\n\nWith this one:\nSource File: $source\n       Size: [file size $source]\n   Modified: $date1} -justify left -aspect 600" "Replace {global PREFS;set PREFS(SKIP) 0}" "Replace-ALL {global PREFS;set PREFS(SKIP) -999}" "No {global PREFS;set PREFS(SKIP) 1}" "Cancel {global PREFS;set PREFS(SKIP) -1}"
        tkwait variable PREFS(SKIP)
#
# Cancel if SKIP = -1
#
        if { $PREFS(SKIP) == -1 } { 
          set PREFS(SKIP) 0
          .main configure -cursor          left_ptr
          return
        } 
      }
    }
    if { $PREFS(SKIP) <= 0 } { 
      if {$PREFS(CUT_COPY) == 1} {
        file copy   -force -- $source $target
      } else {
        file rename -force -- $source $target
      }
    } else {
      set PREFS(SKIP) 0
    }
  }
  .main configure -cursor          left_ptr
  set PREFS(SKIP) 0
  set PREFS(COPY_PASTE) ""
  after 6000 clearMsgArea
  refresh
}

proc setSortMode {mode} {
#  Set file sort method.    
#  @param mode : dm = file date max-> min.
#<p>             dn = file date min-> max.</p>
#<p>             fm = file name max-> min.</p>
#<p>             fn = file name min-> max.</p>
#<p>             sm = file size max-> min.</p>
#<p>             sn = file size min-> max.</p>
#
  global PREFS
  set PREFS(SORT_MODE)  $mode
  refresh
}

proc setWindowPos { parent child xoff yoff} {
#  Calculate a toplevel's window's relative position to its 
#  parent or some other window.
#  @param parent : parent widget (base coordinates). 
#  @param  child : child widget (new coordinates).    
#  @param   xoff : x -coordinate offset from the parent.
#  @param   yoff : y -coordinate offset from the parent.
#<p>
#              e.g. Place new toplevel .foo on top of the main 
#                   window '.' offset 30 pixels in x and y.
#
#               . .foo 30 30     
#</p>
#
  set geo [split [winfo geometry $parent] +]
  set hw  [split [winfo geometry $parent] x]
  set hh  [split [lindex $hw 1 ] +]
  set pw [lindex $hw 0]
  set ph [lindex $hh 0]
  update idletasks

  if { ($xoff == 0) && ($yoff == 0) } {
    set hw  [split [winfo geometry $child] x]
    set hh  [split [lindex $hw 1 ] +]
    set cw [lindex $hw 0]
    set ch [lindex $hh 0]
    set xpos [expr [lindex $geo 1] + $pw/2 - $cw/2]
    set ypos [expr [lindex $geo 2] + $ph/2 - $ch/2]
  } else {
    set xpos [expr [lindex $geo 1] + $xoff]
    set ypos [expr [lindex $geo 2] + $yoff]
  }
  set geo [split [winfo geometry $child] +]
  set wgeo "[lindex $geo 0]+$xpos+$ypos"
  wm geometry $child $wgeo
}

proc showImage { filename} {
# Create a button and display an image on it.   
# @param filename : .gif,.ppm,.xbm,or .ppm file to be displayed.
#

    global PREFS

    set type [identifyFile $filename]

    set PREFS(PIC_COUNT) [expr $PREFS(PIC_COUNT)+1]

    if {$PREFS(PIC_COUNT) > 1000 } {
       set PREFS(PIC_COUNT) 1
    }

    if { $type == ".xbm" }  {
      image create bitmap $PREFS(PIC_COUNT).im  -file $filename
    } else {
      image create photo $PREFS(PIC_COUNT).im  -file $filename
    }

    toplevel .$PREFS(PIC_COUNT)
    button .$PREFS(PIC_COUNT).im  \
           -image $PREFS(PIC_COUNT).im  \
           -command "image delete $PREFS(PIC_COUNT).im;destroy .$PREFS(PIC_COUNT)"

    pack .$PREFS(PIC_COUNT).im
#
    wm title .$PREFS(PIC_COUNT) $filename
    set geom [split [winfo geometry .] +]
    set size [split $geom x]
    set x2 [expr ( [lindex $size 0] / 2)  ] 
    set x [expr [lindex $geom 1] + $x2 ]
    set y [expr [lindex $geom 2] + 50]
    wm geometry .$PREFS(PIC_COUNT) +$x+$y
}

proc shrinkImage { im width height} {
# Make thumbnail images out of the originals.  
# @param im : Original image.
# @param width : Width of original image. 
# @param height : Height of original image. 
#
  set w [image width $im]
  set h [image height $im]

  if { ($h > $height) || ($w > $width) } { 
    set iw [expr ($w * $height)/$h]
    set ih [expr ($h * $width)/$w]

    if { $iw <= 0 } {
       set iw 10 
    } elseif { $iw >= $width } {
       set iw $width
    } 

    if { $ih <= 0} {
       set ih  10
    } elseif { $ih >= $height } {
       set ih $height
    }
  } else {
    set iw $w
    set ih $h
  }

  image create photo $im.small  -format gif  -width $iw -height $ih

  set samp_x [expr $w/$iw]
  set samp_y [expr $h/$ih]

  $im.small copy $im  -subsample $samp_x $samp_y  -to 0 0 $iw $ih

  return $im.small
}


# ----------------------------------------------------------------
# Initialize global array and start program.  
# ----------------------------------------------------------------

global PREFS
global env

#
# Development defaults
#
set PREFS(RCS_BASE_VER)    v1_0
set PREFS(DEVELOPMENT_DIR) [pwd]
set PREFS(BUILD_DIR)       [pwd]

if {[checkEnv RCSROOT] == 0} {
    set env(RCSROOT) [pwd]
}
#
# General stuff
#
set PREFS(DIFF)            "" 
set PREFS(COPY_PASTE)      "" 
set PREFS(CUT_COPY)        "" 
set PREFS(BASE_TEXT_W_SIZE) 0 
set PREFS(LINE_NUMBERS)    "" 
set PREFS(NUM_LINES)       24 
set PREFS(LINE_INDEX)      0
set PREFS(SEARCH_MODE)     "" 
set PREFS(LINE_NO)         0
set PREFS(COL_NO)          0
#
set PREFS(CINF)  [list "General        Foreground:GENRL_FG:#000000"\
                       "General        Background:GENRL_BG:#cbcbcb"\
                       "Active         Foreground:ACTIV_FG:#ff0000"\
                       "Active         Background:ACTIV_BG:#ffff00"\
                       "Text           Foreground:TEXTW_FG:#000000"\
                       "Text           Background:TEXTW_BG:#ffffff"\
                       "RCS Button     Foreground:RCSBU_FG:#000000"\
                       "RCS Button     background:RCSBU_BG:#ffcece"\
                       "Special Button Foreground:SPCBU_FG:#fe0000"\
                       "Special Button background:SPCBU_BG:#00cee3"\
                       "Entry          Foreground:ENTRY_FG:#000000"\
                       "Entry          Background:ENTRY_BG:#ffffff"\
                       "List Box       Foreground:LSTBX_FG:#000000"\
                       "List Box       Background:LSTBX_BG:#ffffff"\
                       "Select         Foreground:SELCT_FG:#ff0000"\
                       "Select         Background:SELCT_BG:#ffff00"]

foreach name $PREFS(CINF) {
  set words [split $name ":"]
  set PREFS([lindex $words 1])  [lindex $words 2]
}

readInfo

if {![string compare "windows" $tcl_platform(platform)]} {
  regsub -all {\\} $env(HOME) {/} env(HOME)
}

  
if { $PREFS(RCS_BIN) == "" } {
  set PREFS(RCS_BIN)       [findWhich ci]
}
#
set PREFS(MSG)           ""
set PREFS(CUR_DIR)       ""
set PREFS(D_VIEW_POS)    0
set PREFS(DIR_FIND)      ""
set PREFS(DELETE)        0
set PREFS(CHMOD)         {ug+rw}
set PREFS(MKDIR)         "" 
set PREFS(DU_TOGGLE)     0
set PREFS(DU_OPP)        "du"
set PREFS(FILE_FIND)     "" 
set PREFS(FT_H)          30 
set PREFS(FT_W)          650 
set PREFS(HELP_COUNT)    0
set PREFS(IM_COUNT)      0
set PREFS(MAX_SIZE)      1000000 
set PREFS(OLD_DIR)       ""
set PREFS(OPT_H)         30 
set PREFS(OPT_W)         850 
set PREFS(PIC_COUNT)     0
set PREFS(RCS_COUNT)     0
set PREFS(RCS_MSG)       ""
set PREFS(RCS_TAG)       ""
set PREFS(SAVE_DIR)      ""
set PREFS(SEL_FILES)     ""
set PREFS(SNAPSHOT)      "untitled"
set PREFS(SORT_MODE)     ""
set PREFS(SYM_TAG)       $PREFS(RCS_BASE_VER) 
set PREFS(TAR_FILE_NAME) ""
set PREFS(TYPES)         "*"
set PREFS(WORKING_FILE)  ""
set PREFS(WORK_DIR)      ""
set PREFS(X_POS)         50
set PREFS(Y_POS)         50

# display/remove toplevel windows.
cftMain
    readDir .main.dir0.f.list   \
     .main.files.file_list  \
     .main.sizes.f.size_list   \
     .main.date.date_list
loadRcsInfo

testOptions
testFileTypes

# eof
#

