# jedit_io.tcl - file access procedures for jedit, a tk-based editor
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

# TO DO
#   problem with filename getting set when you cancel Save 
#     for the first time on a new unnamed file
######################################################################

j:ldb:set_defaults {
  {JEio:...new_file {$filename (new file)}}
  {JEio:...is_directory {`$filename' is a directory.}}
  {JEio:...unreadable {You don't have permission to read `$filename'.}}
}

######################################################################
# "Load..." with supplied filename
######################################################################

proc jedit:read { filename t } {
  global JEDIT_MODEPREFS
  set mode [jedit:get_mode $t]
  j:default JEDIT_MODEPREFS($mode,savestate) 0
  set mode [jedit:get_mode $t]
  
  
  if {[info procs mode:$mode:pre_read_hook] != {}} {
    mode:$mode:pre_read_hook $filename $t
  }
  if {[info procs mode:$mode:read] != {}} {
    mode:$mode:read $filename $t
  } else {
    if {! [file exists $filename]} then {
      jedit:save_checkpoint $t			;# in case you were editing sth
      j:text:delete $t 1.0 end
      j:text:move $t 1.0
      #########################################	;# THIS ISN'T WORKING:
      jedit:set_label [jedit:text_to_top $t] [j:ldb JEio:...new_file]
      #########################################
    } else {
      if [file isdirectory $filename] {
        j:alert -text JEio:...is_directory
        return 1
      }
      if { ! [file readable $filename]} {
        j:alert -text JEio:...unreadable
        return 1
      }
      jedit:save_checkpoint $t			;# so you can undo a load
      # should do error checking
      j:text:delete $t 1.0 end
      $t insert end  [j:fileio:read $filename]
      j:text:move $t 1.0
      #
      if $JEDIT_MODEPREFS($mode,savestate) {
        jedit:read_annotation $filename $t
        jedit:yview_insert $t
      }
      jedit:save_checkpoint $t			;# alows undo to original state
    }
  }
  jedit:set_label [jedit:text_to_top $t]	;# display name over text field
  if {[info procs mode:$mode:post_read_hook] != {}} {
    mode:$mode:post_read_hook $filename $t
  }
}

######################################################################
# write out a file
######################################################################

proc jedit:write { filename t } {
  global JEDIT_MODEPREFS
  set mode [jedit:get_mode $t]
  if {! [info exists JEDIT_MODEPREFS($mode,savestate)]} {
    set JEDIT_MODEPREFS($mode,savestate) 0
  }
  set mode [jedit:get_mode $t]
  
  if {[info procs mode:$mode:pre_write_hook] != {}} {
    mode:$mode:pre_write_hook $filename $t
  }
  if {[info procs mode:$mode:write] != {}} {
    mode:$mode:write $filename $t
  } else {
    # should do error checking
    j:fileio:write $filename [$t get 1.0 end-1c]
    jedit:set_label [jedit:text_to_top $t]
    #
    if $JEDIT_MODEPREFS($mode,savestate) {
      jedit:write_annotation $filename $t
    }   
  }
  if {[info procs mode:$mode:post_write_hook] != {}} {
    mode:$mode:post_write_hook $filename $t
  }
}

######################################################################
# write out non-text content of a file
######################################################################

proc jedit:write_annotation { filename t } {
  set dirname [file dirname $filename]
  set tail [file tail $filename]
  set filename "$dirname/.state.$tail"
  # should do error checking
  j:fileio:write $filename [j:tag:get_annotation $t]
}

######################################################################
# restore non-text content of a file
######################################################################

proc jedit:read_annotation { filename t } {
### NEEDS ERROR CHECKING!
  set dirname [file dirname $filename]
  set tail [file tail $filename]
  set filename "$dirname/.state.$tail"
  catch {
    set state [j:fileio:read $filename]
    j:tag:set_annotation $t $state
  }
}





