# jinit.tcl - common application initialisation procedures
#
######################################################################
# Copyright 1992-1998 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# global variables:
#
global J_PREFS env
if {! [info exists J_PREFS(autoposition)]} {set J_PREFS(autoposition) 0}
if {! [info exists J_PREFS(confirm)]} {set J_PREFS(confirm) 1}
#
######################################################################


######################################################################
# j:jstools_init - common initialisation for jstools
######################################################################

proc j:jstools_init { {app jstools} } {
  if {[catch {package require Tk 8.0}]} {
    tkerror {This application requires at least Tk 8.0.}
    exit 1
  }
  
  package require jldb
  
  global J_PREFS			;# user preferences
  
  global JSTOOLS_VERSION
  set JSTOOLS_VERSION {8.0/4.6}
  
  global tk_library
  global env
  
  if {![info exists env(USER)]} {
    if [info exists env(LOGNAME)] {
      set env(USER) $env(LOGNAME)
    } else {
      set env(USER) [file tail $env(HOME)]
    }
  }
  global NAME; set NAME $env(USER)
  global HOME; set HOME $env(HOME)
  
  j:wm_client				;# set client hostname
  j:wm_command				;# set client command string
  
  j:pref:create_global_prefs		;# set up standard global prefs
  j:read_global_prefs			;# read standard jstools preferences
  j:ldb:init jstools			;# read in language database for library
  ::jldb::init jstools			;# read in language database for library
  j:pref:create_global_prefs		;# again with language set (inefficient)
  j:source_config jstoolsrc.tcl		;# read cross-application preferences
  catch {				;# read cross-application X defaults:
    option readfile [glob -nocomplain ~/.tk/jstools.ad] userDefault
  }
  if {"x$app" != "xjstools"} {		;# application-specific initialisation
    j:ldb:init $app			;# read in language database for app
    ::jldb::init $app			;# read in language database for app
    catch {				;# read application-specific X defaults:      option readfile [glob -nocomplain ~/.tk/$app.ad] userDefault
    }
    ###					;# could read preferences here?
  }
  
  # following use users prefs, bindings files:
  j:tb:init Text			;# uses prefs, ~/.tk/textbindings.tcl
  j:eb:init Entry			;# uses prefs, ~/.tk/entrybindings.tcl
  
  j:command:register j:cmd:prompt_tcl {Issue Tcl Command...}
  j:command:register j:cmd:prompt_unix {Issue Unix Command...}
  j:command:register j:cmd:global_pref_panel {Global Preferences...}
  
  j:command:register j:cmd:text_cut {Cut}
  j:command:register j:cmd:text_copy {Copy}
  j:command:register j:cmd:text_paste {Paste}
}


