# jstools.tcl - miscellaneous jstools procedures
#
######################################################################
# Copyright 1992-1998 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# global variables:
#
global J_PREFS env
if {! [info exists J_PREFS(autoposition)]} {set J_PREFS(autoposition) 0}
if {! [info exists J_PREFS(confirm)]} {set J_PREFS(confirm) 1}
#
######################################################################


######################################################################
# j:cmd:prompt_tcl - prompt for a tcl command and execute it
######################################################################

j:command:register j:cmd:prompt_tcl {Issue Tcl Command...}
proc j:cmd:prompt_tcl { w args } {
  # set `w' global variable to `w' local variable:
  uplevel #0 [list set w $w]
  
  j:prompt_tcl
}

######################################################################
# j:cmd:prompt_unix - prompt for a unix command and execute it
######################################################################

j:command:register j:cmd:prompt_unix {Issue Unix Command...}
proc j:cmd:prompt_unix { w args } {
  j:prompt_unix
}

######################################################################
# j:cmd:global_pref_panel - pop up global preferences panel
######################################################################

j:command:register j:cmd:global_pref_panel {Global Preferences...}
proc j:cmd:global_pref_panel { w args } {
  j:global_pref_panel
}
