# jtclutils.tcl - general utilities that don't require Tk
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# j:default var value - set var to value only if it's not set already,
#   returning $var
######################################################################

proc j:default { var value } {
  if {![uplevel 1 [list info exists $var]]} {
    uplevel 1 [list set $var $value]
  }
  return [uplevel 1 [list set $var]]
}

######################################################################
# j:mkdir dir - try to make directory $dir (and parents if necessary)
######################################################################

proc j:mkdir { dir } {
  global tcl_version
  if {![info exists tcl_version]} {
    set tcl_version [info tclversion]
  }
  if {$tcl_version >= 7.6} {
    file mkdir $dir			;# tcl 1.6 has this built-in:
    return
  }
  
  set dir [string trimright $dir /]	;# make sure doesn't end in /
  
  if {[file isdirectory $dir]} {
    return
  }
  
  set parent [file dirname $dir]
  if [string length $parent] {
    j:mkdir $parent
  }
  if [catch {exec mkdir $dir}] {
    error "Couldn't create directory $dir"
  }
}
  