# jtextbasic.tcl - support for basic Text bindings
#
######################################################################
# Copyright 1992-1996 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# NOTE: the "jtextemacs.tcl" and "jtextvi.tcl" libraries contain actual
#       procedures for emulation-specific actions.  "basic" bindings,
#       however, don't use anything that isn't general (and therefore
#       in jbindtext.tcl), so this file just has j:tb:basic_init in it.
######################################################################

######################################################################
# j:tb:basic_init t - set basic bindings up for widget $t (possibly "Text")
######################################################################

proc j:tb:basic_init { {t Text} } {
  global j_teb
  set j_teb(cutbuffer) {}
  set j_teb(dragscroll,txnd) 0
  set j_teb(dragscroll,delay) 50
  set j_teb(scanpaste_time) 0
  set j_teb(scanpaste_paste) 1

  set j_teb(keymap,$t) basic
  
  j:tb:key_bind $t
  j:tb:mouse_bind $t
  
  j:tkb:mkmap Text basic basic {
    {Control-slash		j:tb:select_all}
    {Control-backslash		j:tb:clear_selection}
    
    {Delete			j:tkb:delete_left}
    {BackSpace			j:tkb:delete_left}
    {Return			j:tkb:insert_newline}
    
    {Up				j:tkb:up}
    {Down			j:tkb:down}
    {Left			j:tkb:left}
    {Right			j:tkb:right}
    
    {Home			j:tkb:bol}
    {End			j:tkb:eol}
    
    {Next			j:tkb:scroll_down}
    {Prior			j:tkb:scroll_up}
    
    {Control-v			j:tkb:paste_selection}
    {Control-i			j:tkb:self_insert}
    {Control-j			j:tkb:self_insert}
    {Control-h			j:tkb:delete_left}
    
    {Control-DEFAULT		j:tb:beep}
    {DEFAULT			j:tkb:self_insert}
    {Shift-DEFAULT		j:tkb:self_insert}
  }
}

# deprecated alias for backwards-compatibility:

proc j:tb:basic_bind { W } {
  j:tb:basic_init $W
}
