# jtext.tcl - constrained interface to Text widget
#
######################################################################
# Copyright 1992-1996 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# global variables:
#
global J_PREFS env
if {! [info exists J_PREFS(typeover)]} {set J_PREFS(typeover) 1}
#
######################################################################

######################################################################
# j:cmd:text_cut w -
#   copy the selected text into a buffer
#   copy the selected text and its tags into another buffer
#   delete the selected text
######################################################################

proc j:cmd:text_cut { w args } {
  global j_text
  global j_tag
  
  # just beep if there's no selection:
  if ![j:text:has_selection $w] {
    j:beep $w
    return
  }
  
  set j_text(cutbuffer) [$w get sel.first sel.last]
  catch {j:fileio:write ~/.tk/cut_text $j_text(cutbuffer)}
  
  j:tk4 {
    # set richbuffer to match, in case we paste plain text into a rich widget
    set j_text(richbuffer) [list [list $j_text(cutbuffer) {}]]
    
    if [info exists j_tag(tags,$w)] {
      set j_text(richbuffer) [j:text:get_text_with_tags $w sel.first sel.last]
    }
    
    catch {
      j:fileio:write ~/.tk/cut_richtext $j_text(richbuffer)
    }
  }

  j:text:delete $w sel.first sel.last
}

######################################################################
# j:cmd:text_copy w -
#   copy the selected text into a buffer
#   copy the selected text and its tags into another buffer
######################################################################

proc j:cmd:text_copy { w args } {
  global j_text
  global j_tag
  
  # just beep if there's no selection:
  if ![j:text:has_selection $w] {
    j:beep $w
    return
  }
  
  set j_text(cutbuffer) [$w get sel.first sel.last]
  catch {j:fileio:write ~/.tk/cut_text $j_text(cutbuffer)}
  
  j:tk4 {
    # set richbuffer to match, in case we paste plain text into a rich widget
    set j_text(richbuffer) [list [list $j_text(cutbuffer) {}]]
    
    if [info exists j_tag(tags,$w)] {
      set j_text(richbuffer) [j:text:get_text_with_tags $w sel.first sel.last]
    }
    
    catch {
      j:fileio:write ~/.tk/cut_richtext $j_text(richbuffer)
    }
  }
}

######################################################################
# j:cmd:text_paste w -
#    insert current contents of cutbuffer into text widget
######################################################################

proc j:cmd:text_paste { w args } {
  global j_text
  global j_tag
  global J_PREFS
  
  # if we're using tagged-insertion, then 
  if {[info exists j_tag(tags,$w)]
      && [j:tk4]} {
    # in typeover mode, all insertions replace selection:
    if $J_PREFS(typeover) {
      if [j:text:insert_touches_selection $w] {	;# else might be off-screen!
        j:text:delete $w sel.first sel.last
      }
    }
    
    lappend j_text(richbuffer) {}		;# make sure it's defined
    
    # use richbuffer from disk if the disk file exists:
    catch {
      set j_text(richbuffer) [j:fileio:read ~/.tk/cut_richtext]
    }
    
    j:text:tagged_insert $w $j_text(richbuffer)
    $w tag remove sel 1.0 end			;# clear sel. (guaranteed there)
  } else {					;# else just plain text
    # use cutbuffer from disk if the disk file exists:
    catch {
      set j_text(cutbuffer) [j:fileio:read ~/.tk/cut_text]
    }
    
    j:text:insert $w $j_text(cutbuffer)
  }
}
