# jtkversion.tcl - procedures to deal with multiple Tk versions
#
######################################################################
# Copyright 1992-1996 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# j:tk4 - perform an action if running under Tk 4.0 or greater
######################################################################

proc j:tk4 { {command ""} } {
  global tk_version
  
  set major_version [lindex [split $tk_version .] 0]
  
  if {$major_version >= 4} {
    if {[string length $command]} {
      uplevel 1 [list eval $command]
    }
    return 1
  } else {
    return 0
  }
}

######################################################################
# j:tk3 - perform an action if running under Tk 3.X or earlier
######################################################################

proc j:tk3 { {command ""} } {
  global tk_version
  
  set major_version [lindex [split $tk_version .] 0]
  
  if {$major_version <= 3} {
    if {[string length $command]} {
      uplevel 1 [list eval $command]
    }
    return 1
  } else {
    return 0
  }
}

######################################################################
# j:tkversion 
#  perform an action if running under a specific range of Tk versions
######################################################################

proc j:tkversion { op versions {command ""} } {
  global tk_version
  
  if {[string match "range" $op]} {
    set from [lindex $versions 0]
    set to [lindex $versions 1]
    
    if {$tk_version >= $from && $tk_version <= $to} {
      if {[string length $command]} {
        uplevel 1 [list eval $command]
      }
      return 1
    } else {
      return 0
    }
  } else {
    if [list $tk_version $op $versions] {
      if {[string length $command]} {
        uplevel 1 [list eval $command]
      }
      return 1
    } else {
      return 0
    }
  }
}
