# copyright (C) 1997-98 Jean-Luc Fontaine (mailto:jfontain@mygale.org)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: databar.tcl,v 1.14 1998/08/01 11:16:16 jfontain Exp $}

class dataBarChart {

    proc dataBarChart {this parentPath args} composite {
        [new barchart $parentPath\
            -title {} -bottommargin 6 -topmargin 3 -bufferelements 0 -plotborderwidth 1\
            -plotbackground $widget::(default,ButtonBackgroundColor)\
        ] $args
    } blt2DViewer {$widget::($this,path)} {
if {$::officialBLT} {
        $widget::($this,path) grid off                                                                      ;# grid is on by default
        $widget::($this,path) xaxis configure -hide 1
} else {
        $widget::($this,path) xaxis configure -mapped 0
}
        composite::complete $this
    }

    proc ~dataBarChart {this} {
        if {[string length $composite::($this,-deletecommand)]>0} {
            uplevel #0 $composite::($this,-deletecommand)                                   ;# always invoke command at global level
        }
    }

    proc options {this} {
        # force size values
        return [list\
            [list -deletecommand {} {}]\
            [list -draggable draggable Draggable 0 0]\
            [list -height height Height 200]\
            [list -mode mode Mode normal normal]\
            [list -width width Width 300]\
        ]
    }

    proc set-deletecommand {this value} {}

    foreach option {-height -width} {
        proc set$option {this value} "\$widget::(\$this,path) configure $option \$value"
    }

    proc set-draggable {this value} {
        if {$composite::($this,complete)} {
            error {option -draggable cannot be set dynamically}
        }
        if {$value} {
            blt2DViewer::allowDrag $this
        }
    }

    proc set-mode {this value} {
        $widget::($this,path) configure -barmode $value
    }

    proc newElement {this path args} {                                                          ;# invoked from 2D viewer base class
        set element [eval new element $path $args]
        element::update $element {}                                                            ;# show empty value for user feedback
        return $element
    }

    proc updateElement {this element seconds value} {
        element::update $element $value
    }

}

class dataBarChart {
    class element {

        proc element {this path args} switched {$args} {
            $path element create $this -label {} -borderwidth 1 -xdata 0              ;# use object identifier as element identifier
            set ($this,path) $path
            switched::complete $this
        }

        proc ~element {this} {
            [set ($this,path)] element delete $this
            if {[string length $switched::($this,-deletecommand)]>0} {
                uplevel #0 $switched::($this,-deletecommand)                                ;# always invoke command at global level
            }
        }

        proc options {this} {
            return [list\
                [list -color black black]\
                [list -deletecommand {} {}]\
                [list -label {} {}]\
            ]
        }

        proc set-label {this value} {
            [set ($this,path)] element configure $this -label $value
        }

        proc set-color {this value} {
            [set ($this,path)] element configure $this -foreground $value
        }

        proc set-deletecommand {this value} {}                                                   ;# data is stored at switched level

        proc update {this y} {
            if {[string length $y]==0} {                                                                       ;# handle empty value
                [set ($this,path)] element configure $this -ydata 0 -label "$switched::($this,-label): ?"
            } else {
                [set ($this,path)] element configure $this -ydata $y -label "$switched::($this,-label): $y"
            }
        }
    }
}

class dataSideBarChart {
    proc dataSideBarChart {this parentPath args} dataBarChart {$parentPath $args} {
        composite::configure $this -mode aligned
    }
    proc ~dataSideBarChart {this} {}
    proc iconData {} {
        return {
            R0lGODdhKAAoAMYAAHt5e87PzgAAANbX1v///wAIADFhITFhGAAQAK33e6X3e5znc6Xvc5zna5TX
            a5Tfazk4OUJJQozPY4THWnvHWoTPY3u+Wnu+UqWupQAYAHO2UhgQADEgAHNJAGuuShAIACkgAPff
            Su/XQiEYAGOmSu/PQufHOWOeQue+OVqWOda2MQAgAN6+MVKOOd62MUqGMc6mKVIIYzEIOXMQhGsQ
            e2sYe0J5KTkoAK0YzrUg1r0o1owQpQAoADlxKc6eIQAQEBBphBBhe944/6UYvbUYzkIoAMaWIa3X
            57Xf76XP594w/95B/zlpIb2OGMaeIedJ/0owAAAQGJTH3r0Y3iFREFI4AAAYIYy+1oS+znMoe+dR
            /ylZGLWGEGumvXOuxudZ/7V5EAAgKWsge+dh/9YY984Y761xCFKWrXMwe2NBAAAwQkKOpd4o/wAA
            AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwA
            AAAAKAAoAAAH/oAAgoOEhYaHiIMBAAKNjo+QkZKTjYsCAZiZAQOYnJuanp6ao6OMAQSoqagAqq2s
            ramvq6iWp7AEsrC5rqqvlgOoBQUGB8TFxbq3s7G0poIFCAnSCgoLDAeJ2YW1wQXVDODWBsnKub6M
            wATQ4QsLDQsH5LfmzZfdDO8N7w4Ggr3KuP4RqPUMwb4HCPlBiKBN2y9UCAo4eOCgogMJ/eiVE8iN
            AAIEFCWIFJlR4DyO6CAWGClyAoWSzDbGJAjgYwUKEyrcnGBgYcNsHSO6nGChqAWYy07OTOkRAQWj
            RS8gJYABoMaOGRBc2MpVg4ENHDqIHStWXsCBzmoi0KDBA1u3/gY+gAhBl64IER1+AsBaoG1btx4M
            jOAQ4q5hvGbPCUiXFfBbEl853C0xuUSHxPVsZShAorNnyINLiDZhooSJvBqX/RKU9YTr1ycEcyhN
            2gSK0z4dmkLVOsWJFL5TyLZtQoUKFChQmzzbcQUC4NCBG+DAAYUKFtivK4+pejeBFQV+twDeosV0
            DtddqDe+PSlzRo6ylp/f4sV5F8bzw+hACZKlGAA698KABNoHAgcwGAfDgip0IIMMM0RIwww0TEhD
            DRj+B2BWL9jg4YcG3ADCgiQu2AGAOKSIQw4stqiDDpbsICMPBXjYg402hIjggj74YOIPBQARxJBE
            BiHEkUJY/jIEETk4Z0MPUEZpQBE7GmElDEZ08MMPRyBxxJdHJBGEEkIssYQlOBCBAw8IQMmEm0xM
            CYKVTTjhhBFNaMmll2CKWeYST6C5Io1MFGqoAQZAwYGVeDZhZQdRRBGmFJRSGoSZT5zJCA46TOEc
            oqAiSkUVHDRh6ql5WhEFpVe0igUWQWSRhRZaWDLFrWwiWgwxW1ChaBNcBCtsB1ZYccWrXSTrRaxZ
            fPGFrVPo4NwBW1RbLRWjcsAFGNuCwW0HYUThRRfjJttFEGJkMcYYtpJRBo3YxhsvFCBsa4a3YJgB
            bhTmJnvGGbGisa4l7r6LgLzypsHBvfd6q68aUfwr8RprGgQ8MCMFF8zGxhx37PHHIHO8CCkkl2yy
            yYEAADs=
        }
    }
}

class dataStackedBarChart {
    proc dataStackedBarChart {this parentPath args} dataBarChart {$parentPath $args} {
        composite::configure $this -mode stacked
    }
    proc ~dataStackedBarChart {this} {}
    proc iconData {} {
        return {
            R0lGODdhKAAoAMYAAHt5e87PzgAAANbX1v///xAoCAAIADFhITFhGAAQAK33e6X3e5znc6Xvc5zn
            a5TXa5Tfazk4OUJJQozPY4THWnvHWoTPY3u+Wnu+UlI4ABAIABgQADEgAHNJACkgAO/XQvffSiEY
            AO/PQufHOee+Oda2MSEQAN6+Md62MVIIY86mKWsQe2sYe4wQpTkoAHMoe70o1qUYvbUYzrUg1gAY
            IQAQEBBphBBhe2sge944/60Yzq3X57Xf76XP53Mwe95B/+dJ/70Y3gAQGJTH3oy+1oS+zudR/2um
            vXOuxudZ/9YY984Y7wAgKedh/wAoOVKWrQAwQkKOpd4o/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
            AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
            AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwA
            AAAAKAAoAAAH/oAAgoOEhYaHiIMBAAKNjo+QkZKTjYsCAZiZAQOYnJuanp6ao6OMAQSoqagAqq2s
            ramvq6iWp7AEsrC5rqqvlgOoBQIGxAcIxsjHysnMy7i0poLDxAkK1gsMDdYK2NrX2dvdCIS1qMTn
            3Q3Z6evZ6g3sDQfPBL/m5wkN6gwO7gz8/gDq+9cPAb1yBM4Ra9Cv3wOGAB82ZCAx4oFB9aIBUJjA
            IQQIDzyCFBmS4scHByJIiADAXsIEMA08APngwYSZNW3irHmTps2LgjJeQpXAAMwEICconZB0aVOl
            TycAZeXSaMylEyhUwKqV69alWqcKXQTgKEwLFSigVZt2rdu2/nAppJQgoaUpokcNaKVwoe/evhf+
            +k0LWGxVsxUAX8CQGDBjxY8dG75LIIMGDRs4dNjMubPnz50x1hK04bIGDx9AqAaRWnVr1q0/vJbd
            IYJtu0MJmA7BQbbv38CD/+4gmhEwAiGSZxbxgXnz58yji5AOXQTxoAiTJ+cwYvqI7967i+hOfrz3
            8depGheknTf57+/fk4A/f/yI+bVX4rbVngOJ+SWU8N8IAgI4YIEGkpDeWKiYwMGDHJxQwgkUSljh
            hBZSOCGGEy6IEIQPTojCiCKiUGKAJJ5YgoeMOOIBiCYGWEKMM8ooI400dvCIJSn0COGLKgSowpBC
            BlkCkUQe/mmkCh2swMKTlrQgJYQueDDklVhmqSWWHbzgJQyWxCDDDDQMU4MBNtygpppprnlDm2vC
            uSYOXuZgiQ4y6EBMDXzuwMMOgPbgJ6A7CPpnoIMGesMLPvjww506zLBnn4cWmqillRpKaA+LNgrE
            nTAEwWcNQghR6BCoDnFqqqui2uoQN9D5wqOMBGFrqTTQIASqRBBRRBG8+grsEL3+GuyvnfpghCW2
            wpDrs8IecQQS0U5bLbW/SotEskkwq8QSTITLhBBITCutueVqa6666R4Rq5dNWPItuEw4Me65Rzzx
            BL768rvvufomGy8j8zIBxcFC6KtvFFEo/ATDDkOsMMMCFlsixcUYZ6zxxhx3LMUipIQs8sgjBwIA
            Ow==
        }
    }
}

if {$officialBLT} {

class dataOverlapBarChart {
    proc dataOverlapBarChart {this parentPath args} dataBarChart {$parentPath $args} {
        composite::configure $this -mode overlap
    }
    proc ~dataOverlapBarChart {this} {}
    proc iconData {} {
        return {
            R0lGODdhKAAoAMYAAHt5e87PzgAAANbX1v///xAoCAAIADFhITFhGAAQAK33e6X3e5znc6Xvc5zn
            a5TXa5Tfazk4OUJJQozPY4THWnvHWoTPY3u+Wnu+UqWupQAYAHO2UlI4ABAIABgQADEgAHNJAGuu
            SikgAPffSu/XQiEYAGOmSu/PQufHOWOeQue+OVqWOda2MQAgACEQAN6+MVKOOd62MUqGMc6mKVII
            YzEIOXMQhGsQe2sYe4wQpUJ5KTkoAK0YzrUg1r0o1qUYvbUYzgAoADlxKUIoAM6eIQAYIQAQEBBp
            hBBhe944/8aWIa3X57Xf76XP594w/95B/zlpIb2OGMaeIedJ/70Y3kowAAAQGJTH3oy+1oS+znMo
            e+dR/ylZGLWGEGumvXOuxudZ/9YY984Y7yFRELV5EAAgKWsge+dh/61xCAAoOVKWrXMwe2NBAAAw
            QkKOpd4o/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwA
            AAAAKAAoAAAH/oAAgoOEhYaHiIMBAAKNjo+QkZKTjYsCAZiZAQOYnJuanp6ao6OMAQSoqagAqq2s
            ramvq6iWp7AEsrC5rqqvlgOoBQIGxAcIxsi9t7OxtKaCw8QJCtQLDA0IidqKpqjE39YNDdcHysu5
            vozABN8GCeIMDA4MCOa36M6X3u0N8/MPBwbhWjawGYFagtol+AcBAsAIEiJsQ/TLW4KLBh44fPBg
            QkBBBe+Zq4UqgbuLDieo9Chwl72CFdldNLlyAoUKH1m5NMgMIYCZFy1UoCCUwgGIEiYeIkkAqIGb
            FC5IzRlS10h1FmdWkCoVA9UMBPEd7EZAQwINZjGo3cChQwcP/h9AyJ0LgpdBn2jNJtiwIcQGD247
            iBhBeAQJEiCUMj2L1kDfvoFLfDB8+HDdl+kErGNs1m8IEyVCwz18gsSJE5d5wiSbV4MBE7BBh5Z8
            +gQK24lBVs08QFDrBCmCp5gt+TYKFCpQgIAoMdHivMBXpFhB/ANyFCxUqMj9SixTDS3AJ1hBfoWL
            D+g/qGDx4gV77sx6kk3Qor6B6TBgpEfPPkYMFizAt1s+jqAVXgL5wSCDCPv9ByALM4BAySOW0GAh
            ePUlIMOGMqTH4AwAzgAiCDWUaMMNJ6J4Aw4sWpLDixiaJYMONKa3gwgi5hihhTTwwEMPQAbpgw+W
            /ABEDxgG/mEAjULo8MEOQ+zwQY5EFDGMEQYcgcSWXCbhZRKW8AAED+AF0UICOgih5gdRDjHlDEoo
            QYwRdC7BxBJ4NoGEE0k88USYP2pgZhAJqAkFFGwOMYQIcUYhxZx13pknEn0+MUWYPlAhaAtKHgrF
            AYlW8UGcSkRBpxFWWLFEE1e0egUSfk7xJyNU1CqomQkcoCuoVVTBwQdRBBtFqkUUYUWrWGCRRRZI
            aOHsFpbU6sOthOqKABcf+CpqFF10W+y3ymbhhRdfNOssGNGGIcatZ17LxRgfcCDvB12QUW8Z+JZh
            xRfkjusFEmY4e4Yl6q4bxMEGjKEwvNqKUC8aZOCbhr7+OXqhhhrNrrHGwIwUTG0CC8PLxsgfQAxx
            GW2kbMXFF7vhRsYbW/LGzDTXbPPNOOf8xiKk9Ozzzz8HAgA7
        }
    }
}

}
