# copyright (C) 1997-98 Jean-Luc Fontaine (mailto:jfontain@mygale.org)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: html.tcl,v 1.13 1998/06/13 21:11:46 jfontain Exp $}

# use bold and smaller sizes than the HTML library default ones for headers
array set HMtag_map {
    h1 {size 22 weight bold}
    h2 {size 20 weight bold}
    h3 {size 18 weight bold}
    h4 {size 16 weight bold}
    h5 {size 14 weight bold}
    h6 {weight bold}
}

# use a font (Helvetica instead of Times) nicer and smaller than the HTML library default one
set HMtag_map(hmstart) {
    family Helvetica  weight medium  style r  size 12
    Tcenter ""  Tlink ""  Tnowrap ""  Tunderline ""  list list
    fill 1  indent ""  counter 0  adjust 0
}

# make headers and preformatted text stand out better by adding new lines around them.
array set HMinsert_map {
    h1 "\n\n" /h1 "\n\n" h2 "\n\n" /h2 "\n\n" h3 "\n\n" /h3 "\n\n" h4 "\n\n" /h4 "\n\n" h5 "\n\n" /h5 "\n\n" h6 "\n\n" /h6 "\n\n"
    pre "\n\n" /pre "\n\n"
}

proc helpWindow {} {
    global htmlHelpDataText

    if {[winfo exists .topHelp]} {
        wm deiconify .topHelp
        raise .topHelp
        return
    }
    toplevel .topHelp
    wm title .topHelp {moodss: Global Help}
    frame .topHelp.bound                      ;# create a frame for bindings that otherwise would propagate to all toplevel children

    set panes [new panner .topHelp -panes 2]                                         ;# split window in 2 for contents and help data
    pack $widget::($panes,path) -fill both -expand 1

    set contents [new scroll text $panner::($panes,frame1) -horizontal 0]
    pack $widget::($contents,path) -fill both -expand 1

    set widget [new scroll text $panner::($panes,frame2) -horizontal 0]
    pack $widget::($widget,path) -fill both -expand 1

    bind .topHelp.bound <Destroy> "delete $widget $contents $panes"

    set contentsText $composite::($contents,scrolled,path)                                       ;# first setup and display contents
    $contentsText configure -cursor watch                                                 ;# show that we are busy for user feedback
    update idletasks
    HMinit_win $contentsText
    $contentsText configure -state normal
    HMparse_html $::htmlHelpContents "HMrender $contentsText"
    $contentsText configure -state disabled
    HMset_state $contentsText -stop 1                                                        ;# stop rendering previous page if busy

    set htmlHelpDataText $composite::($widget,scrolled,path)                                      ;# now setup and display help text
    $htmlHelpDataText configure -cursor watch                                             ;# show that we are busy for user feedback
    update idletasks
    HMinit_win $htmlHelpDataText
    $htmlHelpDataText configure -state normal
    HMparse_html $::htmlHelpData "HMrender $htmlHelpDataText"
    $htmlHelpDataText configure -state disabled
    HMset_state $htmlHelpDataText -stop 1                                                    ;# stop rendering previous page if busy
    focus $htmlHelpDataText                                         ;# force focus on text widget so that page up and down keys work

    $htmlHelpDataText configure -cursor {}                                      ;# show that we are no longer busy for user feedback
    $contentsText configure -cursor {}
    update idletasks
}

proc HMlink_callback {widget reference} {                                                          ;# supply link callback procedure
    global htmlHelpDataText

    if {![string match #* $reference]} return                                                 ;# can only handle internal references
    HMgoto $htmlHelpDataText [string trimleft $reference #]                                   ;# always update help data text widget
}

proc HMset_image {widget label source} {                                                          ;# supply image handling procedure
    pack propagate [winfo parent $label] 1                    ;# do not display image, display alternate text in the smallest window
}
