/* $Id: statfs.c,v 1.1 1998/12/06 18:39:25 jfontain Exp $ */

/* to create the loadable library, use: cc -shared -o libstatfs.so.1.0 -O2 -fPIC -Wall statfs.c */

#include <tcl.h>
#include <sys/vfs.h>
#include <errno.h>
#include <string.h>

static int fileSystemStatistics(ClientData clientData, Tcl_Interp *interpreter, int numberOfArguments, Tcl_Obj * CONST arguments[])
{
    struct statfs statistics;
    Tcl_Obj *object;

    if(numberOfArguments != 2){
        Tcl_WrongNumArgs(interpreter, 1, arguments, "device");
        return TCL_ERROR;
    }
    if(statfs(Tcl_GetStringFromObj(arguments[1], 0), &statistics)<0){
        Tcl_SetObjResult(interpreter, Tcl_NewStringObj(strerror(errno), -1));                /* core takes care of freeing object */
        return TCL_ERROR;
    }
    object = Tcl_NewObj();
    Tcl_ListObjAppendElement(interpreter, object, Tcl_NewLongObj(statistics.f_bsize));             /* optimal transfer block size */
    Tcl_ListObjAppendElement(interpreter, object, Tcl_NewLongObj(statistics.f_blocks));                      /* total data blocks */
    Tcl_ListObjAppendElement(interpreter, object, Tcl_NewLongObj(statistics.f_bavail));  /* free blocks available to normal users */
    Tcl_SetObjResult(interpreter, object);                                                   /* core takes care of freeing object */
    return TCL_OK;
}

int Statfs_Init(Tcl_Interp *interpreter)
{
    Tcl_CreateObjCommand(interpreter, "statfs", fileSystemStatistics, 0, 0);
    return 0;
}
