# copyright (C) 1997-98 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: font.tcl,v 1.5 1998/11/17 21:05:35 jfontain Exp $}

# Note: on UNIX, for best results, make sure your X Window server has the proper dots-per-inch setting for your screen
# (eventually correct it using the -dpi option of your X server, as I do on my Linux machine)

class font {
    catch {widget::widget}       ;# force widget class load for static data members visibility below, in case of package utilization

    set font::(mediumBold) [eval font create [font actual $widget::(default,ButtonFont)]]
    font configure $font::(mediumBold) -weight bold                                                          ;# force weight to bold
    set font::(mediumNormal) [eval font create [font actual $font::(mediumBold)]]
    font configure $font::(mediumNormal) -weight normal                                                    ;# force weight to normal
    set font::(smallNormal) [eval font create [font actual $font::(mediumNormal)]]
    # small size is 80% of medium size
    font configure $font::(smallNormal) -size [expr {round(0.8*[font actual $font::(mediumNormal) -size])}]
}

