# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: cpustats.tcl,v 1.13 1998/12/26 16:41:36 jfontain Exp $}

package provide cpustats 1.2

package require network 1.2


namespace eval cpustats {

    if {[info exists ::env(MOODSSREMOTE)]} {                                                                    ;# remote monitoring
        foreach {remote(user) remote(host)} [network::parseRemoteLocator $::env(MOODSSREMOTE)] {}
    }

    array set data {
        updates 0
        0,label {} 0,type ascii 0,message {}
        1,label user 1,type real 1,message {percentage spent in user mode}
        2,label system 2,type real 2,message {percentage spent in system mode}
        3,label nice 3,type real 3,message {percentage spent in nice mode}
        4,label idle 4,type real 4,message {percentage spent in idle mode}
        columns 5
        sort {0 increasing}
        helpText {
This is a view of processor activity for the system as a whole.

For remote monitoring (rsh facilities must be properly setup), set the environment variable MOODSSREMOTE to user@host or simply host for use with current user name.
        }
    }

    if {[info exists remote]} {
        set data(pollTimes) {20 10 30 60 120 300}                                        ;# poll less often when remotely monitoring
    } else {
        set data(pollTimes) {10 5 20 30 60 120 300}
    }

    array set data {0,0 percent}           ;# initialize single row index column with data unit so that viewer labels are meaningful

    array set last {user 0 nice 0 system 0 idle 0}                                                    ;# stored values for last poll

    if {[info exists remote]&&[catch "exec /usr/bin/rsh -l $remote(user) $remote(host) stat /proc/stat" message]} {
        puts stderr "on host $remote(host) as user $remote(user), file error: $message"                       ;# detect errors early
        exit 1
    } else {
        set file [open /proc/stat]                                                    ;# keep local file open for better performance
    }

    proc update {} {                                               ;# gather cpu statistics (based on the proc man page information)
        variable remote
        variable file
        variable last
        variable data

        if {[info exists remote]} {
            set file [open "| /usr/bin/rsh -l $remote(user) $remote(host) cat /proc/stat"]
            gets $file line
            close $file                                                             ;# closing is necessary since seek does not work
        } else {
            seek $file 0                                                                            ;# rewind before retrieving data
            gets $file line
        }
        scan $line {cpu %d %d %d %d} user nice system idle                                              ;# in hundredths of a second
        foreach item {user nice system idle} {         ;# calculate statistics during the last poll period except for the first pass
            set current [set $item]
            set $item [expr {$current-$last($item)}]
            set last($item) $current
        }
        set multiplier [expr {100.0/($user+$nice+$system+$idle)}]
        array set data "
            0,1 [format %.1f [expr {$multiplier*$user}]] 0,2 [format %.1f [expr {$multiplier*$system}]]
            0,3 [format %.1f [expr {$multiplier*$nice}]] 0,4 [format %.1f [expr {$multiplier*$idle}]]
        "
        incr data(updates)
    }
}
