# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: memstats.tcl,v 1.5 1998/12/26 16:42:22 jfontain Exp $}

package provide memstats 1.1

package require network 1.2

namespace eval memstats {

    if {[info exists ::env(MOODSSREMOTE)]} {                                                                    ;# remote monitoring
        foreach {remote(user) remote(host)} [network::parseRemoteLocator $::env(MOODSSREMOTE)] {}
    }

    array set data {
        updates 0
        0,label type 0,type ascii 0,message {type}
        1,label available 1,type integer 1,message {total available}
        2,label used 2,type integer 2,message {used}
        3,label free 3,type integer 3,message {free}
        4,label shared 4,type integer 4,message {shared memory}
        5,label buffers 5,type integer 5,message {memory used for buffers}
        6,label cached 6,type integer 6,message {cached memory}
        columns 7
        sort {0 increasing}
        helpText {
This is a view of memory and swap statistics for the system as a whole.

For remote monitoring (rsh facilities must be properly setup), set the environment variable MOODSSREMOTE to user@host or simply host for use with current user name.
        }
    }

    if {[info exists remote]} {
        set data(pollTimes) {20 10 30 60 120 300}                                        ;# poll less often when remotely monitoring
    } else {
        set data(pollTimes) {10 5 20 30 60 120 300}
    }

    array set data {0,0 memory 0,6 {} 1,0 swap 1,4 {} 1,5 {}}                                             ;# initialize static cells

    if {[info exists remote]&&[catch "exec /usr/bin/rsh -l $remote(user) $remote(host) stat /proc/meminfo" message]} {
        puts stderr "on host $remote(host) as user $remote(user), file error: $message"                       ;# detect errors early
        exit 1
    } else {
        set file [open /proc/meminfo]                                                 ;# keep local file open for better performance
    }

    proc update {} {                                               ;# gather cpu statistics (based on the proc man page information)
        variable remote
        variable file
        variable data

        if {[info exists remote]} {
            set file [open "| /usr/bin/rsh -l $remote(user) $remote(host) cat /proc/meminfo"]
        } else {
            seek $file 0                                                                            ;# rewind before retrieving data
        }
        gets $file; gets $file; gets $file                                                           ;# skip redundant first 3 lines
        set data(0,1) [lindex [gets $file] 1]                                                                        ;# total memory
        set data(0,3) [lindex [gets $file] 1]                                                                         ;# free memory
        set data(0,2) [expr {$data(0,1)-$data(0,3)}]                                                                  ;# used memory
        set data(0,4) [lindex [gets $file] 1]                                                                       ;# shared memory
        set data(0,5) [lindex [gets $file] 1]                                                                             ;# buffers
        set data(1,6) [lindex [gets $file] 1]                                                                       ;# cached memory
        set data(1,1) [lindex [gets $file] 1]                                                                          ;# total swap
        set data(1,3) [lindex [gets $file] 1]                                                                           ;# free swap
        set data(1,2) [expr {$data(1,1)-$data(1,3)}]                                                                    ;# used swap
        if {[info exists remote]} {                                                 ;# closing is necessary since seek does not work
            close $file
        }
        incr data(updates)
    }
}
