# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: random.tcl,v 1.23 1999/01/16 20:31:02 jfontain Exp $}

# module sample file with random data

# corresponding pkgIndex.tcl file content:
# package ifneeded random 4.0 "source [file join $dir random.tcl]"

package provide random 4.1

namespace eval random {                                                                    ;# namespace name must match package name
    # Module data is arranged in a single array that can be used by many views, such as tables, graphs, pies,...
    # It contains configuration values as well as dynamic data (see below and update procedure).

    # Array members are:
    # - updates: a counter traced on write by viewers monitoring this module data. Must be incremented as soon as the data has been
    #   updated. Must be initialized in the namespace body in all cases as it is used for automatic module detection (may not be
    #   changed in the initialize procedure).
    # Column numbers must be positive, starting from 0 included. Column members are:
    #   - label: the title displayed on the top cell of the data column.
    #   - type: valid types are those that the lsort command can handle.
    #   - message: a short help string that appears in the message area at the bottom of the data window when the mouse cursor
    #     passes over the column title cell.
    #   - anchor: optional member. Column data is either centered by default (center), tucked to the left (left) or right side
    #     (right) of the column.
    # - pollTimes: in seconds. A list with the default poll time in first position. The other times can be in any order, as the core
    #   will sort them and use the lowest value as the minimum poll time value.
    #   The minimum poll seconds must be a reasonable value depending on the processing time of the update procedure.
    # - visibleColumns: an optional list that specifies the table columns that should be displayed. If not specified, all the table
    #   columns are visible.
    # - columns: total number of data columns to be displayed (obsolete, no longer required).
    # - sort: a list that defines the initial column to be used for sorting the table data and in which direction. The specified
    #   column must be visible (see visibleColumns member above).
    # - indexColumns: a list that specifies the columns required to uniquely identify a row in the table. It is optional and
    #   defaults to the column 0, unless of course you do not have a 0 column index, in which case it is mandatory to specify this
    #   list. When specified, all the columns in the list must be visible (see visibleColumns member above).
    # - helpText: displayed when the module help is launched from the main window help menu. Can be plain text or HTML formatted
    #   (<HTML> and <BODY> tags required), in which case it is properly rendered in the module help window (note: tables, frames,
    #   and may other tags are not supported: stick to formatted text at the moment).
    # - views: optional. If specified, it defines one or more views to be used in place of the default view. One table will be
    #   displayed per view. Each view is a list of array members, suitable as an argument to an "array set" command. For each view,
    #   2 members must be defined: visibleColumns and sort (syntax and usage are identical to the default table members).
    # - switches: optional. A list of switch / boolean pairs. A switch is a single letter or a string prepended with the - or +
    #   sign. The boolean value (0 or 1) specifies whether the switch takes an argument. If the switches member exists, an
    #   appropriate initialize procedure must be provided by the module (see initialize procedure example in this module).
    #   The core will take care of parsing the command line and reject any invalid switch / value combination for the module.
    #   The switches value may not be changed in the initialize procedure.
    array set data {
        updates 0
        0,label name 0,type ascii 0,message {user name}
        1,label cpu 1,type real 1,message {cpu usage in percent}
        2,label disk 2,type integer 2,message {disk usage in megabytes}
        3,label memory 3,type integer 3,message {memory usage in kilobytes}
        4,label command 4,type dictionary 4,message {command name} 4,anchor left
        pollTimes {10 5 20 30 60 120 300}
        sort {1 decreasing}
        indexColumns {0 4}
        views {
            {visibleColumns {0 1 3 4} sort {1 decreasing}}
            {visibleColumns {0 2 4} sort {2 decreasing}}
        }
        switches {-a 0 --asynchronous 0}
    }
    set file [open [file join $packageDirectory random.htm]]                                ;# directory is set in pkgIndex.tcl file
    set data(helpText) [read $file]                                   ;# initialize HTML help data from file in module sub-directory
    close $file

    # The initialize procedure, if it exists, is invoked by the core before any update occurs (update procedure invocation if the
    # module is synchronous). It can be used for module setup, although it is rather redundant with inline module namespace code
    # (namespace code outside of any module namespace procedure) for a module with no command line arguments support.
    # The initialize procedure is optional when the module does not support command line arguments, and in such a case takes no
    # arguments.
    # The initialize procedure is mandatory when the module supports command line arguments, and in such a case takes an array name
    # as sole argument. The array contains the switched options values, indexed by switch. For example, if the command line was:
    # $ moodss random --asynchronous --other-option value -x 1234
    # the options array will contain:
    #   options(--asynchronous) = 
    #   options(--other-option) = value
    #   options(-x)             = 1234
    # Note that the --asynchronous member value is empty as that switch takes no argument.
    # For the above example, switches would have been defined as:
    #   switches {-a 0 --asynchronous 0 --other-option 1 -x 1}
    # In all cases, data members other than updates and switches can be set or updated in the initialize procedure, and taken into
    # account by the core.
    proc initialize {optionsName} {
        upvar $optionsName options
        variable asynchronous
        variable data

        set asynchronous [expr {[info exists options(-a)]||[info exists options(--asynchronous)]}]
        if {$asynchronous} {
            # for a module to be asynchronous, the pollTimes member must be a single negative integer value. It then represents the
            # preferred time interval for viewers that require one.
            array set data {pollTimes -10}
            after 3000 random::update                                                                             ;# boot simulation
        }
    }

    # The dynamic data array index is the row number followed by the column number separated by a comma.
    # The column number must start from 0 up to the total number of columns minus 1 (no holes are allowed in the column sequence)
    # The row number can take any positive integer value (between 0 and 2147483647) and be defined in any order, as long as it is
    # unique during the lifetime of the module data. if a new row is created, it must take a value that was never used: thus, the
    # number of a row that has disappeared is not allowed. Row numbers need not be consecutive.

    # The update procedure is mandatory only for synchronous modules, as it is never invoked by the core for asynchronous modules.
    # Its function is to update module data.
    proc update {} {
        variable data
        variable asynchronous

        array set data "
            0,0 john 0,1 [format %.1f [expr {rand()*30}]] 0,2 [expr {100+int(rand()*50)}] 0,3 [expr {10+int(rand()*50)}] 0,4 cc
            1,0 bill 1,1 [format %.1f [expr {rand()*3}]] 1,2 [expr {300+int(rand()*100)}] 1,3 [expr {30+int(rand()*100)}] 1,4 xedit
            2,0 anny 2,1 [format %.1f [expr {rand()*5}]] 2,2 [expr {200+int(rand()*30)}] 2,3 [expr {20+int(rand()*30)}] 2,4 ps
            4,0 peter 4,1 [format %.1f [expr {rand()*8}]] 4,2 [expr {50+int(rand()*10)}] 4,3 [expr {5+int(rand()*10)}] 4,4 ls
            6,0 laura 6,1 [format %.1f [expr {rand()*20}]] 6,2 [expr {90+int(rand()*20)}] 6,3 [expr {9+int(rand()*20)}] 6,4 emacs
            3,0 robert 3,1 [format %.1f [expr {rand()*10}]] 3,2 [expr {500+int(rand()*150)}] 3,3 [expr {50+int(rand()*150)}] 3,4 top
            9,0 laura 9,1 [format %.1f [expr {rand()*30}]] 9,2 [expr {100+int(rand()*50)}] 9,3 [expr {10+int(rand()*50)}] 9,4 cc
        "
        incr data(updates)                         ;# write variable so that update can be detected with an eventual tcl write trace
        if {$asynchronous} {                                                           ;# eventually simulate asynchronous operation
            after [expr {2000+round(rand()*8000)}] random::update
        }
    }
}
