# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: apache.tcl,v 1.5 1999/01/31 11:04:52 jfontain Exp $}

package provide apache 1.1
package require apacheutilities


namespace eval apache {

    # use an empty hidden column as index since there is only a single row
    array set data {
        updates 0
        0,label {} 0,type ascii 0,message {} 0,0 {}
        1,label accesses 1,type real 1,message {total number of accesses}
        2,label kilobytes 2,type real 2,message {total number of kilobytes served}
        3,label {CPU load} 3,type real 3,message {CPU load in percent}
        4,label {up time} 4,type dictionary 4,message {total running time in d(ays), h(ours), m(inutes) and s(econds)}
        5,label requests 5,type real 5,message {averaged number of requests per second}
        6,label bytes 6,type integer 6,message {averaged number of bytes per second}
        7,label bytes/request 7,type integer 7,message {average number of bytes per requests}
        8,label busy 8,type integer 8,message {number of busy servers}
        9,label idle 9,type integer 9,message {number of idle servers}
        10,label accesses/second 10,type real 10,message {current number of accesses per second}
        11,label kilobytes/second 11,type real 11,message {current kilobytes served per second}
        pollTimes {10 5 20 30 60 120 300}
        views {
            {visibleColumns {3 4 8 9} sort {3 increasing}}
            {visibleColumns {1 2 5 6 7 10 11} sort {1 increasing}}
        }
        switches {-r 1 --remote 1}
    }
    set file [open [file join $::packageDirectory(apache) apache.htm]]
    set data(helpText) [read $file]                                                           ;# initialize HTML help data from file
    close $file

    proc initialize {optionsName} {
        upvar $optionsName options
        variable url

        set url [url options apache ?auto]
    }

    proc update {} {
        variable url
        variable transaction

        if {[info exists transaction]} return                                                                                ;# busy
        set transaction [::http::geturl $url -command ::apache::completed]
    }

    proc completed {token} {
        variable data
        variable last
        variable transaction

        set valid [expr {[lindex [set ${token}(http)] 1]==200}]                               ;# sole HTTP code for good transaction
        if {$valid} {
            foreach line [split [set ${token}(body)] \n] {
                if {![regexp {^(.+): (.+)$} $line dummy name value]} break                             ;# stop at first invalid line
                set current($name) $value
            }
            # check that all statistics are present (per second values are not always returned when server was just (re)started)
            set valid [expr {[array size current]==10}]
        }
        unset $token                                                     ;# free transaction data array (fully qualified and global)
        if {$valid} {
            set data(0,1) $current(Total Accesses)
            set data(0,2) $current(Total kBytes)
            set data(0,3) [format %.2f $current(CPULoad)]
            set data(0,4) [formattedTime $current(Uptime)]
            set data(0,5) [format %.2f $current(ReqPerSec)]
            set data(0,6) [expr {round($current(BytesPerSec))}]
            set data(0,7) [expr {round($current(BytesPerReq))}]
            set data(0,8) $current(BusyServers)
            set data(0,9) $current(IdleServers)
            if {[info exists last]} {
                set interval [expr {double($current(Uptime)-$last(uptime))}]                    ;# force floating point calculations
                set data(0,10) [format %.2f [expr {($current(Total Accesses)-$last(accesses))/$interval}]]
                set data(0,11) [format %.2f [expr {($current(Total kBytes)-$last(kilobytes))/$interval}]]
            } else {                                                                                                   ;# first poll
                array set data {0,10 0 0,11 0}
            }
            array set last [list accesses $current(Total Accesses) kilobytes $current(Total kBytes) uptime $current(Uptime)]
        } else {                                                                                            ;# an HTTP error occured
            array set data {0,1 0 0,2 0 0,3 0 0,4 ? 0,5 0 0,6 0 0,7 0 0,8 0 0,9 0 0,10 0 0,11 0}          ;# show meaningless values
            catch {unset last}
        }
        unset transaction                                                                              ;# ready for next transaction
        incr data(updates)
    }

    proc formattedTime {seconds} {
        set string {}
        set interval [expr {$seconds/86400}]                                                                                 ;# days
        if {$interval>0} {
            append string ${interval}d
            set seconds [expr {$seconds%86400}]
        }
        set interval [expr {$seconds/3600}]                                                                                 ;# hours
        if {$interval>0} {
            append string ${interval}h
            set seconds [expr {$seconds%3600}]
        }
        set interval [expr {$seconds/60}]                                                                                 ;# minutes
        if {$interval>0} {
            append string ${interval}m
            set seconds [expr {$seconds%60}]
        }
        append string ${seconds}s
        return $string
    }

}
