# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: apacheu.tcl,v 1.2 1999/01/31 11:05:37 jfontain Exp $}

package provide apacheutilities 1.0
package require http 2


::http::config                                              ;# force immediate loading so that following procedure can be overloaded
proc ::http::Finish {token {errormsg ""}} {     ;# modified from http package so that no transaction data is freed and errors caught
    variable $token
    upvar 0 $token state
    global errorInfo errorCode
    if {[string length $errormsg] != 0} {
        set state(error) [list $errormsg $errorInfo $errorCode]
        set state(status) error
    }
    catch {close $state(sock)}
    catch {after cancel $state(after)}
    if {[info exists state(-command)]} {
        eval $state(-command) {$token}
    }
}

namespace eval apache {

    proc url {optionsName moduleName {flag {}}} {     ;# works for both apache and apachex modules, flag can be ?auto, ?notable, ...
        upvar $optionsName options

        if {![catch {set url $options(--remote)}]||![catch {set url $options(-r)}]} {
            if {[string first ? $url]>=0} {                                                         ;# we specify the flag ourselves
                puts stderr "usage: moodss ... $moduleName \[-r|--remote\] \[http://\]host\[statusLocator\] ..."
                exit 1
            }
            regsub {/$} $url {} url                                                              ;# eventually remove trailing slash
            if {![regexp {[^/]/[^/]} $url]} {                                                    ;# if status locator is not present
                append url /server-status                                                                             ;# use default
            }
            append url $flag
        } else {
            set url 127.0.0.1/server-status${flag}                                                ;# default for server on localhost
        }
        return $url
    }

}
