# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: apachex.tcl,v 1.1 1999/01/31 11:13:43 jfontain Exp $}

package provide apachex 1.0
package require apacheutilities


namespace eval apachex {

    array set data {
        updates 0
        0,label server 0,type integer 0,message {server number}
        1,label process 1,type dictionary 1,message {operating system process identifier}
        2,label accesses 2,type integer 2,message {number of accesses for this connection / this child / this slot}
        3,label mode 3,type ascii 3,message {_(waiting),Starting,Reading,W(sending),Keepalive,DNSlookup,Logging,G(finishing)}
        4,label {CPU usage} 4,type real 4,message {CPU usage in seconds}
        5,label {request age} 5,type integer 5,message {seconds since beginning of most recent request}
        6,label {request time} 6,type integer 6,message {milliseconds required to process most recent request}
        7,label {connection traffic} 7,type real 7,message {kilobytes transferred for this connection}
        8,label {child traffic} 8,type real 8,message {megabytes transferred for this child}
        9,label {slot traffic}  9,type real 9,message {total megabytes transferred for this slot}
        10,label client 10,type integer 10,message {client network address} 10,anchor left
        11,label {virtual host} 11,type integer 11,message {server virtual host} 11,anchor left
        12,label request 12,type integer 12,message {HTTP request} 12,anchor left
        pollTimes {10 5 20 30 60 120 300}
        views {
            {visibleColumns {0 1 2 3 4} sort {0 increasing}}
            {visibleColumns {0 5 6 7 8 9} sort {0 increasing}}
            {visibleColumns {0 10 11 12} sort {0 increasing}}
        }
        switches {-r 1 --remote 1}
    }
    set file [open [file join $::packageDirectory(apachex) apachex.htm]]
    set data(helpText) [read $file]                                                           ;# initialize HTML help data from file
    close $file

    proc initialize {optionsName} {
        upvar $optionsName options
        variable url

        set url [::apache::url options apache]
    }

    proc update {} {
        variable url
        variable transaction

        if {[info exists transaction]} return                                                                                ;# busy
        set transaction [::http::geturl $url -command ::apachex::completed]
    }

    proc completed {token} {
        variable data
        variable transaction

        set valid [expr {[lindex [set ${token}(http)] 1]==200}]                               ;# sole HTTP code for good transaction
        if {$valid} {
            set body [set ${token}(body)]                                ;# keep first table rows except the 1st row (column titles)
            set lines [string range $body [expr {[string first </tr> $body]+5}] [expr {[string first </table> $body]-1}]]
            regsub -all \n [string trim $lines] {} lines                                         ;# carriage returns must be ignored
            regsub -all \t $lines { } lines                         ;# replace all tabs by spaces as tabs will be used as separators
            regsub {^<tr>} $lines {} lines                                                       ;# remove extreme table row markers
            regsub {</tr>$} $lines {} lines
            regsub -all {</tr> *<tr>} $lines \t lines     ;# table row markers are row separators (use tab character as replacement)
            set separator {<td[^>]*>}                                                      ;# table cell markers are cell separators
            foreach line [split $lines \t] {
                regsub ^$separator $line {} line                                                      ;# remove leftmost cell marker
                regsub -all $separator $line \t line                                               ;# use tab character as separator
                set column 0
                foreach cell [split $line \t] {
                    regsub -all {<[^>]+>} $cell {} cell                                    ;# remove all remaining (formatting) tags
                    if {$column==0} {
                        set row $cell                                                             ;# use server number as row number
                        set current($row) {}                                        ;# keep track of current rows for latter cleanup
                    }
                    set data($row,$column) $cell
                    incr column
                }
            }
        }
        foreach name [array names data *,0] {                                                          ;# cleanup vanished rows data
            set row $data($name)
            if {[info exists current($row)]} continue
            for {set column 0} {$column<=12} {incr column} {
                unset data($row,$column)
            }
        }
        unset $token                                                     ;# free transaction data array (fully qualified and global)
        unset transaction                                                                              ;# ready for next transaction
        incr data(updates)
    }

}
