set htmlHelpContents {
<HTML>
<BODY>
<UL>
<LI>
<A HREF="#about">1. About this document</A></LI>

<LI>
<A HREF="#introduction">2. Introduction</A></LI>

<LI>
<A HREF="#required">3. Required software</A></LI>

<LI>
<A HREF="#architecture">4. Architecture</A></LI>

<LI>
<A HREF="#core">5. Core</A></LI>

<UL>
<LI>
<A HREF="#userinterface">5.1. User interface</A></LI>

<UL>
<LI>
<A HREF="#draganddrop">5.1.1. Drag and drop</A></LI>

<UL>
<LI>
<A HREF="#dropsites">5.1.1.1. Drop sites</A></LI>

<LI>
<A HREF="#dragsites">5.1.1.2. Drag sites</A></LI>
</UL>

<LI>
<A HREF="#saving">5.1.2. Saving</A></LI>
</UL>

<LI>
<A HREF="#commandline">5.2. Command line</A></LI>

<UL>
<LI>
<A HREF="#mainarguments">5.2.1. Main arguments</A></LI>

<LI>
<A HREF="#modulearguments">5.2.2. Module arguments</A></LI>
</UL>
</UL>
</UL>
</BODY>
</HTML>
}
set htmlHelpData {
<BODY>
<HTML>
<H3>
<A NAME="about"></A>1. About this document</H3>
This document contains general information, reference information and examples
designed to help the user understand the moodss application and the programmer
write modules for it.
<H3>
<A NAME="introduction"></A>2. Introduction</H3>
Quite often, one needs to monitor changing data, whether it might come
from a system, such as the different processes running on a Unix server,
or from a network, such as the volume and distribution of traffic that
runs through it.
<P>Most often, such data can be organized in a table with rows of information,
each column representing a different kind of data. For example, in the
case of processes running on a computer system, rows might be sorted according
to their unique process identifier, with columns containing values such
as CPU usage, memory usage, owner's name, time of creation, ...
<P>The software used to view this type of information comes in different
forms and shapes. Unix users might be familiar with the "top" application
which presents rows of process data as lines of text, whereas RMON (Remote
MONitoring) SNMP software usually uses multiple windows with graphical
displays, curves, pie charts, multiple configuration dialog boxes, even
3D visualization modules to visualize network traffic, connection matrices,
...
<P>In most cases, data comes from one or more tables. A common interface,
graphical with menus, drag'n'drop capability, table widgets, textual and
graphical data viewers such as multiple line graphs, bar and pie charts,
could be used. The user could then sort table rows, select one or more
cells, rows, columns, create views such as other tables, charts, ... best
suited to the way data should be presented. Once optimized, the data viewers
layout and configuration could be saved for later reuse as a dashboard.
In effect, what is needed is a spreadsheet that is capable of dealing with
dynamically changing data.
<P>Moodss (Modular Object Oriented Dynamic SpreadSheet) is an attempt at
answering these needs. It is composed of a main part (the core) and an
unlimited number of modules, loaded as the application is launched, each
module interfacing to a specific type of data. The core is written in the
great Tcl language (at <A HREF="http://www.scriptics.com/">http://www.scriptics.com/</A>)
using object oriented techniques thanks to the stooop and scwoop packages
(at <A HREF="http://www.multimania.com/jfontain/">http://www.multimania.com/jfontain/</A>).
The module function is to describe the data that it is also in charge of
retrieving and formatting. Modules can be written in plain Tcl or use dynamically
linked libraries written in the C language (modules are packages in the
Tcl sense, so any language that can interface with Tcl is supported).
<P>Modules are loaded when moodss is started. Several modules can be handled
concurrently (starting with moodss version 3.0). This way, you may monitor
data coming from any number of heterogeneous sources. Module names are
specified in the command line and cannot be dynamically unloaded.
<P>Versions 4.0 and up add a dashboard functionality: the current configuration
(modules, viewers, poll time, windows sizes and placement, ...) can be
saved in a file at any time, for later reuse (see the -f (--file) command
line switch documentation).
<P>Versions 4.3 and up support asynchronous modules (no polling needed
as module data may change on its own). Note that any number of asynchronous
and regular (synchronous) modules can be simultaneously loaded.
<P>Versions 5.0 and up add a free text viewer, which can be used for comments,
and which can also embed live data cells in text form.
<P>Versions 5.3 and up support viewer type mutation through viewer icon
drag'n'drop, and viewer quick destruction through trash icon drag'n'drop
operation. A new menu for empty viewer creation was also added.
<P>Versions 6.0 and up support command line arguments per module, data
table column anchoring in module configuration and automatic module discovery.
<P>Versions 6.1 and up support HTML formatted data for modules.
<P>Since module data access is entirely customizable (through C code, Tcl,
HTTP, ...) and since several modules can be loaded at once, applications
for moodss become limitless. For example, comparing a remote database server
CPU activity and traffic load from a network probe on the same graph becomes
possible.
<P>As features are added to moodss, different ways of viewing data will
be made available while the module structure will stay the same. The goal
of moodss is to become a nice feature packed generic way of viewing data.
Moodss can be used to monitor any type of data, since the simplest cases
can fit in one table with a single row, with the most complicated requiring
loading several multiple table modules.
<P>As moodss is written in Tcl and uses well supported extensions (Tktable
and BLT), it will run on Tcl/Tk supported platforms: UNIX and Windows (I
do not know if Tktable and BLT are available for the MacIntosh). Obviously,
some modules may be specific to a platform, but the core is guaranteed
to run on them all.
<P>After reading and understanding this document, you should be able to
write your own modules in order to monitor the data that you are interested
in.
<P>Moodss is free software. You can redistribute it and/or modify it under
the terms described in the COPYRIGHT file or use the main window Help Copyright
menu for more information.
<H3>
<A NAME="required"></A>3. Required software</H3>
If you are using a Linux Redhat system (5.1 or above), then use the moodss
rpm file (available (starting with 4.4) at <A HREF="http://www.multimania.com/jfontain/">http://www.multimania.com/jfontain/</A>)
for installation. It requires the tcl, tk, blt and tktable rpms (see INSTALL
file for more information). Unless you want to work on the moodss source
code, you can skip the rest of this section.
<P>For the current version (6.3), the following packages must be installed
before attempting to install moodss (make sure to check the INSTALL file
for the latest information):
<UL>
<LI>
Tcl/Tk version 8.0 or above (at <A HREF="http://sunscript.sun.com/">http://sunscript.sun.com/</A>)</LI>

<LI>
tkTable version 2.2 or above (at <A HREF="http://oprs.mchh.siemens.de/tcl/capp/tkTable/">http://oprs.mchh.siemens.de/tcl/capp/tkTable/</A>)<B>*</B></LI>

<LI>
the BLT library version 2.4 (at <A HREF="ftp://ftp.tcltk.com/pub/blt/">ftp://ftp.tcltk.com/pub/blt/</A>)<B>*</B></LI>
</UL>

<DIV ALIGN=right><B>*</B><I> many thanks to the authors for these great
packages</I></DIV>

<P><BR>The pie widgets, stooop and scwoop libraries are included in the
self contained <I>moodss</I> application file. Therefore, it is not required
to install the stooop, scwoop and tkpiechart packages, unless you want
to work on the moodss source code itself. However, should you want to get
more information on those extensions, you will find the latest versions:
<UL>
<LI>
stooop version 3.7 or above</LI>

<LI>
switched version 1.4 or above (included in the stooop distribution)</LI>

<LI>
scwoop version 2.6 or above</LI>

<LI>
tkpiechart version 5.2.2 or above</LI>
</UL>
at <A HREF="http://www.multimania.com/jfontain/">http://www.multimania.com/jfontain/</A>.
<H3>
<A NAME="architecture"></A>4. Architecture</H3>
The moodss application is composed of the core software and one or several
modules. Modules are implemented as Tcl packages and thus usually comprise
a Tcl source file and a pkgIndex.tcl file as required by the Tcl package
implementation.
<P>The core will load one or more modules, whose names were passed as command
line parameters or come from a save file, and will start displaying module
data in one or more tables. The tables are then updated at the frequency
defined by the poll time, which the user may change, or asynchronously
for the relevant modules. For example, to launch moodss with the random
module, just type:
<PRE>$ wish moodss random</PRE>
All the module code and data are kept in a separate namespace. The module
data is stored is a single array including some configuration data used
when the module is loaded by the core, and variable data (displayed in
the application table and eventual graphical viewers). If a module is synchronous,
it must start updating its data when requested by the core. If a module
is asynchronous, its data may be updated at any time. The synchronous or
asynchronous nature is specified in the configuration data for the module.
<P>The initial data tables represent the first data views, from which any
number of cells can be selected. Data viewers can be created by dropping
cells through a drag'n'drop operation into a graph, bar chart, pie chart,
summary table or free text iconic site. In turn, these viewers can display
more table cells, which when dropped into the viewer, result in the creation
of corresponding data graph lines, chart bars, pie slices, table rows or
text cells. Cells or rows can be removed from existing viewers, by simply
selecting them and dropping them in the trash iconic site (a bullet hole).
<P>Any viewer can be mutated (its type changed) by dropping a viewer icon
into it. For example, create a stacked data bar viewer from several cells,
then drag the 3D pie drag'n'drop icon into it. Any viewer can also be destroyed
in one shot by dropping the trash icon into it.
<P>Any draggable data can be dropped in any valid drop site at any time.
It is thus possible to drag several data cells from any table or any viewer
into other ones, the trash, ... even if the data comes from different modules.
<P>All data viewers can be moved and resized at will with the help of a
simple internal window manager.
<P>The current configuration (loaded modules, tables and viewers coordinates,
sizes, poll time, main window size, ...) can be saved in a file at any
time, so that an identical dashboard can be relaunched at will.
<H3>
<A NAME="core"></A>5. Core</H3>

<H4>
<A NAME="userinterface"></A>5.1. User interface</H4>
Soon after the application launch, tabular data is displayed in one or
more tkTable widgets with automatic scroll bars, between the menu bar,
the drop sites with graphical viewers, summary table, free text and trash
icons and a message area, as one can see below:
<CENTER><PRE><IMG SRC="moodss1.gif" ALT="moodss initial main window view" NOSAVE HEIGHT=501 WIDTH=501></PRE></CENTER>
The message area is used to display status information, such as when the
data is being updated, and help information, as the user moves the mouse
pointer over sensitive areas, such as table column headers. Further help
is provided through widget tips (also known as balloons) when appropriate,
and of course the Help menu.
<P>The window title shows the name of the loaded module(s) along with the
poll time.
<P>The <I>File</I> menu contains the <I>Save</I>, <I>Save As</I> and <I>Exit</I>
menu entries, used to save the current configuration (modules and viewers),
or gracefully quit the moodss application.
<P>The <I>Options</I> menu (may not exist, see below) contains the <I>Poll
time</I> entry which when selected launches the corresponding dialog box,
as shown below:
<CENTER><PRE><IMG SRC="moodss2.gif" ALT="poll time dialog box" NOSAVE HEIGHT=140 WIDTH=161></PRE></CENTER>
The user can select a new poll time among the module choices from a spin
entry widget, or directly type in a new value, as long as it is not smaller
than the module minimum poll time, in which case a message dialog box warns
the user.
<P>When several modules are used, the minimum poll time is the greater
of the minimum poll times of all modules. The default poll time (used when
moodss is started) is the greater of the default poll times of all modules.
The available choices in the poll time dialog box is the combination of
all modules poll times.
<P>The <I>Poll time</I> menu entry is available only when needed, which
is not the case if all the loaded modules are asynchronous. If this case,
the <I>Options</I> menu itself is not displayed.
<P>The <I>New</I> menu (only visible when not running in read-only mode,
see <A HREF="#commandline">Command line</A>), allows the creation of empty
viewers of any type.
<P>Any data displayed in a table can be sorted at any time by simply clicking
on a column title. Clicking on the same column title again sorts the data
in opposite order, thus toggling between increasing and decreasing orders.
<BR>When sorting, the selected column is used as a reference, meaning that
all rows will be rearranged so that the selected column appears sorted,
with values either increasing or decreasing.
<BR>A little arrow indicator is placed to the right of the reference column
title label, pointing up or down depending on whether the sorting order
is decreasing or increasing.
<BR>Table columns can be interactively resized by holding the first mouse
button down on a column border. The mouse cursor is changed to an horizontal
double arrow on column borders to show this capability.
<P>Aside from the main tables, graphical and textual viewers can be created
for viewing table cell data behavior over time. Viewers can also be deleted,
data views (such as pie slices, curves, ...) can be added or removed from
existing viewers, ... These functions are all implemented using the drag
and drop functionality described below.
<P>Graphical viewers available at this time are BLT graph viewers (such
as can be seen below), side-by-side bars charts, overlapped bars charts
(only available when the BLT version 2.4 library is used), stacked bars
charts, 2D pie charts and 3D pie charts*.
<P>*<I>note: if you know of any other nice viewers (like 3D graphs) that
work with Tcl, please let me know so I can integrate them. Many thanks
in advance...</I>
<CENTER><TABLE COLS=2 WIDTH="100%" NOSAVE >
<TR ALIGN=CENTER VALIGN=CENTER NOSAVE>
<TD NOSAVE>
<CENTER><PRE><IMG SRC="hgraph.gif" ALT="graph viewer sample" NOSAVE HEIGHT=200 WIDTH=300></PRE></CENTER>
</TD>

<TD>
<PRE><IMG SRC="hoverbar.gif" ALT="overlap bar chart viewer sample" NOSAVE HEIGHT=200 WIDTH=300></PRE>
</TD>
</TR>

<TR ALIGN=CENTER VALIGN=CENTER NOSAVE>
<TD NOSAVE>
<PRE><IMG SRC="hsidebar.gif" ALT="side bar chart viewer sample" NOSAVE HEIGHT=200 WIDTH=300></PRE>
</TD>

<TD>
<PRE><IMG SRC="hstackbr.gif" ALT="stacked bar chart viewer sample" NOSAVE HEIGHT=200 WIDTH=300></PRE>
</TD>
</TR>

<TR ALIGN=CENTER VALIGN=CENTER NOSAVE>
<TD NOSAVE>
<PRE><IMG SRC="h2dpie.gif" ALT="2D pie chart viewer sample" NOSAVE HEIGHT=200 WIDTH=300></PRE>
</TD>

<TD>
<PRE><IMG SRC="h3dpie.gif" ALT="3D pie chart viewer sample" NOSAVE HEIGHT=200 WIDTH=300></PRE>
</TD>
</TR>
</TABLE></CENTER>
There are 2 textual viewers.
<P>The summary table displays for each row the cell label, the current,
average, minimum and maximum values since the row was created. Data cells
can be inserted one or several at a time through a simple drop. Rows can
be deleted by selecting any cell in the row then dropping any number of
them into the trash drop site.
<P>The free text viewer is an editable Tcl text widget with any number
(including zero) of embedded data cell windows. Data cells can be inserted
one or several at a time through a simple drop, as with the other viewers.
New data cell windows are inserted at the current insertion cursor position.
Data cells can be deleted by selecting then dropping any number of them
into the trash drop site. They can also be deleted using the keyboard Delete
and Backspace keys, which also work on the regular text, as well as the
expected other key bindings. When dropping data cells, each data cell window
is preceded by a relevant label text for the cell, which can later be edited
at any time.
<CENTER><TABLE WIDTH="100%" NOSAVE >
<TR ALIGN=CENTER VALIGN=CENTER NOSAVE>
<TD WIDTH="58%" NOSAVE>
<PRE><IMG SRC="hsumtbl.gif" ALT="summary table viewer sample" NOSAVE HEIGHT=200 WIDTH=350></PRE>
</TD>

<TD WIDTH="42%" NOSAVE>
<PRE><IMG SRC="hfreetxt.gif" ALT="free text viewer sample" NOSAVE HEIGHT=200 WIDTH=250></PRE>
</TD>
</TR>
</TABLE></CENTER>
Here is a screen shot of loaded <I>ps</I> and <I>cpustats</I> modules with
several graphical viewers:
<CENTER><PRE><IMG SRC="moodss3.gif" ALT="moodss window with graph data viewers" NOSAVE HEIGHT=514 WIDTH=524></PRE></CENTER>
All data viewers can be moved and resized thanks to handling areas in the
data viewer borders. When moving the mouse pointer over these areas, the
mouse cursor changes to indicate the possible action. Corner handles allow
resizing in both X and Y axis. Handles in the middle of the sides allow
resizing in either the X or Y axis direction. All other areas can be used
for moving the data viewer as shown by the quadruple arrow cursor. Clicking
on any part of the border changes the stacking order: the viewer being
clicked on either goes below (eventually becomes hidden) the other viewers,
or becomes fully visible (on top, eventually hiding other viewers). When
moving or resizing, the message area displays the current coordinates or
size in real time as the mouse is being moved. Further description of this
small window manager functionality is useless, as it behaves like a basic
window manager (let me know if it does not).
<P>Here is another shot featuring a free text viewer with loaded <I>cpustats</I>
and <I>memstats</I> modules:
<CENTER><PRE><IMG SRC="moodss4.gif" ALT="moodss window with free text data viewer" NOSAVE HEIGHT=480 WIDTH=459></PRE></CENTER>
The <I>Help</I> menu contains <I>Global</I> help (actually launches an
embedded HTML viewer with this very document), <I>Modules</I> menu with
one sub-menu per module (which displays the module's help data), <I>Copyright</I>
which displays the GPL (Gnu General Public License) document, <I>Source
Versions </I>which display all the source code file names with their versions
and <I>About</I> general information entries.
<H5>
<A NAME="draganddrop"></A>5.1.1 Drag and drop</H5>
Drag and drop in moodss tries to behave as the now familiar Windows functionality
(no, it doesn't mean I am a Bill Gates fan, as they probably stole the
idea from somebody else anyway :^). For example, to create a graphical
plot, one must first select one or more data cells in a data table, hold
down the first mouse button (the left one for a right handed user) while
dragging over to the left-most icon below the menu bar (when dragging an
object, as the mouse pointer passes over possible drop sites, they are
highlighted with a thin black border for user feedback). Releasing the
mouse button at this time results in the creation of a BLT graph viewer.
<P>Only valid drop sites for the data being dragged are highlighted when
the mouse cursor passes over them, thus guaranteeing error free operations
(if there are no bugs, that is :).
<P>In summary, data cells can be dragged from any table or any viewer into
any viewer drop site icon, any viewer or the trash can.
<H6>
<A NAME="dropsites"></A>5.1.1.1. Drop sites</H6>
All icons right below the menu bar are valid drop sites for data cells
(several may be dropped at the same time). From left to right:
<UL>
<LI>
graph viewer with one or more data curves created at once</LI>

<LI>
side by side bar chart with one or more data bars created at once</LI>

<LI>
stacked bar chart with one or more data bars created at once</LI>

<LI>
2D pie chart with one or more data slices created at once</LI>

<LI>
3D pie chart with one or more data slices created at once</LI>

<LI>
summary table with one or more data rows created at once</LI>

<LI>
free text with one or more labeled data cell windows created at once</LI>

<LI>
object trash with one or more data viewer elements deleted at once</LI>
</UL>
For example, a graph viewer with 1 curve is created by dropping 1 data
cell into the graph viewer icon.
<P>Once a viewer exists, it also acts as a drop site for data cells, which
may be dragged from any table or other viewers. Dropping one or more cells
directly in the viewer results in corresponding lines, bars, slices or
rows being created and automatically updated. Each new graphical element
is assigned a new and different color.
<P>You may delete one or more viewer elements (graph lines, bar chart bars,
pie charts slices, summary table rows or free text cell window) from a
viewer by selecting them (using the first mouse button) through their labels.
Several elements can be selected by depressing the control key as the first
mouse button is pressed. The selection can also be extended by depressing
the shift key along with the first mouse button. The pie slices can also
be directly selected by clicking on the slices themselves.
<BR>Then dragging from the viewer to the trash drop site (the bullet hole)
on the upper right side of the main window and releasing the first mouse
button result in the corresponding viewer elements to be destroyed. When
there are no remaining elements, the viewer itself (graph, bar chart, pie
or summary table) can be destroyed by dropping it into the trash. The free
text viewer can only be deleted this way when completely emptied of any
text and data cell window.
<P>Any viewer can be deleted in one shot by dropping from the trash icon
into it.
<P>Any viewer also acts as a drop site for viewer type data, which allows
viewer mutation by just dropping from the new viewer type icon into the
existing viewer. It is much quicker than destroying the existing viewer
and create a new one of the new type, while remembering which data cells
were monitored by the viewer of the old type.
<BR>When mutating, if some cells in the current viewer no longer exist
(they may belong to a disappeared summary table), they are not made a part
of the new viewer, and a warning message is flashed to the user in the
message area.
<H6>
<A NAME="dragsites"></A>5.1.1.2. Drag sites</H6>
A table is obviously a drag site. One or more cells can be dragged at once
after selection, using the traditional single/shift/control mouse click
technique.
<P>Any viewer is also a drag site. It requires selecting one or more viewer
elements before initiating the drag operation from any selected element
in the viewer. If there are no selected elements, dragging is impossible:
the mouse cursor is not changed into the drag circular cursor.
<P>If a viewer contains no elements, then the viewer itself can be dragged
and dropped into the trash.
<P>All viewer icons (below the menu bar) are drag sites for viewer type
data, which allows quick viewer mutation (see mechanism description in
<A HREF="#dropsites">Drop
sites</A>).
<P>The trash icon is also a drag site of the killing action type, which
allows viewer destruction in one shot.
<H5>
<A NAME="saving"></A>5.1.2 Saving</H5>
The current application configuration (including existing data viewers)
can be saved in a file, which achieves a dashboard functionality.
<P>Once moodss has been launched with one or several modules and tables
have been moved, resized, viewers created, moved and resized, the current
configuration can be saved in a .moo file, and later reused by passing
the corresponding file name with the -f (--file) command line switch.
<P>For moodss version 4.0 and above, the following information is saved
in the file (which is human readable):
<UL>
<LI>
moodss version</LI>

<LI>
date and time</LI>

<LI>
application window size</LI>

<LI>
poll time</LI>

<LI>
modules</LI>

<LI>
tables positions and sizes</LI>

<LI>
viewers types, positions, sizes and specific data</LI>
</UL>
For moodss version 5.1 and above, the following information is also saved:
<UL>
<LI>
table viewers column widths</LI>
</UL>
For moodss version 5.2 and above, the following information is also saved:
<UL>
<LI>
viewers stacking order (for internal window manager)</LI>
</UL>
When using the <I>File Save</I> menu for the first time, and if a file
name was not specified in the command line, the file selector dialog box
appears so that the user may choose a file name (with a .moo extension).
<P>The <I>File Save As</I> menu behaves as expected, with the user always
having to choose a file name.
<P>Once a file name has been specified (either through the command line
or the file selector dialog box), that file name is reused whenever the
<I>File
Save</I> menu is used. The <I>File Save As</I> menu may be used at any
time to change the file name.
<H4>
<A NAME="commandline"></A>5.2. Command line</H4>

<H5>
<A NAME="mainarguments"></A>5.2.1. Main arguments</H5>
Launching moodss is very simple: just pass one or more data module names
as parameters, as in:
<PRE>&nbsp;&nbsp;&nbsp; $ wish moodss random</PRE>
or, for 2 modules at once:
<PRE>&nbsp;&nbsp;&nbsp; $ wish moodss ps cpustats</PRE>
You may not specify the same module more than once in the command line.
<P>You may eventually specify a poll time in seconds using:
<PRE>&nbsp;&nbsp;&nbsp; $ wish moodss -p 25 random</PRE>
Note that when all the specified modules are asynchronous, the poll time
option specifies the preferred interval for graph viewers.
<P>Once saved through the File Save menus (for example in save.moo) , the
configuration can be retrieved using:
<PRE>&nbsp;&nbsp;&nbsp; $ wish moodss -f save.moo</PRE>
which would result in the same modules being loaded, the same viewers displayed
at the same positions and sizes, the same poll time being used, as well
at the same application window size. New modules data displays can be added
at any latter time to existing dashboards by specifying modules on the
command line after the -f (--file) switch / value pair.
<P>Command line options include:
<UL>
<LI>
<B>-f</B> (or <B>--file</B>): specify a configuration file name</LI>

<LI>
<B>-h</B> (or <B>--help</B>): display some help text and exit</LI>

<LI>
<B>-geometry</B>: set the initial geometry of the main window (a la X window)</LI>

<LI>
<B>-p</B> (or <B>--poll-time</B>): specify a poll time in seconds</LI>

<LI>
<B>-r</B> (or <B>--read-only</B>): disable viewer creation, editing, ...</LI>

<LI>
<B>-S</B> (or <B>--static</B>): disable internal window manager sizing
and moving</LI>

<LI>
<B>--show-modules</B>: discover valid moodss modules, show their directory
location(s) and exit</LI>

<LI>
<B>--version</B>: output version information and exit</LI>
</UL>
Moodss command line options must appear before any module name appears
on the command line, so as not to interfere with the module options.
<H5>
<A NAME="modulearguments"></A>5.2.2. Module arguments</H5>
Module themselves can take options (if programmed to do so, see <A HREF="#initialization">module
initialization</A>), through command line arguments placed right after
the module name and before the next module name, if any.
<P>For example, the following command:
<PRE>&nbsp;&nbsp;&nbsp; $ moodss -p 15 random --asynchronous arp --remote jdoe@foo.bar --numeric route --numeric</PRE>
causes the <I>random</I> module to update asynchronously, the <I>arp</I>
module to collect data from the <I>foo.bar</I> host under the <I>jdoe</I>
login name and not attempt to lookup symbolic names for hosts, with the
last module <I>route</I> doing the same.
<P>Note the setting the application poll time to 15 seconds does not interfere
with the module options.
<P>The moodss core checks the validity of module options according to the
information provided by the module programmer. Any invalid option / value
combination for the module is detected, reported on the standard error
channel before the application exits.
</BODY>
</HTML>
}
