# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: gui.tcl,v 1.9 1999/03/13 21:35:22 jfontain Exp $}

proc updateTitle {} {                                                          ;# show modules and poll time or mode in window title
    if {[llength $global::pollTimes]==0} {
        wm title . "moodss: [commaSeparatedString $modules::(all)] data (asynchronous)"
    } else {
        wm title . "moodss: [commaSeparatedString $modules::(all)] data (every $global::pollTime seconds)"
    }
}

proc createMenuWidget {parentPath readOnly includePollTime} {
    set menu [menu $parentPath.menu -tearoff 0]
    $menu add cascade -label File -menu [menu $menu.file -tearoff 0] -underline 0
    if {!$readOnly} {
        $menu.file add command -label Save -command {save 0} -underline 1 -accelerator Alt+S
        bind $parentPath <Alt-s> {save 0}
        $menu.file add command -label {Save As...} -command {save 1} -underline 6 -accelerator Alt+A
        bind $parentPath <Alt-a> {save 1}
    }
    $menu.file add command -label Exit -command exit -underline 1 -accelerator Alt+X
    bind $parentPath <Alt-x> exit
    if {!$readOnly&&$includePollTime} {
        $menu add cascade -label Options -menu [menu $menu.options -tearoff 0] -underline 0
        $menu.options add command -label {Poll Time...} -command inquirePollTime -underline 0
    }
    if {!$readOnly} {
        $menu add cascade -label New -menu [menu $menu.new -tearoff 0] -underline 0
        $menu.new add command -label {Graph Chart...} -underline 0\
            -command "createCellsViewer dataGraph {} 1 $global::static \$global::pollTime"
        $menu.new add command -label {Overlap Bar Chart...} -underline 0\
            -command "createCellsViewer dataOverlapBarChart {} 1 $global::static"
        $menu.new add command -label {Side Bar Chart...} -underline 5\
            -command "createCellsViewer dataSideBarChart {} 1 $global::static"
        $menu.new add command -label {Stacked Bar Chart...} -underline 0\
            -command "createCellsViewer dataStackedBarChart {} 1 $global::static"
        $menu.new add command -label {2D Pie Chart...} -underline 0 -command "createCellsViewer data2DPieChart {} 1 $global::static"
        $menu.new add command -label {3D Pie Chart...} -underline 0 -command "createCellsViewer data3DPieChart {} 1 $global::static"
        $menu.new add command -label {Summary Table...} -underline 8 -command "createCellsViewer summaryTable {} 1 $global::static"
        $menu.new add command -label {Free Text...} -underline 0 -command "createCellsViewer freeText {} 1 $global::static"
    }
    $menu add cascade -label Help -menu [menu $menu.help -tearoff 0] -underline 0
    $menu.help add command -label Global... -underline 0 -accelerator F1 -command generalHelpWindow
    bind $parentPath <F1> generalHelpWindow
    $menu.help add cascade -label Modules -menu [menu $menu.help.modules -tearoff 0] -underline 0
    foreach module $modules::(all) {
        $menu.help.modules add command -label $module... -command "moduleHelpWindow $module"
    }
    $menu.help add command -label Copyright... -underline 0 -command {simpleTextDialogBox {moodss: Copyright} $help::copyright}
    $menu.help add command -label {Source Versions...} -underline 0 -command versionsDialogBox
    $menu.help add command -label About... -underline 0 -command aboutDialogBox

    $parentPath configure -menu $menu
}

proc createMessageWidget {parentPath} {
    set global::messenger [new lifoLabel $parentPath -headerfont $font::(mediumBold) -font $font::(mediumNormal)]
    return $widget::($global::messenger,path)                                                             ;# return actual tk widget
}

proc dragEcho {data format} {
    return $data
}

proc createDragAndDropZone {parentPath} {
    set frame [frame $parentPath.drops]

    set label [label $frame.graph -image applicationIcon]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer dataGraph \$dragSite::data(DATACELLS) 1 $global::static \$global::pollTime"
    new widgetTip -path $label -text "graph chart\ndrag'n'drop site"
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::dataGraph}

    set label [label $frame.overlapBarChart -image [image create photo -data [dataOverlapBarChart::iconData]]]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer dataOverlapBarChart \$dragSite::data(DATACELLS) 1 $global::static"
    new widgetTip -path $label -text "overlap bar chart\ndrag'n'drop site"
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::dataOverlapBarChart}

    set label [label $frame.sideBarChart -image [image create photo -data [dataSideBarChart::iconData]]]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer dataSideBarChart \$dragSite::data(DATACELLS) 1 $global::static"
    new widgetTip -path $label -text "side bar chart\ndrag'n'drop site"
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::dataSideBarChart}

    set label [label $frame.stackedBarChart -image [image create photo -data [dataStackedBarChart::iconData]]]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer dataStackedBarChart \$dragSite::data(DATACELLS) 1 $global::static"
    new widgetTip -path $label -text "stacked bar chart\ndrag'n'drop site"
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::dataStackedBarChart}

    set label [label $frame.2DPieChart -image [image create photo -data [data2DPieChart::iconData]]]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer data2DPieChart \$dragSite::data(DATACELLS) 1 $global::static"
    new widgetTip -path $label -text "2D pie chart\ndrag'n'drop site"
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::data2DPieChart}

    set label [label $frame.3DPieChart -image [image create photo -data [data3DPieChart::iconData]]]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer data3DPieChart \$dragSite::data(DATACELLS) 1 $global::static"
    new widgetTip -path $label -text "3D pie chart\ndrag'n'drop site"
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::data3DPieChart}

    set label [label $frame.summaryTable -image [image create photo -data [summaryTable::iconData]]]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer summaryTable \$dragSite::data(DATACELLS) 1 $global::static"
    new widgetTip -path $label -text "summary table\ndrag'n'drop site"
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::summaryTable}

    set label [label $frame.freeText -image [image create photo -data [freeText::iconData]]]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer freeText \$dragSite::data(DATACELLS) 1 $global::static"
    new widgetTip -path $label -text "free text\ndrag'n'drop site"
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::freeText}

    set trashData {
        R0lGODlhKAAoAKUAAP8A/8/Lz+/r71FRUZ6anpaSlv/7/wgICL66vkFBQYaChtfT17LA3LaytjAwMFlZWZaant/b3/fz96aipnFxcWlpaWFhYTAoKCAgICgo
        KOfj576yvklJSRAQEBAQCI6Slq6yrp6SnhgYGAAAAI6KjoaKhnl5ecfDx66ipiAoIOfr5ygwMJ6Slnlxce/j5zg4OL7Dx6aint/T38fLz4Z5hvf7/8/Tz66q
        tqairv/z939/f/fz79fLz0lRUXmChllRUSH5BAEAAAAALAAAAAAoACgAAAb+QIBwSBwGisikckkUDAhMYiEaNQwO06ggS00iDIXEQcFcLA5dpUDAaCgch8GD
        DIVEDJJJIp2URBQUFQoWCRcYGRkGihoBCnt8RQYbDxwZhx0eBwcYHyAMIRMDDpBEEwYPGBgiHSOtrh0PJCVhGaRDCw0JHq68vAkDJh0cfBIEHAoNGb3LvR0O
        DlBDJwsTSHcnBRaszNytAxMaa4oGJyRCAn4LBggMBAfd8BwQCxL1AiiPAOrjDRMU8PBSUDghIJyKFcOEBDAQIMKJCQqUAeQW54QEDREKjOACQIOGAhQ4iJgY
        0KIAFgcoFFlIgoKDXSS7UZAggIKIJAJCtFjxLib+NwcuNLwYkARGDAovevpchkFGhBFLEJhIupTbDA2jlBho8K/qsg400CzJ80Cp11Ydhi6JEIBEgm1nW2Hg
        kBDJFwQVHGCI6wqRWGs1ClRIMJLviAQmoCbBY4LDi1R8LUSwYSJJAAE3OhzogDBuBgISYNRCouFEhgHmAFCAWbUCugkvcKLCMYREA7MxNRjQMCFrkRMYog0x
        UCGFzwMcDORYMImYBhYJJHbTgUPGDow8eORKI2AHAkeqzB54QYG6ABkCFgSYESDACOFM0GGr8MCCBQo9FJgowAAHjjUCGODCAjxE0EAHFnSh2wkfkOADDSGw
        oIA/CTgwgH8MKKCAAC5S8MBAASLkw8QJBsgwAQEk0PBDYX4dgAMCrfg2AUqjUaGCAQsgQMIKRCHxT4K2EEEAOjZYIAJHRKQWJBEgCJCDkUtCgoJRHkQJCQkW
        bGTllrYEAQA7
    }
    set label [label $frame.trash -image [image create photo -data $trashData]]
    pack $label -pady 1 -side right
    new dropSite -path $label -formats OBJECTS -command "eval delete \$dragSite::data(OBJECTS)"
    new widgetTip -path $label -text "objects trashing\ndrag'n'drop site"
    set drag [new dragSite -path $label]
    dragSite::provide $drag KILL list                                           ;# drag data is unimportant, only the kill action is

    return $frame
}

proc inquirePollTime {} {
    set dialog\
        [new dialogBox . -buttons oc -default o -title {moodss: Poll Time} -die 0 -x [winfo pointerx .] -y [winfo pointery .]]
    set frame [frame $widget::($dialog,path).frame]
    set minimum [lindex $global::pollTimes 0]
    set message [message $frame.message\
        -width [winfo screenwidth .] -font $font::(mediumNormal) -justify center\
        -text "Enter new poll time (greater than $minimum):"\
    ]
    pack $message
    set entry [new spinEntry $frame -width 4 -list $global::pollTimes -side right]
    spinEntry::set $entry $global::pollTime
    pack $widget::($entry,path) -anchor e -side left -expand 1 -padx 2       ;# evenly pack entry and label together near the center
    pack [label $frame.label -text seconds] -anchor w -side right -expand 1 -padx 2
    dialogBox::display $dialog $frame
    widget::configure $dialog -command "
        set time \[spinEntry::get $entry\]
        if {\$time<$minimum} {                                                                    ;# check against minimum poll time
            bell
            $message configure -text {Enter new poll time\n(must be greater than $minimum):}
        } else {                                                                                                ;# new time is valid
            if {\$time!=\$global::pollTime} {                                     ;# but check that it actually differs from current
                set global::pollTime \$time
                viewer::updateInterval \$time
                updateTitle
                refresh                                      ;# update immediately in case poll time was set to a much greater value
            }
            delete $dialog                                                                                     ;# destroy dialog box
        }
    "
    bind $frame <Destroy> "delete $entry"                                            ;# delete objects not managed by the dialog box
}
