# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: menuhelp.tcl,v 1.1 1999/04/19 21:13:32 jfontain Exp $}

class menuContextHelp {

    proc menuContextHelp {this menu} {
        bind $menu <<MenuSelect>> "menuContextHelp::selected $this \$::tkPriv(activeItem)"
        ::set menuContextHelp::($this,active) -1                                            ;# corresponding to none: no active item
        ::set menuContextHelp::($this,menu) $menu
    }

    proc ~menuContextHelp {this} {
        variable ${this}string

        bind $menuContextHelp::($this,menu) <<MenuSelect>> {}
        catch {unset ${this}string}
    }

    proc set {this item string} {
        variable ${this}string

        ::set ${this}string($item) $string
    }

    proc selected {this item} {
        variable ${this}string

        if {[string compare $item none]==0} {                                                                      ;# normalize item
            ::set item -1
        }
        if {$item==$menuContextHelp::($this,active)} return                                                             ;# no change
        lifoLabel::pop $global::messenger
        if {$item>=0} {                                                                                     ;# replace with new item
            if {[catch {::set ${this}string($item)} string]} {
                lifoLabel::push $global::messenger $item                                     ;# display item number to aid debugging
            } else {
                lifoLabel::push $global::messenger $string
            }
        }
        ::set menuContextHelp::($this,active) $item
    }

}
