# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: global.tcl,v 1.17 1999/07/14 15:59:26 jfontain Exp $}

namespace eval global {                                                                     ;# gather miscellaneous global data here
    variable applicationVersion 7.99
    variable messenger                                                                                   ;# main window message area
    variable pollTimes                                       ;# list of predefined poll times calculated according to loaded modules
    variable pollTime                                                                               ;# current main window poll time
    variable canvas                                                                                ;# main window canvas widget path
    variable static                                                                            ;# whether main window view is static
    variable windowManager                                                                             ;# main window window manager
    variable fileMenuContextHelper                                             ;# menu context help object for file menu in menu bar
    variable fileMenuContextHelperSaveIndex                                                        ;# save button index in the above
    variable saveFile                                                     ;# current configuration and layout current save file name
    variable xWindowManagerInitialOffset 30
    variable yWindowManagerInitialOffset 20
    variable graphNumberOfIntervals 100
    variable viewerHeight 200
    variable viewerWidth 300
    variable canvasHeight [winfo screenheight .]
    variable canvasWidth [winfo screenwidth .]
    variable canvasBackground white
}

proc updateCanvasSize {args} {                                                                             ;# ignore trace arguments
    $global::canvas configure -width $global::canvasWidth -height $global::canvasHeight\
        -scrollregion [list 0 0 $global::canvasWidth $global::canvasHeight]
}

proc updateCanvasBackground {args} {                                                                       ;# ignore trace arguments
    $global::canvas configure -background $global::canvasBackground
}
