# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: utility.tcl,v 1.11 1999/05/01 19:06:39 jfontain Exp $}

proc minimum {a b} {return [expr {$a<$b?$a:$b}]}
proc maximum {a b} {return [expr {$a>$b?$a:$b}]}

proc ldelete {listName value} {
    upvar $listName list

    set index [lsearch -exact $list $value]
    if {$index<0} {
        error "\"$value\" is not in list"
    }
    set list [lreplace $list $index $index]

}

proc commaSeparatedString {words} {
    for {set index 0} {$index<([llength $words]-1)} {incr index} {
        append string "[lindex $words $index], "
    }
    append string [lindex $words $index]
    return $string
}

proc static {localName {initialValue {}}} {
    set global ::[lindex [info level -1] 0]:$localName
    uplevel upvar #0 $global $localName
    if {![info exists $global]} {
        set $global $initialValue
    }
}

proc startGatheringPackageDirectories {} {
    catch {rename source _source}
    proc source {file} {
        foreach name [package names] {
            set package($name) {}
        }
        uplevel _source [list $file]
        foreach name [package names] {                                                        ;# see what new packages are available
            if {![info exists package($name)]} {
                set ::packageDirectory($name) [file dirname $file]
            }
        }
    }
}

proc destroyChildren {path} {
    eval destroy [winfo children $path]
}
