set htmlHelpContents {
<HTML>
<BODY>
<ul>
<li>
<a href="#about">1. About this document</a></li>

<li>
<a href="#introduction">2. Introduction</a></li>

<li>
<a href="#required">3. Required software</a></li>

<li>
<a href="#architecture">4. Architecture</a></li>

<li>
<a href="#core">5. Core</a></li>

<ul>
<li>
<a href="#userinterface">5.1. User interface</a></li>

<ul>
<li>
<a href="#draganddrop">5.1.1. Drag and drop</a></li>

<ul>
<li>
<a href="#dropsites">5.1.1.1. Drop sites</a></li>

<li>
<a href="#dragsites">5.1.1.2. Drag sites</a></li>
</ul>

<li>
<a href="#saving">5.1.2. Saving</a></li>
</ul>

<li>
<a href="#commandline">5.2. Command line</a></li>

<ul>
<li>
<a href="#mainarguments">5.2.1. Main arguments</a></li>

<li>
<a href="#modulearguments">5.2.2. Module arguments</a></li>
</ul>
</ul>
</ul>
</BODY>
</HTML>
}
set htmlHelpData {
<BODY>
<HTML>
<h3>
<a NAME="about"></a>1. About this document</h3>
This document contains general information, reference information and examples
designed to help the user understand the moodss application and the programmer
write modules for it.
<h3>
<a NAME="introduction"></a>2. Introduction</h3>
Quite often, one needs to monitor changing data, whether it might come
from a system, such as the different processes running on a Unix server,
or from a network, such as the volume and distribution of traffic that
runs through it.
<p>Most often, such data can be organized in a table with rows of information,
each column representing a different kind of data. For example, in the
case of processes running on a computer system, rows might be sorted according
to their unique process identifier, with columns containing values such
as CPU usage, memory usage, owner's name, time of creation, ...
<p>The software used to view this type of information comes in different
forms and shapes. Unix users might be familiar with the <i>top</i> application
which presents rows of process data as lines of text, whereas RMON (Remote
MONitoring) SNMP software usually uses multiple windows with graphical
displays, curves, pie charts, multiple configuration dialog boxes, even
3D visualization modules to visualize network traffic, connection matrices,
...
<p>In most cases, data comes from one or more tables. A common interface,
graphical with menus, drag'n'drop capability, table widgets, textual and
graphical data viewers such as multiple line graphs, bar and pie charts,
could be used. The user could then sort table rows, select one or more
cells, rows, columns, create views such as other tables, charts, ... best
suited to the way data should be presented. Once optimized, the data viewers
layout and configuration could be saved for later reuse as a dashboard.
In effect, what is needed is a spreadsheet tailored to dynamic data processing.
<p>Moodss (Modular Object Oriented Dynamic SpreadSheet) is an attempt at
answering these needs. It is composed of a main part (the core) and an
unlimited number of modules, loaded as the application is launched, each
module interfacing to a specific type of data. The core is written in the
great Tcl language (at <a href="http://www.scriptics.com/">http://www.scriptics.com/</a>)
using object oriented techniques thanks to the stooop package (at <a href="http://www.multimania.com/jfontain/">http://www.multimania.com/jfontain/</a>).
The module function is to describe the data that it is also in charge of
retrieving and formatting. Modules can be written in plain Tcl or use dynamically
linked libraries written in the C language (modules are packages in the
Tcl sense, so any language that can interface with Tcl is supported).
<p>Modules are loaded when moodss is started. Several modules can be handled
concurrently (starting with moodss version 3.0). This way, you may monitor
data coming from any number of heterogeneous sources. Modules are specified
in the command line and cannot be dynamically unloaded.
<p>Versions 4.0 and up add a dashboard functionality: the current configuration
(modules, viewers, poll time, windows sizes and placement, ...) can be
saved in a file at any time, for later reuse (see the -f (--file) command
line switch documentation).
<p>Versions 4.3 and up support asynchronous modules (for which no polling
is needed as module data may change on its own). Note that any number of
asynchronous and regular (synchronous) modules can be simultaneously loaded.
<p>Versions 5.0 and up add a free text viewer, which can be used for comments,
and which can also embed live data cells in text form.
<p>Versions 5.3 and up support viewer type mutation through viewer icon
drag'n'drop, and viewer quick destruction by a drop into the trash icon.
A new menu for empty viewer creation was also added.
<p>Versions 6.0 and up support command line arguments per module, data
table column anchoring in module configuration and automatic module discovery.
<p>Versions 6.1 and up support HTML formatted help data for modules.
<p>Versions 6.6 and up support automatic cross hairs with coordinates in
message area for graph data viewers.
<p>Versions 6.7 and up support contextual help (through the main window
message area) on all menu items.
<p>Versions 7.0 and up support per user (on UNIX systems) application wide
preferences setting.
<p>Versions 7.99 and up support concurrent instances of the same module.
<p>Since module data access is entirely customizable (through C code, Tcl,
HTTP, ...) and since several modules can be loaded at once, applications
for moodss become limitless. For example, comparing a remote database server
CPU activity and traffic load from a network probe on the same graph becomes
possible.
<p>As features are added to moodss, different ways of viewing data will
be made available while the module structure will stay the same. The goal
of moodss is to become a nice feature packed generic way of viewing data.
Moodss can be used to monitor any type of data, since the simplest cases
can fit in one table with a single row, with the most complicated requiring
loading several multiple table modules.
<p>As moodss is written in Tcl and uses well supported extensions (Tktable
and BLT), it will run on Tcl/Tk supported platforms: UNIX and Windows (I
do not know if Tktable and BLT are available for the MacIntosh). Obviously,
some modules may be specific to a platform, but the core is guaranteed
to run on them all.
<p>After reading and understanding this document, you should be able to
write your own modules in order to monitor the data that you are interested
in.
<p>Moodss is free software. You can redistribute it and/or modify it under
the terms described in the COPYRIGHT file or use the main window Help Copyright
menu for more information.
<h3>
<a NAME="required"></a>3. Required software</h3>
If you are using a Linux Redhat system (5.1 or above), then use the moodss
rpm file (available (starting with 4.4) at <a href="http://www.multimania.com/jfontain/">http://www.multimania.com/jfontain/</a>)
for installation. It requires the tcl, tk, blt and tktable rpms (see INSTALL
file for more information). You are then all set for using the included
Linux modules or develop your own modules.
<p><b><i>Unless you want to work on the moodss source code (not the modules),
you can skip the rest of this section.</i></b>
<p>For the current version (8.0), the following packages must be installed
before attempting to install moodss (make sure to check the INSTALL file
for the latest information):
<ul>
<li>
Tcl/Tk version 8.0 or above (at <a href="http://sunscript.sun.com/">http://sunscript.sun.com/</a>)</li>

<li>
tkTable version 2.2 or above (at <a href="http://oprs.mchh.siemens.de/tcl/capp/tkTable/">http://oprs.mchh.siemens.de/tcl/capp/tkTable/</a>)<b>*</b></li>

<li>
the BLT library version 2.4 (at <a href="ftp://ftp.tcltk.com/pub/blt/">ftp://ftp.tcltk.com/pub/blt/</a>)<b>*</b></li>
</ul>

<div align=right><b>*</b><i> many thanks to the authors for these great
packages</i></div>

<p><br>The pie widgets, stooop and scwoop libraries are included in the
self contained <i>moodss</i> application file. Therefore, it is not required
to install the stooop, scwoop and tkpiechart packages, unless you want
to work on the moodss source code itself. However, should you want to get
more information on those extensions, you will find the latest versions:
<ul>
<li>
stooop version 3.7 or above</li>

<li>
switched version 1.4 or above (included in the stooop distribution)</li>

<li>
scwoop version 2.6 or above</li>

<li>
tkpiechart version 5.3 or above</li>
</ul>
at <a href="http://www.multimania.com/jfontain/">http://www.multimania.com/jfontain/</a>.
<h3>
<a NAME="architecture"></a>4. Architecture</h3>
The moodss application is composed of the core software and one or several
modules. Modules are implemented as Tcl packages and thus usually comprise
a Tcl source file and a pkgIndex.tcl file as required by the Tcl package
implementation.
<p>The core loads one or more modules, whose names are passed as command
line parameters or come from a save file, and starts displaying module
data in one or more tables. The tables are then updated at the frequency
defined by the poll time, which the user may change, or asynchronously
for the relevant modules. For example, to launch moodss with the random
module, just type (on a UNIX machine):
<pre>$ moodss random</pre>
All the module code and data are kept in a separate namespace. The module
data is stored is a single array including some configuration data used
when the module is loaded by the core, and variable data (displayed in
the application table and eventual graphical viewers). If a module is synchronous,
it must start updating its data when requested by the core. If a module
is asynchronous, its data may be updated at any time. The synchronous or
asynchronous nature is specified in the configuration data for the module.
<p>The initial data tables represent the first data views, from which any
number of cells can be selected. Data viewers can be created by dragging
and dropping cells into a graph, bar chart, pie chart, summary table or
free text iconic site. In turn, these viewers can display more table cells,
which when dropped into the viewer, result in the creation of corresponding
data graph lines, chart bars, pie slices, table rows or text cells. Cells
or rows can be removed from existing viewers, by simply selecting them
and dropping them in the trash iconic site (a bullet hole).
<p>Any viewer can be mutated (its type changed) by by dragging from a viewer
icon and dropping into it. For example, create a stacked data bar viewer
from several cells, then drag the 3D pie icon into it. Any viewer can also
be destroyed in one shot by dropping the trash icon into it.
<p>Any draggable data can be dropped in any valid drop site at any time.
It is thus possible to drag several data cells from any table or any viewer
into other ones, the trash, ... even if the data comes from different modules.
<p>All data viewers can be moved and resized at will with the help of a
simple internal window manager.
<p>The current configuration (loaded modules, tables and viewers coordinates,
sizes, poll time, main window size, ...) can be saved in a file at any
time, so that an identical dashboard can be relaunched at will.
<h3>
<a NAME="core"></a>5. Core</h3>

<h4>
<a NAME="userinterface"></a>5.1. User interface</h4>
Immediately after launch, module(s) is(are) loaded and initialized, with
corresponding messages displayed in the message area, as follows:
<center><pre><img SRC="moodss5.gif" height=54 width=234></pre></center>
Soon after, tabular data is displayed in one or more tkTable widgets with
the module identifier as title, automatic scroll bars, between the menu
bar, the drop sites with graphical viewers, summary table, free text and
trash icons and a message area, as one can see below:
<center><pre><img SRC="moodss1.gif" ALT="moodss initial main window view" NOSAVE height=515 width=505></pre></center>
The message area is used to display status information, such as when the
data is being updated, and help information, as the user moves the mouse
pointer over sensitive areas, such as table column headers. Contextual
help on all menu items is also activated as traversal occurs, either using
the mouse or the keyboard, resulting in a short explicative string appearing
in the message area and related to the active (highlighted) menu item.
Further help is provided through widget tips (also known as balloons) when
appropriate, and of course the Help menu.
<p>The window title shows the name of the loaded module(s) along with the
poll time.
<p>When several modules of the same type are loaded (for example, CPU statistics
on a group of servers), the initial data tables feature the module name
followed by an instance number (<i>module&lt;N></i>), or the module identifier
generated from the module code (<i>cpustats(host.domain.org)</i> for example).
A lone module keeps his unmodified name as table titles.
<p>The <i>File</i> menu contains the <i>Save</i>, <i>Save As</i> and <i>Exit</i>
menu entries, used to save the current configuration (modules and viewers),
or gracefully quit the moodss application.
<p>The <i>Edit</i> menu contains the <i>New</i> sub menu (only visible
when not running in read-only mode, see <a href="#commandline">Command
line</a>), which allows the creation of empty viewers of any type, and
the <i>Preferences</i> entry which when selected launches the following
dialog box:
<center><pre><img SRC="moodss6.gif" height=200 width=446></pre></center>
The Preferences dialog box allows the user to change application wide settings,
saved in a global file (known as an <i>rc</i> file to UNIX people), used
for initialization when the application is started. Since this file is
stored in the user home directory (on a UNIX system), it provides a way
for a user to customize the look, behavior, ... of the moodss application
in a permanent manner. Further and up-to-date help is always provided in
the different Preferences dialog box screens.
<p>The <i>View</i> menu (may not exist, see below) contains the <i>Poll
time</i> entry which when selected launches the corresponding dialog box,
as shown below:
<center><pre><img SRC="moodss2.gif" ALT="poll time dialog box" NOSAVE height=140 width=161></pre></center>
The user can select a new poll time among the module choices from a spin
entry widget, or directly type in a new value, as long as it is not smaller
than the module minimum poll time, in which case a warning message is displayed.
<p>When several modules are used, the minimum poll time is the greater
of the minimum poll times of all modules. The default poll time (used when
moodss is started) is the greater of the default poll times of all modules.
The available choices in the poll time dialog box is the combination of
all modules poll times.
<p>The <i>Poll time</i> menu entry is available only when needed, which
is not the case if all the loaded modules are asynchronous. If this case,
the <i>Options</i> menu itself is not displayed.
<p>Any data displayed in a table can be sorted at any time by simply clicking
on a column title. Clicking on the same column title again sorts the data
in opposite order, thus toggling between increasing and decreasing orders.
<br>When sorting, the selected column is used as a reference, meaning that
all rows will be rearranged so that the selected column appears sorted,
with values either increasing or decreasing.
<br>A little triangular indicator is placed to the right of the reference
column title label, pointing up or down depending on whether the sorting
order is decreasing or increasing.
<br>Table columns can be interactively resized by holding the first mouse
button down on a column border. The mouse cursor is changed to an horizontal
double arrow on column borders to show this capability.
<p>Aside from the main tables, graphical and textual viewers can be created
for monitoring table cell data over time. Viewers can also be deleted,
data views (such as pie slices, curves, ...) can be added or removed from
existing viewers, ... These functions are all implemented using the drag
and drop functionality described below.
<p>For all viewers, if a module identifier string is required (provided
by the module, several instances of the same module, ...) for proper cell
identification, that string will be placed first in the label. For example,
data cells originating from the third instance of the random module would
be labeled: "<i>random&lt;3>: data cell label"</i>.
<p>Graphical viewers available at this time are BLT graph viewers (see
images below), side-by-side bars charts, overlapped bars charts, stacked
bars charts, 2D pie charts and 3D pie charts*. Graph viewers feature an
automatic cross hair which follows the mouse pointer movements inside the
plotting area. Corresponding coordinates are updated in real time in the
main window message area.
<p>*<i>note: if you know of any other nice viewers (like 3D graphs) that
work with Tcl, please let me know so I can integrate them. Many thanks
in advance...</i>
<center><table COLS=2 WIDTH="100%" NOSAVE >
<tr ALIGN=CENTER VALIGN=CENTER NOSAVE>
<td NOSAVE>
<center><pre><img SRC="hgraph.gif" ALT="graph viewer sample" NOSAVE height=200 width=300></pre></center>
</td>

<td>
<pre><img SRC="hoverbar.gif" ALT="overlap bar chart viewer sample" NOSAVE height=200 width=300></pre>
</td>
</tr>

<tr ALIGN=CENTER VALIGN=CENTER NOSAVE>
<td NOSAVE>
<pre><img SRC="hsidebar.gif" ALT="side bar chart viewer sample" NOSAVE height=200 width=300></pre>
</td>

<td>
<pre><img SRC="hstackbr.gif" ALT="stacked bar chart viewer sample" NOSAVE height=200 width=300></pre>
</td>
</tr>

<tr ALIGN=CENTER VALIGN=CENTER NOSAVE>
<td NOSAVE>
<pre><img SRC="h2dpie.gif" ALT="2D pie chart viewer sample" NOSAVE height=200 width=300></pre>
</td>

<td>
<pre><img SRC="h3dpie.gif" ALT="3D pie chart viewer sample" NOSAVE height=200 width=300></pre>
</td>
</tr>
</table></center>
There are 2 textual viewers.
<p>The summary table displays for each row the cell label, the current,
average, minimum and maximum values since the row was created. Data cells
can be inserted one or several at a time through a simple drop. Rows can
be deleted by selecting any cell in the row then dropping any number of
them into the trash drop site. Data cells with missing data (could be no
longer available if coming from a vanished process, for example) display
the 000000 pattern.
<p>The free text viewer is an editable Tk text widget with any number (including
zero) of embedded data cell windows. Data cells can be inserted one or
several at a time through a simple drop, as with the other viewers. New
data cell windows are inserted at the current insertion cursor position.
Data cells can be deleted by selecting then dropping any number of them
into the trash drop site. They can also be deleted using the keyboard Delete
and Backspace keys, which also work on the regular text, as well as the
expected other key bindings. When dropping data cells, each data cell window
is preceded by a relevant label text for the cell, which can later be edited
at any time.
<center><table WIDTH="100%" NOSAVE >
<tr ALIGN=CENTER VALIGN=CENTER NOSAVE>
<td WIDTH="58%" NOSAVE>
<pre><img SRC="hsumtbl.gif" ALT="summary table viewer sample" NOSAVE height=200 width=350></pre>
</td>

<td WIDTH="42%" NOSAVE>
<pre><img SRC="hfreetxt.gif" ALT="free text viewer sample" NOSAVE height=200 width=250></pre>
</td>
</tr>
</table></center>
Here is a screen shot of loaded <i>ps</i> and <i>cpustats</i> modules with
several graphical viewers:
<center><pre><img SRC="moodss3.gif" ALT="moodss window with graph data viewers" NOSAVE height=553 width=538></pre></center>
All data viewers can be moved and resized thanks to handling areas in the
data viewer borders. When moving the mouse pointer over these areas, the
mouse cursor changes to indicate the possible action. Corner handles allow
resizing in both X and Y axis. Handles in the middle of the sides allow
resizing in either the X or Y axis direction. All other areas can be used
for moving the data viewer as shown by the quadruple arrow cursor. Clicking
on any part of the border changes the stacking order: the viewer being
clicked on either goes below (eventually becomes hidden) the other viewers,
or becomes fully visible (on top, eventually hiding other viewers). When
moving or resizing, the message area displays the current coordinates or
size in real time as the mouse is being moved. Further description of this
small window manager functionality is useless, as it behaves like a basic
window manager (let me know if it does not).
<p>Here is another shot featuring a free text viewer with loaded <i>cpustats</i>
and <i>memstats</i> modules:
<center><pre><img SRC="moodss4.gif" ALT="moodss window with free text data viewer" NOSAVE height=509 width=493></pre></center>
The <i>Help</i> menu contains <i>Global</i> help (actually launches an
embedded HTML viewer with this very document minus the sections related
to module development), <i>Modules</i> menu with one sub menu per module
(which displays the module's help data), <i>Copyright</i> which displays
the GPL (Gnu General Public License) document, <i>Source Versions </i>which
display all the source code file names with their versions and <i>About</i>
general information entries.
<h5>
<a NAME="draganddrop"></a>5.1.1 Drag and drop</h5>
Drag and drop in moodss tries to behave as the now familiar Windows functionality
(no, it doesn't mean I am a Bill Gates fan, as they probably stole the
idea from somebody else anyway :^). For example, to create a graphical
plot, one must first select one or more data cells in a data table, hold
down the first mouse button (the left one for a right handed user) while
dragging over to the left-most icon below the menu bar (when dragging an
object, as the mouse pointer passes over possible drop sites, they are
highlighted with a thin black border for user feedback). Releasing the
mouse button at this time results in the creation of a BLT graph viewer.
<p>Only valid drop sites for the data being dragged are highlighted when
the mouse cursor passes over them, thus guaranteeing error free operations
(if there are no bugs, that is :).
<p>In summary, data cells can be dragged from any table or any viewer into
any viewer drop site icon, any viewer or the trash can.
<h6>
<a NAME="dropsites"></a>5.1.1.1. Drop sites</h6>
All icons right below the menu bar are valid drop sites for data cells
(several may be dropped at the same time). From left to right:
<ul>
<li>
graph viewer with one or more data curves created at once</li>

<li>
side by side bar chart with one or more data bars created at once</li>

<li>
stacked bar chart with one or more data bars created at once</li>

<li>
2D pie chart with one or more data slices created at once</li>

<li>
3D pie chart with one or more data slices created at once</li>

<li>
summary table with one or more data rows created at once</li>

<li>
free text with one or more labeled data cell windows created at once</li>

<li>
object trash with one or more data viewer elements deleted at once</li>
</ul>
For example, a graph viewer with 1 curve is created by dropping 1 data
cell into the graph viewer icon.
<p>Once a viewer exists, it also acts as a drop site for data cells, which
may be dragged from any table or other viewers. Dropping one or more cells
directly in the viewer results in corresponding lines, bars, slices or
rows being created and automatically updated. Each new graphical element
is assigned a new and different color.
<p>You may delete one or more viewer elements (graph lines, bar chart bars,
pie charts slices, summary table rows or free text cell window) from a
viewer by selecting them (using the first mouse button) through their labels.
Several elements can be selected by depressing the control key as the first
mouse button is pressed. The selection can also be extended by depressing
the shift key along with the first mouse button. The pie slices can also
be directly selected by clicking on the slices themselves.
<br>Then dragging from the viewer to the trash drop site (the bullet hole)
on the upper right side of the main window and releasing the first mouse
button result in the corresponding viewer elements to be destroyed. When
there are no remaining elements, the viewer itself (graph, bar chart, pie
or summary table) can be destroyed by dropping it into the trash. The free
text viewer can only be deleted this way when completely emptied of any
text and data cell window.
<p>Any viewer can be deleted in one shot by dropping from the trash icon
into it.
<p>Any viewer also acts as a drop site for viewer type data, which allows
viewer mutation by just dropping from the new viewer type icon into the
existing viewer. It is much quicker than destroying the existing viewer
and create a new one of the new type, while remembering which data cells
were monitored by the viewer of the old type.
<br>When mutating, if some cells in the current viewer no longer exist
(they may belong to a disappeared summary table), they are not made a part
of the new viewer, and a warning message is flashed to the user in the
message area.
<h6>
<a NAME="dragsites"></a>5.1.1.2. Drag sites</h6>
A table is obviously a drag site. One or more cells can be dragged at once
after selection, using the traditional single/shift/control mouse click
technique.
<p>Any viewer is also a drag site. It requires selecting one or more viewer
elements before initiating the drag operation from any selected element
in the viewer. If there are no selected elements, dragging is impossible:
the mouse cursor is not changed into the drag circular cursor.
<p>If a viewer contains no elements, then the viewer itself can be dragged
and dropped into the trash.
<p>All viewer icons (below the menu bar) are drag sites for viewer type
data, which allows quick viewer mutation (see mechanism description in
<a href="#dropsites">Drop
sites</a>).
<p>The trash icon is also a drag site of the killing action type, which
allows viewer destruction in one shot.
<h5>
<a NAME="saving"></a>5.1.2 Saving</h5>
The current application configuration (including existing data viewers)
can be saved in a file, which achieves a dashboard functionality.
<p>Once moodss has been launched with one or several modules and tables
have been moved, resized, viewers created, moved and resized, the current
configuration can be saved in a .moo file, and later reused by passing
the corresponding file name with the -f (--file) command line switch.
<p>For moodss version 4.0 and above, the following information is saved
in the file (which is human readable):
<ul>
<li>
moodss version</li>

<li>
date and time</li>

<li>
application window size</li>

<li>
poll time</li>

<li>
modules</li>

<li>
tables positions and sizes</li>

<li>
viewers types, positions, sizes and specific data</li>
</ul>
For moodss version 5.1 and above, the following information is also saved:
<ul>
<li>
table viewers column widths</li>
</ul>
For moodss version 5.2 and above, the following information is also saved:
<ul>
<li>
viewers stacking order (for internal window manager)</li>
</ul>
When using the <i>File Save</i> menu for the first time, and if a file
name was not specified in the command line, the file selector dialog box
appears so that the user may choose a file name (with a .moo extension).
<p>The <i>File Save As</i> menu behaves as expected, with the user always
having to choose a file name.
<p>Once a file name has been specified (either through the command line
or the file selector dialog box), that file name is reused whenever the
<i>File
Save</i> menu is used. The <i>File Save As</i> menu may be used at any
time to change the file name.
<h4>
<a NAME="commandline"></a>5.2. Command line</h4>

<h5>
<a NAME="mainarguments"></a>5.2.1. Main arguments</h5>
Launching moodss is very simple: just pass one or more data module names
as parameters, as in:
<pre>&nbsp;&nbsp;&nbsp; $ wish moodss random</pre>
or, for 2 modules at once:
<pre>&nbsp;&nbsp;&nbsp; $ wish moodss ps cpustats</pre>
You can specify the same module more than once and with different arguments
in the command line:
<pre>&nbsp;&nbsp;&nbsp; $ wish moodss ps -r host.domain ps -r otherhost.domain</pre>
When several modules of the same type are passed as argument, the initial
data tables feature the module name followed by a number as title. For
example <i>"ps&lt;2>"</i>. If the module provides an identifier string,
that text will be used instead, as in <i>"ps(host.domain)"</i>. Data cell
labels include the module identifier or numbered module name as well, for
proper identification.
<p>You may eventually specify a poll time in seconds using:
<pre>&nbsp;&nbsp;&nbsp; $ wish moodss -p 25 random</pre>
Note that when all the specified modules are asynchronous, the poll time
option specifies the preferred interval for graph viewers.
<p>Once saved through the File Save menus (for example in save.moo) , the
configuration can be retrieved using:
<pre>&nbsp;&nbsp;&nbsp; $ wish moodss -f save.moo</pre>
which would result in the same modules being loaded, the same viewers displayed
at the same positions and sizes, the same poll time being used, as well
at the same application window size. New modules data displays can be added
at any latter time to existing dashboards by specifying modules on the
command line after the -f (--file) switch / value pair.
<p>Command line options include:
<ul>
<li>
<b>-f</b> (or <b>--file</b>): specify a configuration file name</li>

<li>
<b>-h</b> (or <b>--help</b>): display some help text and exit</li>

<li>
<b>-geometry</b>: set the initial geometry of the main window (a la X window)</li>

<li>
<b>-p</b> (or <b>--poll-time</b>): specify a poll time in seconds</li>

<li>
<b>-r</b> (or <b>--read-only</b>): disable viewer creation, editing, ...</li>

<li>
<b>-S</b> (or <b>--static</b>): disable internal window manager sizing
and moving</li>

<li>
<b>--show-modules</b>: discover valid moodss modules, show their directory
location(s) and exit</li>

<li>
<b>--version</b>: output version information and exit</li>
</ul>
Moodss command line options must appear before any module name appears
on the command line, so as not to interfere with the module options.
<h5>
<a NAME="modulearguments"></a>5.2.2. Module arguments</h5>
Module themselves can take options (if programmed to do so, see <a href="#initialization">module
initialization</a>), through command line arguments placed right after
the module name and before the next module name, if any.
<p>For example, the following command:
<pre>&nbsp;&nbsp;&nbsp; $ moodss -p 15 random --asynchronous arp --remote jdoe@foo.bar --numeric route --numeric</pre>
causes the <i>random</i> module to update asynchronously, the <i>arp</i>
module to collect data from the <i>foo.bar</i> host under the <i>jdoe</i>
login name and not attempt to lookup symbolic names for hosts, with the
last module <i>route</i> doing the same.
<p>Note the setting the application poll time to 15 seconds does not interfere
with the module options.
<p>The moodss core checks the validity of module options according to the
information provided by the module programmer. Any invalid option / value
combination for the module is detected, reported on the standard error
channel before the application exits.
</body>
</html>
}
