#!/bin/sh
# the next line restarts using wish \
exec wish8.0 "$0" "$@"       

# ---------------------------------------------------
# user changeable values

  set user "Holzer Andreas"
  set configs(program.all) { 4 x { 6 x { { stretch 7 } { relax 13 } } {pause 30} } }

  set configs(program.intro) 10
  # stretching time in seconds
  set configs(program.stretch) 7
  # relaxing time in seconds
  set configs(program.relax) 13
  # pause after one pass in seconds
  set configs(program.pause) 30

  # number of stretching/relaxing actions during one pass
  set program(onePass) 6
  # repeat factor for one pass
  set program(passes)  4

  set pictures(intro)   ./intro.gif
  set pictures(stretch) ./stretch.gif
  set pictures(relax)   ./relax.gif   
  set pictures(pause)   ./pause.gif

  set configs(color.intro)   lightblue
  set configs(color.stretch) red
  set configs(color.relax)   green
  set configs(color.pause)   lightgreen

  set configs(updateInterval) 1000

# ------------------------------------------------------------
# Very simple Program for muscle training
# dont look for programing beauty. It was thought to relax
# my muscles not to stretch
#
# it should also run on window systems, but I havent tried 
# yet (see above) 

# -------------------------------------------------------------
proc toTime { t } {

   set s [ expr $t % 60 ]
   set m [ expr ($t/60) % 60 ]
   return [ format "%02d:%02d" $m $s ]
}

# -------------------------------------------------------------
proc countdown { intervall timeVal mode } {

   incr timeVal -1

   global timeOne timeAll timeAllI

   incr timeAllI +1
   set  timeAll "Total Time: [ toTime $timeAllI ]"

   set  timeOne "[ toTime $timeVal ]"

   if { $timeVal > 0 } {
      after $intervall countdown $intervall $timeVal $mode
   } else {
     global ready
     set ready TRUE
   }
}

# ------------------------------------------------------------------
proc stretchOrRelax { pass1 pass2 action expl } {

   global configs
   global timeOne timeAll timeAllI passes onePass ready images widgets
   global explanation

   set countdownValue $configs(program.$action)
   set interval       $configs(updateInterval)

   .frame0.image configure -image $images($action) 

   set passes  [ expr $pass1 + 1 ]
   set onePass [ expr $pass2 + 1 ]
   set explanation $expl 

   set timeOne "[ toTime $countdownValue ]"

   .frame0.labelMode configure -background $configs(color.$action)

   after $interval countdown $interval $countdownValue $action

   tkwait variable ready
}

# ----------------------------------------------------------------  
  catch { source ~/.muscleTrainer.tcl }

  wm positionfrom . user
  wm sizefrom . ""
  wm title . "muscleTrainer: $user"
  wm resizable . false false

  # build widget .frame0
  frame .frame0 \
    -borderwidth {2} -height {30} \
    -relief {raised} -width {30}

  global timeOne timeAll pass ready

  set timeOne [ toTime 0 ]
  set timeAll "Total Time: [ toTime 0 ]"
  set timeAllI 0
  set passes   ""
  set onePass  ""
  set explanation ""

  set images(intro)   [ image create photo -file $pictures(intro) ]
  set images(stretch) [ image create photo -file $pictures(stretch) ] 
  set images(relax)   [ image create photo -file $pictures(relax) ] 
  set images(pause)   [ image create photo -file $pictures(pause) ] 

  # build widgets 
  label .frame0.image -background {grey} -image $images(intro)

  label .frame0.passes \
    -background {pink} -relief {sunken} \
    -textvariable passes 
 
  label .frame0.explanation \
    -background {grey} -relief {sunken} -padx 10 \
    -textvariable explanation -justify left -font { Times 14 italic }
    
  label .frame0.onePass \
    -background {pink} -relief {sunken} \
    -textvariable onePass 

  label .frame0.labelMode \
    -background {green} -relief {sunken} -anchor c \
    -textvariable timeOne -padx 10 -height 2

  label .label3 \
    -background {yellow} -relief {sunken} \
    -textvariable timeAll -height 2 -padx 10

  button .start -command { set start Go }  -text "Go"

  # pack them
  pack configure .frame0.image \
    -expand 1 -fill x -side left

  pack configure .frame0.explanation \
    -expand 1 -fill x -side right

  pack configure .frame0 -fill x
  
  pack configure .start -side bottom -fill x

  # lets go

  set explanation \
  { 
    This program trains your muscles to 
    prevent pain caused by mainly 
    sitting work.
    There are two phases: Streching and
    relaxing. If stretching takes place 
    then stretch the affected muscle area 
    as hard as you can. Afterwards relax.
    Please note that the intervalls for
    stretching and relaxing are my personal
    ones. Your values can be examined by
    an experienced trainer using sensors
    in one training session. 

    Enjoy, Andreas

  }

  tkwait variable start

  pack unpack .frame0.image  
  pack unpack .frame0.explanation
  pack unpack .start

  .frame0.explanation configure -height 2 

  pack configure .frame0.labelMode \
    -expand 1 -fill x -side top

  pack configure .frame0.image \
    -expand 1 -fill x -side top

  pack configure .frame0.explanation \
    -expand 1 -fill x -side top

  pack configure .frame0 -fill x

  pack configure .frame0.passes \
    -expand 1 -fill x -side left

  pack configure .frame0.onePass \
    -expand 1 -fill x -side right

  pack configure .label3 -fill x

  for { set i1 0 } { $i1 < $program(passes) } { incr i1 +1 } {
    for { set i2 0 } { $i2 < $program(onePass) } { incr i2 +1 } {
        
        stretchOrRelax $i1 $i2 stretch {stretch your muscles}     
        stretchOrRelax $i1 $i2 relax {relax all your muscles}      
    }
    stretchOrRelax $i1 "-1"  pause { some more time to relax }      
  }

  destroy .

