#
#  finance.yahoo.com stock service
#  yahoo provides a nice 'csv' format, easy to parse
#  decimal values returned by yahoo

proc finance.yahoo.com {} {
    global ticker_symbols data
    set i 0
    set symbol_list ""
    while {[info exists ticker_symbols([incr i])]} {
	lappend symbol_list $ticker_symbols($i)
    }
    if {[llength $symbol_list] == 0} {
        return 0
    }
    set symvar [cgi_cgi_set s $symbol_list]
    set timeout [expr {3 * 60000}]
    set id [http::geturl \
        http://finance.yahoo.com/d/quotes.csv?f=sl1d1t1c1ohgv&e=.csv&$symvar \
	-timeout $timeout]
    if {"[http::wait $id]" != "ok"} {
	return 0
    }
    set html [http::data $id]
    catch {unset $id}
    foreach line [split $html \n] {
	# further split on comma to separate quote values
	set datavals [split $line ,]
	if {[llength $datavals] != 9} continue
	foreach {sym last date time change bid ask open vol} $datavals {
	    break
	}
	# remove double quotes around symbols
	regsub -all \" $sym {} sym
	# make sure symbol and quote values are valid
	if {[string length $sym] == 0} continue
	if {[scan $last   %f v] != 1}  continue
	if {[scan $change %f v] != 1}  continue

	set newdata($sym,last) $last
        if {$change > 0} {
	    set newdata($sym,sign) +
	} elseif {$change < 0} {
	    set newdata($sym,sign) -
	} else {
	    set newdata($sym,sign) =
	}
	set newdata($sym,delta) $change
    }
    catch {unset data}
    global data
    array set data [array get newdata]
    return 1
}


proc finance.yahoo.com_lookup {str} {
    if {[string length $str] == 0} {
        return ""
    }
    set symco_list ""
    set symvar [cgi_cgi_set s $str]
    set timeout [expr {3 * 60000}]
    set id [http::geturl http://finance.yahoo.com/l?$symvar -timeout $timeout]
    if {"[http::wait $id]" != "ok"} {
	return ""
    }
    set html [http::data $id]
    catch {unset $id}
    if {[regexp -nocase {returned no matches} $html]} {
	return ""
    }
    if {[regexp -indices {returned:} $html indx]} {
        set html [string range $html [lindex $indx 1] end]
    }
    # clean up newlines and special characters
    regsub -all \n $html { } html
    regsub -all \r $html { } html
    regsub -all {&nbsp;} $html { } html
    # make each table row a newline so with can split on it
    regsub -all -nocase {</tr>} $html \n html
    foreach line [lrange [split $html \n] 1 end] {
	# make the table data tags a newline so we can further split it
	regsub -all -nocase {</td>} $line \n line
	# remove all other html tags
	regsub -all {<[^>]*>} $line { } line
	# remove any left over html tag stuff
	regsub -all {>} $line {} line
	# make multiple whitespace into a single space
	regsub -all "\[ \t\]\[ \t\]?" $line { } line
	set line [split $line \n]
	if {[llength $line] == 3} {
	    set sym [string trim [lindex $line 0]]
	    set co  [string trim [lindex $line 1]]
	    lappend symco_list $sym $co
	}
    }
    return $symco_list
}


