class
	--
	-- Adds appropriate tclmidi parsing and formatting features to
	-- EVENTS
	--
	ANNOTATOR

creation
	make

feature -- Initialization
	make(context: COMMAND_CONTEXT) is
			-- create annotator
		do
			!!channel_pressure.make(context)
			!!key_pressure.make(context)
			!!meta_channel_prefix.make(context)
			!!meta_copyright.make(context)
			!!meta_cue.make(context)
			!!meta_end_of_track.make(context)
			!!meta_instrument_name.make(context)
			!!meta_key.make(context)
			!!meta_lyric.make(context)
			!!meta_marker.make(context)
			!!meta_port_number.make(context)
			!!meta_sequence_name.make(context)
			!!meta_sequence_number.make(context)
			!!meta_smpte.make(context)
			!!meta_tempo.make(context)
			!!meta_text.make(context)
			!!meta_time.make(context)
			!!meta_unknown.make(context)
			!!note_off.make(context)
			!!note_on.make(context)
			!!parameter.make(context)
			!!pitch_wheel.make(context)
			!!program.make(context)
			!!system_exclusive.make(context)
		end

feature -- Implementation
	annotate_event(e: EVENT) is
			-- add tclmidi parsing/formatting to an event
		require
			not_void: e /= Void
		local
			channel_pressure_event: CHANNEL_PRESSURE_EVENT
			key_pressure_event: KEY_PRESSURE_EVENT
			meta_channel_prefix_event: META_CHANNEL_PREFIX_EVENT
			meta_copyright_event: META_COPYRIGHT_EVENT
			meta_cue_event: META_CUE_EVENT
			meta_end_of_track_event: META_END_OF_TRACK_EVENT
			meta_instrument_name_event: META_INSTRUMENT_NAME_EVENT
			meta_key_event: META_KEY_EVENT
			meta_lyric_event: META_LYRIC_EVENT
			meta_marker_event: META_MARKER_EVENT
			meta_port_number_event:META_PORT_NUMBER_EVENT
			meta_sequence_name_event: META_SEQUENCE_NAME_EVENT
			meta_sequence_number_event: META_SEQUENCE_NUMBER_EVENT
			meta_smpte_event: META_SMPTE_EVENT
			meta_tempo_event: META_TEMPO_EVENT
			meta_text_event: META_TEXT_EVENT
			meta_time_event: META_TIME_EVENT
			meta_unknown_event: META_UNKNOWN_EVENT
			note_off_event: NOTE_OFF_EVENT
			note_on_event: NOTE_ON_EVENT
			parameter_event: PARAMETER_EVENT
			pitch_wheel_event: PITCH_WHEEL_EVENT
			program_event: PROGRAM_EVENT
			system_exclusive_event: SYSTEM_EXCLUSIVE_EVENT
		do
			channel_pressure_event ?= e
			key_pressure_event ?= e
			meta_channel_prefix_event ?= e
			meta_copyright_event ?= e
			meta_cue_event ?= e
			meta_end_of_track_event ?= e
			meta_instrument_name_event ?= e
			meta_key_event ?= e
			meta_lyric_event ?= e
			meta_marker_event ?= e
			meta_port_number_event ?= e
			meta_sequence_name_event ?= e
			meta_sequence_number_event ?= e
			meta_smpte_event ?= e
			meta_tempo_event ?= e
			meta_text_event ?= e
			meta_time_event ?= e
			meta_unknown_event ?= e
			note_off_event ?= e
			note_on_event ?= e
			parameter_event ?= e
			pitch_wheel_event ?= e
			program_event ?= e
			system_exclusive_event ?= e

			if note_on_event /= Void then
				e.set_syntax(note_on)
			elseif note_off_event /= Void then
				e.set_syntax(note_off)
			elseif parameter_event /= Void then
				e.set_syntax(parameter)
			elseif program_event /= Void then
				e.set_syntax(program)
			elseif pitch_wheel_event /= Void then
				e.set_syntax(pitch_wheel)
			elseif key_pressure_event /= Void then
				e.set_syntax(key_pressure)
			elseif channel_pressure_event /= Void then
				e.set_syntax(channel_pressure)

			elseif meta_tempo_event /= Void then
				e.set_syntax(meta_tempo)
			elseif meta_time_event /= Void then
				e.set_syntax(meta_time)
			elseif meta_key_event /= Void then
				e.set_syntax(meta_key)
			elseif meta_end_of_track_event /= Void then
				e.set_syntax(meta_end_of_track)
			elseif meta_smpte_event /= Void then
				e.set_syntax(meta_smpte)
			elseif meta_channel_prefix_event /= Void then
				e.set_syntax(meta_channel_prefix)
			elseif meta_copyright_event /= Void then
				e.set_syntax(meta_copyright)
			elseif meta_cue_event /= Void then
				e.set_syntax(meta_cue)
			elseif meta_instrument_name_event /= Void then
				e.set_syntax(meta_instrument_name)
			elseif meta_lyric_event /= Void then
				e.set_syntax(meta_lyric)
			elseif meta_marker_event /= Void then
				e.set_syntax(meta_marker)
			elseif meta_sequence_name_event /= Void then
				e.set_syntax(meta_sequence_name)
			elseif meta_text_event /= Void then
				e.set_syntax(meta_text)
			elseif meta_sequence_number_event /= Void then
				e.set_syntax(meta_sequence_number)
			elseif meta_port_number_event /= Void then
				e.set_syntax(meta_port_number)
			elseif meta_unknown_event /= Void then
				e.set_syntax(meta_unknown)
			elseif system_exclusive_event /= Void then
				e.set_syntax(system_exclusive)
			end
		end

feature {NONE} -- Implementation
	channel_pressure: SYNTAX_CHANNEL_PRESSURE
	key_pressure: SYNTAX_KEY_PRESSURE
	meta_channel_prefix: SYNTAX_META_CHANNEL_PREFIX
	meta_copyright: SYNTAX_META_COPYRIGHT
	meta_cue: SYNTAX_META_CUE
	meta_end_of_track: SYNTAX_META_END_OF_TRACK
	meta_instrument_name: SYNTAX_META_INSTRUMENT_NAME
	meta_key: SYNTAX_META_KEY
	meta_lyric: SYNTAX_META_LYRIC
	meta_marker: SYNTAX_META_MARKER
	meta_port_number: SYNTAX_META_PORT_NUMBER
	meta_sequence_name: SYNTAX_META_SEQUENCE_NAME
	meta_sequence_number: SYNTAX_META_SEQUENCE_NUMBER
	meta_smpte: SYNTAX_META_SMPTE
	meta_tempo: SYNTAX_META_TEMPO
	meta_text: SYNTAX_META_TEXT
	meta_time: SYNTAX_META_TIME
	meta_unknown: SYNTAX_META_UNKNOWN
	note_off: SYNTAX_NOTE_OFF
	note_on: SYNTAX_NOTE_ON
	parameter: SYNTAX_PARAMETER
	pitch_wheel: SYNTAX_PITCH_WHEEL
	program: SYNTAX_PROGRAM
	system_exclusive: SYNTAX_SYSTEM_EXCLUSIVE

end -- ANNOTATOR
