class
	--
	-- The midifree command implementation
	--
	COMMAND_MIDI_FREE

inherit
	TCLMIDI_COMMAND

creation
	make

feature {TCLMIDI_COMMAND} -- Access
	command_name: STRING is
			-- command name
		do
			Result := "midifree"
		end

	usage: STRING is
			-- command syntax
		once
			!!Result.copy(command_name)
			Result.append(" SongID")
		end

feature -- Actions
	check_syntax is
			-- check for valid arguments
		do
			if arguments.count /= 2 then
				syntax_valid := False
				error := True
				!!command_result.copy("wrong # args: should be %"")
				command_result.append(usage)
				command_result.append("%"")
			else
				if not context.song_table.has(arguments.item(2)) then
					syntax_valid := False
					error := True
					!!command_result.copy("invalid SongID '")
					command_result.append(arguments.item(2))
					command_result.append("'")
				else
					syntax_valid := True
					error := False
				end
			end
		end

	execute is
			-- execute command
		do
			context.song_table.remove(arguments.item(2))
		ensure
			removed: not context.song_table.has(arguments.item(2))
		end

end -- COMMAND_MIDI_FREE
