class
	--
	-- The midimake command implementation
	--
	COMMAND_MIDI_MAKE

inherit
	TCLMIDI_COMMAND

creation
	make

feature {TCLMIDI_COMMAND} -- Access
	command_name: STRING is
			-- command name
		do
			Result := "midimake"
		end

	usage: STRING is
			-- command syntax
		once
			!!Result.copy(command_name)
		end

feature -- Actions
	check_syntax is
			-- check for valid arguments
		do
			if arguments.count = 1 then
				syntax_valid := True
				error := False
			else
				syntax_valid := False
				error := True
				!!command_result.copy("wrong # args: should be %"")
				command_result.append(usage)
				command_result.append("%"")
			end
		end

	execute is
			-- execute command
		local
			song: SONG
		do
			-- make a new song
			!!song.make

			-- add it to the song table
			command_result := context.song_table.add(song)
		ensure
			new_song: context.song_table.has(command_result)
		end

end -- COMMAND_MIDI_MAKE
