class
	--
	-- The midimerge command implementation
	--
	COMMAND_MIDI_MERGE

inherit
	TCLMIDI_COMMAND

creation
	make

feature {TCLMIDI_COMMAND} -- Access
	command_name: STRING is
			-- command name
		do
			Result := "midimerge"
		end

	usage: STRING is
			-- command syntax
		once
			!!Result.copy(command_name)
			Result.append(" {DestSongID DestTrack} {SrcSongID SrcTrack} %
				%?{SrcSongId SrcTrack} ...?")
		end

feature -- Actions
	check_syntax is
			-- check for valid arguments
		local
			track: TRACK_NUMBER
			arg: INTEGER
			tcl_list: TCL_LIST
		do
			if arguments.count < 3 then
				syntax_valid := False
				error := True
				!!command_result.copy("wrong # args: should be %"")
				command_result.append(usage)
				command_result.append("%"")
			end

			-- verify each song/track pair
			from
				arg := 2
			until
				arg > arguments.count or else error
			loop
				!!tcl_list.make_from_list(context.tcl_interp,
					arguments.item(arg))
				tcl_list.split
				if tcl_list.error then
					error := True
				end

				if not error then
					if tcl_list.split_list.count /= 2 then
						error := True
						syntax_valid := False
						!!command_result.copy("Invalid Song/Track %
							%identifier '")
						command_result.append(arguments.item(arg))
						command_result.append("'")
					end
				end

				if not error then
					if not context.song_table.has(
						tcl_list.split_list.item(1)) then
						syntax_valid := False
						error := True
						!!command_result.copy("invalid SongID '")
						command_result.append(tcl_list.split_list.item(1))
						command_result.append("'")
					end
				end

				if not error then
					-- verify valid track number
					!!track.make
					track.set_context(context)
					track.set_song(context.song_table.get(
						tcl_list.split_list.item(1)))
					track.check_track_identifier(tcl_list.split_list.item(2))
					if track.is_valid then
					syntax_valid := True
						error := False
					else
						syntax_valid := False
						error := True
						command_result := track.error_description
					end
				end

				arg := arg + 1
			end
		end

	execute is
			-- execute command
		local
			dest_song, src_song: SONG
			dest_track, src_track: TRACK
			tcl_list: TCL_LIST
			track_id: TRACK_NUMBER
			arg: INTEGER
		do
			!!tcl_list.make_from_list(context.tcl_interp, arguments.item(2))
			tcl_list.split

			dest_song := context.song_table.get(tcl_list.split_list.item(1))
			!!track_id.make
			track_id.set_context(context)
			track_id.set_song(dest_song)
			track_id.set_track_identifier(tcl_list.split_list.item(2))
			dest_track := dest_song.track(track_id.track_number)

			from
				arg := 3
			until
				arg > arguments.count or else error
			loop
				!!tcl_list.make_from_list(context.tcl_interp,
					arguments.item(arg))
				tcl_list.split

				src_song := context.song_table.get(tcl_list.split_list.item(1))
				!!track_id.make
				track_id.set_context(context)
				track_id.set_song(src_song)
				track_id.set_track_identifier(tcl_list.split_list.item(2))
				src_track := src_song.track(track_id.track_number)

				src_track.start
				src_track.mark_in
				src_track.finish
				src_track.forth
				src_track.mark_out

				src_track.copy_range(dest_track, src_track.in_point)

				arg := arg + 1
			end
		end

end -- COMMAND_MIDI_MERGE
