class
	--
	-- The midirewind command implementation
	--
	COMMAND_MIDI_REWIND

inherit
	TCLMIDI_COMMAND

creation
	make

feature {TCLMIDI_COMMAND} -- Access
	command_name: STRING is
			-- command name
		do
			Result := "midirewind"
		end

	usage: STRING is
			-- command syntax
		once
			!!Result.copy(command_name)
			Result.append(" SongID ?track?")
		end

feature -- Actions
	check_syntax is
			-- check for valid arguments
		local
			track: TRACK_NUMBER
		do
			if arguments.count < 2 or else arguments.count > 3 then
				syntax_valid := False
				error := True
				!!command_result.copy("wrong # args: should be %"")
				command_result.append(usage)
				command_result.append("%"")
			else
				if not context.song_table.has(arguments.item(2)) then
					syntax_valid := False
					error := True
					!!command_result.copy("invalid SongID '")
					command_result.append(arguments.item(2))
					command_result.append("'")
				else
					if arguments.count = 2 then
						syntax_valid := True
						error := False
					else
						-- verify valid track number
						!!track.make
						track.set_context(context)
						track.set_song(context.song_table.get(
						    arguments.item(2)))
						track.check_track_identifier(arguments.item(3))
						if track.is_valid then
							syntax_valid := True
							error := False
						else
							syntax_valid := False
							error := True
							command_result := track.error_description
						end
					end
				end
			end
		end

	execute is
			-- execute command
		local
			song: SONG
			track: TRACK_NUMBER
			start_track, end_track, t: INTEGER
		do
			song := context.song_table.get(arguments.item(2))
			if arguments.count = 2 then
				start_track := 1
				end_track := song.number_of_tracks
			else
				!!track.make
				track.set_context(context)
				track.set_song(song)
				track.set_track_identifier(arguments.item(3))
				start_track := track.track_number
				end_track := track.track_number
			end

			from
				t := start_track
			until
				t > end_track
			loop
				if not song.track(t).empty then
					song.track(t).start
					-- back up to before track start
					song.track(t).back
				end
				t := t + 1
			end
		end

end -- COMMAND_MIDI_REWIND
