class
	--
	-- Generate MIDI EVENTs from tclmidi syntax
	--
	EVENT_FACTORY

creation
	make

feature -- Initialization
	make(a: ANNOTATOR) is
			-- create the event factory
		require
			not_void: a /= Void
		do
			annotator := a
		ensure
			annotator_set: annotator = a
		end

feature -- Access
	annotator: ANNOTATOR
	event_description: ARRAY[STRING]
	error: BOOLEAN
	error_description: STRING

feature -- Element Change
	set_event_description(d: like event_description) is
			-- set the tclmidi event description
		require
			not_void: d /= Void
		do
			event_description := d
		ensure
			description_set: event_description = d
		end

feature -- Action
	create_event: EVENT is
			-- create an event from the description
		require
			has_description: event_description /= Void
		local
			event_name: STRING
		do
			error := False
			event_name := event_description.item(2)
			inspect
				event_name.item(1).to_lower
			when 'c' then
				if event_name.same_as("ChannelPressure") then
					!CHANNEL_PRESSURE_EVENT!Result.make
				end
			when 'k' then
				if event_name.same_as("KeyPressure") then
					!KEY_PRESSURE_EVENT!Result.make
				end
			when 'm' then
				-- meta event
				inspect
					event_name.item(5).to_lower
				when 'c' then
					if event_name.same_as("MetaChannelPrefix") then
						!META_CHANNEL_PREFIX_EVENT!Result.make
					elseif event_name.same_as("MetaCopyright") then
						!META_COPYRIGHT_EVENT!Result.make
					elseif event_name.same_as("MetaCue") then
						!META_CUE_EVENT!Result.make
					end
				when 'e' then
					if event_name.same_as("MetaEndOfTrack") then
						!META_END_OF_TRACK_EVENT!Result.make
					end
				when 'i' then
					if event_name.same_as("MetaInstrumentName") then
						!META_INSTRUMENT_NAME_EVENT!Result.make
					end
				when 'k' then
					if event_name.same_as("MetaKey") then
						!META_KEY_EVENT!Result.make
					end
				when 'l' then
					if event_name.same_as("MetaLyric") then
						!META_LYRIC_EVENT!Result.make
					end
				when 'm' then
					if event_name.same_as("MetaMarker") then
						!META_MARKER_EVENT!Result.make
					end
				when 'p' then
					if event_name.same_as("MetaPortNumber") then
						!META_PORT_NUMBER_EVENT!Result.make
					end
				when 's' then
					if event_name.same_as("MetaSequenceName") then
						!META_SEQUENCE_NAME_EVENT!Result.make
					elseif event_name.same_as("MetaSequenceNumber") then
						!META_SEQUENCE_NUMBER_EVENT!Result.make
					elseif event_name.same_as("MetaSMPTE") then
						!META_SMPTE_EVENT!Result.make
					end
				when 't' then
					if event_name.same_as("MetaTempo") then
						!META_TEMPO_EVENT!Result.make
					elseif event_name.same_as("MetaText") then
						!META_TEXT_EVENT!Result.make
					elseif event_name.same_as("MetaTime") then
						!META_TIME_EVENT!Result.make
					end
				when 'u' then
					if event_name.same_as("MetaUnknown") then
						!META_UNKNOWN_EVENT!Result.make
					end
				end
			when 'n' then
					if event_name.same_as("NoteOn") then
						!NOTE_ON_EVENT!Result.make
					elseif event_name.same_as("NoteOff") then
						!NOTE_OFF_EVENT!Result.make
					elseif event_name.same_as("Note") then
						-- Only make NoteOn, NoteOff happend elsewhere
						!NOTE_ON_EVENT!Result.make
					end
			when 'p' then
					if event_name.same_as("Parameter") then
						!PARAMETER_EVENT!Result.make
					elseif event_name.same_as("PitchWheel") then
						!PITCH_WHEEL_EVENT!Result.make
					elseif event_name.same_as("Program") then
						!PROGRAM_EVENT!Result.make
					end
			when 's' then
					if event_name.same_as("SystemExclusive") then
						!SYSTEM_EXCLUSIVE_EVENT!Result.make
					end
			end

			if Result = Void then
				error := True
				!!error_description.copy("No such event type '")
				error_description.append(event_name)
				error_description.append("'")
			else
				annotator.annotate_event(Result)

				Result.syntax.parse(Result, event_description)

				if Result.syntax.error then
					error := True
					error_description := Result.syntax.error_description
				end
			end
		end

end -- EVENT_FACTORY
