class
	--
	-- tclmidi syntax for meta_smpte events
	--
	SYNTAX_META_SMPTE

inherit
	EVENT_SYNTAX
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "MetaSMPTE" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a meta smpte event from arguments
		local
			smpte: META_SMPTE_EVENT
			h, m, s, f, ff: INTEGER
			max_frame: INTEGER
		do
			error := False
			if args.count /= 8 then
				error := True
				error_description := "wrong number of args: should be %
					%'time MetaSMPTE 24|25|30df|30ndf hour minute second frame %
					%fractional_frame'";
			else
				smpte ?= e

				if args.item(3).is_equal("*") then
					max_frame := 30
					smpte.set_format_wildcard
				elseif args.item(3).is_equal("24") then
					max_frame := 24
					smpte.set_format(smpte.Format_24)
				elseif args.item(3).is_equal("25") then
					max_frame := 25
					smpte.set_format(smpte.Format_25)
				elseif args.item(3).same_as("30df") then
					max_frame := 30
					smpte.set_format(smpte.Format_30_df)
				elseif args.item(3).same_as("30ndf") then
					max_frame := 30
					smpte.set_format(smpte.Format_30_ndf)
				else
					error := True
					!!error_description.copy("Invalid format '")
					error_description.append(args.item(3))
					error_description.append("'")
				end

				if not error then
					if not args.item(4).is_integer then
						if args.item(4).is_equal("*") then
							smpte.set_hour_wildcard
						else
							error := True
							!!error_description.copy("Invalid hour '")
							error_description.append(args.item(4))
							error_description.append("'")
						end
					else
						h := args.item(4).to_integer
						if h >= 0 and then h <= 24 then
							smpte.set_hour(h)
						else
							error := True
							!!error_description.copy("Invalid hour value '")
							error_description.append(args.item(4))
							error_description.append("': should be in range 0 %
								%to 24")
						end
					end
				end

				if not error then
					if not args.item(5).is_integer then
						if args.item(5).is_equal("*") then
							smpte.set_minute_wildcard
						else
							error := True
							!!error_description.copy("Invalid minute '")
							error_description.append(args.item(5))
							error_description.append("'")
						end
					else
						m := args.item(5).to_integer
						if m >= 0 and then m <= 59 then
							smpte.set_minute(m)
						else
							error := True
							!!error_description.copy("Invalid minute value '")
							error_description.append(args.item(5))
							error_description.append("': should be in range 0 %
								%to 59")
						end
					end
				end

				if not error then
					if not args.item(6).is_integer then
						if args.item(6).is_equal("*") then
							smpte.set_second_wildcard
						else
							error := True
							!!error_description.copy("Invalid second '")
							error_description.append(args.item(6))
							error_description.append("'")
						end
					else
						s := args.item(6).to_integer
						if s >= 0 and then s <= 59 then
							smpte.set_second(s)
						else
							error := True
							!!error_description.copy("Invalid second value '")
							error_description.append(args.item(6))
							error_description.append("': should be in range 0 %
								%to 59")
						end
					end
				end

				if not error then
					if not args.item(7).is_integer then
						if args.item(7).is_equal("*") then
							smpte.set_frame_wildcard
						else
							error := True
							!!error_description.copy("Invalid frame '")
							error_description.append(args.item(7))
							error_description.append("'")
						end
					else
						f := args.item(7).to_integer
						if f >= 0 and then f <= max_frame then
							smpte.set_frame(f)
						else
							error := True
							!!error_description.copy("Invalid frame value '")
							error_description.append(args.item(7))
							error_description.append("': should be in range 0 %
								%to ")
							error_description.append(max_frame.to_string)
						end
					end
				end

				if not error then
					if not args.item(8).is_integer then
						if args.item(8).is_equal("*") then
							smpte.set_fractional_frame_wildcard
						else
							error := True
							!!error_description.copy("Invalid fractional %
								%frame '")
							error_description.append(args.item(8))
							error_description.append("'")
						end
					else
						ff := args.item(8).to_integer
						if ff >= 0 and then ff <= 99 then
							smpte.set_fractional_frame(ff)
						else
							error := True
							!!error_description.copy("Invalid fractional frame %
								%value '")
							error_description.append(args.item(8))
							error_description.append("': should be in range 0 %
								%to 99")
						end
					end
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			smpte: META_SMPTE_EVENT
		do
			smpte ?= e
			if smpte.format_wildcard then
				!!Result.copy("*")
			else
				if smpte.format = smpte.Format_24 then
					!!Result.copy("24")
				elseif smpte.format = smpte.Format_25 then
					!!Result.copy("25")
				elseif smpte.format = smpte.Format_30_df then
					!!Result.copy("30df")
				elseif smpte.format = smpte.Format_30_ndf then
					!!Result.copy("30ndf")
				end
			end

			Result.append(" ")
			if smpte.hour_wildcard then
				Result.append("*")
			else
				Result.append(smpte.hour.to_string)
			end

			Result.append(" ")
			if smpte.minute_wildcard then
				Result.append("*")
			else
				Result.append(smpte.minute.to_string)
			end

			Result.append(" ")
			if smpte.second_wildcard then
				Result.append("*")
			else
				Result.append(smpte.second.to_string)
			end

			Result.append(" ")
			if smpte.frame_wildcard then
				Result.append("*")
			else
				Result.append(smpte.frame.to_string)
			end

			Result.append(" ")
			if smpte.fractional_frame_wildcard then
				Result.append("*")
			else
				Result.append(smpte.fractional_frame.to_string)
			end
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a META_SMPTE_EVENT?
		local
			smpte: META_SMPTE_EVENT
		do
			smpte ?= e
			Result := smpte /= Void
		end

end -- SYNTAX_META_SMPTE
