class
	--
	-- tclmidi syntax for meta_tempo events
	--
	SYNTAX_META_TEMPO

inherit
	EVENT_SYNTAX
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "MetaTempo" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a meta smpte event from arguments
		local
			tempo: META_TEMPO_EVENT
			t: INTEGER
		do
			error := False
			if args.count /= 3 then
				error := True
				error_description := "wrong number of args: should be %
					%'time MetaTempo tempo'";
			else
				tempo ?= e

				if not args.item(3).is_integer then
					if args.item(3).is_equal("*") then
						tempo.set_tempo_wildcard
					else
						error := True
						!!error_description.copy("Invalid tempo '")
						error_description.append(args.item(3))
						error_description.append("'")
					end
				else
					t := args.item(3).to_integer
					if t >= 0 then
						tempo.set_tempo(t)
					else
						error := True
						!!error_description.copy("Invalid tempo value '")
						error_description.append(args.item(3))
						error_description.append("': should be greater than 0")
					end
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			tempo: META_TEMPO_EVENT
		do
			tempo ?= e
			if tempo.tempo_wildcard then
				!!Result.copy("*")
			else
				!!Result.copy(tempo.tempo.to_string)
			end
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a META_TEMPO_EVENT?
		local
			tempo: META_TEMPO_EVENT
		do
			tempo ?= e
			Result := tempo /= Void
		end

end -- SYNTAX_META_TEMPO
