class
	--
	-- tclmidi syntax for program events
	--
	SYNTAX_PROGRAM

inherit
	SYNTAX_CHANNEL
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "Program" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a channel event from arguments
		local
			program: PROGRAM_EVENT
			prog: INTEGER
		do
			error := False
			if args.count /= 4 then
				error := True
				error_description := "wrong number of args: should be %
					%'time Program channel program'";
			else
				precursor(e, args)
				if not error then
					program ?= e

					-- fourth argument should be pressure
					if not args.item(4).is_integer then
						if args.item(4).is_equal("*") then
							program.set_program_wildcard
						else
							error := True
							!!error_description.copy("Invalid program value '")
							error_description.append(args.item(4))
							error_description.append("'")
						end
					else
						prog := args.item(4).to_integer
						if prog >= 0 and then prog <= 128 then
							program.set_program(prog)
						else
							error := True
							!!error_description.copy("Invalid program value '")
							error_description.append(args.item(4))
							error_description.append("': should be in range %
								%0 to 128")
						end
					end
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			program: PROGRAM_EVENT
		do
			Result := precursor(e)

			program ?= e
			Result.append(" ")
			if program.program_wildcard then
				Result.append("*")
			else
				Result.append(program.program.to_string)
			end
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a PROGRAM_EVENT?
		local
			program: PROGRAM_EVENT
		do
			program ?= e
			Result := program /= Void
		end

end -- SYNTAX_PROGRAM
