class
	--
	-- tclmidi syntax for system exclusive events
	--
	SYNTAX_SYSTEM_EXCLUSIVE

inherit
	EVENT_SYNTAX
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "SystemExclusive" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a system exclusive event from arguments
		local
			sys_ex: SYSTEM_EXCLUSIVE_EVENT
			continued: BOOLEAN
			i: INTEGER
			tcl_list: TCL_LIST
			data_list: ARRAY[STRING]
			data: ARRAY[INTEGER]
		do
			error := False
			if args.count /= 4 then
				error := True
				error_description := "wrong number of args: should be %
					%'time SystemExclusive continued_boolean data'";
			else
				sys_ex ?= e

				if args.item(3).is_equal("*") then
					sys_ex.set_continued_wildcard
				elseif args.item(3).is_equal("1") or else
					args.item(3).same_as("t") or else
					args.item(3).same_as("true") or else
					args.item(3).same_as("on") then
					sys_ex.set_continued(True)
				elseif args.item(3).is_equal("0") or else
					args.item(3).same_as("f") or else
					args.item(3).same_as("false") or else
					args.item(3).same_as("off") then
					sys_ex.set_continued(False)
				else
					error := True
					!!error_description.copy("Invalid continued boolean '")
					error_description.append(args.item(3))
					error_description.append("'")
				end

				if not error then
					if args.item(4).is_equal("*") then
						sys_ex.set_data_wildcard
					else
						!!tcl_list.make_from_list(context.tcl_interp,
							args.item(4))
						tcl_list.split
						if tcl_list.error then
							error := True
						else
							data_list := tcl_list.split_list
							!!data.make(1, data_list.count)
							from
								i := 1
							until
								i > data_list.count or else error
							loop
								if not data_list.item(i).is_integer then
									error := True
									!!error_description.copy("Invalid data %
										%value '")
									error_description.append(data_list.item(i))
									error_description.append("'")
								else
									data.put(data_list.item(i).to_integer, i)
								end
					
								i := i + 1
							end
							if not error then
								sys_ex.set_data(data)
							end
						end
					end
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			sys_ex: SYSTEM_EXCLUSIVE_EVENT
			tcl_list: TCL_LIST
			data_list: ARRAY[STRING]
			i: INTEGER
		do
			sys_ex ?= e
			if sys_ex.continued_wildcard then
				!!Result.copy("*")
			else
				!!Result.copy(sys_ex.continued.to_string)
			end

			Result.append(" ")
			if sys_ex.data_wildcard then
				Result.append("*")
			else
				!!data_list.make(1, sys_ex.data.count)
				from
					i := 1
				until
					i > sys_ex.data.count
				loop
					data_list.put(sys_ex.data.item(i).to_string, i)
					i := i + 1
				end
				!!tcl_list.make_from_split(context.tcl_interp, data_list)
				tcl_list.merge
				Result.append(tcl_list.list)
			end
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a SYSTEM_EXCLUSIVE_EVENT?
		local
			sys_ex: SYSTEM_EXCLUSIVE_EVENT
		do
			sys_ex ?= e
			Result := sys_ex /= Void
		end

end -- SYNTAX_SYSTEM_EXCLUSIVE
