#include <stdio.h>
#include <tcl.h>
#include "eiffel.h"

void
c_tcl_split_list(Tcl_Interp *interp, void *list, void *split_list)
{
	char *list_str, **split_argv;
	int i, split_argc;
	void *e_str;

	list_str = eiffel_string_to_external(list);

	if (Tcl_SplitList(interp, list_str, &split_argc, &split_argv)
	    == TCL_OK) {
		for (i = 0; i < split_argc; i++) {
			e_str = eiffel_make_string(eiffel_root_object,
			    split_argv[i]);
			eiffel_array_force_string(split_list, e_str, i + 1);
		}
	}
	Tcl_Free((char *)split_argv);
}

void
c_tcl_merge(void *split_list, void *list)
{
	int argc, i;
	char **argv, *list_str;
	void *e_str;

	argc = eiffel_array_count_string(split_list);
	argv = (char **)Tcl_Alloc(sizeof(char *) * argc);
	for (i = 0; i < argc; i++) {
		e_str = eiffel_array_get_string(split_list, i + 1);
		argv[i] = eiffel_string_to_external(e_str);
	}
	list_str = Tcl_Merge(argc, argv);

	eiffel_string_copy(list, eiffel_make_string(eiffel_root_object,
	    list_str));

	Tcl_Free(list_str);
	Tcl_Free((char *)argv);
}
