#include <stdio.h>
#include <tcl.h>

#include "eiffel.h"

static int Tclmidi_MidiMake(ClientData client_data, Tcl_Interp *interp,
    int argc, char *argv[]);
static int Tclmidi_MidiFree(ClientData client_data, Tcl_Interp *interp,
    int argc, char *argv[]);
static int Tclmidi_MidiRead(ClientData client_data, Tcl_Interp *interp,
    int argc, char *argv[]);
static int Tclmidi_MidiWrite(ClientData client_data, Tcl_Interp *interp,
    int argc, char *argv[]);
static int Tclmidi_MidiConfig(ClientData client_data, Tcl_Interp *interp,
    int argc, char *argv[]);
static int Tclmidi_MidiRewind(ClientData client_data, Tcl_Interp *interp,
    int argc, char *argv[]);
static int Tclmidi_MidiGet(ClientData client_data, Tcl_Interp *interp,
    int argc, char *argv[]);
static int Tclmidi_MidiPut(ClientData client_data, Tcl_Interp *interp,
    int argc, char *argv[]);
static int Tclmidi_MidiDelete(ClientData client_data, Tcl_Interp *interp,
    int argc, char *argv[]);
static int Tclmidi_MidiMerge(ClientData client_data, Tcl_Interp *interp,
    int argc, char *argv[]);
static int Tclmidi_MidiSplit(ClientData client_data, Tcl_Interp *interp,
    int argc, char *argv[]);
static int Tclmidi_MidiCopy(ClientData client_data, Tcl_Interp *interp,
    int argc, char *argv[]);
static int Tclmidi_MidiVersion(ClientData client_data, Tcl_Interp *interp,
    int argc, char *argv[]);
static int Tclmidi_MidiTrack(ClientData client_data, Tcl_Interp *interp,
    int argc, char *argv[]);
static int Tclmidi_MidiGrep(ClientData client_data, Tcl_Interp *interp,
    int argc, char *argv[]);

static void *convert_args(int argc, char *argv[]);
static int process_command_results(ClientData client_data, Tcl_Interp *interp);

static const char *TCLMIDI_NUM_VERSION = "4.0";
static const char *TCLMIDI_FULL_VERSION = "4.0b1";


int
Tclmidi_Init(Tcl_Interp *interp)
{
	void *disp, *compat;

	/* Initialize SmallEiffel */
	initialize_eiffel_runtime(0, NULL);
	disp = eiffel_make_dispatcher(eiffel_root_object, interp);
#ifdef COMPAT_3
	compat = eiffel_make_string(eiffel_root_object, "3.0");
	eiffel_set_compatibility_mode(disp, compat);
#endif /* COMPAT_3 */

	Tcl_CreateCommand(interp, "midimake", Tclmidi_MidiMake, disp, 0);
	Tcl_CreateCommand(interp, "midifree", Tclmidi_MidiFree, disp, 0);
	Tcl_CreateCommand(interp, "midiread", Tclmidi_MidiRead, disp, 0);
	Tcl_CreateCommand(interp, "midiwrite", Tclmidi_MidiWrite, disp, 0);
	Tcl_CreateCommand(interp, "midiconfig", Tclmidi_MidiConfig, disp, 0);
	Tcl_CreateCommand(interp, "midirewind", Tclmidi_MidiRewind, disp, 0);
	Tcl_CreateCommand(interp, "midiget", Tclmidi_MidiGet, disp, 0);
	Tcl_CreateCommand(interp, "midiput", Tclmidi_MidiPut, disp, 0);
	Tcl_CreateCommand(interp, "mididelete", Tclmidi_MidiDelete, disp, 0);
	Tcl_CreateCommand(interp, "midimerge", Tclmidi_MidiMerge, disp, 0);
	Tcl_CreateCommand(interp, "midisplit", Tclmidi_MidiSplit, disp, 0);
	Tcl_CreateCommand(interp, "midicopy", Tclmidi_MidiCopy, disp, 0);
	Tcl_CreateCommand(interp, "miditrack", Tclmidi_MidiTrack, disp, 0);
	Tcl_CreateCommand(interp, "midigrep", Tclmidi_MidiGrep, disp, 0);
	Tcl_CreateCommand(interp, "midiversion", Tclmidi_MidiVersion, disp, 0);

	return (Tcl_PkgProvide(interp, "tclmidi", (char *)TCLMIDI_NUM_VERSION));
}

static int
Tclmidi_MidiMake(ClientData client_data, Tcl_Interp *interp, int argc,
    char *argv[])
{
	void *args;

	args = convert_args(argc, argv);
	eiffel_midimake(client_data, args);
	return (process_command_results(client_data, interp));
}

static int
Tclmidi_MidiFree(ClientData client_data, Tcl_Interp *interp, int argc,
    char *argv[])
{
	void *args;

	args = convert_args(argc, argv);
	eiffel_midifree(client_data, args);
	return (process_command_results(client_data, interp));
}

static int
Tclmidi_MidiRead(ClientData client_data, Tcl_Interp *interp, int argc,
    char *argv[])
{
	void *args;

	args = convert_args(argc, argv);
	eiffel_midiread(client_data, args);
	return (process_command_results(client_data, interp));
}

static int
Tclmidi_MidiWrite(ClientData client_data, Tcl_Interp *interp, int argc,
    char *argv[])
{
	void *args;

	args = convert_args(argc, argv);
	eiffel_midiwrite(client_data, args);
	return (process_command_results(client_data, interp));
}

static int
Tclmidi_MidiConfig(ClientData client_data, Tcl_Interp *interp, int argc,
    char *argv[])
{
	void *args;

	args = convert_args(argc, argv);
	eiffel_midiconfig(client_data, args);
	return (process_command_results(client_data, interp));
}

static int
Tclmidi_MidiRewind(ClientData client_data, Tcl_Interp *interp, int argc,
    char *argv[])
{
	void *args;

	args = convert_args(argc, argv);
	eiffel_midirewind(client_data, args);
	return (process_command_results(client_data, interp));
}

static int
Tclmidi_MidiGet(ClientData client_data, Tcl_Interp *interp, int argc,
    char *argv[])
{
	void *args;

	args = convert_args(argc, argv);
	eiffel_midiget(client_data, args);
	return (process_command_results(client_data, interp));
}

static int
Tclmidi_MidiPut(ClientData client_data, Tcl_Interp *interp, int argc,
    char *argv[])
{
	void *args;

	args = convert_args(argc, argv);
	eiffel_midiput(client_data, args);
	return (process_command_results(client_data, interp));
}

static int
Tclmidi_MidiDelete(ClientData client_data, Tcl_Interp *interp, int argc,
    char *argv[])
{
	void *args;

	args = convert_args(argc, argv);
	eiffel_mididelete(client_data, args);
	return (process_command_results(client_data, interp));
}

static int
Tclmidi_MidiMerge(ClientData client_data, Tcl_Interp *interp, int argc,
    char *argv[])
{
	void *args;

	args = convert_args(argc, argv);
	eiffel_midimerge(client_data, args);
	return (process_command_results(client_data, interp));
}

static int
Tclmidi_MidiSplit(ClientData client_data, Tcl_Interp *interp, int argc,
    char *argv[])
{
	void *args;

	args = convert_args(argc, argv);
	eiffel_midisplit(client_data, args);
	return (process_command_results(client_data, interp));
}

static int
Tclmidi_MidiCopy(ClientData client_data, Tcl_Interp *interp, int argc,
    char *argv[])
{
	void *args;

	args = convert_args(argc, argv);
	eiffel_midicopy(client_data, args);
	return (process_command_results(client_data, interp));
}

static int
Tclmidi_MidiTrack(ClientData client_data, Tcl_Interp *interp, int argc,
    char *argv[])
{
	void *args;

	args = convert_args(argc, argv);
	eiffel_miditrack(client_data, args);
	return (process_command_results(client_data, interp));
}

static int
Tclmidi_MidiGrep(ClientData client_data, Tcl_Interp *interp, int argc,
    char *argv[])
{
	void *args;

	args = convert_args(argc, argv);
	eiffel_midigrep(client_data, args);
	return (process_command_results(client_data, interp));
}

static int
Tclmidi_MidiVersion(ClientData client_data, Tcl_Interp *interp, int argc,
    char *argv[])
{

	if (argc != 1) {
		Tcl_SetResult(interp, "wrong # args: should be midiversion",
		    TCL_STATIC);
		return (TCL_ERROR);
	}
	Tcl_SetResult(interp, (char *)TCLMIDI_FULL_VERSION, TCL_STATIC);
	return (TCL_OK);
}

static void *
convert_args(int argc, char *argv[])
{
	void *args, *str;
	int i;

	/* make ARRAY[STRING] large enough from argc strings */
	args = eiffel_make_args_list(eiffel_root_object, argc);

	/* fill array with strings */
	for (i = 0; i < argc; i++) {
		str = eiffel_make_string(eiffel_root_object, argv[i]);
		eiffel_array_put_string(args, str, i + 1);
	}
	return (args);
}

static int
process_command_results(ClientData client_data, Tcl_Interp *interp)
{
	int error;
	void *result;
	char *result_str;

	result = eiffel_command_result(client_data);
	if (result != NULL) {
		result_str = eiffel_string_to_external(result);
		Tcl_SetResult(interp, result_str, TCL_VOLATILE);
	}

	if (eiffel_command_error(client_data))
		error = TCL_ERROR;
	else
		error = TCL_OK;
	return (error);
}
