class
	--
	-- The midiconfig command implementation
	--
	COMMAND_MIDI_CONFIG

inherit
	TCLMIDI_COMMAND
		redefine
			make
		end

creation
	make

feature -- Initialization
	make is
			-- create a midiconfig command
		do
			precursor
			valid_formats := <<0, 1, 2>>
		end

feature {TCLMIDI_COMMAND} -- Access
	command_name: STRING is
			-- command name
		do
			Result := "midiconfig"
		end

	usage: STRING is
			-- command syntax
		once
			!!Result.copy(command_name)
			Result.append(" SongID ?{format|division|tracks ?value?} ...?")
		end

feature -- Actions
	check_syntax is
			-- check for valid arguments
		local
			list_splitter: TCL_LIST
			sub_list: ARRAY[STRING]
			bad_list: BOOLEAN
			i, div, tracks, format_type: INTEGER
			param: STRING
		do
			if arguments.count < 2 then
				syntax_valid := False
				error := True
				!!command_result.copy("wrong # args: should be %"")
				command_result.append(usage)
				command_result.append("%"")
			else
				if not context.song_table.has(arguments.item(2)) then
					syntax_valid := False
					error := True
					!!command_result.copy("invalid SongID '")
					command_result.append(arguments.item(2))
					command_result.append("'")
				else
					-- verify parameters
					from
						i := 3
						bad_list := False
					until
						i > arguments.count or else bad_list
					loop
						!!list_splitter.make_from_list(context.tcl_interp,
							arguments.item(i))
						list_splitter.split
						if list_splitter.error then
							bad_list := True
						else
							sub_list := list_splitter.split_list
							if sub_list.count > 2 then
								!!command_result.copy("too many items in %
									%config list '")
								command_result.append(arguments.item(i))
								command_result.append("'")
								bad_list := True
							else
								param := sub_list.item(1)
								if param.is_equal("format") then
									if sub_list.count = 2 then
										-- verify format
										format_type :=
											sub_list.item(2).to_integer
										if not valid_formats.has(format_type)
											then
											!!command_result.copy("bad format %
												%value '")
											command_result.append(
												sub_list.item(2))
											command_result.append("'")
											bad_list := True
										end
									end
								elseif param.is_equal("division") then
									if sub_list.count = 2 then
										-- verify division
										div := sub_list.item(2).to_integer
										if div < 0 or else
											div > max_division then
											!!command_result.copy("bad %
												%division value '")
											command_result.append(
												sub_list.item(2))
											command_result.append("'")
											bad_list := True
										end
									end
								elseif param.is_equal("tracks") then
									if sub_list.count = 2 then
										-- verify tracks
										tracks := sub_list.item(2).to_integer
										if tracks < 0 or else
											tracks > max_division then
											!!command_result.copy("bad %
												%tracks value '")
											command_result.append(
												sub_list.item(2))
											command_result.append("'")
											bad_list := True
										end
									end
								else
									bad_list := True
									!!command_result.copy("invalid config %
										%parameter '")
									command_result.append(sub_list.item(1))
									command_result.append("'")
								end
							end
						end
						i := i + 1
					end
					if bad_list then
						syntax_valid := False
						error := True
					else
						syntax_valid := True
						error := False
					end
				end
			end
		end

	execute is
			-- execute command
		local
			song: SONG
			set_flags, report_flags: CONFIG_FLAGS
			i: INTEGER
			param: STRING
			list_splitter, list_merger: TCL_LIST
			format, division, tracks: INTEGER
			converted_format: INTEGER
			sub_list, report_values: ARRAY[STRING]
			report_item: STRING
		do
			song := context.song_table.get(arguments.item(2))

			!!set_flags
			!!report_flags

			if arguments.count = 2 then
				report_flags.set_all
			else
				from
					i := 3
				until
					i > arguments.count
				loop
					!!list_splitter.make_from_list(context.tcl_interp,
						arguments.item(i))
					list_splitter.split
					sub_list := list_splitter.split_list
					param := sub_list.item(1)
					if param.is_equal("format") then
						if sub_list.count = 1 then
							report_flags.set_format
						else
							format := sub_list.item(2).to_integer
							set_flags.set_format
						end
					elseif param.is_equal("division") then
						if sub_list.count = 1 then
							report_flags.set_division
						else
							division := sub_list.item(2).to_integer
							set_flags.set_division
						end
					elseif param.is_equal("tracks") then
						if sub_list.count = 1 then
							report_flags.set_tracks
						else
							tracks := sub_list.item(2).to_integer
							set_flags.set_tracks
						end
					end

					i := i + 1
				end
			end

			-- set anything that needs to be set
			if set_flags.format then
				inspect
					format
				when 0 then
					converted_format := song.Format_single
				when 1 then
					converted_format := song.Format_multi
				when 2 then
					converted_format := song.Format_independent
				end
				song.set_format(converted_format)
			end
			if set_flags.division then
				song.set_division(division)
			end
			if set_flags.tracks then
				song.set_number_of_tracks(tracks)
			end

			-- report values
			!!report_values.make(1, 0)
			if report_flags.format then
				!!report_item.copy("format ")
				report_item.append(song.format.to_string)
				report_values.force(report_item, report_values.count + 1)
			end
			if report_flags.division then
				!!report_item.copy("division ")
				report_item.append(song.division.to_string)
				report_values.force(report_item, report_values.count + 1)
			end
			if report_flags.tracks then
				!!report_item.copy("tracks ")
				report_item.append(song.number_of_tracks.to_string)
				report_values.force(report_item, report_values.count + 1)
			end

			if report_values.count > 0 then
				!!list_merger.make_from_split(context.tcl_interp, report_values)
				list_merger.merge
				command_result := list_merger.list
			end
		end

feature {NONE} -- Implementation
	valid_formats: ARRAY[INTEGER]
	max_division: INTEGER is 65535
	max_tracks: INTEGER is 65535

end -- COMMAND_MIDI_CONFIG
