class
	--
	-- The midicopy command implementation
	--
	COMMAND_MIDI_COPY

inherit
	TCLMIDI_COMMAND

creation
	make

feature {TCLMIDI_COMMAND} -- Access
	command_name: STRING is
			-- command name
		do
			Result := "midicopy"
		end

	usage: STRING is
			-- command syntax
		once
			!!Result.copy(command_name)
			Result.append(" {DestSongID DestTrack} DestInTime %
				%{SrcSongID SrcTrack} SrcInTime SrcOutTime")
		end

feature -- Actions
	check_syntax is
			-- check for valid arguments
		local
			track: TRACK_NUMBER
			arg: INTEGER
			tcl_list: TCL_LIST
			in_time, out_time: INTEGER
		do
			if arguments.count /= 6 then
				syntax_valid := False
				error := True
				!!command_result.copy("wrong # args: should be %"")
				command_result.append(usage)
				command_result.append("%"")
			end

			-- verify destination song/track pair
			!!tcl_list.make_from_list(context.tcl_interp, arguments.item(2))
			tcl_list.split
			if tcl_list.error then
				error := True
			end

			if not error then
				if tcl_list.split_list.count /= 2 then
					error := True
					syntax_valid := False
					!!command_result.copy("Invalid Song/Track identifier '")
					command_result.append(arguments.item(arg))
					command_result.append("'")
				end
			end

			if not error then
				if not context.song_table.has(tcl_list.split_list.item(1)) then
					syntax_valid := False
					error := True
					!!command_result.copy("invalid SongID '")
					command_result.append(tcl_list.split_list.item(1))
					command_result.append("'")
				end
			end

			if not error then
				-- verify valid track number
				!!track.make
				track.set_context(context)
				track.set_song(context.song_table.get(
					tcl_list.split_list.item(1)))
				track.check_track_identifier(tcl_list.split_list.item(2))
				if track.is_valid then
					syntax_valid := True
					error := False
				else
					syntax_valid := False
					error := True
					command_result := track.error_description
				end
			end

			if not arguments.item(3).is_integer or else
				arguments.item(3).to_integer < 0 then
				error := True
				syntax_valid := False
				!!command_result.copy("Invalid destinatio In point '")
				command_result.append(arguments.item(3))
				command_result.append("'")
			end

			-- verify destination song/track pair
			!!tcl_list.make_from_list(context.tcl_interp, arguments.item(4))
			tcl_list.split
			if tcl_list.error then
				error := True
			end

			if not error then
				if tcl_list.split_list.count /= 2 then
					error := True
					syntax_valid := False
					!!command_result.copy("Invalid Song/Track identifier '")
					command_result.append(arguments.item(arg))
					command_result.append("'")
				end
			end

			if not error then
				if not context.song_table.has(tcl_list.split_list.item(1)) then
					syntax_valid := False
					error := True
					!!command_result.copy("invalid SongID '")
					command_result.append(tcl_list.split_list.item(1))
					command_result.append("'")
				end
			end

			if not error then
				-- verify valid track number
				!!track.make
				track.set_context(context)
				track.set_song(context.song_table.get(
					tcl_list.split_list.item(1)))
				track.check_track_identifier(tcl_list.split_list.item(2))
				if track.is_valid then
					syntax_valid := True
					error := False
				else
					syntax_valid := False
					error := True
					command_result := track.error_description
				end
			end

			if not error then
				if not arguments.item(5).is_integer or else
					arguments.item(5).to_integer < 0 then
					syntax_valid := False
					error := True
					!!command_result.copy("invalid source In point '")
					command_result.append(arguments.item(5))
					command_result.append("'")
				else
					in_time := arguments.item(5).to_integer
				end
			end

			if not error then
				if not arguments.item(6).is_integer or else
					arguments.item(6).to_integer < 0 then
					syntax_valid := False
					error := True
					!!command_result.copy("invalid source Out point '")
					command_result.append(arguments.item(6))
					command_result.append("'")
				else
					out_time := arguments.item(6).to_integer
					if out_time <= in_time then
						syntax_valid := False
						error := True
						!!command_result.copy("invalid source Out point '")
						command_result.append(arguments.item(6))
						command_result.append("' must be greater than %
							%SrcInPoint '")
						command_result.append(in_time.to_string)
						command_result.append("'")
					end
				end
			end
		end

	execute is
			-- execute command
		local
			dest_song, src_song: SONG
			dest_track, src_track: TRACK
			tcl_list: TCL_LIST
			track_id: TRACK_NUMBER
			in_point, out_point, dest_time: INTEGER
		do
			!!tcl_list.make_from_list(context.tcl_interp, arguments.item(2))
			tcl_list.split

			dest_song := context.song_table.get(tcl_list.split_list.item(1))
			!!track_id.make
			track_id.set_context(context)
			track_id.set_song(dest_song)
			track_id.set_track_identifier(tcl_list.split_list.item(2))
			dest_track := dest_song.track(track_id.track_number)

			dest_time := arguments.item(3).to_integer

			!!tcl_list.make_from_list(context.tcl_interp, arguments.item(4))
			tcl_list.split

			src_song := context.song_table.get(tcl_list.split_list.item(1))
			!!track_id.make
			track_id.set_context(context)
			track_id.set_song(src_song)
			track_id.set_track_identifier(tcl_list.split_list.item(2))
			src_track := src_song.track(track_id.track_number)

			in_point := arguments.item(5).to_integer
			out_point := arguments.item(6).to_integer

			if src_track.empty then
				error := True
				command_result := "Source track is empty"
			else
				src_track.goto(in_point)
				src_track.mark_in
				src_track.goto(out_point)
				src_track.mark_out
				src_track.copy_range(dest_track, dest_time)
			end
		end

end -- COMMAND_MIDI_COPY
