class
	--
	-- The midigrep command implementation
	--
	COMMAND_MIDI_GREP

inherit
	TCLMIDI_COMMAND

creation
	make

feature {TCLMIDI_COMMAND} -- Access
	command_name: STRING is
			-- command name
		do
			Result := "midigrep"
		end

	usage: STRING is
			-- command syntax
		once
			!!Result.copy(command_name)
			Result.append(" SongID track event ?event?")
		end

feature -- Actions
	check_syntax is
			-- check for valid arguments
		local
			track: TRACK_NUMBER
			time: INTEGER
		do
			if arguments.count < 4 then
				syntax_valid := False
				error := True
				!!command_result.copy("wrong # args: should be %"")
				command_result.append(usage)
				command_result.append("%"")
			end

			if not error then
				if not context.song_table.has(arguments.item(2)) then
					syntax_valid := False
					error := True
					!!command_result.copy("invalid SongID '")
					command_result.append(arguments.item(2))
					command_result.append("'")
				end
			end
	
			if not error then
				-- verify valid track number
				!!track.make
				track.set_context(context)
				track.set_song(context.song_table.get(arguments.item(2)))
				track.check_track_identifier(arguments.item(3))
				if track.is_valid then
					syntax_valid := True
					error := False
				else
					syntax_valid := False
					error := True
					command_result := track.error_description
				end
			end

			-- verifying event involves parsing it.  Wait for execution.

		end

	execute is
			-- execute command
		local
			song: SONG
			track_id: TRACK_NUMBER
			track: TRACK
			i, time, duration: INTEGER
			e: EVENT
			note_on: NOTE_ON_EVENT
			tcl_list: TCL_LIST
			args: ARRAY[STRING]
			found_match: BOOLEAN
			syntax: EVENT_SYNTAX
			event_matches: LINKED_LIST[STRING]
			event_matches_array: ARRAY[STRING]
		do
			song := context.song_table.get(arguments.item(2))
			!!track_id.make
			track_id.set_context(context)
			track_id.set_song(song)
			track_id.set_track_identifier(arguments.item(3))
			track := song.track(track_id.track_number)

			!!event_matches.make
			from
				i := 4
			until
				i > arguments.count or else error
			loop
				!!tcl_list.make_from_list(context.tcl_interp, arguments.item(i))
				tcl_list.split
				if tcl_list.error then
					error := True
				else
					args := tcl_list.split_list

					context.event_factory.set_event_description(args)
					e := context.event_factory.create_event

					if context.event_factory.error then
						command_result :=
							context.event_factory.error_description
						error := True
					else
						duration := -1
						if args.item(2).same_as("Note") then
							note_on ?= e

								-- must be note on
								check note_on /= Void end

							note_on.set_sibling_wildcard
							if not args.item(6).is_equal("*") then
								if not args.item(6).is_integer then
									error := True
									!!command_result.copy("invalid Note %
										%duration '")
									command_result.append(args.item(6))
									command_result.append("'")
								else
									duration := args.item(6).to_integer
								end
							end
						end

						if args.item(1).same_as("*") then
							from
								track.start
							until
								track.after
							loop
								track.search(e)
								if track.found then
									found_match := True
									if duration /= -1 then
										-- a note event
										note_on ?= track.item
											-- must be note on
											check note_on /= Void end
										if note_on.duration /= duration then
											found_match := False
										end
									end
									if found_match then
										event_matches.add_last(
											track.item.syntax.format(
											track.time, track.item))
									end
									track.forth
								end
							end
						elseif not args.item(1).is_integer then
							error := True
							!!command_result.copy("Invalid time value '")
							command_result.append(args.item(1))
							command_result.append("'")
						else
							time := args.item(1).to_integer

							track.find(e, time)
							if track.found then
								found_match := True
								if duration /= -1 then
									-- a note event
									note_on ?= track.item
										-- must be note on
										check note_on /= Void end
									if note_on.duration /= duration then
										found_match := False
									end
								end
								if found_match then
									event_matches.add_last(
										track.item.syntax.format(track.time,
											track.item))
								end
							end
						end
					end
				end
				i := i + 1
			end

			if not error and event_matches.count > 0 then
				!!event_matches_array.from_collection(event_matches)
				!!tcl_list.make_from_split(context.tcl_interp,
					event_matches_array)
				tcl_list.merge

				command_result := tcl_list.list
			end
		end

end -- COMMAND_MIDI_GREP
