class
	--
	-- The midiwrite command implementation
	--
	COMMAND_MIDI_WRITE

inherit
	TCLMIDI_COMMAND

creation
	make

feature {TCLMIDI_COMMAND} -- Access
	command_name: STRING is
			-- command name
		do
			Result := "midiwrite"
		end

	usage: STRING is
			-- command syntax
		once
			!!Result.copy(command_name)
			Result.append(" FileID SongID")
		end

feature -- Actions
	check_syntax is
			-- check for valid arguments
		local
			output_chan: TCL_OUTPUT_CHANNEL
		do
			if arguments.count /= 3 then
				syntax_valid := False
				error := True
				!!command_result.copy("wrong # args: should be %"")
				command_result.append(usage)
				command_result.append("%"")
			else
				!!output_chan.make(context.tcl_interp, arguments.item(2))
				if not output_chan.is_connected then
					syntax_valid := False
					error := True
					!!command_result.copy("invalid FileID '")
					command_result.append(arguments.item(2))
					command_result.append("'")
				else
					if not context.song_table.has(arguments.item(3)) then
						syntax_valid := False
						error := True
						!!command_result.copy("invalid SongID '")
						command_result.append(arguments.item(3))
						command_result.append("'")
					else
						syntax_valid := True
						error := False
					end
				end
			end
		end

	execute is
			-- execute command
		local
			output_chan: TCL_OUTPUT_CHANNEL
			smf: SMF_WRITE
			song: SONG
			song_key: STRING
		do
			!!output_chan.make(context.tcl_interp, arguments.item(2))
			!!smf.make_with_stream(output_chan)

			song := context.song_table.get(arguments.item(3))
			smf.write_song(song)
		end

end -- COMMAND_MIDI_WRITE
